DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -1.34963085984344E-11   0.00000000000000E+00   1.31938183509818E-10   1.64411234925082E-22
      1.33643758479057E-08   1.34963140314157E-08  -7.90356667088165E-19  -2.50371042858463E-01  -2.50371042857039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42386139855453E-09   0.00000000000000E+00  -1.42386139855453E-09
      3.70001668496812E-18  -2.50371042858464E-01  -2.46567585215326E-01   0.00000000000000E+00  -4.28244497771534E-12
     -9.83405481596999E-23  -1.20681701878862E-08  -1.20724526328640E-08  -2.90966001787995E-18
      1.17500000000000E-12
      0.00000000000000E+00  -1.34927266536833E-11   0.00000000000000E+00   8.88167129493774E-12   1.65785630605270E-22
      1.34838990896167E-08   1.34927807609118E-08  -7.89530143318329E-19  -2.50727023102220E-01  -2.50727023100880E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33966529009460E-09   0.00000000000000E+00  -1.33966529009460E-09
      3.69911241089731E-18  -2.50727023102224E-01  -2.46898160230406E-01   0.00000000000000E+00  -5.90624900929989E-12
     -9.83451993305804E-23  -1.21472092218071E-08  -1.21531154708165E-08  -2.90958226757898E-18
      2.08625000000000E-12
      0.00000000000000E+00  -1.34885936405090E-11   0.00000000000000E+00   2.89542677089079E-13   1.68053894679811E-22
      1.34883042186255E-08   1.34885937613028E-08  -7.88547512361128E-19  -2.51140737930657E-01  -2.51140737929448E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20884850237451E-09   0.00000000000000E+00  -1.20884850237451E-09
      3.69801084769952E-18  -2.51140737930659E-01  -2.47271964092227E-01   0.00000000000000E+00  -6.68041321535181E-12
     -9.83514500034838E-23  -1.22730648457120E-08  -1.22797452589275E-08  -2.90946333533839E-18
      2.24002343750000E-12
      0.00000000000000E+00  -1.34879507273485E-11   0.00000000000000E+00  -6.06630483543898E-14   1.68445245519099E-22
      1.34879716867868E-08   1.34879110237386E-08  -7.88385412305810E-19  -2.51208897626914E-01  -2.51208897625728E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18639459359679E-09   0.00000000000000E+00  -1.18639459359679E-09
      3.69782841172463E-18  -2.51208897626916E-01  -2.47333264338899E-01   0.00000000000000E+00  -6.78363042637975E-12
     -9.83524989823921E-23  -1.22947327997083E-08  -1.23015164301348E-08  -2.90944299941882E-18
      2.34382050781250E-12
      0.00000000000000E+00  -1.34874915036625E-11   0.00000000000000E+00  -1.35309072062332E-13   1.68712344248259E-22
      1.34875934050377E-08   1.34874580959658E-08  -7.88277660858140E-19  -2.51254190404008E-01  -2.51254190402837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17110270113640E-09   0.00000000000000E+00  -1.17110270113640E-09
      3.69770685469522E-18  -2.51254190404010E-01  -2.47373882048188E-01   0.00000000000000E+00  -6.83801239604132E-12
     -9.83532030308933E-23  -1.23095173824238E-08  -1.23163553948199E-08  -2.90942919383708E-18
      2.48394655273438E-12
      0.00000000000000E+00  -1.34868485905021E-11   0.00000000000000E+00  -1.59238888781252E-13   1.69076028044681E-22
      1.34870184417730E-08   1.34868592028844E-08  -7.88135167692092E-19  -2.51314079711671E-01  -2.51314079710521E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15030364376620E-09   0.00000000000000E+00  -1.15030364376620E-09
      3.69754566719516E-18  -2.51314079711673E-01  -2.47427407227717E-01   0.00000000000000E+00  -6.88278513842055E-12
     -9.83541408683456E-23  -1.23296727739785E-08  -1.23365555591170E-08  -2.90941049950306E-18
      2.67311671337891E-12
      0.00000000000000E+00  -1.34860219878672E-11   0.00000000000000E+00  -1.62344971566711E-13   1.69568035689011E-22
      1.34862352680699E-08   1.34860729230985E-08  -7.87948069701086E-19  -2.51392713007245E-01  -2.51392713006123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12214698948590E-09   0.00000000000000E+00  -1.12214698948590E-09
      3.69733339046889E-18  -2.51392713007235E-01  -2.47497417427962E-01   0.00000000000000E+00  -6.89484550033429E-12
     -9.83553873517893E-23  -1.23570310881230E-08  -1.23639259336235E-08  -2.90938532076781E-18
      2.92849643024902E-12
      0.00000000000000E+00  -1.34850116957579E-11   0.00000000000000E+00  -1.57962479095386E-13   1.70225981028951E-22
      1.34852084109282E-08   1.34850504484493E-08  -7.87704747234824E-19  -2.51494971481781E-01  -2.51494971480696E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08438999351742E-09   0.00000000000000E+00  -1.08438999351742E-09
      3.69705645925937E-18  -2.51494971481797E-01  -2.47588102642144E-01   0.00000000000000E+00  -6.84274114876771E-12
     -9.83570195156979E-23  -1.23938177137912E-08  -1.24006604549400E-08  -2.90935171202455E-18
      3.27325904802368E-12
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00  -1.50204801623745E-13   1.71090763735387E-22
      1.34838882140180E-08   1.34837380092166E-08  -7.87392345403310E-19  -2.51626248116227E-01  -2.51626248115193E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452921936672E-09   0.00000000000000E+00  -1.03452921936672E-09
      3.69669979225753E-18  -2.51626248116264E-01  -2.47704084135640E-01   0.00000000000000E+00  -6.68932716369822E-12
     -9.83591270748663E-23  -1.24425194626860E-08  -1.24492087898498E-08  -2.90930744685422E-18
      3.73868858201947E-12
      0.00000000000000E+00  -1.34820726641673E-11   0.00000000000000E+00  -1.39507837615800E-13   1.72201601825577E-22
      1.34822220116594E-08   1.34820825038219E-08  -7.86998084914823E-19  -2.51791892979947E-01  -2.51791892978977E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70090135537335E-10   0.00000000000000E+00  -9.70090135537335E-10
      3.69624828365782E-18  -2.51791892979872E-01  -2.47849949232082E-01   0.00000000000000E+00  -6.40206248145297E-12
     -9.83618014438351E-23  -1.25055903058025E-08  -1.25119923682840E-08  -2.90925019874299E-18
      4.36701845291379E-12
      0.00000000000000E+00  -1.34800520799487E-11   0.00000000000000E+00  -1.28633743712080E-13   1.73588219313175E-22
      1.34801672377257E-08   1.34800386039821E-08  -7.86511767429405E-19  -2.51996156322868E-01  -2.51996156321979E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.89102657104833E-10   0.00000000000000E+00  -8.89102657104833E-10
      3.69568963390007E-18  -2.51996156322831E-01  -2.48029340899434E-01   0.00000000000000E+00  -5.95824356353317E-12
     -9.83651217191327E-23  -1.25849777033179E-08  -1.25909359468816E-08  -2.90917786647066E-18
      4.79114111576745E-12
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00  -1.21190453573441E-13   1.74472511470157E-22
      1.34788642271628E-08   1.34787430367094E-08  -7.86203247437541E-19  -2.52125706434050E-01  -2.52125706433213E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37237773552440E-10   0.00000000000000E+00  -8.37237773552440E-10
      3.69533454238611E-18  -2.52125706375117E-01  -2.48142958926445E-01   0.00000000000000E+00  -5.65284226104612E-12
     -9.83672422632379E-23  -1.26358524208969E-08  -1.26415052631580E-08  -2.90913129494857E-18
      4.93428251448056E-12
      0.00000000000000E+00  -1.34783070299418E-11   0.00000000000000E+00  -1.18480422289586E-13   1.74765089708659E-22
      1.34784338076349E-08   1.34783153272128E-08  -7.86101328363207E-19  -2.52168497661404E-01  -2.52168497660584E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20052821628145E-10   0.00000000000000E+00  -8.20052821628145E-10
      3.69521715887820E-18  -2.52168497586145E-01  -2.48180470796324E-01   0.00000000000000E+00  -5.54996349947694E-12
     -9.83679403689609E-23  -1.26527125420813E-08  -1.26582625055808E-08  -2.90911583051499E-18
      5.12752340274326E-12
      0.00000000000000E+00  -1.34777559615185E-11   0.00000000000000E+00  -1.15136267081222E-13   1.75149553722277E-22
      1.34778692053745E-08   1.34777540691076E-08  -7.85967646311997E-19  -2.52224618400290E-01  -2.52224618399493E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97432720394815E-10   0.00000000000000E+00  -7.97432720394815E-10
      3.69506306227098E-18  -2.52224618303572E-01  -2.48229641853155E-01   0.00000000000000E+00  -5.41156912415953E-12
     -9.83684378125765E-23  -1.26749097796043E-08  -1.26803213487285E-08  -2.90909541595899E-18
      5.38839860189791E-12
      0.00000000000000E+00  -1.34770212036209E-11   0.00000000000000E+00  -1.10694094747896E-13   1.75649797750456E-22
      1.34771360290020E-08   1.34770253349075E-08  -7.85794035314045E-19  -2.52297492292678E-01  -2.52297492291910E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67939671976540E-10   0.00000000000000E+00  -7.67939671976540E-10
      3.69486272585612E-18  -2.52297492187952E-01  -2.48293453532432E-01   0.00000000000000E+00  -5.22717229581984E-12
     -9.83699959641538E-23  -1.27038584906294E-08  -1.27090856629253E-08  -2.90906869054207E-18
      5.74058012075668E-12
      0.00000000000000E+00  -1.34761027562488E-11   0.00000000000000E+00  -1.04906370154355E-13   1.76291922842262E-22
      1.34761965720552E-08   1.34760916656852E-08  -7.85571546320130E-19  -2.52390867519211E-01  -2.52390867518481E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29981180070348E-10   0.00000000000000E+00  -7.29981180070348E-10
      3.69460563997538E-18  -2.52390867417676E-01  -2.48375164107772E-01   0.00000000000000E+00  -4.98451419190319E-12
     -9.83715958436966E-23  -1.27411259714264E-08  -1.27461104856184E-08  -2.90903409365525E-18
      6.21602517121602E-12
      0.00000000000000E+00  -1.34749087746651E-11   0.00000000000000E+00  -9.73103725860139E-14   1.77101290789173E-22
      1.34750140693389E-08   1.34749167589665E-08  -7.85291427929112E-19  -2.52508403257023E-01  -2.52508403256342E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81977142198967E-10   0.00000000000000E+00  -6.81977142198967E-10
      3.69428139731860E-18  -2.52508403165510E-01  -2.48477946449475E-01   0.00000000000000E+00  -4.67145527702803E-12
     -9.83735549931258E-23  -1.27882681614864E-08  -1.27929396167635E-08  -2.90898996938948E-18
      6.85787598933613E-12
      0.00000000000000E+00  -1.34734392588698E-11   0.00000000000000E+00  -8.92701493201924E-14   1.78097064297855E-22
      1.34735603353141E-08   1.34734710651649E-08  -7.84946953461549E-19  -2.52652900707427E-01  -2.52652900706804E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22673603478924E-10   0.00000000000000E+00  -6.22673603478924E-10
      3.69388173375678E-18  -2.52652900627228E-01  -2.48604215517194E-01   0.00000000000000E+00  -4.27662381653533E-12
     -9.83759737126649E-23  -1.28465208378705E-08  -1.28507974616871E-08  -2.90893478029523E-18
      7.29112529156720E-12
      0.00000000000000E+00  -1.34725208114977E-11   0.00000000000000E+00  -8.37123074061340E-14   1.78727534060627E-22
      1.34726401933748E-08   1.34725564810675E-08  -7.84728864084457E-19  -2.52744361200145E-01  -2.52744361199560E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85018929567195E-10   0.00000000000000E+00  -5.85018929567195E-10
      3.69362827471375E-18  -2.52744361144618E-01  -2.48684101036214E-01   0.00000000000000E+00  -4.02450323751291E-12
     -9.83774900307968E-23  -1.28835130482619E-08  -1.28875375514995E-08  -2.90889941062930E-18
      7.36423611131870E-12
      0.00000000000000E+00  -1.34724289667605E-11   0.00000000000000E+00  -8.29003651352408E-14   1.78832746163852E-22
      1.34724866327925E-08   1.34724037324276E-08  -7.84692468639369E-19  -2.52759623367747E-01  -2.52759623367168E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78731667569966E-10   0.00000000000000E+00  -5.78731667569966E-10
      3.69358596316712E-18  -2.52759623312033E-01  -2.48697430485302E-01   0.00000000000000E+00  -3.98227163235246E-12
     -9.83777414245023E-23  -1.28896897932550E-08  -1.28936720648874E-08  -2.90889349452775E-18
      7.46293571798321E-12
      0.00000000000000E+00  -1.34722452772861E-11   0.00000000000000E+00  -8.16698411834655E-14   1.78972674204083E-22
      1.34722824201784E-08   1.34722007503374E-08  -7.84644065640426E-19  -2.52779919503487E-01  -2.52779919502916E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70364259727936E-10   0.00000000000000E+00  -5.70364259727936E-10
      3.69352966843903E-18  -2.52779919447522E-01  -2.48715154410106E-01   0.00000000000000E+00  -3.92617650306216E-12
     -9.83780933586578E-23  -1.28979103140826E-08  -1.29018364905858E-08  -2.90888560279860E-18
      7.59618018698031E-12
      0.00000000000000E+00  -1.34719697430744E-11   0.00000000000000E+00  -8.00354019279386E-14   1.79157816740220E-22
      1.34720122642827E-08   1.34719322288809E-08  -7.84580027122034E-19  -2.52806770036212E-01  -2.52806770035652E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59283730253263E-10   0.00000000000000E+00  -5.59283730253263E-10
      3.69345514697537E-18  -2.52806769980852E-01  -2.48738598610530E-01   0.00000000000000E+00  -3.85181984325223E-12
     -9.83785580477566E-23  -1.29087966787915E-08  -1.29126484986348E-08  -2.90887511985334E-18
      7.77606022012639E-12
      0.00000000000000E+00  -1.34716023641256E-11   0.00000000000000E+00  -7.78816020910909E-14   1.79401079590705E-22
      1.34716573800750E-08   1.34715794984731E-08  -7.84495891528596E-19  -2.52842044170921E-01  -2.52842044170376E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44708618192940E-10   0.00000000000000E+00  -5.44708618192940E-10
      3.69335716477108E-18  -2.52842044115755E-01  -2.48769391971536E-01   0.00000000000000E+00  -3.75378848278917E-12
     -9.83791615816990E-23  -1.29231170917977E-08  -1.29268708802805E-08  -2.90886127324248E-18
      8.01889826487360E-12
      0.00000000000000E+00  -1.34711431404396E-11   0.00000000000000E+00  -7.50692215030376E-14   1.79717693735883E-22
      1.34711955247645E-08   1.34711204555431E-08  -7.84386381111266E-19  -2.52887952015843E-01  -2.52887952015317E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25710107029307E-10   0.00000000000000E+00  -5.25710107029307E-10
      3.69322950235658E-18  -2.52887951961526E-01  -2.48809458945843E-01   0.00000000000000E+00  -3.62550174325757E-12
     -9.83799438414559E-23  -1.29417848467682E-08  -1.29454103485116E-08  -2.90884312124532E-18
      8.34672962528234E-12
      0.00000000000000E+00  -1.34705002272791E-11   0.00000000000000E+00  -7.14181855362323E-14   1.80124531856244E-22
      1.34706019262565E-08   1.34705305080712E-08  -7.84245614874257E-19  -2.52946954468968E-01  -2.52946954468466E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01247393367550E-10   0.00000000000000E+00  -5.01247393367550E-10
      3.69306517774172E-18  -2.52946954416820E-01  -2.48860940282413E-01   0.00000000000000E+00  -3.45942674855125E-12
     -9.83809507177965E-23  -1.29658236879538E-08  -1.29692831147025E-08  -2.90881956286746E-18
      8.78930196183413E-12
      0.00000000000000E+00  -1.34698573141187E-11   0.00000000000000E+00  -6.66949947099121E-14   1.80638395985476E-22
      1.34698516447881E-08   1.34697849497936E-08  -7.84067662880705E-19  -2.53021529683708E-01  -2.53021529683238E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70262934630633E-10   0.00000000000000E+00  -4.70262934630633E-10
      3.69285705237594E-18  -2.53021529635493E-01  -2.48925988763556E-01   0.00000000000000E+00  -3.24783073242749E-12
     -9.83822294395886E-23  -1.29962741844327E-08  -1.29995220151652E-08  -2.90878938949524E-18
      9.38677461617904E-12
      0.00000000000000E+00  -1.34688470220094E-11   0.00000000000000E+00  -6.05721768956970E-14   1.81272749576277E-22
      1.34689241083244E-08   1.34688635361477E-08  -7.83847619806899E-19  -2.53113721636957E-01  -2.53113721636526E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31869604375389E-10   0.00000000000000E+00  -4.31869604375389E-10
      3.69259902209708E-18  -2.53113721594943E-01  -2.49006375317537E-01   0.00000000000000E+00  -2.98421764819912E-12
     -9.83838214155068E-23  -1.30340097141223E-08  -1.30369939317706E-08  -2.90875140229018E-18
      1.01933626995447E-11
      0.00000000000000E+00  -1.34677448851629E-11   0.00000000000000E+00  -5.45051325294039E-14   1.82032467408897E-22
      1.34678104486521E-08   1.34677559435198E-08  -7.83583340559870E-19  -2.53224411198643E-01  -2.53224411198257E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85657147046292E-10   0.00000000000000E+00  -3.85657147046292E-10
      3.69228795563801E-18  -2.53224411165880E-01  -2.49102854339405E-01   0.00000000000000E+00  -2.66364807431265E-12
     -9.83857513863107E-23  -1.30794351484005E-08  -1.30820987964749E-08  -2.90870461507814E-18
      1.07378096558165E-11
      0.00000000000000E+00  -1.34671019720024E-11   0.00000000000000E+00  -5.02588649647879E-14   1.82504680084629E-22
      1.34671183197234E-08   1.34670680608586E-08  -7.83418749845895E-19  -2.53293329812076E-01  -2.53293329811719E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.56835827674095E-10   0.00000000000000E+00  -3.56835827674095E-10
      3.69209367745774E-18  -2.53293329754533E-01  -2.49162909437017E-01   0.00000000000000E+00  -2.46361896022574E-12
     -9.83870738763286E-23  -1.31077686142267E-08  -1.31102322331870E-08  -2.90867492761185E-18
      1.09215605035582E-11
      0.00000000000000E+00  -1.34668264377908E-11   0.00000000000000E+00  -4.84281570723750E-14   1.82659556005663E-22
      1.34668931083243E-08   1.34668446801674E-08  -7.83364729688730E-19  -2.53315947158343E-01  -2.53315947157995E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47374524313614E-10   0.00000000000000E+00  -3.47374524313614E-10
      3.69202984709442E-18  -2.53315946756463E-01  -2.49182615999245E-01   0.00000000000000E+00  -2.39770963625165E-12
     -9.83875055967438E-23  -1.31170724462047E-08  -1.31194701558410E-08  -2.90866511740569E-18
      1.11696241480096E-11
      0.00000000000000E+00  -1.34665509035792E-11   0.00000000000000E+00  -4.70441631531660E-14   1.82860719601404E-22
      1.34665980145327E-08   1.34665509703698E-08  -7.83294487536426E-19  -2.53345352907119E-01  -2.53345352906784E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35059857260929E-10   0.00000000000000E+00  -3.35059857260929E-10
      3.69194673092512E-18  -2.53345352127526E-01  -2.49208234175177E-01   0.00000000000000E+00  -2.31225700147807E-12
     -9.83879919389673E-23  -1.31291788561024E-08  -1.31314911131040E-08  -2.90865224338869E-18
      1.15045100680189E-11
      0.00000000000000E+00  -1.34661835246304E-11   0.00000000000000E+00  -4.50151339954206E-14   1.83118522699278E-22
      1.34662174962620E-08   1.34661724811282E-08  -7.83204314870831E-19  -2.53383096806835E-01  -2.53383096806516E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19236468039720E-10   0.00000000000000E+00  -3.19236468039720E-10
      3.69183982312682E-18  -2.53383095782965E-01  -2.49241111894831E-01   0.00000000000000E+00  -2.20217319613239E-12
     -9.83885901238902E-23  -1.31447338398956E-08  -1.31469360130918E-08  -2.90863550825599E-18
      1.19566060600314E-11
      0.00000000000000E+00  -1.34656324562071E-11   0.00000000000000E+00  -4.20256607892479E-14   1.83443066373008E-22
      1.34657366796732E-08   1.34656946540126E-08  -7.83090512470453E-19  -2.53430722470445E-01  -2.53430722470146E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99249724322732E-10   0.00000000000000E+00  -2.99249724322732E-10
      3.69170453352584E-18  -2.53430721340389E-01  -2.49282591192890E-01   0.00000000000000E+00  -2.06269789519965E-12
     -9.83894063520929E-23  -1.31643822317954E-08  -1.31664449296907E-08  -2.90861402105539E-18
      1.25669356492484E-11
      0.00000000000000E+00  -1.34651732325211E-11   0.00000000000000E+00  -3.81489209328312E-14   1.83842054282628E-22
      1.34651441049638E-08   1.34651059560431E-08  -7.82950089616175E-19  -2.53489473621049E-01  -2.53489473620774E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74571437203019E-10   0.00000000000000E+00  -2.74571437203019E-10
      3.69153695445336E-18  -2.53489472525421E-01  -2.49333752998162E-01   0.00000000000000E+00  -1.88973729524619E-12
     -9.83904588990925E-23  -1.31886447815438E-08  -1.31905345188391E-08  -2.90858686483719E-18
      1.33908805946913E-11
      0.00000000000000E+00  -1.34644384746234E-11   0.00000000000000E+00  -3.32318983708399E-14   1.84317378896265E-22
      1.34644352936033E-08   1.34644020617051E-08  -7.82781875174417E-19  -2.53559827791153E-01  -2.53559827790908E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44998635040508E-10   0.00000000000000E+00  -2.44998635040508E-10
      3.69133508906638E-18  -2.53559826884791E-01  -2.49395012352868E-01   0.00000000000000E+00  -1.68186290868302E-12
     -9.83917419862426E-23  -1.32177215637570E-08  -1.32194034266658E-08  -2.90855321389196E-18
      1.45032062710393E-11
      0.00000000000000E+00  -1.34636118719886E-11   0.00000000000000E+00  -2.90109496624694E-14   1.84860662753710E-22
      1.34636192992864E-08   1.34635902883369E-08  -7.82587986069859E-19  -2.53640880726518E-01  -2.53640880726307E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10920765198992E-10   0.00000000000000E+00  -2.10920765198992E-10
      3.69110047648357E-18  -2.53640880160716E-01  -2.49465584869007E-01   0.00000000000000E+00  -1.43995445278866E-12
     -9.83932459355896E-23  -1.32512295686846E-08  -1.32526695231375E-08  -2.90851249041371E-18
      1.60048459341090E-11
      0.00000000000000E+00  -1.34626934246165E-11   0.00000000000000E+00  -2.12667566799221E-14   1.85449099631901E-22
      1.34627520011779E-08   1.34627307344214E-08  -7.82375255800239E-19  -2.53729751261064E-01  -2.53729751260890E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73629705179407E-10   0.00000000000000E+00  -1.73629705179407E-10
      3.69083974723159E-18  -2.53729738126648E-01  -2.49542965520132E-01   0.00000000000000E+00  -1.17586340834039E-12
     -9.83942280335774E-23  -1.32879251658342E-08  -1.32891010292426E-08  -2.90846449143135E-18
      1.62582476272520E-11
      0.00000000000000E+00  -1.34626015798793E-11   0.00000000000000E+00  -2.32992256674717E-14   1.85544445612167E-22
      1.34626041013478E-08   1.34625808021224E-08  -7.82340704851194E-19  -2.53744182323033E-01  -2.53744182322865E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67563237176975E-10   0.00000000000000E+00  -1.67563237176975E-10
      3.69079728642358E-18  -2.53744167957509E-01  -2.49555530845346E-01   0.00000000000000E+00  -1.13162543727848E-12
     -9.83953711977526E-23  -1.32938859395073E-08  -1.32950175649447E-08  -2.90845658157239E-18
      1.66003399129950E-11
      0.00000000000000E+00  -1.34624178904049E-11   0.00000000000000E+00  -2.27843715419127E-14   1.85666207790093E-22
      1.34624099118385E-08   1.34623871274672E-08  -7.82296391324499E-19  -2.53762687039747E-01  -2.53762687039587E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59779586262980E-10   0.00000000000000E+00  -1.59779586262980E-10
      3.69074262705970E-18  -2.53762672134294E-01  -2.49571643796449E-01   0.00000000000000E+00  -1.07681270666598E-12
     -9.83956778641108E-23  -1.33015307284977E-08  -1.33026075412045E-08  -2.90844623573520E-18
      1.70621644987482E-11
      0.00000000000000E+00  -1.34621423561932E-11   0.00000000000000E+00  -2.09396161677707E-14   1.85818868983427E-22
      1.34621681903766E-08   1.34621472507606E-08  -7.82240526661278E-19  -2.53786009595752E-01  -2.53786009595602E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49978122344960E-10   0.00000000000000E+00  -1.49978122344960E-10
      3.69067336347548E-18  -2.53785994547979E-01  -2.49591953829796E-01   0.00000000000000E+00  -1.00721343361522E-12
     -9.83960537104316E-23  -1.33111619149824E-08  -1.33121691284161E-08  -2.90843283681420E-18
      1.76856276895149E-11
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00  -1.86747953951260E-14   1.86005570872902E-22
      1.34618753586470E-08   1.34618566838518E-08  -7.82171679898196E-19  -2.53814742187345E-01  -2.53814742187207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37921924744731E-10   0.00000000000000E+00  -1.37921924744731E-10
      3.69058737423220E-18  -2.53814727078041E-01  -2.49616979604404E-01   0.00000000000000E+00  -9.21181478648569E-13
     -9.83965930268043E-23  -1.33230135776287E-08  -1.33239347591075E-08  -2.90841569433400E-18
      1.85273029970500E-11
      0.00000000000000E+00  -1.34614994430328E-11   0.00000000000000E+00  -1.64546413993696E-14   1.86226431845633E-22
      1.34615282516214E-08   1.34615117969802E-08  -7.82089315704844E-19  -2.53849099389078E-01  -2.53849099388954E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23538098914152E-10   0.00000000000000E+00  -1.23538098914152E-10
      3.69048339526480E-18  -2.53849084177569E-01  -2.49646913697823E-01   0.00000000000000E+00  -8.18129774190557E-13
     -9.83972768432390E-23  -1.33371555682929E-08  -1.33379736980672E-08  -2.90839407955996E-18
      1.96635646622224E-11
      0.00000000000000E+00  -1.34611320640840E-11   0.00000000000000E+00  -1.39965345241487E-14   1.86476419708233E-22
      1.34611300435732E-08   1.34611160470389E-08  -7.81994489642016E-19  -2.53888627139744E-01  -2.53888627139637E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07049068577822E-10   0.00000000000000E+00  -1.07049068577822E-10
      3.69036175951189E-18  -2.53888611793013E-01  -2.49681371111698E-01   0.00000000000000E+00  -6.99885333172319E-13
     -9.83980913102256E-23  -1.33533670931274E-08  -1.33540669784606E-08  -2.90836726986987E-18
      2.04305412862137E-11
      0.00000000000000E+00  -1.34608565298723E-11   0.00000000000000E+00  -1.25413415834833E-14   1.86625601982076E-22
      1.34608894744773E-08   1.34608769331359E-08  -7.81937139344430E-19  -2.53912520346096E-01  -2.53912520345999E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71108889961210E-11   0.00000000000000E+00  -9.71108889961210E-11
      3.69028727773009E-18  -2.53912504922784E-01  -2.49702208542776E-01   0.00000000000000E+00  -6.28576538477788E-13
     -9.83985943960621E-23  -1.33631374676005E-08  -1.33637660441391E-08  -2.90835013838566E-18
      2.14659597286021E-11
      0.00000000000000E+00  -1.34605809956607E-11   0.00000000000000E+00  -1.06501995358396E-14   1.86796404978350E-22
      1.34606087308464E-08   1.34605980806471E-08  -7.81870152357730E-19  -2.53940407316852E-01  -2.53940407316766E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55658194701551E-11   0.00000000000000E+00  -8.55658194701551E-11
      3.69019868130257E-18  -2.53940391827885E-01  -2.49726546083540E-01   0.00000000000000E+00  -5.45837771292797E-13
     -9.83991992868584E-23  -1.33744864234082E-08  -1.33750322611796E-08  -2.90832852894485E-18
      2.28637746258263E-11
      0.00000000000000E+00  -1.34603054614491E-11   0.00000000000000E+00  -8.53297744595474E-15   1.86981430807584E-22
      1.34602954168176E-08   1.34602868838403E-08  -7.81795314695978E-19  -2.53971528546634E-01  -2.53971528546561E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27811795422771E-11   0.00000000000000E+00  -7.27811795422771E-11
      3.69009694668557E-18  -2.53971513040382E-01  -2.49753737609997E-01   0.00000000000000E+00  -4.54112994377529E-13
     -9.83999040433643E-23  -1.33870515913034E-08  -1.33875057042978E-08  -2.90830163198959E-18
      2.47508247370791E-11
      0.00000000000000E+00  -1.34599380825003E-11   0.00000000000000E+00  -6.14048566167294E-15   1.87167515336813E-22
      1.34599647223513E-08   1.34599585818658E-08  -7.81716203150416E-19  -2.54004374157329E-01  -2.54004374157270E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94643006801718E-11   0.00000000000000E+00  -5.94643006801718E-11
      3.68998473457036E-18  -2.54004358743677E-01  -2.49782491397267E-01   0.00000000000000E+00  -3.58650142166203E-13
     -9.84006970239346E-23  -1.34001356310427E-08  -1.34004942811850E-08  -2.90826853141994E-18
      2.72983423872703E-11
      0.00000000000000E+00  -1.34595707035514E-11   0.00000000000000E+00  -3.63406682437470E-15   1.87336442679940E-22
      1.34596382758379E-08   1.34596346417713E-08  -7.81637925638987E-19  -2.54036795344543E-01  -2.54036795344496E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66205216839222E-11   0.00000000000000E+00  -4.66205216839222E-11
      3.68986596796851E-18  -2.54036780231473E-01  -2.49810968704232E-01   0.00000000000000E+00  -2.66717061988546E-13
     -9.84015593470291E-23  -1.34127474030258E-08  -1.34130141200879E-08  -2.90822804232952E-18
      3.07374912150284E-11
      0.00000000000000E+00  -1.34592951693398E-11   0.00000000000000E+00  -3.45493110982764E-15   1.87468121061131E-22
      1.34593393861556E-08   1.34593359312247E-08  -7.81565999942743E-19  -2.54066478769813E-01  -2.54066478769778E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53540984508886E-11   0.00000000000000E+00  -3.53540984508886E-11
      3.68974437996226E-18  -2.54066464294887E-01  -2.49837196926235E-01   0.00000000000000E+00  -1.84073105422067E-13
     -9.84024740116435E-23  -1.34237977596680E-08  -1.34239818327735E-08  -2.90817838001952E-18
      3.30589166737651E-11
      0.00000000000000E+00  -1.34592033246026E-11   0.00000000000000E+00  -2.76635466452140E-15   1.87525083752434E-22
      1.34591849324057E-08   1.34591821660512E-08  -7.81528720389454E-19  -2.54081817761881E-01  -2.54081817761851E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97756817591813E-11   0.00000000000000E+00  -2.97756817591813E-11
      3.68967525793658E-18  -2.54081803804733E-01  -2.49850827360163E-01   0.00000000000000E+00  -1.43779467991485E-13
     -9.84030072779845E-23  -1.34292627048227E-08  -1.34294064842908E-08  -2.90814653754712E-18
      3.38423977660888E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -3.08341886895873E-15   1.87541082230854E-22
      1.34591374879629E-08   1.34591344045442E-08  -7.81517281996260E-19  -2.54086518374119E-01  -2.54086518374091E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80982630654842E-11   0.00000000000000E+00  -2.80982630654842E-11
      3.68965324347873E-18  -2.54086504658414E-01  -2.49855014615443E-01   0.00000000000000E+00  -1.31155540843222E-13
     -9.84031867848075E-23  -1.34309049859387E-08  -1.34310361414796E-08  -2.90813596148248E-18
      3.49000972407257E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.23684469057932E-15   1.87557660992246E-22
      1.34590810737690E-08   1.34590788369245E-08  -7.81503627167393E-19  -2.54092120500077E-01  -2.54092120500050E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61549699392007E-11   0.00000000000000E+00  -2.61549699392007E-11
      3.68962557938077E-18  -2.54092107066368E-01  -2.49860022471537E-01   0.00000000000000E+00  -1.17730093602144E-13
     -9.84033978520339E-23  -1.34328061368916E-08  -1.34329238669853E-08  -2.90812195221338E-18
      3.63279915314855E-11
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00  -1.91423132774163E-15   1.87572618344600E-22
      1.34590162128712E-08   1.34590142986400E-08  -7.81487855203978E-19  -2.54098577037176E-01  -2.54098577037152E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40092638095077E-11   0.00000000000000E+00  -2.40092638095077E-11
      3.68959129669005E-18  -2.54098563951073E-01  -2.49865823686649E-01   0.00000000000000E+00  -1.02311842475905E-13
     -9.84036706500866E-23  -1.34349027229880E-08  -1.34350050348306E-08  -2.90810344148608E-18
      3.82556488240113E-11
      0.00000000000000E+00  -1.34589277903910E-11   0.00000000000000E+00  -1.58322754249208E-15   1.87582513201229E-22
      1.34589441070666E-08   1.34589425238392E-08  -7.81470292714061E-19  -2.54105746584653E-01  -2.54105746584631E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17796184558087E-11   0.00000000000000E+00  -2.17796184558087E-11
      3.68954931304971E-18  -2.54105733985998E-01  -2.49872313889116E-01   0.00000000000000E+00  -8.63371307172275E-14
     -9.84040117204719E-23  -1.34370765682519E-08  -1.34371629053827E-08  -2.90807902033565E-18
      4.08579861689211E-11
      0.00000000000000E+00  -1.34588359456538E-11   0.00000000000000E+00  -1.25783647036016E-15   1.87582698969828E-22
      1.34588668804308E-08   1.34588656225945E-08  -7.81451424410259E-19  -2.54113424920977E-01  -2.54113424920957E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96313438108480E-11   0.00000000000000E+00  -1.96313438108480E-11
      3.68949822567058E-18  -2.54113413001618E-01  -2.49879340325697E-01   0.00000000000000E+00  -7.10167942295002E-14
     -9.84044346299278E-23  -1.34391632619895E-08  -1.34392342787838E-08  -2.90804680126032E-18
      4.43711415845494E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -1.02930864335772E-15   1.87567718348439E-22
      1.34587863262457E-08   1.34587852969373E-08  -7.81431679444565E-19  -2.54121438963898E-01  -2.54121438963880E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77413457771520E-11   0.00000000000000E+00  -1.77413457771520E-11
      3.68943589756558E-18  -2.54121427964611E-01  -2.49886785141518E-01   0.00000000000000E+00  -5.75919479006422E-14
     -9.84049601533167E-23  -1.34409863592120E-08  -1.34410439511600E-08  -2.90800421812102E-18
      4.55568315373239E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.55747060191565E-16   1.87561211653818E-22
      1.34587614180214E-08   1.34587604622745E-08  -7.81425567652719E-19  -2.54123917726351E-01  -2.54123917726333E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72003927975279E-11   0.00000000000000E+00  -1.72003927975279E-11
      3.68941550323266E-18  -2.54123907036839E-01  -2.49889101610711E-01   0.00000000000000E+00  -5.37743120219566E-14
     -9.84051328237365E-23  -1.34415062951655E-08  -1.34415600694776E-08  -2.90798993557994E-18
      4.57569167168546E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.43184323902200E-16   1.87560073551517E-22
      1.34587572773321E-08   1.34587563341479E-08  -7.81424551543917E-19  -2.54124329777515E-01  -2.54124329777498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71117821130953E-11   0.00000000000000E+00  -1.71117821130953E-11
      3.68941207941866E-18  -2.54124319140261E-01  -2.49889487098111E-01   0.00000000000000E+00  -5.31501276832377E-14
     -9.84051618168088E-23  -1.34415914019089E-08  -1.34416445520366E-08  -2.90798752787475E-18
      4.60270317092211E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.26918123967809E-16   1.87558466960282E-22
      1.34587517976216E-08   1.34587508707037E-08  -7.81423206499042E-19  -2.54124875134947E-01  -2.54124875134930E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69968343374185E-11   0.00000000000000E+00  -1.69968343374185E-11
      3.68940748831888E-18  -2.54124864568219E-01  -2.49889998033265E-01   0.00000000000000E+00  -5.23412218303594E-14
     -9.84052009116726E-23  -1.34417016951493E-08  -1.34417540363712E-08  -2.90798428181985E-18
      4.63916869489158E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.06026698439194E-16   1.87556177593884E-22
      1.34587445901047E-08   1.34587436840782E-08  -7.81421436788860E-19  -2.54125592552441E-01  -2.54125592552424E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68497142435147E-11   0.00000000000000E+00  -1.68497142435147E-11
      3.68940134398230E-18  -2.54125582080793E-01  -2.49890671460155E-01   0.00000000000000E+00  -5.13076397828823E-14
     -9.84052533543351E-23  -1.34418426621893E-08  -1.34418939698292E-08  -2.90797990719344E-18
      4.68839715225036E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.79858128188058E-16   1.87552884439061E-22
      1.34587351813597E-08   1.34587343015018E-08  -7.81419125845087E-19  -2.54126529220987E-01  -2.54126529220971E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66647316572782E-11   0.00000000000000E+00  -1.66647316572782E-11
      3.68939314019198E-18  -2.54126518877357E-01  -2.49891552934424E-01   0.00000000000000E+00  -5.00110369979416E-14
     -9.84053234268676E-23  -1.34420195588109E-08  -1.34420695698480E-08  -2.90797401434689E-18
      4.75485556968472E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.47830378488172E-16   1.87548106585838E-22
      1.34587230098441E-08   1.34587221620139E-08  -7.81416135493748E-19  -2.54127741129701E-01  -2.54127741129685E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64374870909049E-11   0.00000000000000E+00  -1.64374870909049E-11
      3.68938221609819E-18  -2.54127730958200E-01  -2.49892697247097E-01   0.00000000000000E+00  -4.84235368871192E-14
     -9.84054168857589E-23  -1.34422362513855E-08  -1.34422846749224E-08  -2.90796608060445E-18
      4.84457443322111E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.09819571500790E-16   1.87541129655283E-22
      1.34587074262952E-08   1.34587066164758E-08  -7.81412306303420E-19  -2.54129293083221E-01  -2.54129293083205E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61665994180113E-11   0.00000000000000E+00  -1.61665994180113E-11
      3.68936771160892E-18  -2.54129283142708E-01  -2.49894168987025E-01   0.00000000000000E+00  -4.65405903986727E-14
     -9.84055413143687E-23  -1.34424934764681E-08  -1.34425400170586E-08  -2.90795540530550E-18
      4.96569489899523E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.66467882187606E-16   1.87530911663316E-22
      1.34586876897140E-08   1.34586869232463E-08  -7.81407457557277E-19  -2.54131259123916E-01  -2.54131259123900E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58558233328767E-11   0.00000000000000E+00  -1.58558233328767E-11
      3.68934850696185E-18  -2.54131249492518E-01  -2.49896043632536E-01   0.00000000000000E+00  -4.43967147102078E-14
     -9.84057066291275E-23  -1.34427867031982E-08  -1.34428310999131E-08  -2.90794104940457E-18
      5.12920752779030E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.19890557336093E-16   1.87515974420923E-22
      1.34586629385195E-08   1.34586622186291E-08  -7.81401382638783E-19  -2.54133725344451E-01  -2.54133725344436E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55158611945742E-11   0.00000000000000E+00  -1.55158611945742E-11
      3.68932313656933E-18  -2.54133716125683E-01  -2.49898410945613E-01   0.00000000000000E+00  -4.20788409921917E-14
     -9.84059258535270E-23  -1.34431042785941E-08  -1.34431463574352E-08  -2.90792175393055E-18
      5.18439304000863E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00   1.43690105322256E-15   1.87510988630376E-22
      1.34586539289849E-08   1.34586553658861E-08  -7.81399384433195E-19  -2.54134536875352E-01  -2.54134536875336E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54061970698876E-11   0.00000000000000E+00  -1.54061970698876E-11
      3.68931463458056E-18  -2.54134528268065E-01  -2.49899191397758E-01   0.00000000000000E+00  -4.37623788043530E-14
     -9.84071335195927E-23  -1.34432054064349E-08  -1.34432491688138E-08  -2.90791525014737E-18
      5.19370559519547E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.97115221295630E-16   1.87510160202332E-22
      1.34586527590413E-08   1.34586521619263E-08  -7.81399048608744E-19  -2.54134673342424E-01  -2.54134673342408E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53886283373828E-11   0.00000000000000E+00  -1.53886283373828E-11
      3.68931320150606E-18  -2.54134664836919E-01  -2.49899322741198E-01   0.00000000000000E+00  -4.13788331800300E-14
     -9.84084472821658E-23  -1.34432221547474E-08  -1.34432635335807E-08  -2.90791415289732E-18
      5.20627754469771E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -5.48560774315556E-16   1.87509023495284E-22
      1.34586513045604E-08   1.34586507559998E-08  -7.81398597413455E-19  -2.54134856669784E-01  -2.54134856669769E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53655851225030E-11   0.00000000000000E+00  -1.53655851225030E-11
      3.68931126975245E-18  -2.54134848231861E-01  -2.49899499319483E-01   0.00000000000000E+00  -4.11074688389731E-14
     -9.84079479683129E-23  -1.34432440634133E-08  -1.34432851708822E-08  -2.90791267233900E-18
      5.22324967652574E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.13276248972358E-16   1.87507447612547E-22
      1.34586491207217E-08   1.34586485074456E-08  -7.81397992495279E-19  -2.54135102469478E-01  -2.54135102469463E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53351724521400E-11   0.00000000000000E+00  -1.53351724521400E-11
      3.68930866704677E-18  -2.54135094065134E-01  -2.49899736279872E-01   0.00000000000000E+00  -4.07957976649784E-14
     -9.84071126579583E-23  -1.34432725391983E-08  -1.34433133349961E-08  -2.90791067455149E-18
      5.24616205449357E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.75166987026362E-16   1.87505245388911E-22
      1.34586458904297E-08   1.34586452152629E-08  -7.81397183563894E-19  -2.54135431234563E-01  -2.54135431234548E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52952452041370E-11   0.00000000000000E+00  -1.52952452041370E-11
      3.68930516254238E-18  -2.54135422864273E-01  -2.49900053537412E-01   0.00000000000000E+00  -4.04837512107204E-14
     -9.84065374424589E-23  -1.34433094863108E-08  -1.34433499700621E-08  -2.90790797897849E-18
      5.27709376475014E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.96595552423516E-16   1.87502190684304E-22
      1.34586414049701E-08   1.34586407083748E-08  -7.81396105139847E-19  -2.54135869681977E-01  -2.54135869681962E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52433374605141E-11   0.00000000000000E+00  -1.52433374605141E-11
      3.68930044751740E-18  -2.54135861375867E-01  -2.49900477115724E-01   0.00000000000000E+00  -4.01482538723172E-14
     -9.84062788069903E-23  -1.34433572226624E-08  -1.34433973709164E-08  -2.90790434237756E-18
      5.31885157359651E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.90558615088668E-16   1.87498007735663E-22
      1.34586354172908E-08   1.34586347267324E-08  -7.81394672773905E-19  -2.54136452338613E-01  -2.54136452338598E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51768108428322E-11   0.00000000000000E+00  -1.51768108428322E-11
      3.68929411001374E-18  -2.54136444143608E-01  -2.49901040809253E-01   0.00000000000000E+00  -3.97373882747226E-14
     -9.84062204002581E-23  -1.34434181784996E-08  -1.34434579158879E-08  -2.90789943723984E-18
      5.37522461553911E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.73262046348153E-16   1.87492310410347E-22
      1.34586275590700E-08   1.34586268858081E-08  -7.81392778707225E-19  -2.54137223407860E-01  -2.54137223407845E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50932060812771E-11   0.00000000000000E+00  -1.50932060812771E-11
      3.68928560151435E-18  -2.54137215382027E-01  -2.49901788178933E-01   0.00000000000000E+00  -3.92106945587879E-14
     -9.84062606656606E-23  -1.34434944690315E-08  -1.34435336797262E-08  -2.90789282280712E-18
      5.45132822216163E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.53339677090873E-16   1.87484526757184E-22
      1.34586173020250E-08   1.34586166486855E-08  -7.81390286848302E-19  -2.54138239013696E-01  -2.54138239013681E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49907265978089E-11   0.00000000000000E+00  -1.49907265978089E-11
      3.68927419303075E-18  -2.54138231225942E-01  -2.49902774962796E-01   0.00000000000000E+00  -3.85522566086364E-14
     -9.84063520296686E-23  -1.34435873698295E-08  -1.34436259220862E-08  -2.90788390618244E-18
      5.55406809110202E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.33701013414034E-16   1.87473833891329E-22
      1.34586039324826E-08   1.34586032987818E-08  -7.81387026589907E-19  -2.54139570110797E-01  -2.54139570110782E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48688782282136E-11   0.00000000000000E+00  -1.48688782282136E-11
      3.68925891676474E-18  -2.54139562643549E-01  -2.49904072199200E-01   0.00000000000000E+00  -3.77674259432442E-14
     -9.84064835976958E-23  -1.34436966531266E-08  -1.34437344205526E-08  -2.90787189017483E-18
      5.69276691417155E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.14297513712913E-16   1.87459089665874E-22
      1.34585865293621E-08   1.34585859150647E-08  -7.81382784214454E-19  -2.54141306745792E-01  -2.54141306745777E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47291806193150E-11   0.00000000000000E+00  -1.47291806193150E-11
      3.68923848756458E-18  -2.54141299700216E-01  -2.49905770722569E-01   0.00000000000000E+00  -3.68798759074702E-14
     -9.84066615147826E-23  -1.34438198545694E-08  -1.34438567344454E-08  -2.90785570335012E-18
      5.88001032531541E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.94789339204076E-16   1.87438743561514E-22
      1.34585639123358E-08   1.34585633175466E-08  -7.81377289510330E-19  -2.54143564947116E-01  -2.54143564947101E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45755800079403E-11   0.00000000000000E+00  -1.45755800079403E-11
      3.68921119575138E-18  -2.54143558451278E-01  -2.49907988203422E-01   0.00000000000000E+00  -3.59317963688440E-14
     -9.84068998497243E-23  -1.34439518057419E-08  -1.34439877375384E-08  -2.90783390624104E-18
      6.13278893035963E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.75702314598636E-16   1.87410725010900E-22
      1.34585345265515E-08   1.34585339508493E-08  -7.81370194438793E-19  -2.54146498057002E-01  -2.54146498056988E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44139690564743E-11   0.00000000000000E+00  -1.44139690564743E-11
      3.68917476032146E-18  -2.54146492283069E-01  -2.49910880374817E-01   0.00000000000000E+00  -3.49811681582181E-14
     -9.84072186545653E-23  -1.34440850006251E-08  -1.34441199817933E-08  -2.90780456588267E-18
      6.47404004716933E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.58202274199044E-16   1.87372312545152E-22
      1.34584962493769E-08   1.34584956911748E-08  -7.81361041885721E-19  -2.54150314164807E-01  -2.54150314164792E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42503244987425E-11   0.00000000000000E+00  -1.42503244987425E-11
      3.68912613092996E-18  -2.54150309379658E-01  -2.49914657973183E-01   0.00000000000000E+00  -3.40900178247971E-14
     -9.84076450279056E-23  -1.34442112766577E-08  -1.34442453666756E-08  -2.90776508904424E-18
      6.93472905486242E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.43436800283973E-16   1.87319975591143E-22
      1.34584461161762E-08   1.34584455727396E-08  -7.81349227556501E-19  -2.54155299754352E-01  -2.54155299754338E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40876515172735E-11   0.00000000000000E+00  -1.40876515172735E-11
      3.68906123066798E-18  -2.54155296478561E-01  -2.49919609617559E-01   0.00000000000000E+00  -3.33040664375946E-14
     -9.84082154174809E-23  -1.34443246171560E-08  -1.34443579212225E-08  -2.90771200311148E-18
      7.55665921524809E-11
      0.00000000000000E+00  -1.34583767219677E-11   0.00000000000000E+00  -5.31926099306314E-16   1.87249162743478E-22
      1.34583799806188E-08   1.34583794486929E-08  -7.81333966426170E-19  -2.54161847044123E-01  -2.54161847044109E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39230211180915E-11   0.00000000000000E+00  -1.39230211180915E-11
      3.68897463920041E-18  -2.54161846520050E-01  -2.49926128632386E-01   0.00000000000000E+00  -3.26329886281234E-14
     -9.84089787617674E-23  -1.34444237945860E-08  -1.34444564275747E-08  -2.90764067277424E-18
      8.39626493176874E-11
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00  -5.23307321764880E-16   1.87154004974186E-22
      1.34582921421931E-08   1.34582916188860E-08  -7.81314281912313E-19  -2.54170480903765E-01  -2.54170480903751E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37465521774201E-11   0.00000000000000E+00  -1.37465521774201E-11
      3.68885922236250E-18  -2.54170486336345E-01  -2.49934740533299E-01   0.00000000000000E+00  -3.20446286795137E-14
     -9.84100004813031E-23  -1.34445130220799E-08  -1.34445450667087E-08  -2.90754494045019E-18
      9.52973264907162E-11
      0.00000000000000E+00  -1.34581930324933E-11   0.00000000000000E+00  -5.16258708402972E-16   1.87026925790456E-22
      1.34581750247610E-08   1.34581745085024E-08  -7.81289035115251E-19  -2.54181883047063E-01  -2.54181883047049E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35432407553725E-11   0.00000000000000E+00  -1.35432407553725E-11
      3.68870571410066E-18  -2.54181902410609E-01  -2.49946129463713E-01   0.00000000000000E+00  -3.14787338009330E-14
     -9.84113674365195E-23  -1.34445997890131E-08  -1.34446312677470E-08  -2.90741667898541E-18
      1.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00  -5.07412137192015E-16   1.86858198565216E-22
      1.34580194720208E-08   1.34580189646089E-08  -7.81257002347694E-19  -2.54196916127741E-01  -2.54196916127728E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32968236074602E-11   0.00000000000000E+00  -1.32968236074602E-11
      3.68850224857659E-18  -2.54196965943133E-01  -2.49961164384778E-01   0.00000000000000E+00  -3.08685679967457E-14
     -9.84131938464000E-23  -1.34446912724333E-08  -1.34447221410014E-08  -2.90724524622890E-18
      1.30599140674305E-10
      0.00000000000000E+00  -1.34578256535445E-11   0.00000000000000E+00  -4.85929891093261E-16   1.86642493585620E-22
      1.34578249409884E-08   1.34578244550586E-08  -7.81218172406561E-19  -2.54216045914434E-01  -2.54216045914421E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30039441517504E-11   0.00000000000000E+00  -1.30039441517504E-11
      3.68824216969356E-18  -2.54216137980046E-01  -2.49980305453249E-01   0.00000000000000E+00  -3.01648082177403E-14
     -9.84155501791643E-23  -1.34447903460986E-08  -1.34448205109069E-08  -2.90702399728699E-18
      1.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00  -4.43365270011906E-16   1.86431518524281E-22
      1.34576465825901E-08   1.34576461392250E-08  -7.81182014462979E-19  -2.54234724036501E-01  -2.54234724036488E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27368006064062E-11   0.00000000000000E+00  -1.27368006064062E-11
      3.68798743368143E-18  -2.54234818793596E-01  -2.49998958305115E-01   0.00000000000000E+00  -2.94886042871558E-14
     -9.84178732951962E-23  -1.34448798500143E-08  -1.34449093386187E-08  -2.90680541921845E-18
      1.70599140674305E-10
      0.00000000000000E+00  -1.34574582745956E-11   0.00000000000000E+00  -3.86601538239529E-16   1.86225144093450E-22
      1.34574902143286E-08   1.34574898277273E-08  -7.81148215412751E-19  -2.54253005623547E-01  -2.54253005623535E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24935873558475E-11   0.00000000000000E+00  -1.24935873558475E-11
      3.68773756193431E-18  -2.54253008499432E-01  -2.50017120655568E-01   0.00000000000000E+00  -2.88044693895375E-14
     -9.84201589119767E-23  -1.34449674359018E-08  -1.34449962403713E-08  -2.90658934652156E-18
      1.90599140674305E-10
      0.00000000000000E+00  -1.34573664298584E-11   0.00000000000000E+00  -3.40414881680157E-16   1.86023124958013E-22
      1.34573516320699E-08   1.34573512916553E-08  -7.81116544959929E-19  -2.54270917785400E-01  -2.54270917785388E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22674298974252E-11   0.00000000000000E+00  -1.22674298974252E-11
      3.68749221333636E-18  -2.54270705673179E-01  -2.50034790246708E-01   0.00000000000000E+00  -2.81300709352459E-14
     -9.84224051338364E-23  -1.34450557316868E-08  -1.34450838617578E-08  -2.90637566837643E-18
      2.10599140674305E-10
      0.00000000000000E+00  -1.34571827403840E-11   0.00000000000000E+00  -3.68843121971854E-16   1.85824960606789E-22
      1.34572075306990E-08   1.34572071618561E-08  -7.81086910727186E-19  -2.54288432755574E-01  -2.54288432755562E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20427781246245E-11   0.00000000000000E+00  -1.20427781246245E-11
      3.68725135777387E-18  -2.54287944221726E-01  -2.50052003443541E-01   0.00000000000000E+00  -2.75397750211753E-14
     -9.84246190916674E-23  -1.34451368439564E-08  -1.34451643837315E-08  -2.90616444704668E-18
      2.30599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -4.73424154886574E-16   1.85629840139756E-22
      1.34570143376205E-08   1.34570138641965E-08  -7.81059381204681E-19  -2.54305455523359E-01  -2.54305455523347E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17979471863100E-11   0.00000000000000E+00  -1.17979471863100E-11
      3.68701539883014E-18  -2.54304834860635E-01  -2.50068877873298E-01   0.00000000000000E+00  -2.72376682551244E-14
     -9.84268225697252E-23  -1.34451886793418E-08  -1.34452159170102E-08  -2.90595601762546E-18
      2.50599140674305E-10
      0.00000000000000E+00  -1.34567235166980E-11   0.00000000000000E+00  -7.18479900847745E-16   1.85436853328248E-22
      1.34567265238380E-08   1.34567258053583E-08  -7.81034099949116E-19  -2.54321861062587E-01  -2.54321861062576E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15179408938127E-11   0.00000000000000E+00  -1.15179408938127E-11
      3.68678504001227E-18  -2.54321577646073E-01  -2.50085623213345E-01   0.00000000000000E+00  -2.73013873247360E-14
     -9.84290497198852E-23  -1.34451805630771E-08  -1.34452078644645E-08  -2.90575094006315E-18
      2.70599140674305E-10
      0.00000000000000E+00  -1.34562642930120E-11   0.00000000000000E+00  -9.45010420592718E-16   1.85245596194759E-22
      1.34563408923017E-08   1.34563399472914E-08  -7.81011032649026E-19  -2.54337608609423E-01  -2.54337608609412E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12174058027963E-11   0.00000000000000E+00  -1.12174058027963E-11
      3.68656069189621E-18  -2.54338395848027E-01  -2.50102468322704E-01   0.00000000000000E+00  -2.77316945226741E-14
     -9.84313287597502E-23  -1.34450948097940E-08  -1.34451225414886E-08  -2.90554965924718E-18
      2.90599140674305E-10
      0.00000000000000E+00  -1.34559887588003E-11   0.00000000000000E+00  -9.44120974601455E-16   1.85057064176159E-22
      1.34559549504903E-08   1.34559540063696E-08  -7.80989587906186E-19  -2.54352915815267E-01  -2.54352915815256E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09630426544248E-11   0.00000000000000E+00  -1.09630426544248E-11
      3.68634143104312E-18  -2.54355357254579E-01  -2.50119471205511E-01   0.00000000000000E+00  -2.80469008119129E-14
     -9.84336459760347E-23  -1.34449629168142E-08  -1.34449909637151E-08  -2.90535184313694E-18
      3.10599140674305E-10
      0.00000000000000E+00  -1.34557132245887E-11   0.00000000000000E+00  -3.80604791934198E-16   1.84874272406740E-22
      1.34557973659023E-08   1.34557969852977E-08  -7.80968336733116E-19  -2.54368391105438E-01  -2.54368391105427E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08715829254128E-11   0.00000000000000E+00  -1.08715829254128E-11
      3.68612399938461E-18  -2.54372120935373E-01  -2.50136255563322E-01   0.00000000000000E+00  -2.73737796243695E-14
     -9.84359058257622E-23  -1.34448980285926E-08  -1.34449254023723E-08  -2.90515566265150E-18
      3.30599140674305E-10
      0.00000000000000E+00  -1.34561724482747E-11   0.00000000000000E+00   9.37061570964968E-16   1.84701620803947E-22
      1.34561624837405E-08   1.34561634208022E-08  -7.80945248348981E-19  -2.54384932855306E-01  -2.54384932855295E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10534226971955E-11   0.00000000000000E+00  -1.10534226971955E-11
      3.68590293093067E-18  -2.54387774578374E-01  -2.50151851078265E-01   0.00000000000000E+00  -2.47489623119371E-14
     -9.84379237277408E-23  -1.34450852491427E-08  -1.34451099981051E-08  -2.90495768258169E-18
      3.50599140674305E-10
      0.00000000000000E+00  -1.34571827403840E-11   0.00000000000000E+00   2.61548631275865E-15   1.84542007322272E-22
      1.34571913475977E-08   1.34571939630842E-08  -7.80918871845536E-19  -2.54403194924593E-01  -2.54403194924582E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14892614562548E-11   0.00000000000000E+00  -1.14892614562548E-11
      3.68567314570154E-18  -2.54401048744471E-01  -2.50164937912085E-01   0.00000000000000E+00  -1.99397213758176E-14
     -9.84395013644686E-23  -1.34456847619064E-08  -1.34457047016279E-08  -2.90475427385601E-18
      3.70599140674305E-10
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00   3.64537522233488E-15   1.84391740641580E-22
      1.34585254068490E-08   1.34585290522244E-08  -7.80890472500542E-19  -2.54422606582316E-01  -2.54422606582304E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18800318293226E-11   0.00000000000000E+00  -1.18800318293226E-11
      3.68543554506496E-18  -2.54411179660598E-01  -2.50174771419355E-01   0.00000000000000E+00  -1.49665205714969E-14
     -9.84406145630254E-23  -1.34466340538745E-08  -1.34466490203951E-08  -2.90454507256442E-18
      3.90599140674305E-10
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00   1.26448236324188E-15   1.84235660042749E-22
      1.34590247786835E-08   1.34590260431661E-08  -7.80866162559483E-19  -2.54440376673711E-01  -2.54440376673700E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15901872146906E-11   0.00000000000000E+00  -1.15901872146906E-11
      3.68520374132067E-18  -2.54419373188950E-01  -2.50182716963772E-01   0.00000000000000E+00  -1.35523082121718E-14
     -9.84416663984941E-23  -1.34474223036431E-08  -1.34474358559514E-08  -2.90433757876118E-18
      4.10599140674305E-10
      0.00000000000000E+00  -1.34569072061724E-11   0.00000000000000E+00  -4.58033349262654E-15   1.84047712166967E-22
      1.34569268312210E-08   1.34569222508877E-08  -7.80856803641502E-19  -2.54451496823890E-01  -2.54451496823880E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86520842019198E-12   0.00000000000000E+00  -9.86520842019198E-12
      3.68500643715226E-18  -2.54430146464597E-01  -2.50193609777527E-01   0.00000000000000E+00  -2.34431119818667E-14
     -9.84436286098826E-23  -1.34470335993555E-08  -1.34470570424676E-08  -2.90414963351076E-18
      4.30599140674305E-10
      0.00000000000000E+00  -1.34508454535167E-11   0.00000000000000E+00  -1.32787107213746E-14   1.83803604511746E-22
      1.34508570669835E-08   1.34508437882730E-08  -7.80872893916177E-19  -2.54451033860250E-01  -2.54451033860244E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.45607437115240E-12   0.00000000000000E+00  -6.45607437115240E-12
      3.68487731566484E-18  -2.54450985469913E-01  -2.50215290135433E-01   0.00000000000000E+00  -4.79611391766603E-14
     -9.84477796953400E-23  -1.34443397527625E-08  -1.34443877139018E-08  -2.90400442174866E-18
      4.50599140674305E-10
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00  -2.17530561031714E-14   1.83508152576207E-22
      1.34417624746898E-08   1.34417407216339E-08  -7.80913128147089E-19  -2.54439353375890E-01  -2.54439353375887E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.53992952540634E-12   0.00000000000000E+00  -2.53992952540634E-12
      3.68482651707433E-18  -2.54488479994528E-01  -2.50254418542458E-01   0.00000000000000E+00  -7.82856826067483E-14
     -9.84547814012078E-23  -1.34391225064258E-08  -1.34392007921085E-08  -2.90391338892724E-18
      4.70599140674305E-10
      0.00000000000000E+00  -1.34349563139798E-11   0.00000000000000E+00  -1.68648092904945E-14   1.83228023225118E-22
      1.34349580749479E-08   1.34349412101388E-08  -7.80950246260244E-19  -2.54428679096601E-01  -2.54428679096600E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36142898125028E-12   0.00000000000000E+00  -1.36142898125028E-12
      3.68479928849471E-18  -2.54540347480886E-01  -2.50308056767288E-01   0.00000000000000E+00  -9.44167091357153E-14
     -9.84631877551789E-23  -1.34334853644484E-08  -1.34335797811576E-08  -2.90384904223446E-18
      4.90599140674305E-10
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   1.35796098216061E-14   1.83103415034604E-22
      1.34403305729530E-08   1.34403441525630E-08  -7.80925274264429E-19  -2.54445940361404E-01  -2.54445940361397E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.57350866488642E-12   0.00000000000000E+00  -7.57350866488642E-12
      3.68464781832141E-18  -2.54586231800347E-01  -2.50354196193362E-01   0.00000000000000E+00  -6.06285657824749E-14
     -9.84681919718314E-23  -1.34327100153322E-08  -1.34327706438981E-08  -2.90372254405698E-18
      5.00599140674305E-10
      0.00000000000000E+00  -1.34474471982400E-11   0.00000000000000E+00   3.45776973479402E-14   1.83102694387808E-22
      1.34474504268251E-08   1.34474850045227E-08  -7.80888380095951E-19  -2.54465637296141E-01  -2.54465637296128E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30670711389411E-11   0.00000000000000E+00  -1.30670711389411E-11
      3.68451714761002E-18  -2.54603777041107E-01  -2.50371222104584E-01   0.00000000000000E+00  -2.42989483051661E-14
     -9.84907412519987E-23  -1.34343936344351E-08  -1.34344179333835E-08  -2.90362876751407E-18
      5.03974140674305E-10
      0.00000000000000E+00  -1.34503862298307E-11   0.00000000000000E+00   4.29374620951584E-14   1.83107948066436E-22
      1.34503756469964E-08   1.34504185844587E-08  -7.80872852246170E-19  -2.54473680620490E-01  -2.54473680620475E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51792110317713E-11   0.00000000000000E+00  -1.51792110317713E-11
      3.68446591777278E-18  -2.54608904712978E-01  -2.50376091305835E-01   0.00000000000000E+00  -1.21102219034735E-14
     -9.84706249416066E-23  -1.34352272632047E-08  -1.34352393734267E-08  -2.90359306552662E-18
      5.08530390674305E-10
      0.00000000000000E+00  -1.34556213798515E-11   0.00000000000000E+00   5.68667413773703E-14   1.83133607610017E-22
      1.34556048513273E-08   1.34556617180688E-08  -7.80844995299077E-19  -2.54487679612097E-01  -2.54487679612078E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.87449951008436E-11   0.00000000000000E+00  -1.87449951008436E-11
      3.68438051088886E-18  -2.54613939582570E-01  -2.50380597749525E-01   0.00000000000000E+00   1.15318100046192E-14
     -9.84688820057501E-23  -1.34369282547785E-08  -1.34369167229686E-08  -2.90353551558978E-18
      5.14681328174305E-10
      0.00000000000000E+00  -1.34653569219955E-11   0.00000000000000E+00   7.83407413507747E-14   1.83204794225589E-22
      1.34652786228464E-08   1.34653569635879E-08  -7.80792114798866E-19  -2.54513546402811E-01  -2.54513546402786E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48271670906566E-11   0.00000000000000E+00  -2.48271670906566E-11
      3.68422780053578E-18  -2.54615827832300E-01  -2.50381347852170E-01   0.00000000000000E+00   5.25944605182121E-14
     -9.84668762954017E-23  -1.34405823909574E-08  -1.34405297964970E-08  -2.90343568573691E-18
      5.22985093799305E-10
      0.00000000000000E+00  -1.34840932483858E-11   0.00000000000000E+00   1.13721681513732E-13   1.83383538545135E-22
      1.34839879202057E-08   1.34841016418874E-08  -7.80686247883775E-19  -2.54564261195989E-01  -2.54564261195953E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.55289806857500E-11   0.00000000000000E+00  -3.55289806857500E-11
      3.68393277620727E-18  -2.54605023272206E-01  -2.50368009924522E-01   0.00000000000000E+00   1.27187016932410E-13
     -9.84614860511744E-23  -1.34486998482189E-08  -1.34485726612020E-08  -2.90324652832350E-18
      5.34195177393055E-10
      0.00000000000000E+00  -1.35211066774805E-11   0.00000000000000E+00   1.63661572044341E-13   1.83805333640533E-22
      1.35209844958950E-08   1.35211481574672E-08  -7.80467136601173E-19  -2.54667854792164E-01  -2.54667854792110E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43622851079028E-11   0.00000000000000E+00  -5.43622851079028E-11
      3.68332337044687E-18  -2.54553275773497E-01  -2.50310523701333E-01   0.00000000000000E+00   2.71359495879748E-13
     -9.84468209947411E-23  -1.34670572318553E-08  -1.34667858723595E-08  -2.90285623384569E-18
      5.49328790244618E-10
      0.00000000000000E+00  -1.35886125593280E-11   0.00000000000000E+00   2.21029871167410E-13   1.84685026685474E-22
      1.35884167897058E-08   1.35886378195771E-08  -7.80037612908997E-19  -2.54870289139064E-01  -2.54870289138982E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.28102498017613E-11   0.00000000000000E+00  -8.28102498017613E-11
      3.68207015218622E-18  -2.54386805709442E-01  -2.50131753360964E-01   0.00000000000000E+00   5.08693356490979E-13
     -9.84106370979879E-23  -1.35063362631316E-08  -1.35058275697752E-08  -2.90203253927722E-18
      5.69328790244618E-10
      0.00000000000000E+00  -1.36558429069639E-11   0.00000000000000E+00   1.67489314688577E-13   1.85732882594781E-22
      1.36556276273157E-08   1.36557951166305E-08  -7.79503864376558E-19  -2.55127102155147E-01  -2.55127102155053E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.37142033181301E-11   0.00000000000000E+00  -9.37142033181301E-11
      3.68019586811986E-18  -2.54018863868550E-01  -2.49746088479095E-01   0.00000000000000E+00   6.81743101850570E-13
     -9.83482369993025E-23  -1.35627626564142E-08  -1.35620809133125E-08  -2.90069200374330E-18
      5.79328790244618E-10
      0.00000000000000E+00  -1.36740281649310E-11   0.00000000000000E+00   9.08086719796673E-14   1.86097114669490E-22
      1.36738673645973E-08   1.36739581732694E-08  -7.79299241519298E-19  -2.55228497559948E-01  -2.55228497559861E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71245520693447E-11   0.00000000000000E+00  -8.71245520693447E-11
      3.67932462259917E-18  -2.53808928991978E-01  -2.49528354663340E-01   0.00000000000000E+00   6.95515049247435E-13
     -9.83170197534910E-23  -1.35875291362491E-08  -1.35868336212000E-08  -2.90002538107987E-18
      5.92828790244618E-10
      0.00000000000000E+00  -1.36345349279318E-11   0.00000000000000E+00  -1.32296415642149E-13   1.85791685786742E-22
      1.36346927767081E-08   1.36345604802926E-08  -7.79345850446895E-19  -2.55220557008962E-01  -2.55220557008923E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.92680164858120E-11   0.00000000000000E+00  -3.92680164858120E-11
      3.67879450437661E-18  -2.53550537996889E-01  -2.49267301557703E-01   0.00000000000000E+00   4.37644699469473E-13
     -9.82916143488443E-23  -1.35957301085062E-08  -1.35952924638068E-08  -2.89944865392971E-18
      6.11053790244618E-10
      0.00000000000000E+00  -1.33648787794905E-11   0.00000000000000E+00  -5.68758382964850E-13   1.82368735549415E-22
      1.33656224902968E-08   1.33650537319140E-08  -7.80668632147335E-19  -2.54635262754930E-01  -2.54635262755062E-01
      0.00000000000000E+00   0.00000000000000E+00   1.31027887485501E-10   0.00000000000000E+00   1.31027887485501E-10
      3.68118248762603E-18  -2.53605824616081E-01  -2.49353891742237E-01   0.00000000000000E+00  -8.58909048964113E-13
     -9.83566946042955E-23  -1.34952227103506E-08  -1.34960816193996E-08  -2.90051385547870E-18
      6.31053790244618E-10
      0.00000000000000E+00  -1.27765213929390E-11   0.00000000000000E+00  -1.04860329882502E-12   1.74055713451837E-22
      1.27779727578027E-08   1.27769241545040E-08  -7.84143898228145E-19  -2.53056399654613E-01  -2.53056399655032E-01
      0.00000000000000E+00   0.00000000000000E+00   4.18603968127054E-10   0.00000000000000E+00   4.18603968127054E-10
      3.68955456698857E-18  -2.54725853671574E-01  -2.50568688174618E-01   0.00000000000000E+00  -3.34308749708433E-12
     -9.86326579805900E-23  -1.31921850351338E-08  -1.31955281226310E-08  -2.90541066876043E-18
      6.51053790244618E-10
      0.00000000000000E+00  -1.21294752193120E-11   0.00000000000000E+00  -1.48216051290859E-12   1.63789345831504E-22
      1.21310530283896E-08   1.21295708678768E-08  -7.88699836508202E-19  -2.50954598784040E-01  -2.50954598784675E-01
      0.00000000000000E+00   0.00000000000000E+00   6.35504703686877E-10   0.00000000000000E+00   6.35504703686877E-10
      3.70226466106231E-18  -2.57096664605291E-01  -2.53075026594381E-01   0.00000000000000E+00  -5.23297959044359E-12
     -9.90941754402835E-23  -1.27598425919732E-08  -1.27650755715638E-08  -2.91356482455411E-18
      6.71053790244618E-10
      0.00000000000000E+00  -1.20041071530237E-11   0.00000000000000E+00  -3.16952597123267E-13   1.59198984796879E-22
      1.20044215923973E-08   1.20041046398003E-08  -7.90920864892459E-19  -2.49883927901351E-01  -2.49883927901812E-01
      0.00000000000000E+00   0.00000000000000E+00   4.61631146144577E-10   0.00000000000000E+00   4.61631146144577E-10
      3.71149728398520E-18  -2.59913925576722E-01  -2.55986561210951E-01   0.00000000000000E+00  -4.73719850656157E-12
     -9.95020449356683E-23  -1.24609985874382E-08  -1.24657357859448E-08  -2.92057641909274E-18
      6.91053790244618E-10
      0.00000000000000E+00  -1.31594221023572E-11   0.00000000000000E+00   2.85317303978950E-12   1.71601475176077E-22
      1.31565400027496E-08   1.31593931757896E-08  -7.85586876790439E-19  -2.52247638843331E-01  -2.52247638842936E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94811678620125E-10   0.00000000000000E+00  -3.94811678620125E-10
      3.70360105041280E-18  -2.61004800942000E-01  -2.56983291047524E-01   0.00000000000000E+00   9.94045067959762E-13
     -9.93833859651819E-23  -1.27655755422374E-08  -1.27645814971695E-08  -2.91801417362236E-18
      7.11053790244618E-10
      0.00000000000000E+00  -1.60517047217595E-11   0.00000000000000E+00   7.15777291152969E-12   2.10805062301535E-22
      1.60445617807321E-08   1.60517195536438E-08  -7.69701606565155E-19  -2.59458557895556E-01  -2.59458557893694E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86197058989421E-09   0.00000000000000E+00  -1.86197058989421E-09
      3.66636163861492E-18  -2.56959132522265E-01  -2.52488622049159E-01   0.00000000000000E+00   1.18981582509372E-11
     -9.82459676667503E-23  -1.42016471220004E-08  -1.41897489637496E-08  -2.89666003204976E-18
      7.31053790244618E-10
      0.00000000000000E+00  -2.01166609458274E-11   0.00000000000000E+00   1.00722286946747E-11   2.73848643722858E-22
      2.01065949100980E-08   2.01166671387930E-08  -7.47162950974666E-19  -2.69840268071962E-01  -2.69840268068614E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.34839820037731E-09   0.00000000000000E+00  -3.34839820037731E-09
      3.59939367460737E-18  -2.44335828648587E-01  -2.39052933485420E-01   0.00000000000000E+00   2.31043189308234E-11
     -9.59223757952663E-23  -1.67913732573464E-08  -1.67682689384157E-08  -2.85223072363270E-18
      7.51053790244618E-10
      0.00000000000000E+00  -2.31259537604320E-11   0.00000000000000E+00   7.47246264346030E-12   3.29842988852625E-22
      2.31184068432546E-08   2.31258793058984E-08  -7.28428324068295E-19  -2.78789568585850E-01  -2.78789568581943E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.90659371964590E-09   0.00000000000000E+00  -3.90659371964590E-09
      3.52126180021445E-18  -2.23218012941384E-01  -2.17162878627310E-01   0.00000000000000E+00   2.82909266580938E-11
     -9.28736056709288E-23  -1.92475765129105E-08  -1.92192855862525E-08  -2.79283347614616E-18
      7.71053790244618E-10
      0.00000000000000E+00  -2.12030004975180E-11   0.00000000000000E+00  -4.71998937652763E-12   3.17472879588198E-22
      2.12077208946176E-08   2.12030009052414E-08  -7.28973943264257E-19  -2.79255234424711E-01  -2.79255234422724E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.98696893552293E-09   0.00000000000000E+00  -1.98696893552293E-09
      3.48152242150399E-18  -2.03227848155235E-01  -1.97173702287630E-01   0.00000000000000E+00   2.07124963000866E-11
     -9.07433826987580E-23  -1.92367444660185E-08  -1.92160319697185E-08  -2.75254847823974E-18
      7.91053790244618E-10
      0.00000000000000E+00  -1.26133132949213E-11   0.00000000000000E+00  -2.12257378137659E-11   2.05133171800110E-22
      1.26345700998743E-08   1.26133443620608E-08  -7.64782595576124E-19  -2.63586259930901E-01  -2.63586259934082E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18131875151599E-09   0.00000000000000E+00   3.18131875151599E-09
      3.54514879653431E-18  -2.00399919248631E-01  -1.95423680610008E-01   0.00000000000000E+00  -4.66151314584064E-12
     -9.18689517271047E-23  -1.57900016004309E-08  -1.57946631135768E-08  -2.78036620095819E-18
      8.11053790244618E-10
      0.00000000000000E+00  -2.27921899854198E-12   0.00000000000000E+00  -2.56329005441101E-11   6.25692846079137E-23
      2.30482601696202E-09   2.27919311641797E-09  -8.41369840138169E-19  -2.28499491646061E-01  -2.28499491654964E-01
      0.00000000000000E+00   0.00000000000000E+00   8.90335911269608E-09   0.00000000000000E+00   8.90335911269608E-09
      3.72321597878823E-18  -2.18482672812767E-01  -2.14959496625899E-01   0.00000000000000E+00  -5.01749400238871E-11
     -9.72085605292599E-23  -1.11323772890900E-08  -1.11825522291140E-08  -2.88184613865007E-18
      8.31053790244618E-10
      0.00000000000000E+00   4.21402023255574E-12   0.00000000000000E+00  -1.63441051947172E-11  -2.46736502573610E-23
     -4.19762717811575E-09  -4.21397128331049E-09  -9.54122673032567E-19  -1.74384564646488E-01  -1.74384564658950E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24622189242290E-08   0.00000000000000E+00   1.24622189242290E-08
      3.97246035727282E-18  -2.44517901604308E-01  -2.41919171050051E-01   0.00000000000000E+00  -1.13524762054288E-10
     -1.05940051845581E-22  -8.13472287886416E-09  -8.24824764091856E-09  -3.01833768424025E-18
      8.51053790244618E-10
      0.00000000000000E+00   6.20521413521492E-12   0.00000000000000E+00  -5.45479958851533E-12  -4.42395418450049E-23
     -6.19975614651207E-09  -6.20521094610063E-09  -1.08184144433558E-18  -1.08762169673415E-01  -1.08762169686660E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32459558785291E-08   0.00000000000000E+00   1.32459558785291E-08
      4.23737947484340E-18  -2.67505308978334E-01  -2.65286993048661E-01   0.00000000000000E+00  -1.79642370830952E-10
     -1.16777169962681E-22  -6.86110256159735E-09  -7.04074493242842E-09  -3.15553803050782E-18
      8.71053790244618E-10
      0.00000000000000E+00   5.04328636480250E-12   0.00000000000000E+00   2.26832480092576E-12  -4.67138295486799E-23
     -5.04552349858759E-09  -5.04325517378672E-09  -1.18265770280493E-18  -5.30070065819099E-02  -5.30070065924854E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05755462952532E-08   0.00000000000000E+00   1.05755462952532E-08
      4.44889040074846E-18  -2.87397310190187E-01  -2.85654246056924E-01   0.00000000000000E+00  -2.07294805689569E-10
     -1.27162598459919E-22  -5.32499631577674E-09  -5.53229112146644E-09  -3.26623269794352E-18
      8.91053790244618E-10
      0.00000000000000E+00   2.27168773009097E-12   0.00000000000000E+00   6.51023381642270E-12  -4.72326896061897E-23
     -2.27814434753380E-09  -2.27163411371742E-09  -1.22757715694072E-18  -2.69779161815816E-02  -2.69779161870294E-02
      0.00000000000000E+00   0.00000000000000E+00   5.44783981497643E-09   0.00000000000000E+00   5.44783981497643E-09
      4.55784719704799E-18  -3.05479192312855E-01  -3.04478455833258E-01   0.00000000000000E+00  -1.47742268494273E-10
     -1.33691526899173E-22  -3.02846343276461E-09  -3.17620570125901E-09  -3.33027004010727E-18
      9.11053790244618E-10
      0.00000000000000E+00   7.97947076858992E-13   0.00000000000000E+00   3.53061357516264E-12  -4.73686558780660E-23
     -8.01432049154141E-10  -7.97901435579026E-10  -1.24293859996814E-18  -1.79517880646193E-02  -1.79517880671207E-02
      0.00000000000000E+00   0.00000000000000E+00   2.50136107645240E-09   0.00000000000000E+00   2.50136107645240E-09
      4.60787441857704E-18  -3.19714428853575E-01  -3.19177713893751E-01   0.00000000000000E+00  -8.65083499069608E-11
     -1.37257803661957E-22  -1.61695129096620E-09  -1.70345964087330E-09  -3.36493581860890E-18
      9.31053790244618E-10
      0.00000000000000E+00   3.15578517045062E-13   0.00000000000000E+00   1.16248920397533E-12  -4.74162429010257E-23
     -3.16711324322638E-10  -3.15548835118710E-10  -1.24863941768514E-18  -1.45881909836593E-02  -1.45881909851908E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53148568837612E-09   0.00000000000000E+00   1.53148568837612E-09
      4.63850413234456E-18  -3.32798283213296E-01  -3.32415174683699E-01   0.00000000000000E+00  -6.53951218997653E-11
     -1.39817137316524E-22  -1.15054173135760E-09  -1.21593685325750E-09  -3.38986471465942E-18
      9.51053790244618E-10
      0.00000000000000E+00   1.16275437304729E-13   0.00000000000000E+00   4.90385576705025E-13  -4.74186242875017E-23
     -1.16771303848438E-10  -1.16280918271781E-10  -1.25037025156327E-18  -1.34062262171535E-02  -1.34062262186876E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53409661266806E-09   0.00000000000000E+00   1.53409661266806E-09
      4.66918606459792E-18  -3.51449869064842E-01  -3.51003150337148E-01   0.00000000000000E+00  -8.58195460810724E-11
     -1.42996987593292E-22  -1.33199614831506E-09  -1.41781569439627E-09  -3.41881581303466E-18
      9.71053790244618E-10
      0.00000000000000E+00  -1.18112332048879E-13   0.00000000000000E+00   6.12171734335436E-13  -4.73426794608589E-23
      1.17537630360154E-10   1.18149802094442E-10  -1.24746208855285E-18  -1.48568581597617E-02  -1.48568581611462E-02
      0.00000000000000E+00   0.00000000000000E+00   1.38454536187087E-09   0.00000000000000E+00   1.38454536187087E-09
      4.69687697183534E-18  -3.74110860339148E-01  -3.73637396840052E-01   0.00000000000000E+00  -9.84827539509196E-11
     -1.46470406892953E-22  -1.40421241001421E-09  -1.50269516396528E-09  -3.44941488328248E-18
      9.91053790244618E-10
      0.00000000000000E+00  -1.12932288870375E-12   0.00000000000000E+00   2.67270752108072E-12  -4.68941825049848E-23
      1.12669902561689E-09   1.12937173313792E-09  -1.22457469872472E-18  -2.79813517280078E-02  -2.79813517277748E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.33005096110424E-10   0.00000000000000E+00  -2.33005096110424E-10
      4.69221686991313E-18  -3.98449921755641E-01  -3.98167502917401E-01   0.00000000000000E+00  -5.40476097503891E-11
     -1.48367226611094E-22  -8.42319027277016E-10  -8.96366637027553E-10  -3.46764217118841E-18
      1.01105379024462E-09
      0.00000000000000E+00  -2.62510627886553E-12   0.00000000000000E+00   4.04351981442097E-12  -4.59652175690922E-23
      2.62102690014781E-09   2.62507041996218E-09  -1.17278720587230E-18  -5.71720992170190E-02  -5.71720992144050E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.61396033006943E-09   0.00000000000000E+00  -2.61396033006943E-09
      4.63993766331174E-18  -4.23725229863710E-01  -4.23721746523249E-01   0.00000000000000E+00   2.04037162019446E-11
     -1.47721223058425E-22  -3.15138060945686E-11  -1.11100898927717E-11  -3.46715045743944E-18
      1.02105379024462E-09
      0.00000000000000E+00  -3.39862265562732E-12   0.00000000000000E+00   4.21140366466444E-12  -4.52947832982214E-23
      3.39440133519520E-09   3.39861273885982E-09  -1.13978936378199E-18  -7.52206041928915E-02  -7.52206041891277E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.76380871610466E-09   0.00000000000000E+00  -3.76380871610466E-09
      4.60229957615069E-18  -4.36326174573406E-01  -4.36441264601811E-01   0.00000000000000E+00   5.38918088779854E-11
     -1.46827941987353E-22   3.11304168367110E-10   3.65195977244949E-10  -3.46251021236870E-18
      1.03455379024462E-09
      0.00000000000000E+00  -4.35059335678333E-12   0.00000000000000E+00   3.90061221597697E-12  -4.33491075633314E-23
      4.34670111373682E-09   4.35060172595276E-09  -1.08519047604204E-18  -1.04138961237838E-01  -1.04138961232879E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95943541602214E-09   0.00000000000000E+00  -4.95943541602214E-09
      4.53534719803439E-18  -4.53210528382073E-01  -4.53402399875775E-01   0.00000000000000E+00   8.45628960445161E-11
     -1.44887336187709E-22   5.24270794024744E-10   6.08833690069115E-10  -3.45015672199236E-18
      1.05277879024462E-09
      0.00000000000000E+00  -6.51822099961817E-12   0.00000000000000E+00   6.28370786727893E-12  -2.89447014045882E-23
      6.51190833215084E-09   6.51819204001808E-09  -9.91627758479084E-19  -1.51243677537591E-01  -1.51243677530819E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77184882887512E-09   0.00000000000000E+00  -6.77184882887512E-09
      4.41193025312815E-18  -4.74528872693521E-01  -4.74608907732037E-01   0.00000000000000E+00   1.24548458694636E-10
     -1.40854163859217E-22   1.29108330162605E-10   2.53656788857100E-10  -3.42030249464906E-18
      1.07277879024462E-09
      0.00000000000000E+00  -1.22626500882629E-11   0.00000000000000E+00   1.44959049013807E-11   6.06939702320712E-23
      1.22481359249652E-08   1.22626318298666E-08  -8.76541532952902E-19  -2.05578184150593E-01  -2.05578184142143E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.44980226192538E-09   0.00000000000000E+00  -8.44980226192538E-09
      4.24293420788964E-18  -4.88547233192131E-01  -4.87346292430295E-01   0.00000000000000E+00   1.53295278398280E-10
     -1.34807506891998E-22  -3.96612484633946E-09  -3.81282956794132E-09  -3.36639267493673E-18
      1.09277879024462E-09
      0.00000000000000E+00  -2.53755987535932E-11   0.00000000000000E+00   3.25538447210824E-11   2.95976940448504E-22
      2.53430063599509E-08   2.53755602046723E-08  -7.74798114813597E-19  -2.51404757053929E-01  -2.51404757044327E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.60243217581772E-09   0.00000000000000E+00  -9.60243217581772E-09
      4.05088556437328E-18  -4.77092558201220E-01  -4.72123778302430E-01   0.00000000000000E+00   1.71909715137639E-10
     -1.26579109208853E-22  -1.59450377439921E-08  -1.57731280288546E-08  -3.27608744955968E-18
      1.11277879024462E-09
      0.00000000000000E+00  -4.24017761371245E-11   0.00000000000000E+00   4.22247393845230E-11   6.18925814553447E-22
      4.23595550486184E-08   4.24017797880035E-08  -7.02951002426396E-19  -2.83901521724987E-01  -2.83901521714440E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05474074526260E-08   0.00000000000000E+00  -1.05474074526260E-08
      3.83993741532076E-18  -4.28403001437183E-01  -4.18367814428139E-01   0.00000000000000E+00   1.83598826709947E-10
     -1.15568937883695E-22  -3.20379711620873E-08  -3.18543723353775E-08  -3.13698641289437E-18
      1.13277879024462E-09
      0.00000000000000E+00  -5.28043866074606E-11   0.00000000000000E+00   2.58934868019770E-11   8.32165105513386E-22
      5.27784978788769E-08   5.28043913656797E-08  -6.61850993618962E-19  -3.04033074679227E-01  -3.04033074667908E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13182721843665E-08   0.00000000000000E+00  -1.13182721843665E-08
      3.61357197163343E-18  -3.43353160599791E-01  -3.30283124240276E-01   0.00000000000000E+00   1.77627641800326E-10
     -1.02992117731034E-22  -4.16637468231135E-08  -4.14861191813132E-08  -2.95172097801447E-18
      1.15277879024462E-09
      0.00000000000000E+00  -5.27659036625706E-11   0.00000000000000E+00  -5.57409387631698E-15   8.59495057244584E-22
      5.27658475791252E-08   5.27658420050322E-08  -6.42613115685033E-19  -3.15627466853672E-01  -3.15627466841832E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18399872102931E-08   0.00000000000000E+00  -1.18399872102931E-08
      3.37677222742757E-18  -2.39333830894548E-01  -2.26439929749460E-01   0.00000000000000E+00   1.41299821346824E-10
     -9.01203878870934E-23  -4.10671546160858E-08  -4.09258547947391E-08  -2.73415911174254E-18
      1.17277879024462E-09
      0.00000000000000E+00  -4.87842506151499E-11   0.00000000000000E+00  -9.83687871488714E-12   7.97260993120947E-22
      4.87940463779017E-08   4.87842094991876E-08  -6.30365999978433E-19  -3.24538879952957E-01  -3.24538879940982E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19753489091145E-08   0.00000000000000E+00  -1.19753489091145E-08
      3.13726524924528E-18  -1.43082727969485E-01  -1.31485693428534E-01   0.00000000000000E+00   8.68528736968562E-11
     -7.39001737868314E-23  -3.68957134637699E-08  -3.68088605900731E-08  -2.50689924926685E-18
      1.18277879024462E-09
      0.00000000000000E+00  -4.57202183371696E-11   0.00000000000000E+00  -1.51535518597408E-11   7.43630657567565E-22
      4.57353695592357E-08   4.57202160073768E-08  -6.25201560696526E-19  -3.28626134931506E-01  -3.28626134919506E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20003290453762E-08   0.00000000000000E+00  -1.20003290453762E-08
      3.01726195879152E-18  -1.00628573514320E-01  -9.00046855984000E-02   0.00000000000000E+00   6.18428822756489E-11
     -2.60057286763267E-23  -3.37817298442762E-08  -3.37198869620006E-08  -2.39206039809499E-18
      1.19627879024462E-09
      0.00000000000000E+00  -4.15004118861698E-11   0.00000000000000E+00  -1.53463858180924E-11   6.81814832366045E-22
      4.15158398087567E-08   4.15004934229393E-08  -6.11869110556779E-19  -3.36432925343372E-01  -3.36432925331644E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17284069866206E-08   0.00000000000000E+00  -1.17284069866206E-08
      2.85892846447214E-18  -5.93262359248085E-02  -4.99461410719886E-02   0.00000000000000E+00   4.18814301547441E-11
      1.69828932180566E-22  -2.98139678664735E-08  -2.97720864363186E-08  -2.24705935391536E-18
      1.21450379024462E-09
      0.00000000000000E+00  -3.59366413956122E-11   0.00000000000000E+00  -1.50240594586429E-11   6.62835751072100E-22
      3.59517090248772E-08   3.59366849654192E-08  -5.75175897422785E-19  -3.53428522217057E-01  -3.53428522205940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11166632482685E-08   0.00000000000000E+00  -1.11166632482685E-08
      2.65632727677245E-18  -3.27640675029092E-02  -2.49441403600192E-02   0.00000000000000E+00   2.63335102844667E-11
      5.01525653056313E-22  -2.48463552274357E-08  -2.48200217171508E-08  -2.08115137934966E-18
      1.23450379024462E-09
      0.00000000000000E+00  -3.22846191100293E-11   0.00000000000000E+00  -8.99621710819563E-12   6.50751558461697E-22
      3.22936496834838E-08   3.22846534663763E-08  -5.24434870053317E-19  -3.75662570649938E-01  -3.75662570639287E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06511291980839E-08   0.00000000000000E+00  -1.06511291980839E-08
      2.44330469281077E-18  -2.17853762035437E-02  -1.49693742814893E-02   0.00000000000000E+00   1.47330159681516E-11
      7.24230179147325E-22  -2.16482572842612E-08  -2.16335242682923E-08  -1.91886982275745E-18
      1.25450379024462E-09
      0.00000000000000E+00  -3.02390531229433E-11   0.00000000000000E+00  -5.01960803833217E-12   5.91836072107515E-22
      3.02440321985962E-08   3.02390125905585E-08  -4.73597881264752E-19  -3.97926038236396E-01  -3.97926038225996E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03992332219861E-08   0.00000000000000E+00  -1.03992332219861E-08
      2.23532002837105E-18  -1.69149576579835E-02  -1.06640954706571E-02   0.00000000000000E+00   9.28817478739599E-12
      7.68173701496145E-22  -1.98490675433605E-08  -1.98397793685723E-08  -1.76172214710630E-18
      1.27450379024462E-09
      0.00000000000000E+00  -2.88042546382873E-11   0.00000000000000E+00  -3.50808038983056E-12   4.92291898275530E-22
      2.88077811277864E-08   2.88042730473970E-08  -4.24889521405737E-19  -4.19445477735023E-01  -4.19445477724797E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02267269214782E-08   0.00000000000000E+00  -1.02267269214782E-08
      2.03078548994148E-18  -1.41458216138483E-02  -8.29264130509901E-03   0.00000000000000E+00   7.17750033929899E-12
      6.88495022524155E-22  -1.85847236262588E-08  -1.85775461259188E-08  -1.60589596853575E-18
      1.29450379024462E-09
      0.00000000000000E+00  -2.77402333577381E-11   0.00000000000000E+00  -2.59422977517652E-12   3.75762763649133E-22
      2.77428251529949E-08   2.77402309232201E-08  -3.77802460005847E-19  -4.40348181541039E-01  -4.40348181530944E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00953081573871E-08   0.00000000000000E+00  -1.00953081573871E-08
      1.82887932679374E-18  -1.23563201836949E-02  -6.79697416166755E-03   0.00000000000000E+00   5.94772843834072E-12
      5.46155138673612E-22  -1.76508704942719E-08  -1.76449227658330E-08  -1.45107686678789E-18
      1.31450379024462E-09
      0.00000000000000E+00  -2.72441799320803E-11   0.00000000000000E+00  -1.19385251939105E-12   2.62700276809032E-22
      2.72453867442047E-08   2.72441928916855E-08  -3.30236171552440E-19  -4.61435623411157E-01  -4.61435623400896E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02602494629298E-08   0.00000000000000E+00  -1.02602494629298E-08
      1.62367433753514E-18  -1.11520792170421E-02  -5.80098210395942E-03   0.00000000000000E+00   5.09100023549208E-12
      3.87986893336480E-22  -1.69890344289917E-08  -1.69839434287558E-08  -1.29343816598271E-18
      1.33450379024462E-09
      0.00000000000000E+00  -2.78246386712319E-11   0.00000000000000E+00   1.46347497104923E-12   1.66028242423356E-22
      2.78232090324774E-08   2.78246725074486E-08  -2.78994566032545E-19  -4.84123798859272E-01  -4.84123798848184E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10881205591033E-08   0.00000000000000E+00  -1.10881205591033E-08
      1.40191192635308E-18  -1.04565518755430E-02  -5.18339567214671E-03   0.00000000000000E+00   4.08588884711818E-12
      2.43826103636608E-22  -1.67406378371926E-08  -1.67365519483452E-08  -1.12291736032053E-18
      1.35450379024462E-09
      0.00000000000000E+00  -2.84424782184269E-11   0.00000000000000E+00   1.56040054907845E-12   9.23202259693834E-23
      2.84409139013197E-08   2.84424743018688E-08  -2.26429139255108E-19  -5.07543402706043E-01  -5.07543402694366E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16769979186501E-08   0.00000000000000E+00  -1.16769979186501E-08
      1.16837196798008E-18  -1.00222096812595E-02  -4.73993618328276E-03   0.00000000000000E+00   3.25046867350648E-12
      1.31170724657745E-22  -1.67687268518924E-08  -1.67654763832188E-08  -9.41942828724970E-19
      1.35575379024462E-09
      0.00000000000000E+00  -2.85194441082068E-11   0.00000000000000E+00   3.01870576427784E-12   8.73798367423387E-23
      2.85164413406639E-08   2.85194600464282E-08  -2.23214781773028E-19  -5.08996279023708E-01  -5.08996279011908E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17993572933650E-08   0.00000000000000E+00  -1.17993572933650E-08
      1.15362277136337E-18  -9.98498118478586E-03  -4.71700376094408E-03   0.00000000000000E+00   4.86741324342278E-12
      1.23222927036098E-22  -1.67249701663062E-08  -1.67201027530627E-08  -9.30407989590343E-19
      1.35744129024462E-09
      0.00000000000000E+00  -2.86340663402418E-11   0.00000000000000E+00   3.37917350811415E-12   8.07926538334669E-23
      2.86307034782320E-08   2.86340826517402E-08  -2.18837634265844E-19  -5.10975895938074E-01  -5.10975895926158E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19157484807623E-08   0.00000000000000E+00  -1.19157484807623E-08
      1.13351494580209E-18  -9.96040653373113E-03  -4.69298547487335E-03   0.00000000000000E+00   3.22880194028577E-12
      1.12892681925346E-22  -1.67215629729184E-08  -1.67183341709780E-08  -9.14677311536242E-19
      1.35971941524462E-09
      0.00000000000000E+00  -2.88101327014686E-11   0.00000000000000E+00   3.84350780950042E-12   7.25833732324620E-23
      2.88063212638031E-08   2.88101647716126E-08  -2.12879509947881E-19  -5.13672465516612E-01  -5.13672465504587E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20253384676024E-08   0.00000000000000E+00  -1.20253384676024E-08
      1.10611972160558E-18  -9.95794450481307E-03  -4.66957303058834E-03   0.00000000000000E+00   1.71913810771930E-12
      1.00201796730129E-22  -1.67865454421183E-08  -1.67848263040105E-08  -8.93240211657698E-19
      1.36279488399462E-09
      0.00000000000000E+00  -2.90516843603244E-11   0.00000000000000E+00   3.91612044493880E-12   6.27977277390855E-23
      2.90477983739102E-08   2.90517144943552E-08  -2.04789758315609E-19  -5.17337858950628E-01  -5.17337858938495E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21328128259898E-08   0.00000000000000E+00  -1.21328128259898E-08
      1.06880563490965E-18  -9.97410355075855E-03  -4.64348867465598E-03   0.00000000000000E+00   9.76023078415753E-13
      8.51043860606998E-23  -1.69198776914438E-08  -1.69189016683653E-08  -8.64015876594039E-19
      1.36694676680712E-09
      0.00000000000000E+00  -2.93196873034960E-11   0.00000000000000E+00   3.23092130062584E-12   5.16212720404358E-23
      2.93164795899635E-08   2.93197105112641E-08  -1.93870611948750E-19  -5.22293353407753E-01  -5.22293353395542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22110555458109E-08   0.00000000000000E+00  -1.22110555458109E-08
      1.01810676326651E-18  -9.99557931768411E-03  -4.60517781553730E-03   0.00000000000000E+00   8.31597070741639E-13
      6.78757007927835E-23  -1.71094865625245E-08  -1.71086549654537E-08  -8.24236151317764E-19
      1.37255180860399E-09
      0.00000000000000E+00  -2.94922635647089E-11   0.00000000000000E+00   1.56712809415157E-12   3.95925260999340E-23
      2.94906724590241E-08   2.94922395871183E-08  -1.79346664060232E-19  -5.28902053527287E-01  -5.28902053515117E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21700780447855E-08   0.00000000000000E+00  -1.21700780447855E-08
      9.49892967154259E-19  -9.99329362433705E-03  -4.53562197264226E-03   0.00000000000000E+00   1.12056114960211E-12
      4.94208600318162E-23  -1.73232821034822E-08  -1.73221615423325E-08  -7.70546303094027E-19
      1.38011861502977E-09
      0.00000000000000E+00  -2.92860721296780E-11   0.00000000000000E+00  -1.30003914943168E-12   2.77511983845509E-23
      2.92873370157089E-08   2.92860369765595E-08  -1.60699771461410E-19  -5.37420589249260E-01  -5.37420589237479E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17817461503503E-08   0.00000000000000E+00  -1.17817461503503E-08
      8.60742774676865E-19  -9.91737100389129E-03  -4.40231504607001E-03   0.00000000000000E+00   1.62079948445440E-12
      3.14665439023133E-23  -1.75059116256937E-08  -1.75042908262092E-08  -7.00043003215455E-19
      1.39033380370458E-09
      0.00000000000000E+00  -2.80040114429982E-11   0.00000000000000E+00  -6.15656212144320E-12   1.74816353767043E-23
      2.80102004687276E-08   2.80040439066062E-08  -1.39047676559796E-19  -5.47350281944108E-01  -5.47350281933715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03929068828086E-08   0.00000000000000E+00  -1.03929068828086E-08
      7.54577269989299E-19  -9.69548908455752E-03  -4.14676796419360E-03   0.00000000000000E+00   1.86075732041294E-12
      1.63242975894100E-23  -1.76129977811180E-08  -1.76111370237976E-08  -6.15529593429504E-19
      1.40412430841556E-09
      0.00000000000000E+00  -2.34933327092621E-11   0.00000000000000E+00  -1.61146486354000E-11   9.71268202306289E-24
      2.35094026770250E-08   2.34932880283897E-08  -1.23238855053778E-19  -5.54479138596835E-01  -5.54479138590994E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.84109848129948E-09   0.00000000000000E+00  -5.84109848129948E-09
      6.74025573865604E-19  -9.17340334590631E-03  -3.61174601629388E-03   0.00000000000000E+00   1.14728154164240E-12
      5.79901289680200E-24  -1.76533368286317E-08  -1.76521895470900E-08  -5.50786718811824E-19
      1.42274148977540E-09
      0.00000000000000E+00  -1.07275571505763E-11   0.00000000000000E+00  -3.38128608247414E-11   3.59915923920132E-24
      1.07613997418620E-08   1.07275868810373E-08  -1.50599593464142E-19  -5.41116599571515E-01  -5.41116599578461E-01
      0.00000000000000E+00   0.00000000000000E+00   6.94609236663530E-09   0.00000000000000E+00   6.94609236663530E-09
      8.03342235197394E-19  -8.00153722438692E-03  -2.43310722921902E-03   0.00000000000000E+00  -1.56375771610702E-12
     -6.98803634180689E-25  -1.76721154899566E-08  -1.76736792476727E-08  -6.52742641733253E-19
      1.44274148977540E-09
      0.00000000000000E+00   7.01886666213640E-12   0.00000000000000E+00  -4.37734559043722E-11  -3.66996426780321E-24
     -6.97508960981127E-09  -7.01886306571565E-09  -2.63671312033209E-19  -4.90031613886265E-01  -4.90031613910957E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46921615142161E-08   0.00000000000000E+00   2.46921615142161E-08
      1.29718546548172E-18  -6.38795942694365E-03  -8.19650531250350E-04   0.00000000000000E+00  -6.48270901398379E-12
     -8.64597657516038E-24  -1.76668157394864E-08  -1.76732984485004E-08  -1.03351415344851E-18
      1.46274148977540E-09
      0.00000000000000E+00   1.84064200942860E-11   0.00000000000000E+00  -2.82907047830325E-11  -2.20464160557113E-23
     -1.83781491888368E-08  -1.84064398936198E-08  -4.75724798073289E-19  -4.02861856588253E-01  -4.02861856624280E-01
      0.00000000000000E+00   0.00000000000000E+00   3.60261385007259E-08   0.00000000000000E+00   3.60261385007259E-08
      2.01770823549624E-18  -4.89851697882290E-03   6.52897733316661E-04   0.00000000000000E+00  -1.55002090292028E-11
     -3.94229908298292E-23  -1.76041983980769E-08  -1.76196986071062E-08  -1.54198343742294E-18
      1.48274148977540E-09
      0.00000000000000E+00   1.67993208826287E-11   0.00000000000000E+00   3.49628919839754E-12  -4.02780758983974E-23
     -1.68028496545551E-08  -1.67993533653567E-08  -7.56396284063893E-19  -2.88563669710810E-01  -2.88563669744883E-01
      0.00000000000000E+00   0.00000000000000E+00   3.40727942855916E-08   0.00000000000000E+00   3.40727942855916E-08
      2.69916412120807E-18  -5.62868493603097E-03  -1.86379051330563E-04   0.00000000000000E+00  -3.63930549100440E-11
     -7.46513353565890E-23  -1.72370478653246E-08  -1.72734409202348E-08  -1.94276783714417E-18
      1.50274148977539E-09
      0.00000000000000E+00   1.18673503393217E-11   0.00000000000000E+00   1.14852250825055E-11  -4.41202422786902E-23
     -1.18788285383153E-08  -1.18673433132328E-08  -9.91678629049366E-19  -1.77466983643489E-01  -1.77466983669828E-01
      0.00000000000000E+00   0.00000000000000E+00   2.63394086804072E-08   0.00000000000000E+00   2.63394086804072E-08
      3.22595229481621E-18  -2.54257016463102E-02  -2.08660285953163E-02   0.00000000000000E+00  -7.35936487847158E-11
     -8.69794586867476E-23  -1.43984717183897E-08  -1.44720653671745E-08  -2.23427366576685E-18
      1.52274148977539E-09
      0.00000000000000E+00   8.27328208291680E-12   0.00000000000000E+00   8.04962184860789E-12  -4.66059598803950E-23
     -8.28130321853551E-09  -8.27325359668695E-09  -1.15585649356875E-18  -8.83916598234057E-02  -8.83916598431895E-02
      0.00000000000000E+00   0.00000000000000E+00   1.97837816934616E-08   0.00000000000000E+00   1.97837816934616E-08
      3.62162792868544E-18  -6.29734895520480E-02  -5.93468989999266E-02   0.00000000000000E+00  -1.33414745562559E-10
     -1.00094696771400E-22  -1.13771133512120E-08  -1.15105280967747E-08  -2.46577143511669E-18
      1.52774148977539E-09
      0.00000000000000E+00   6.65709024227595E-12   0.00000000000000E+00   1.49925493092493E-11  -4.70724184838091E-23
     -6.67212259623477E-09  -6.65713004692557E-09  -1.18881293742252E-18  -6.92669786373497E-02  -6.92669786542016E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68519064239532E-08   0.00000000000000E+00   1.68519064239532E-08
      3.70588746080521E-18  -7.42708736219515E-02  -7.10588050920088E-02   0.00000000000000E+00  -1.73164323019201E-10
     -1.03455186724403E-22  -1.00216120540085E-08  -1.01947763770278E-08  -2.51707452338269E-18
      1.53449148977539E-09
      0.00000000000000E+00   4.76646632685902E-12   0.00000000000000E+00   1.31331288513236E-11  -4.75084282857194E-23
     -4.77960110129656E-09  -4.76646797244529E-09  -1.22050865906948E-18  -5.03049494774094E-02  -5.03049494910183E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36088520417791E-08   0.00000000000000E+00   1.36088520417791E-08
      3.79774721208722E-18  -9.19877617214866E-02  -8.92017885570398E-02   0.00000000000000E+00  -1.80710280271365E-10
     -1.07696220741358E-22  -8.66167378906229E-09  -8.84238406933377E-09  -2.57723855301773E-18
      1.53904773977540E-09
      0.00000000000000E+00   3.46704698484693E-12   0.00000000000000E+00   1.35237049154499E-11  -4.76978044650371E-23
     -3.48057148940984E-09  -3.46704778449444E-09  -1.23597690442388E-18  -4.08226867194199E-02  -4.08226867307800E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13600592112652E-08   0.00000000000000E+00   1.13600592112652E-08
      3.84950648186854E-18  -1.05014322250694E-01  -1.02527462798117E-01   0.00000000000000E+00  -1.84225948923479E-10
     -1.10410405483472E-22  -7.70878547784683E-09  -7.89301142677042E-09  -2.61352957744466E-18
      1.54519867727539E-09
      0.00000000000000E+00   2.22135681410124E-12   0.00000000000000E+00   9.66828388815116E-12  -4.78486078706292E-23
     -2.23102818041700E-09  -2.22135989652890E-09  -1.24919455664844E-18  -3.24646413321055E-02  -3.24646413412663E-02
      0.00000000000000E+00   0.00000000000000E+00   9.16084139438257E-09   0.00000000000000E+00   9.16084139438257E-09
      3.90585424473280E-18  -1.23805078635932E-01  -1.21618647111441E-01   0.00000000000000E+00  -1.83465235368068E-10
     -1.13815919738142E-22  -6.75601626248567E-09  -6.93948149785385E-09  -2.65665968808436E-18
      1.55350244290040E-09
      0.00000000000000E+00   1.26010979448727E-12   0.00000000000000E+00   5.53985524275929E-12  -4.79529404318781E-23
     -1.26566179392956E-09  -1.26012193868685E-09  -1.25906177163203E-18  -2.58917447772338E-02  -2.58917447845742E-02
      0.00000000000000E+00   0.00000000000000E+00   7.34043401446793E-09   0.00000000000000E+00   7.34043401446793E-09
      3.96680748837473E-18  -1.49974509563242E-01  -1.48058775529027E-01   0.00000000000000E+00  -1.85877450304434E-10
     -1.18120483199211E-22  -5.89443462547646E-09  -6.08031207578101E-09  -2.70774571674270E-18
      1.56471252649415E-09
      0.00000000000000E+00   6.65506965805739E-13   0.00000000000000E+00   2.53765026744252E-12  -4.80185314497105E-23
     -6.68064829722562E-10  -6.65527179455167E-10  -1.26573456109676E-18  -2.10284022481237E-02  -2.10284022541228E-02
      0.00000000000000E+00   0.00000000000000E+00   5.99908905541311E-09   0.00000000000000E+00   5.99908905541311E-09
      4.03405777817226E-18  -1.84809566627620E-01  -1.83129109568934E-01   0.00000000000000E+00  -1.92885811660246E-10
     -1.23626830965184E-22  -5.14067606429757E-09  -5.33356187595794E-09  -2.76832321707550E-18
      1.57984613934571E-09
      0.00000000000000E+00   3.58194475109354E-13   0.00000000000000E+00   9.69262542524865E-13  -4.80573328002746E-23
     -3.59164402276851E-10  -3.58195139734375E-10  -1.27012496155334E-18  -1.73806412997485E-02  -1.73806413046637E-02
      0.00000000000000E+00   0.00000000000000E+00   4.91520217861063E-09   0.00000000000000E+00   4.91520217861063E-09
      4.10844254503051E-18  -2.28181913577384E-01  -2.26746123576644E-01   0.00000000000000E+00  -1.99104751046282E-10
     -1.30536151775738E-22  -4.35790228782981E-09  -4.55700703887623E-09  -2.83831758347717E-18
      1.59984613934571E-09
      0.00000000000000E+00   2.24284848260780E-13   0.00000000000000E+00   3.17666754535276E-13  -4.80811601525541E-23
     -2.24623104034351E-10  -2.24305437279864E-10  -1.27329540883583E-18  -1.45001166578917E-02  -1.45001166616387E-02
      0.00000000000000E+00   0.00000000000000E+00   3.74698593461081E-09   0.00000000000000E+00   3.74698593461081E-09
      4.18338226372272E-18  -2.74427321296061E-01  -2.73317415634741E-01   0.00000000000000E+00  -1.85956312619638E-10
     -1.38170142764540E-22  -3.33672418471121E-09  -3.52268049733098E-09  -2.91008685488689E-18
      1.61984613934571E-09
      0.00000000000000E+00   1.75423448066376E-13   0.00000000000000E+00   1.14961915502609E-13  -4.80946233062474E-23
     -1.75565241755990E-10  -1.75450279840535E-10  -1.27552094047019E-18  -1.25802467358928E-02  -1.25802467385445E-02
      0.00000000000000E+00   0.00000000000000E+00   2.65174015756636E-09   0.00000000000000E+00   2.65174015756636E-09
      4.23641706687405E-18  -3.07238966702262E-01  -3.06458748818864E-01   0.00000000000000E+00  -1.49689448736322E-10
     -1.43792279305969E-22  -2.32660042898937E-09  -2.47628987772584E-09  -2.96089612640386E-18
      1.63984613934571E-09
      0.00000000000000E+00   1.51543816392419E-13   0.00000000000000E+00   5.68427414297887E-14  -4.81020351775532E-23
     -1.51562549816738E-10  -1.51505707075356E-10  -1.27728913597607E-18  -1.12585170251541E-02  -1.12585170269301E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77602708427866E-09   0.00000000000000E+00   1.77602708427866E-09
      4.27193760855962E-18  -3.28229253315364E-01  -3.27717408272635E-01   0.00000000000000E+00  -1.03109401911124E-10
     -1.47456039894196E-22  -1.52141197529198E-09  -1.62452137720325E-09  -2.99464847258355E-18
      1.65984613934571E-09
      0.00000000000000E+00   1.40338758453101E-13   0.00000000000000E+00   2.67109773976981E-14  -4.81068458934462E-23
     -1.40367460129172E-10  -1.40340749151823E-10  -1.27884753296360E-18  -1.03168361677366E-02  -1.03168361688312E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09463729355251E-09   0.00000000000000E+00   1.09463729355251E-09
      4.29383035443067E-18  -3.39467062883985E-01  -3.39166393556272E-01   0.00000000000000E+00  -5.62721168904953E-11
     -1.49401626046370E-22  -8.98024427510024E-10  -9.54296544400669E-10  -3.01498282146707E-18
      1.67984613934571E-09
      0.00000000000000E+00   1.12785337290843E-13   0.00000000000000E+00   7.12572569332041E-14  -4.81012738653864E-23
     -1.12872874532231E-10  -1.12801617275346E-10  -1.27986621874606E-18  -9.79832290278332E-03  -9.79832290356409E-03
      0.00000000000000E+00   0.00000000000000E+00   7.80760817444121E-10   0.00000000000000E+00   7.80760817444121E-10
      4.30944557077956E-18  -3.46843232900212E-01  -3.46632783647093E-01   0.00000000000000E+00  -3.54583426837811E-11
     -1.50603192575422E-22  -6.32500857484977E-10  -6.67959200168908E-10  -3.02957935203350E-18
      1.69984613934571E-09
      0.00000000000000E+00   8.77117240331881E-14   0.00000000000000E+00   6.91456807944690E-14  -4.80874870617261E-23
     -8.78126319298667E-11  -8.77434862491203E-11  -1.28039631951940E-18  -9.53688207948624E-03  -9.53688208029064E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04397081286416E-10   0.00000000000000E+00   8.04397081286416E-10
      4.32553351240529E-18  -3.55378928490518E-01  -3.55153135893333E-01   0.00000000000000E+00  -4.16022079242241E-11
     -1.51974098778904E-22  -6.75051387112801E-10  -7.16653595037177E-10  -3.04513719288589E-18
      1.70984613934571E-09
      0.00000000000000E+00   6.12604397174203E-14   0.00000000000000E+00   1.42078024434151E-13  -4.80751301998812E-23
     -6.13744385510080E-11  -6.12323605266219E-11  -1.28040024597248E-18  -9.51942174859140E-03  -9.51942174956228E-03
      0.00000000000000E+00   0.00000000000000E+00   9.70879424648080E-10   0.00000000000000E+00   9.70879424648080E-10
      4.33524230665176E-18  -3.61345462949482E-01  -3.61058860010634E-01   0.00000000000000E+00  -6.04595870578313E-11
     -1.52949088555646E-22  -8.49187477063516E-10  -9.09647064121500E-10  -3.05484206067928E-18
      1.71659613934571E-09
      0.00000000000000E+00   3.07679869645215E-14   0.00000000000000E+00   2.38372187880471E-13  -4.80624290511570E-23
     -3.10445159425703E-11  -3.08061437547379E-11  -1.28019989196161E-18  -9.58586737465079E-03  -9.58586737589308E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24229274313253E-09   0.00000000000000E+00   1.24229274313253E-09
      4.34362778266791E-18  -3.67123691944988E-01  -3.66741982337824E-01   0.00000000000000E+00  -8.99673655005261E-11
     -1.53914543794469E-22  -1.12151923387706E-09  -1.21148659937774E-09  -3.06342789070630E-18
      1.72115238934571E-09
      0.00000000000000E+00   2.04813763972785E-14   0.00000000000000E+00   1.30946356244600E-13  -4.80537372236723E-23
     -2.06548248515525E-11  -2.05238784953560E-11  -1.28001903954124E-18  -9.63650443789339E-03  -9.63650443934163E-03
      0.00000000000000E+00   0.00000000000000E+00   1.44824423798771E-09   0.00000000000000E+00   1.44824423798771E-09
      4.35022634547724E-18  -3.71822093186666E-01  -3.71372250453556E-01   0.00000000000000E+00  -1.11376595574274E-10
     -1.54715193255909E-22  -1.31634376391752E-09  -1.42772035949195E-09  -3.07020730593600E-18
      1.72730332684571E-09
      0.00000000000000E+00   2.78289553738806E-14   0.00000000000000E+00  -3.98475600048620E-14  -4.80442136605973E-23
     -2.77490409604226E-11  -2.77888885204755E-11  -1.27982200060933E-18  -9.65048828647036E-03  -9.65048828811913E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64876799937444E-09   0.00000000000000E+00   1.64876799937444E-09
      4.36036781439339E-18  -3.79038953570291E-01  -3.78528217364574E-01   0.00000000000000E+00  -1.30747435938477E-10
     -1.55975390847715E-22  -1.49023167491558E-09  -1.62097911085421E-09  -3.08054581378407E-18
      1.73560709247071E-09
      0.00000000000000E+00   4.34425606991602E-14   0.00000000000000E+00  -7.87162362926066E-14  -4.80341782895067E-23
     -4.33450135129597E-11  -4.34237297493004E-11  -1.27969031441021E-18  -9.56971088343747E-03  -9.56971088520732E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76985482813986E-09   0.00000000000000E+00   1.76985482813986E-09
      4.37506427407654E-18  -3.89368801127542E-01  -3.88824838228168E-01   0.00000000000000E+00  -1.43719378005020E-10
     -1.57823101193751E-22  -1.58271172038551E-09  -1.72643109839069E-09  -3.09537395966633E-18
      1.74681717606446E-09
      0.00000000000000E+00   6.17196634034580E-14   0.00000000000000E+00  -7.02621871845633E-14  -4.80244150309557E-23
     -6.16428762068617E-11  -6.17131383940943E-11  -1.27972546612690E-18  -9.32821033396455E-03  -9.32821033576684E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80229572883835E-09   0.00000000000000E+00   1.80229572883835E-09
      4.39526815985748E-18  -4.03345297140268E-01  -4.02796874946464E-01   0.00000000000000E+00  -1.50429110570243E-10
     -1.60387545187453E-22  -1.59015347987362E-09  -1.74058259044402E-09  -3.11554269373058E-18
      1.76195078891602E-09
      0.00000000000000E+00   9.17528924703192E-14   0.00000000000000E+00  -9.32540930301989E-14  -4.80200709023865E-23
     -9.16312690413749E-11  -9.17245231344531E-11  -1.28024017267772E-18  -8.73389307017427E-03  -8.73389307196284E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78857412847487E-09   0.00000000000000E+00   1.78857412847487E-09
      4.42233574827414E-18  -4.21532288659584E-01  -4.20997645579084E-01   0.00000000000000E+00  -1.53848768851695E-10
     -1.63845722717110E-22  -1.54300083648853E-09  -1.69684960534039E-09  -3.14209557559642E-18
      1.78195078891602E-09
      0.00000000000000E+00   1.39604000555441E-13   0.00000000000000E+00  -1.22410312586306E-13  -4.80323197811898E-23
     -1.39467771377172E-10  -1.39590181689806E-10  -1.28189674868125E-18  -7.39134692129287E-03  -7.39134692306317E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77029360208670E-09   0.00000000000000E+00   1.77029360208670E-09
      4.45774162031587E-18  -4.44165177209824E-01  -4.43651375034550E-01   0.00000000000000E+00  -1.57245743159576E-10
     -1.68382883827795E-22  -1.47345767723706E-09  -1.63070342039680E-09  -3.17584487163462E-18
      1.80195078891602E-09
      0.00000000000000E+00   1.70280142782755E-13   0.00000000000000E+00  -8.59911614362340E-14  -4.80547103174351E-23
     -1.70167998841929E-10  -1.70253990003413E-10  -1.28418264230259E-18  -5.70193434089250E-03  -5.70193434262151E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72901138474356E-09   0.00000000000000E+00   1.72901138474356E-09
      4.49232184801074E-18  -4.65501515646822E-01  -4.65010381005614E-01   0.00000000000000E+00  -1.60614777606608E-10
     -1.72878194921109E-22  -1.39814261713346E-09  -1.55875739474024E-09  -3.20813920570815E-18
      1.82195078891602E-09
      0.00000000000000E+00   1.72117037526905E-13   0.00000000000000E+00  -1.58518055402071E-14  -4.80763256164004E-23
     -1.72135147622536E-10  -1.72150999428124E-10  -1.28652115806070E-18  -4.00835113326150E-03  -4.00835113491837E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65686859218012E-09   0.00000000000000E+00   1.65686859218012E-09
      4.52545921985434E-18  -4.85803107061942E-01  -4.85335299815000E-01   0.00000000000000E+00  -1.62647431472202E-10
     -1.77302600130050E-22  -1.32207016127966E-09  -1.48471759275204E-09  -3.23893806179365E-18
      1.84195078891602E-09
      0.00000000000000E+00   1.17469418888427E-13   0.00000000000000E+00   1.32758257375723E-13  -4.80755721036889E-23
     -1.17617731124553E-10  -1.17484972867225E-10  -1.28778269962179E-18  -2.98940358844585E-03  -2.98940358994959E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50373211897674E-09   0.00000000000000E+00   1.50373211897674E-09
      4.55553386223388E-18  -5.05270153523976E-01  -5.04833372021742E-01   0.00000000000000E+00  -1.59823987169402E-10
     -1.81535698660680E-22  -1.22642315893983E-09  -1.38624714610941E-09  -3.26775116261209E-18
      1.86195078891602E-09
      0.00000000000000E+00  -1.48136376642020E-12   0.00000000000000E+00   4.19792512922854E-12  -4.74184481706739E-23
      1.47714364468428E-09   1.48134156981346E-09  -1.25720475098021E-18  -2.10548992671285E-02  -2.10548992660277E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.10072206404966E-09   0.00000000000000E+00  -1.10072206404966E-09
      4.53351942095289E-18  -5.25838494393820E-01  -5.25718590142563E-01   0.00000000000000E+00  -1.51927661516887E-11
     -1.81923429112403E-22  -3.65426739612056E-10  -3.80619505763927E-10  -3.27631466997268E-18
      1.88195078891602E-09
      0.00000000000000E+00  -3.22448503388185E-12   0.00000000000000E+00   4.77287865608010E-12  -4.61692362776106E-23
      3.21966736326735E-09   3.22444024192338E-09  -1.19246686566765E-18  -5.81681867455330E-02  -5.81681867416865E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84645583323842E-09   0.00000000000000E+00  -3.84645583323842E-09
      4.45659030428812E-18  -5.47281345323707E-01  -5.47477380616228E-01   0.00000000000000E+00   1.32925448042582E-10
     -1.78364443220298E-22   4.89090143272703E-10   6.22015591315107E-10  -3.26412343862047E-18
      1.89195078891602E-09
      0.00000000000000E+00  -4.52730263117062E-12   0.00000000000000E+00   6.96605933539113E-12  -4.53135724149841E-23
      4.52037224726894E-09   4.52733830660428E-09  -1.14766551682206E-18  -8.29025803920205E-02  -8.29025803862490E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.77148278964231E-09   0.00000000000000E+00  -5.77148278964231E-09
      4.39887547639170E-18  -5.58252732292946E-01  -5.58644807538393E-01   0.00000000000000E+00   2.19283963259940E-10
     -1.75379306530279E-22   1.02486051977833E-09   1.24414448303810E-09  -3.25120995956964E-18
      1.89532578891602E-09
      0.00000000000000E+00  -5.11446603613833E-12   0.00000000000000E+00   9.10935050461508E-12  -4.49864147605948E-23
      5.10535585800724E-09   5.11446520851181E-09  -1.13068673506078E-18  -9.20801493635450E-02  -9.20801493569475E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.59748569916109E-09   0.00000000000000E+00  -6.59748569916109E-09
      4.37660896215702E-18  -5.61989726453451E-01  -5.62457073327447E-01   0.00000000000000E+00   2.48740918370798E-10
     -1.74224227272273E-22   1.23427957227928E-09   1.48302049064990E-09  -3.24592222709624E-18
      1.89988203891602E-09
      0.00000000000000E+00  -5.70456847269669E-12   0.00000000000000E+00   6.98920569223839E-12  -4.45216136270847E-23
      5.69760662403772E-09   5.70459582972991E-09  -1.10541517733614E-18  -1.05515942767826E-01  -1.05515942760436E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.38970291369147E-09   0.00000000000000E+00  -7.38970291369147E-09
      4.34293962825652E-18  -5.67062476189925E-01  -5.67593507620484E-01   0.00000000000000E+00   2.76592561241226E-10
     -1.72472973410358E-22   1.40851452272027E-09   1.68510708396132E-09  -3.23752445092038E-18
      1.90603297641602E-09
      0.00000000000000E+00  -6.32865346202184E-12   0.00000000000000E+00   5.58248033980819E-12  -4.38445063585351E-23
      6.32303409993768E-09   6.32861658027745E-09  -1.06852067433388E-18  -1.24682461427867E-01  -1.24682461419787E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.07933970966562E-09   0.00000000000000E+00  -8.07933970966562E-09
      4.29324411466110E-18  -5.73831193142725E-01  -5.74382917866823E-01   0.00000000000000E+00   2.93597755059050E-10
     -1.69928613940895E-22   1.45712537432948E-09   1.75072312938836E-09  -3.22472344032722E-18
      1.91433674204102E-09
      0.00000000000000E+00  -7.11420149935781E-12   0.00000000000000E+00   5.18936514490830E-12  -4.26752920154517E-23
      7.10902493517371E-09   7.11421430031858E-09  -1.01606893800737E-18  -1.51074952624359E-01  -1.51074952615779E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.57960067127293E-09   0.00000000000000E+00  -8.57960067127293E-09
      4.22200112153076E-18  -5.82553614668712E-01  -5.83015480640019E-01   0.00000000000000E+00   2.95094132245592E-10
     -1.66411985185003E-22   1.17029223870892E-09   1.46538637095435E-09  -3.20593218352339E-18
      1.92554682563477E-09
      0.00000000000000E+00  -8.74554772163790E-12   0.00000000000000E+00   7.60797883856673E-12  -3.90350287306085E-23
      8.73798145386008E-09   8.74558943269861E-09  -9.43839407808250E-19  -1.85935097912844E-01  -1.85935097903938E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.90540280723921E-09   0.00000000000000E+00  -8.90540280723921E-09
      4.12217081162559E-18  -5.92696155869734E-01  -5.92746800620863E-01   0.00000000000000E+00   2.84460834904360E-10
     -1.61718221809251E-22  -1.24647460363642E-10   1.59813374540556E-10  -3.17833140381734E-18
      1.94068043848633E-09
      0.00000000000000E+00  -1.39344998396515E-11   0.00000000000000E+00   1.72183669533209E-11  -2.02948942113173E-23
      1.39172533983299E-08   1.39344717652832E-08  -8.49739217443282E-19  -2.29146983442080E-01  -2.29146983432867E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.21246744272311E-09   0.00000000000000E+00  -9.21246744272311E-09
      3.98275289593979E-18  -5.99364981186509E-01  -5.97877918070889E-01   0.00000000000000E+00   2.77945043632477E-10
     -1.55256262805636E-22  -4.99994936619252E-09  -4.72200432256020E-09  -3.13301367849651E-18
      1.96068043848633E-09
      0.00000000000000E+00  -2.90212837523087E-11   0.00000000000000E+00   3.74114262126877E-11   5.04865146409377E-23
      2.89838826707582E-08   2.90212940969709E-08  -7.45283322582443E-19  -2.75145917205942E-01  -2.75145917196176E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76602741766380E-09   0.00000000000000E+00  -9.76602741766380E-09
      3.78743234758652E-18  -5.81980806654515E-01  -5.75915647615987E-01   0.00000000000000E+00   3.01084017408412E-10
     -1.45070785879685E-22  -1.95563506967153E-08  -1.92552666793070E-08  -3.04214902500407E-18
      1.98068043848633E-09
      0.00000000000000E+00  -4.91487823771266E-11   0.00000000000000E+00   4.98907631242917E-11   1.45301397685071E-22
      4.90988928936916E-08   4.91487836568160E-08  -6.70801895699659E-19  -3.07913232353140E-01  -3.07913232342677E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04627309381547E-08   0.00000000000000E+00  -1.04627309381547E-08
      3.57817772882342E-18  -5.28025053226303E-01  -5.15838383705943E-01   0.00000000000000E+00   3.12266905401198E-10
     -1.31918610073485E-22  -3.89983196240624E-08  -3.86860527186614E-08  -2.90737583312376E-18
      2.00068043848633E-09
      0.00000000000000E+00  -6.33996873364581E-11   0.00000000000000E+00   3.54815299377399E-11   2.11354807059517E-22
      6.33641519993536E-08   6.33996335292915E-08  -6.25148747450295E-19  -3.29196532229124E-01  -3.29196532218049E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10757899505504E-08   0.00000000000000E+00  -1.10757899505504E-08
      3.35666192981241E-18  -4.38988856986377E-01  -4.22505051189806E-01   0.00000000000000E+00   2.83952401600789E-10
     -1.15934906236403E-22  -5.26077959803418E-08  -5.23238435787411E-08  -2.73151318236212E-18
      2.02068043848633E-09
      0.00000000000000E+00  -6.38093148644036E-11   0.00000000000000E+00   1.12843345719911E-12   2.14650632323294E-22
      6.38081448380791E-08   6.38092732715365E-08  -6.04724162948658E-19  -3.40705800559231E-01  -3.40705800547603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16282638152836E-08   0.00000000000000E+00  -1.16282638152836E-08
      3.12409665350674E-18  -3.20989214358102E-01  -3.04549691644559E-01   0.00000000000000E+00   2.34905672364879E-10
     -9.97113802835974E-23  -5.24159151286177E-08  -5.21810094562529E-08  -2.51937249055808E-18
      2.04068043848633E-09
      0.00000000000000E+00  -5.52943892778938E-11   0.00000000000000E+00  -2.09566006602410E-11   1.75604326626411E-22
      5.53154664455377E-08   5.52945098448776E-08  -5.97440297962952E-19  -3.47199422359205E-01  -3.47199422347287E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19175942935554E-08   0.00000000000000E+00  -1.19175942935554E-08
      2.88574476763563E-18  -2.00500699408936E-01  -1.86834546909098E-01   0.00000000000000E+00   1.56603394784156E-10
     -8.21098198711392E-23  -4.35335189461062E-08  -4.33769155513222E-08  -2.28830446967268E-18
      2.06068043848633E-09
      0.00000000000000E+00  -4.84034623346875E-11   0.00000000000000E+00  -1.70957457497872E-11   1.37877942189243E-22
      4.84205773154015E-08   4.84034815696519E-08  -5.87440401018906E-19  -3.54786299552929E-01  -3.54786299541129E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18004559692743E-08   0.00000000000000E+00  -1.18004559692743E-08
      2.64973564825015E-18  -1.03019948540105E-01  -9.14877181709050E-02   0.00000000000000E+00   8.28137154274183E-11
     -7.05603586623418E-23  -3.66858393158050E-08  -3.66030256003777E-08  -2.06229524723125E-18
      2.07068043848633E-09
      0.00000000000000E+00  -4.38391462744223E-11   0.00000000000000E+00  -2.25811541103369E-11   1.21943397636522E-22
      4.38617552417107E-08   4.38391740876004E-08  -5.78864197728286E-19  -3.59784795714411E-01  -3.59784795702798E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16135273528799E-08   0.00000000000000E+00  -1.16135273528799E-08
      2.53360037472135E-18  -6.51541709761463E-02  -5.50010306489949E-02   0.00000000000000E+00   5.88789467242197E-11
     -4.28757358313476E-23  -3.22845256814448E-08  -3.22256467347206E-08  -1.95473617699306E-18
      2.07743043848633E-09
      0.00000000000000E+00  -4.01445080307751E-11   0.00000000000000E+00  -2.70498773225595E-11   1.16588656972267E-22
      4.01715518701378E-08   4.01445019928154E-08  -5.68202412673626E-19  -3.64783669499956E-01  -3.64783669488670E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12861034289019E-08   0.00000000000000E+00  -1.12861034289019E-08
      2.45741917657626E-18  -4.69087312373762E-02  -3.78164658701799E-02   0.00000000000000E+00   4.93544426889807E-11
     -4.72709274070272E-24  -2.89077530066023E-08  -2.88583985639134E-08  -1.88921676390264E-18
      2.08198668848633E-09
      0.00000000000000E+00  -3.76462393339931E-11   0.00000000000000E+00  -2.71047802332283E-11   1.16191944314528E-22
      3.76733035817255E-08   3.76461988014924E-08  -5.58350759030245E-19  -3.69041421744997E-01  -3.69041421733987E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10099133399808E-08   0.00000000000000E+00  -1.10099133399808E-08
      2.40725525892098E-18  -3.80241263217342E-02  -2.96319585537600E-02   0.00000000000000E+00   4.25627104163147E-11
      2.58285210957211E-23  -2.66788481719281E-08  -2.66362854615117E-08  -1.84890449989073E-18
      2.08813762598633E-09
      0.00000000000000E+00  -3.52678280192670E-11   0.00000000000000E+00  -1.91479060044728E-11   1.20316304570985E-22
      3.52868926014170E-08   3.52677446954126E-08  -5.41801815940238E-19  -3.75908860647896E-01  -3.75908860637195E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07011729409874E-08   0.00000000000000E+00  -1.07011729409874E-08
      2.34143301298427E-18  -3.03629849189676E-02  -2.26228990171814E-02   0.00000000000000E+00   3.05726481029513E-11
      6.32374948679671E-23  -2.45971444025282E-08  -2.45665717544252E-08  -1.79963119704403E-18
      2.09644139161133E-09
      0.00000000000000E+00  -3.33670093380201E-11   0.00000000000000E+00  -1.13121530279405E-11   1.29276119345930E-22
      3.33783486197556E-08   3.33670364667278E-08  -5.16808658244499E-19  -3.86087329319296E-01  -3.86087329308852E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04440533762155E-08   0.00000000000000E+00  -1.04440533762155E-08
      2.25470804157319E-18  -2.43840269009083E-02  -1.71617675199865E-02   0.00000000000000E+00   2.02841911792048E-11
      1.04956510372501E-22  -2.29432672816917E-08  -2.29229830905124E-08  -1.73789938332869E-18
      2.10765147520508E-09
      0.00000000000000E+00  -3.19886953667467E-11   0.00000000000000E+00  -6.04679374864601E-12   1.39641322278573E-22
      3.19947485756377E-08   3.19887017818892E-08  -4.82171938120186E-19  -4.00121627677046E-01  -4.00121627666788E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02586137015832E-08   0.00000000000000E+00  -1.02586137015832E-08
      2.13970812442245E-18  -1.99200240049817E-02  -1.30735950086086E-02   0.00000000000000E+00   1.33221213248043E-11
      1.46079780384918E-22  -2.17434102016308E-08  -2.17300880803058E-08  -1.65753618630226E-18
      2.12278508805664E-09
      0.00000000000000E+00  -3.08543210174965E-11   0.00000000000000E+00  -3.66244128071101E-12   1.42838039188632E-22
      3.08579878878621E-08   3.08543254465816E-08  -4.36990652772902E-19  -4.18523727344533E-01  -4.18523727334424E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01087801168266E-08   0.00000000000000E+00  -1.01087801168266E-08
      1.98672575973282E-18  -1.65289173597473E-02  -9.99267577305654E-03   0.00000000000000E+00   9.50248277819789E-12
      1.73940901203361E-22  -2.07550478125334E-08  -2.07455453297550E-08  -1.54973510695992E-18
      2.14278508805664E-09
      0.00000000000000E+00  -2.95890679177256E-11   0.00000000000000E+00  -3.08496300904064E-12   1.27152499641505E-22
      2.95921821671929E-08   2.95890972041840E-08  -3.81474178395195E-19  -4.41442897602025E-01  -4.41442897592079E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94553207389008E-09   0.00000000000000E+00  -9.94553207389008E-09
      1.78781511825502E-18  -1.38495098035247E-02  -7.66045796066281E-03   0.00000000000000E+00   7.65927714885509E-12
      1.68554179656570E-22  -1.96512244074428E-08  -1.96435651302938E-08  -1.40634093985983E-18
      2.16278508805664E-09
      0.00000000000000E+00  -2.83791971944909E-11   0.00000000000000E+00  -2.95330465069082E-12   9.76354274443388E-23
      2.83821721170925E-08   2.83792188124419E-08  -3.30149324443022E-19  -4.62991290423030E-01  -4.62991290413231E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79863403870694E-09   0.00000000000000E+00  -9.79863403870694E-09
      1.59184243748088E-18  -1.20802121720430E-02  -6.22606517045724E-03   0.00000000000000E+00   6.62667427984858E-12
      1.32854466165261E-22  -1.85872114480150E-08  -1.85805847737350E-08  -1.26169311303786E-18
      2.18278508805664E-09
      0.00000000000000E+00  -2.73984790905889E-11   0.00000000000000E+00  -2.39253631302364E-12   6.57579463305018E-23
      2.74008939598169E-08   2.73985014235040E-08  -2.82246446826414E-19  -4.83453801645093E-01  -4.83453801635423E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66980339980271E-09   0.00000000000000E+00  -9.66980339980271E-09
      1.39844636948483E-18  -1.08821402213583E-02  -5.29639075764096E-03   0.00000000000000E+00   5.48141007511749E-12
      8.80357192024317E-23  -1.77341794337765E-08  -1.77286980237013E-08  -1.11619992265841E-18
      2.20278508805664E-09
      0.00000000000000E+00  -2.65635185846353E-11   0.00000000000000E+00  -2.03561171078269E-12   3.95501294395649E-23
      2.65655462441623E-08   2.65635106324516E-08  -2.37493640580849E-19  -5.02914484530116E-01  -5.02914484520603E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51275684781917E-09   0.00000000000000E+00  -9.51275684781917E-09
      1.20819123252844E-18  -1.00262050914216E-02  -4.65405052894349E-03   0.00000000000000E+00   4.58537812348307E-12
      4.94200413910537E-23  -1.70553391627559E-08  -1.70507537846324E-08  -9.70697591947596E-19
      2.22278508805664E-09
      0.00000000000000E+00  -2.65716927662468E-11   0.00000000000000E+00   4.20353087706116E-14   2.21752872073072E-23
      2.65716318085949E-08   2.65716738439037E-08  -1.93012902713159E-19  -5.22685412549948E-01  -5.22685412540013E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93478582646229E-09   0.00000000000000E+00  -9.93478582646229E-09
      1.00949551599920E-18  -9.50337180079626E-03  -4.26160999475727E-03   0.00000000000000E+00   3.71683189261805E-12
      2.33739171110330E-23  -1.66406048493341E-08  -1.66368880174414E-08  -8.16482613286040E-19
      2.24278508805664E-09
      0.00000000000000E+00  -2.74869255725198E-11   0.00000000000000E+00   2.28274457713124E-12   1.25555763843585E-23
      2.74846073363309E-08   2.74868900809080E-08  -1.46958614905316E-19  -5.43694790244627E-01  -5.43694790233767E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08598320919829E-08   0.00000000000000E+00  -1.08598320919829E-08
      7.92298874159540E-19  -9.30352228782412E-03  -4.06485474990357E-03   0.00000000000000E+00   2.64500706808445E-12
      8.96567339431876E-24  -1.66297029959932E-08  -1.66270579889251E-08  -6.45340259254223E-19
      2.25278508805664E-09
      0.00000000000000E+00  -2.81057754118241E-11   0.00000000000000E+00   3.08081021173394E-12   9.29485730204708E-24
      2.81026604523202E-08   2.81057412625320E-08  -1.23836791991625E-19  -5.54464534232306E-01  -5.54464534220912E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13935085488211E-08   0.00000000000000E+00  -1.13935085488211E-08
      6.78363788671329E-19  -9.27323727493669E-03  -4.00773256747337E-03   0.00000000000000E+00   2.10602735570775E-12
      4.10819629967145E-24  -1.67143387410666E-08  -1.67122327137109E-08  -5.54526996679704E-19
      2.25953508805664E-09
      0.00000000000000E+00  -2.86647424824691E-11   0.00000000000000E+00   4.11167891709059E-12   7.76536705281918E-24
      2.86606189218188E-08   2.86647306007359E-08  -1.08135213419586E-19  -5.61868892815483E-01  -5.61868892803748E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17351121919856E-08   0.00000000000000E+00  -1.17351121919856E-08
      5.99151781375426E-19  -9.33299299465077E-03  -3.99899558946002E-03   0.00000000000000E+00   9.01701910297021E-13
      1.83308212088596E-24  -1.69305201106605E-08  -1.69296184087502E-08  -4.91016567955840E-19
      2.26409133805664E-09
      0.00000000000000E+00  -2.90762069051588E-11   0.00000000000000E+00   4.48583017897306E-12   6.98691337170222E-24
      2.90717215687624E-08   2.90762073989414E-08  -9.75272735491633E-20  -5.66911932669198E-01  -5.66911932657263E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19347073190413E-08   0.00000000000000E+00  -1.19347073190413E-08
      5.44774271153044E-19  -9.40330219504259E-03  -4.00254662606321E-03   0.00000000000000E+00   1.63665570239764E-13
      6.74902713793627E-25  -1.71416637454704E-08  -1.71415000799001E-08  -4.47246997603881E-19
      2.27024227555664E-09
      0.00000000000000E+00  -2.94331155539473E-11   0.00000000000000E+00   2.90649537891629E-12   6.25106694798850E-24
      2.94302411813306E-08   2.94331476767095E-08  -8.33212911834830E-20  -5.73704369063746E-01  -5.73704369051715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20314704368187E-08   0.00000000000000E+00  -1.20314704368187E-08
      4.70769448463075E-19  -9.47166060999694E-03  -3.98893060411061E-03   0.00000000000000E+00   3.17957944998113E-13
     -3.49088371026024E-25  -1.74019951978356E-08  -1.74016772398906E-08  -3.87448157279590E-19
      2.27854604118164E-09
      0.00000000000000E+00  -2.94380751697565E-11   0.00000000000000E+00   6.99951481185775E-14   5.56181366652514E-24
      2.94380407555992E-08   2.94381107507473E-08  -6.48548668278060E-20  -5.82594234755472E-01  -5.82594234743637E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18352804429199E-08   0.00000000000000E+00  -1.18352804429199E-08
      3.72492053558921E-19  -9.46825311010388E-03  -3.92214531677239E-03   0.00000000000000E+00   1.09018538071693E-12
     -1.14899186663357E-24  -1.76039204932083E-08  -1.76028303078275E-08  -3.07637186731115E-19
      2.28975612477539E-09
      0.00000000000000E+00  -2.85196277976812E-11   0.00000000000000E+00  -4.01207531076262E-12   4.85908845621876E-24
      2.85236092050194E-08   2.85195971297086E-08  -4.26363489911321E-20  -5.93367204399180E-01  -5.93367204388351E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08288740589106E-08   0.00000000000000E+00  -1.08288740589106E-08
      2.51099470132343E-19  -9.32690667822843E-03  -3.75310554666284E-03   0.00000000000000E+00   1.62397807789235E-12
     -1.70633406583298E-24  -1.76923470488760E-08  -1.76907230707981E-08  -2.08463121141211E-19
      2.30488973762696E-09
      0.00000000000000E+00  -2.46626080586511E-11   0.00000000000000E+00  -1.25546869549208E-11   3.88324402209940E-24
      2.46751688319673E-08   2.46626141450124E-08  -2.39385217289656E-20  -6.02366916495667E-01  -6.02366916488699E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.96814393592497E-09   0.00000000000000E+00  -6.96814393592497E-09
      1.45646277512092E-19  -8.90964266411402E-03  -3.33465948169688E-03   0.00000000000000E+00   1.23890216210560E-12
     -2.09592355497008E-24  -1.76957091112494E-08  -1.76944702090873E-08  -1.21707755783126E-19
      2.32488973762696E-09
      0.00000000000000E+00  -1.20379978610533E-11   0.00000000000000E+00  -3.11246266187992E-11   1.83275955685361E-24
      1.20691787740534E-08   1.20380541474346E-08  -4.49339176761140E-20  -5.91314726034177E-01  -5.91314726039825E-01
      0.00000000000000E+00   0.00000000000000E+00   5.64850270262984E-09   0.00000000000000E+00   5.64850270262984E-09
      2.58616331564689E-19  -7.81443721350068E-03  -2.24194561465071E-03   0.00000000000000E+00  -9.60272100749143E-13
     -2.61494231302253E-24  -1.76855965779637E-08  -1.76865568500644E-08  -2.13682413888574E-19
      2.34488973762696E-09
      0.00000000000000E+00   6.82231892451229E-12   0.00000000000000E+00  -4.64895728397595E-11  -1.83885886917045E-24
     -6.77590030180742E-09  -6.82238987464718E-09  -1.40683100429388E-19  -5.44721417925344E-01  -5.44721417949848E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45039289578878E-08   0.00000000000000E+00   2.45039289578878E-08
      7.48694910722444E-19  -6.18410920491317E-03  -6.13198465489057E-04   0.00000000000000E+00  -4.84772966935757E-12
     -4.53893777245308E-24  -1.76766913535713E-08  -1.76815390832406E-08  -6.08011810293056E-19
      2.36488973762696E-09
      0.00000000000000E+00   2.17541607655004E-11   0.00000000000000E+00  -3.69756311001078E-11  -1.11428953347827E-23
     -2.17171417749607E-08  -2.17541174060609E-08  -3.27749050865556E-19  -4.62288759024005E-01  -4.62288759063389E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93839050072348E-08   0.00000000000000E+00   3.93839050072348E-08
      1.53637301086714E-18  -4.49224242660685E-03   1.06235882931441E-03   0.00000000000000E+00  -1.10055866905987E-11
     -1.70960908296860E-23  -1.76187820144833E-08  -1.76297876011740E-08  -1.20862396000158E-18
      2.38488973762696E-09
      0.00000000000000E+00   2.36108021281505E-11   0.00000000000000E+00  -4.94272923243545E-12  -3.48859541645698E-23
     -2.36058225189319E-08  -2.36107652481644E-08  -6.10568484405339E-19  -3.49138676323230E-01  -3.49138676364492E-01
      0.00000000000000E+00   0.00000000000000E+00   4.12613237164576E-08   0.00000000000000E+00   4.12613237164576E-08
      2.36159948519629E-18  -2.30570381517327E-03   3.25543094838111E-03   0.00000000000000E+00  -2.52791428489341E-11
     -6.19860136805876E-23  -1.76252793254441E-08  -1.76505584682931E-08  -1.75103100079095E-18
      2.40488973762696E-09
      0.00000000000000E+00   1.51947014788760E-11   0.00000000000000E+00   2.01375581975920E-11  -4.27682468061883E-23
     -1.52148843346713E-08  -1.51947467764738E-08  -8.95252846177212E-19  -2.25371662828838E-01  -2.25371662860436E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15974327103925E-08   0.00000000000000E+00   3.15974327103925E-08
      2.99354813940414E-18  -8.60682215912161E-03  -3.43886894297123E-03   0.00000000000000E+00  -5.48163454613886E-11
     -8.07756280038365E-23  -1.63478695884572E-08  -1.64026859339187E-08  -2.09829529322693E-18
      2.42488973762696E-09
      0.00000000000000E+00   1.01463636535271E-11   0.00000000000000E+00   1.16688517988367E-11  -4.57298268511816E-23
     -1.01580651842939E-08  -1.01463963324951E-08  -1.09680190358964E-18  -1.21953056165046E-01  -1.21953056188230E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31842822384811E-08   0.00000000000000E+00   2.31842822384811E-08
      3.45723378417376E-18  -3.71825311153321E-02  -3.30747224703774E-02   0.00000000000000E+00  -1.02839010065567E-10
     -9.37922059687013E-23  -1.29350468959203E-08  -1.30378859059860E-08  -2.36043188058413E-18
      2.44488973762696E-09
      0.00000000000000E+00   6.02437184765330E-12   0.00000000000000E+00   9.40873490993617E-12  -4.75048799263725E-23
     -6.03382485899475E-09  -6.02441612408486E-09  -1.21585244116654E-18  -5.32557703845159E-02  -5.32557704003591E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58432228462866E-08   0.00000000000000E+00   1.58432228462866E-08
      3.77409824109949E-18  -8.39043127249165E-02  -8.08107237610717E-02   0.00000000000000E+00  -1.58193653455100E-10
     -1.06390047151833E-22  -9.66061306874651E-09  -9.81880672220172E-09  -2.55824579993296E-18
      2.44738973762696E-09
      0.00000000000000E+00   4.82515511393463E-12   0.00000000000000E+00   2.26590617652049E-11  -4.76359857226834E-23
     -4.84783460011496E-09  -4.82517553834981E-09  -1.22773571436550E-18  -4.61075618601357E-02  -4.61075618738351E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36993364947536E-08   0.00000000000000E+00   1.36993364947536E-08
      3.80834658233638E-18  -9.03903654304350E-02  -8.75943775931411E-02   0.00000000000000E+00  -1.83182878993630E-10
     -1.07986824911369E-22  -8.69097807740989E-09  -8.87416095640363E-09  -2.58061086797088E-18
      2.45076473762696E-09
      0.00000000000000E+00   3.56605561155664E-12   0.00000000000000E+00   1.79044797391960E-11  -4.77673438423690E-23
     -3.58394244589243E-09  -3.56603796615329E-09  -1.23952573685683E-18  -3.88784437213847E-02  -3.88784437329317E-02
      0.00000000000000E+00   0.00000000000000E+00   1.15470277579228E-08   0.00000000000000E+00   1.15470277579228E-08
      3.84731780101937E-18  -9.99639965094210E-02  -9.74494170755068E-02   0.00000000000000E+00  -1.83439911566929E-10
     -1.10015437061184E-22  -7.79754988020224E-09  -7.98098979176928E-09  -2.60779206416253E-18
      2.45532098762696E-09
      0.00000000000000E+00   2.39310647267932E-12   0.00000000000000E+00   1.23731898160175E-11  -4.78797565024454E-23
     -2.40543267797075E-09  -2.39305948815478E-09  -1.25009639573419E-18  -3.22220023713794E-02  -3.22220023808890E-02
      0.00000000000000E+00   0.00000000000000E+00   9.50958128643467E-09   0.00000000000000E+00   9.50958128643467E-09
      3.89064583075569E-18  -1.13800945122292E-01  -1.11558732880614E-01   0.00000000000000E+00  -1.81044489213225E-10
     -1.12561892088155E-22  -6.93547730906669E-09  -7.11652179828003E-09  -2.64054943502150E-18
      2.46147192512696E-09
      0.00000000000000E+00   1.45849442685552E-12   0.00000000000000E+00   7.30471733250392E-12  -4.79655573570670E-23
     -1.46580797622958E-09  -1.45850325889712E-09  -1.25862031746205E-18  -2.66197639543681E-02  -2.66197639621680E-02
      0.00000000000000E+00   0.00000000000000E+00   7.79987796884329E-09   0.00000000000000E+00   7.79987796884329E-09
      3.93862239264967E-18  -1.33239453290415E-01  -1.31241465841127E-01   0.00000000000000E+00  -1.81314408015071E-10
     -1.15787027852932E-22  -6.16006030193094E-09  -6.34137470994612E-09  -2.68000207518762E-18
      2.46977569075196E-09
      0.00000000000000E+00   8.32664387523438E-13   0.00000000000000E+00   3.61777294939673E-12  -4.80264648443877E-23
     -8.36277450493673E-10  -8.32659677544324E-10  -1.26493922936112E-18  -2.21605715922915E-02  -2.21605715988052E-02
      0.00000000000000E+00   0.00000000000000E+00   6.51371595026559E-09   0.00000000000000E+00   6.51371595026559E-09
      3.99271076324850E-18  -1.59646232864341E-01  -1.57856290841387E-01   0.00000000000000E+00  -1.85954278846076E-10
     -1.19936616797340E-22  -5.49510199387506E-09  -5.68105627272126E-09  -2.72777153388738E-18
      2.48098577434571E-09
      0.00000000000000E+00   4.68959228181632E-13   0.00000000000000E+00   1.55230202001540E-12  -4.80669584204782E-23
     -4.70501307807389E-10  -4.68949005787422E-10  -1.26941156363553E-18  -1.86339536633098E-02  -1.86339536688473E-02
      0.00000000000000E+00   0.00000000000000E+00   5.53744029685546E-09   0.00000000000000E+00   5.53744029685546E-09
      4.05478593187165E-18  -1.94142010108189E-01  -1.92545067395686E-01   0.00000000000000E+00  -1.94041253993764E-10
     -1.25305633892117E-22  -4.87445003707405E-09  -5.06849129106794E-09  -2.78537436823611E-18
      2.49611938719727E-09
      0.00000000000000E+00   2.77187416892316E-13   0.00000000000000E+00   6.04955508348185E-13  -4.80915239673390E-23
     -2.77804156079159E-10  -2.77199200570859E-10  -1.27258008212038E-18  -1.57631814044620E-02  -1.57631814090806E-02
      0.00000000000000E+00   0.00000000000000E+00   4.61861397544240E-09   0.00000000000000E+00   4.61861397544240E-09
      4.12468224768681E-18  -2.36332784763792E-01  -2.34964920308402E-01   0.00000000000000E+00  -1.98413874460357E-10
     -1.32017183281931E-22  -4.14300090041112E-09  -4.34141477487161E-09  -2.85210216556643E-18
      2.51611938719727E-09
      0.00000000000000E+00   1.89108313910298E-13   0.00000000000000E+00   2.10141391203520E-13  -4.81060055195082E-23
     -1.89378905770357E-10  -1.89168764379202E-10  -1.27505094628311E-18  -1.33697280952117E-02  -1.33697280987256E-02
      0.00000000000000E+00   0.00000000000000E+00   3.51390909304898E-09   0.00000000000000E+00   3.51390909304898E-09
      4.19496042954779E-18  -2.80431609760161E-01  -2.79384068857590E-01   0.00000000000000E+00  -1.80978053351216E-10
     -1.39308890386892E-22  -3.14376227531833E-09  -3.32474032866968E-09  -2.91990948326468E-18
      2.53611938719727E-09
      0.00000000000000E+00   1.53748090085400E-13   0.00000000000000E+00   8.52271493535015E-14  -4.81126947256968E-23
     -1.53905834390249E-10  -1.53820607240943E-10  -1.27684567197348E-18  -1.17603834477563E-02  -1.17603834502378E-02
      0.00000000000000E+00   0.00000000000000E+00   2.48148650967020E-09   0.00000000000000E+00   2.48148650967020E-09
      4.24459015974119E-18  -3.11444833111643E-01  -3.10711442822206E-01   0.00000000000000E+00  -1.43120105716915E-10
     -1.44617477624970E-22  -2.18454579671225E-09  -2.32766590242931E-09  -2.96774448776772E-18
      2.55611938719727E-09
      0.00000000000000E+00   1.35470987381102E-13   0.00000000000000E+00   4.57360728610515E-14  -4.81147619002288E-23
     -1.35525394182466E-10  -1.35479658109653E-10  -1.27829451131264E-18  -1.06608466981487E-02  -1.06608466998171E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66840722705585E-09   0.00000000000000E+00   1.66840722705585E-09
      4.27795830428231E-18  -3.31313943182512E-01  -3.30830957411752E-01   0.00000000000000E+00  -9.78963111800680E-11
     -1.48066257892304E-22  -1.43503125776594E-09  -1.53292756894616E-09  -2.99966379296967E-18
      2.57611938719727E-09
      0.00000000000000E+00   1.29868458411443E-13   0.00000000000000E+00   1.48494266429312E-14  -4.81161989470104E-23
     -1.29857637465130E-10  -1.29842788038535E-10  -1.27964369571683E-18  -9.86587213827827E-03  -9.86587213929650E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01823122832359E-09   0.00000000000000E+00   1.01823122832359E-09
      4.29832292884878E-18  -3.41697284362233E-01  -3.41417381593430E-01   0.00000000000000E+00  -5.16123904359509E-11
     -1.49841129418311E-22  -8.36776049848964E-10  -8.88388440285065E-10  -3.01867923313195E-18
      2.59611938719727E-09
      0.00000000000000E+00   1.07182808321184E-13   0.00000000000000E+00   6.00618350044547E-14  -4.81089852297262E-23
     -1.07268598118599E-10  -1.07208536283643E-10  -1.28055058848014E-18  -9.43990447077679E-03  -9.43990447147784E-03
      0.00000000000000E+00   0.00000000000000E+00   7.01050971096112E-10   0.00000000000000E+00   7.01050971096112E-10
      4.31234394827070E-18  -3.48010818356918E-01  -3.47823722257293E-01   0.00000000000000E+00  -2.94774977398815E-11
     -1.50839110527716E-22  -5.64364937072429E-10  -5.93842434812461E-10  -3.03179335979056E-18
      2.61611938719727E-09
      0.00000000000000E+00   8.10989029542461E-14   0.00000000000000E+00   7.28865541604355E-14  -4.80928134639495E-23
     -8.11343942314206E-11  -8.10615076773082E-11  -1.28094678931464E-18  -9.27469195095246E-03  -9.27469195170065E-03
      0.00000000000000E+00   0.00000000000000E+00   7.48186566927220E-10   0.00000000000000E+00   7.48186566927220E-10
      4.32730767960925E-18  -3.55877368853242E-01  -3.55667181971519E-01   0.00000000000000E+00  -3.75794412954860E-11
     -1.52074506942007E-22  -6.29545617954264E-10  -6.67125059249902E-10  -3.04636089029460E-18
      2.62611938719727E-09
      0.00000000000000E+00   5.79540291779494E-14   0.00000000000000E+00   1.25877337532683E-13  -4.80801326568297E-23
     -5.80830043538956E-11  -5.79571270164110E-11  -1.28091769380967E-18  -9.28644838526648E-03  -9.28644838617769E-03
      0.00000000000000E+00   0.00000000000000E+00   9.11206312047266E-10   0.00000000000000E+00   9.11206312047266E-10
      4.33641974272972E-18  -3.61428537488542E-01  -3.61159704777909E-01   0.00000000000000E+00  -5.55809774363833E-11
     -1.52969727070491E-22  -7.97668207594421E-10  -8.53249185030958E-10  -3.05550204892005E-18
      2.62949438719727E-09
      0.00000000000000E+00   3.37988632923698E-14   0.00000000000000E+00   3.65890735783514E-13  -4.80733484840210E-23
     -3.41504310935445E-11  -3.37845403578091E-11  -1.28082681105427E-18  -9.32887368229650E-03  -9.32887368333135E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03485521867784E-09   0.00000000000000E+00   1.03485521867784E-09
      4.33991237909276E-18  -3.63764223791226E-01  -3.63448813570548E-01   0.00000000000000E+00  -7.07174368147367E-11
     -1.53349272812145E-22  -9.30353241505078E-10  -1.00107067831997E-09  -3.05908556803848E-18
      2.63405063719727E-09
      0.00000000000000E+00   1.57054500624871E-14   0.00000000000000E+00   2.16932652914507E-13  -4.80637841753588E-23
     -1.58975523097159E-11  -1.56806196568494E-11  -1.28062277312143E-18  -9.40950811833826E-03  -9.40950811960823E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26996931323853E-09   0.00000000000000E+00   1.26996931323853E-09
      4.34569867677620E-18  -3.67873237191376E-01  -3.67478040691459E-01   0.00000000000000E+00  -9.48957353431024E-11
     -1.54033453564358E-22  -1.15939295823871E-09  -1.25428869358197E-09  -3.06507590365477E-18
      2.64020157469727E-09
      0.00000000000000E+00   1.78178790182602E-14   0.00000000000000E+00   3.27403666686998E-15  -4.80528345277248E-23
     -1.78395857529820E-11  -1.78363117163631E-11  -1.28036292515646E-18  -9.47457790988388E-03  -9.47457791141139E-03
      0.00000000000000E+00   0.00000000000000E+00   1.52751586126489E-09   0.00000000000000E+00   1.52751586126489E-09
      4.35509433136910E-18  -3.74605528318934E-01  -3.74129861324816E-01   0.00000000000000E+00  -1.19298575457844E-10
     -1.55188740885148E-22  -1.39038097409035E-09  -1.50967954954835E-09  -3.07473140621264E-18
      2.64850534032227E-09
      0.00000000000000E+00   3.14109001249742E-14   0.00000000000000E+00  -6.42682746924284E-14  -4.80408735613464E-23
     -3.13686058997965E-11  -3.14328741745369E-11  -1.28012952989764E-18  -9.46118773776642E-03  -9.46118773947982E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71339982046188E-09   0.00000000000000E+00   1.71339982046188E-09
      4.36932200190013E-18  -3.84709014357065E-01  -3.84179061744390E-01   0.00000000000000E+00  -1.37807946311819E-10
     -1.56970877572944E-22  -1.54415899997531E-09  -1.68196694628728E-09  -3.08919247200248E-18
      2.65971542391602E-09
      0.00000000000000E+00   4.85858659827817E-14   0.00000000000000E+00  -6.29143150205517E-14  -4.80283938298472E-23
     -4.85296796854138E-11  -4.85925940004824E-11  -1.28001491547280E-18  -9.30807959087396E-03  -9.30807959266133E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78736873834072E-09   0.00000000000000E+00   1.78736873834072E-09
      4.38935855486979E-18  -3.98740816460958E-01  -3.98192963726159E-01   0.00000000000000E+00  -1.48151980605611E-10
     -1.59512468116799E-22  -1.59062416373453E-09  -1.73877614434030E-09  -3.10934363939699E-18
      2.67484903676758E-09
      0.00000000000000E+00   7.37513239776440E-14   0.00000000000000E+00  -7.43385967125682E-14  -4.80189318125314E-23
     -7.36839389476563E-11  -7.37582775444169E-11  -1.28025475536148E-18  -8.87161622285835E-03  -8.87161622464091E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78256755988460E-09   0.00000000000000E+00   1.78256755988460E-09
      4.41633524220284E-18  -4.17194879755873E-01  -4.16656468644507E-01   0.00000000000000E+00  -1.52830379086290E-10
     -1.62968900990224E-22  -1.55597890325372E-09  -1.70880928234017E-09  -3.13608048684136E-18
      2.69484903676758E-09
      0.00000000000000E+00   1.20959518902313E-13   0.00000000000000E+00  -1.17320032649098E-13  -4.80245982625772E-23
     -1.20782182301720E-10  -1.20899502334418E-10  -1.28153483393682E-18  -7.74454686056579E-03  -7.74454686232971E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76392586912822E-09   0.00000000000000E+00   1.76392586912822E-09
      4.45161375958540E-18  -4.40193100115051E-01  -4.39675415465035E-01   0.00000000000000E+00  -1.56349975469701E-10
     -1.67506150255077E-22  -1.48667639132396E-09  -1.64302636679383E-09  -3.17007892564858E-18
      2.71484903676758E-09
      0.00000000000000E+00   1.65687905922378E-13   0.00000000000000E+00  -1.19923704365198E-13  -4.80463560166509E-23
     -1.65565113813079E-10  -1.65685037517492E-10  -1.28372717282017E-18  -6.10114314756970E-03  -6.10114314931054E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74083849427618E-09   0.00000000000000E+00   1.74083849427618E-09
      4.48643052947093E-18  -4.61806215048634E-01  -4.61309914500423E-01   0.00000000000000E+00  -1.60404000039074E-10
     -1.72019696944761E-22  -1.41474945671954E-09  -1.57515345675879E-09  -3.20270335665076E-18
      2.73484903676758E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.50888655230546E-14  -4.80679924381662E-23
     -1.71322197816482E-10  -1.71347286682053E-10  -1.28604770828686E-18  -4.41030867368827E-03  -4.41030867535921E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67094404661341E-09   0.00000000000000E+00   1.67094404661341E-09
      4.51984941040319E-18  -4.82322762804222E-01  -4.81850267589457E-01   0.00000000000000E+00  -1.62478435460906E-10
     -1.76462050486203E-22  -1.33711832447019E-09  -1.49959675993127E-09  -3.23380170211633E-18
      2.75484903676758E-09
      0.00000000000000E+00   2.17947561393461E-13   0.00000000000000E+00  -1.33985783701192E-13  -4.81089576003174E-23
     -2.17788697177255E-10  -2.17922682961004E-10  -1.28931126461232E-18  -2.17241782859197E-03  -2.17241783026918E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67720842925329E-09   0.00000000000000E+00   1.67720842925329E-09
      4.55339357898826E-18  -5.01837284922991E-01  -5.01377489212712E-01   0.00000000000000E+00  -1.68526705158992E-10
     -1.80945046255385E-22  -1.29075904113303E-09  -1.45928574629220E-09  -3.26408231437593E-18
      2.77484903676758E-09
      0.00000000000000E+00  -5.72009023328477E-13   0.00000000000000E+00   2.05964782953874E-12  -4.78201062309751E-23
      5.69941085346417E-10   5.72000733175908E-10  -1.27683268075939E-18  -9.45863151621693E-03  -9.45863151657185E-03
      0.00000000000000E+00   0.00000000000000E+00   3.54927052977741E-10   0.00000000000000E+00   3.54927052977741E-10
      4.56049212004781E-18  -5.21479689381431E-01  -5.21187640036783E-01   0.00000000000000E+00  -9.76171858622439E-11
     -1.83485493373856E-22  -8.29310600291236E-10  -9.26927786153664E-10  -3.28365943928842E-18
      2.79484903676758E-09
      0.00000000000000E+00  -2.48063450723809E-12   0.00000000000000E+00   5.10208036251198E-12  -4.68032442358143E-23
      2.47548899984621E-09   2.48059108020867E-09  -1.22651722452986E-18  -3.88459726676356E-02  -3.88459726649275E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.70808867907627E-09   0.00000000000000E+00  -2.70808867907627E-09
      4.50633034646629E-18  -5.42420420768031E-01  -5.42492139779938E-01   0.00000000000000E+00   7.65919900859123E-11
     -1.81468217690755E-22   1.50905608781793E-10   2.27497598867524E-10  -3.27981312193643E-18
      2.79984903676758E-09
      0.00000000000000E+00  -3.27059109196003E-12   0.00000000000000E+00   8.24263221995766E-12  -4.64623810466464E-23
      3.26234997092601E-09   3.27059260314593E-09  -1.21003793933623E-18  -4.82772046635136E-02  -4.82772046595802E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.93344381566634E-09   0.00000000000000E+00  -3.93344381566634E-09
      4.48666312738796E-18  -5.47739612654196E-01  -5.47948517570969E-01   0.00000000000000E+00   1.40877301737796E-10
     -1.80537726650898E-22   5.21973910782824E-10   6.62851212520439E-10  -3.27662518805172E-18
      2.80659903676758E-09
      0.00000000000000E+00  -4.01692142650839E-12   0.00000000000000E+00   6.00746307784213E-12  -4.59419504098921E-23
      4.01092195002510E-09   4.01692941310290E-09  -1.18291145581881E-18  -6.35370531176166E-02  -6.35370531125430E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.07362106430799E-09   0.00000000000000E+00  -5.07362106430799E-09
      4.45241618520388E-18  -5.55061613856826E-01  -5.55394618583069E-01   0.00000000000000E+00   1.95652681055639E-10
     -1.78771836995418E-22   8.61038970149417E-10   1.05669165120488E-09  -3.26950472938507E-18
      2.81571153676758E-09
      0.00000000000000E+00  -4.99883351199406E-12   0.00000000000000E+00   5.90232473306256E-12  -4.51066064703650E-23
      4.99296870756535E-09   4.99887103229837E-09  -1.13798353678683E-18  -8.81483370249545E-02  -8.81483370184724E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.48209325956638E-09   0.00000000000000E+00  -6.48209325956638E-09
      4.39334811037608E-18  -5.65105857660624E-01  -5.65573270255482E-01   0.00000000000000E+00   2.55035318510607E-10
     -1.75612410586104E-22   1.22818690875764E-09   1.48322222726807E-09  -3.25536457358925E-18
      2.81878700551758E-09
      0.00000000000000E+00  -5.48138576128240E-12   0.00000000000000E+00   8.28015950492201E-12  -4.47939608692923E-23
      5.47309900755514E-09   5.48137916706002E-09  -1.12146409023597E-18  -9.70096035208378E-02  -9.70096035137052E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.13257764074693E-09   0.00000000000000E+00  -7.13257764074693E-09
      4.37141209073501E-18  -5.68507256925843E-01  -5.69027600514206E-01   0.00000000000000E+00   2.74304984182498E-10
     -1.74452200068685E-22   1.37689348950549E-09   1.65119847368782E-09  -3.24994800049904E-18
      2.82293888833008E-09
      0.00000000000000E+00  -5.96522383689165E-12   0.00000000000000E+00   6.35561609436964E-12  -4.43562440339103E-23
      5.95888879684903E-09   5.96524441294335E-09  -1.09748987016474E-18  -1.09667482264681E-01  -1.09667482256935E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74670606839195E-09   0.00000000000000E+00  -7.74670606839195E-09
      4.33924867495616E-18  -5.73099304636008E-01  -5.73660702009850E-01   0.00000000000000E+00   2.93430425228569E-10
     -1.72760460791045E-22   1.48803123022034E-09   1.78146165544874E-09  -3.24175880479142E-18
      2.82854393012695E-09
      0.00000000000000E+00  -6.48956544160943E-12   0.00000000000000E+00   5.19000123470013E-12  -4.37186219622673E-23
      6.48436960412619E-09   6.48955960536084E-09  -1.06318389798932E-18  -1.27393370932179E-01  -1.27393370923906E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.27292547968762E-09   0.00000000000000E+00  -8.27292547968762E-09
      4.29287858186008E-18  -5.79204207934769E-01  -5.79766223915299E-01   0.00000000000000E+00   3.03331503102119E-10
     -1.70368304203831E-22   1.48003437122479E-09   1.78336587432674E-09  -3.22969468387077E-18
      2.83611073655274E-09
      0.00000000000000E+00  -7.18675884175176E-12   0.00000000000000E+00   5.06402991070655E-12  -4.26055212591731E-23
      7.18171356322517E-09   7.18677759313584E-09  -1.01501176684197E-18  -1.51565020601047E-01  -1.51565020592385E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66132349426636E-09   0.00000000000000E+00  -8.66132349426636E-09
      4.22734002358790E-18  -5.87074077726086E-01  -5.87538834217824E-01   0.00000000000000E+00   3.01149289715339E-10
     -1.67106381353881E-22   1.17339661141565E-09   1.47454590113082E-09  -3.21232825674593E-18
      2.84632592522754E-09
      0.00000000000000E+00  -8.63166024750057E-12   0.00000000000000E+00   7.40892792169386E-12  -3.93368358879461E-23
      8.62423613574872E-09   8.63164506367037E-09  -9.48964710636673E-19  -1.83465681599528E-01  -1.83465681590598E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.92911949174985E-09   0.00000000000000E+00  -8.92911949174985E-09
      4.13612738327980E-18  -5.96365187804476E-01  -5.96459197998097E-01   0.00000000000000E+00   2.89594235723627E-10
     -1.62772283974770E-22   7.88019235612553E-12   2.97474428079590E-10  -3.18716267264312E-18
      2.86011642993853E-09
      0.00000000000000E+00  -1.29767429200515E-11   0.00000000000000E+00   1.58590413732516E-11  -2.40358999258576E-23
      1.29608952311659E-08   1.29767542725391E-08  -8.62296896815210E-19  -2.23437531077465E-01  -2.23437531068275E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.19067581210220E-09   0.00000000000000E+00  -9.19067581210220E-09
      4.00938332519585E-18  -6.03533460431704E-01  -6.02341215376122E-01   0.00000000000000E+00   2.80968391044724E-10
     -1.56880062107526E-22  -4.06704685148166E-09  -3.78607846043709E-09  -3.14708642838065E-18
      2.87873361129836E-09
      0.00000000000000E+00  -2.59813147954768E-11   0.00000000000000E+00   3.46729279115572E-11   3.71336355396013E-23
      2.59465847190469E-08   2.59812576469585E-08  -7.61057270090681E-19  -2.68172072187373E-01  -2.68172072177702E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67154206228167E-09   0.00000000000000E+00  -9.67154206228167E-09
      3.82932647259312E-18  -5.92241335147234E-01  -5.87104108762610E-01   0.00000000000000E+00   2.99553559606225E-10
     -1.47703631652306E-22  -1.66092691442828E-08  -1.63097155846767E-08  -3.06826920250243E-18
      2.89873361129836E-09
      0.00000000000000E+00  -4.60974246728809E-11   0.00000000000000E+00   4.98778723402091E-11   1.33122845716369E-22
      4.60475658575666E-08   4.60974437299070E-08  -6.81350512026358E-19  -3.03095292337847E-01  -3.03095292327495E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03523060164852E-08   0.00000000000000E+00  -1.03523060164852E-08
      3.62228035226341E-18  -5.44399003043674E-01  -5.33138950047590E-01   0.00000000000000E+00   3.18837041554186E-10
     -1.35060267396965E-22  -3.60639747549758E-08  -3.57451377134218E-08  -2.94092984023705E-18
      2.91873361129836E-09
      0.00000000000000E+00  -6.22046954606509E-11   0.00000000000000E+00   4.00729292241677E-11   2.08741302975523E-22
      6.21646176656228E-08   6.22046905948471E-08  -6.30969678607467E-19  -3.26218051737111E-01  -3.26218051726134E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09773506509836E-08   0.00000000000000E+00  -1.09773506509836E-08
      3.40273333924374E-18  -4.60894916461450E-01  -4.44756727200483E-01   0.00000000000000E+00   2.95874946611176E-10
     -1.19289124764965E-22  -5.15232148904746E-08  -5.12273399438636E-08  -2.77176366063628E-18
      2.93873361129836E-09
      0.00000000000000E+00  -6.53749920995803E-11   0.00000000000000E+00   7.99169561469239E-12   2.24035869104542E-22
      6.53669534396638E-08   6.53749451352787E-08  -6.06353297779526E-19  -3.39336833677339E-01  -3.39336833665804E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15342347855257E-08   0.00000000000000E+00  -1.15342347855257E-08
      3.17204864353323E-18  -3.46928346894230E-01  -3.29966061238357E-01   0.00000000000000E+00   2.47835586724915E-10
     -1.02933311696023E-22  -5.40885459364778E-08  -5.38407103497530E-08  -2.56569534575370E-18
      2.95873361129836E-09
      0.00000000000000E+00  -5.71424890799837E-11   0.00000000000000E+00  -2.03796129602769E-11   1.86961939226311E-22
      5.71628801602078E-08   5.71425005472477E-08  -5.98607907555220E-19  -3.45989095315004E-01  -3.45989095303092E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19122814186241E-08   0.00000000000000E+00  -1.19122814186241E-08
      2.93380301516075E-18  -2.23129757199937E-01  -2.08879731455506E-01   0.00000000000000E+00   1.75883461389248E-10
     -8.63057913352670E-23  -4.54061025900127E-08  -4.52302191286236E-08  -2.33519510760553E-18
      2.96873361129836E-09
      0.00000000000000E+00  -5.19748449410022E-11   0.00000000000000E+00  -2.56247864061476E-11   1.62572614560438E-22
      5.20004712470231E-08   5.19748464606171E-08  -5.96525706556401E-19  -3.48654529678586E-01  -3.48654529666593E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19933039853570E-08   0.00000000000000E+00  -1.19933039853570E-08
      2.81386997530718E-18  -1.65912070903785E-01  -1.53315522462079E-01   0.00000000000000E+00   1.18289783039133E-10
     -7.98471298343391E-23  -4.00998322582990E-08  -3.99815424752600E-08  -2.21734426875077E-18
      2.97548361129836E-09
      0.00000000000000E+00  -4.91390468349826E-11   0.00000000000000E+00  -2.08710552882203E-11   1.47175112970354E-22
      4.91599350112940E-08   4.91390639560060E-08  -5.94423691974156E-19  -3.50746298550818E-01  -3.50746298538884E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19343787733367E-08   0.00000000000000E+00  -1.19343787733367E-08
      2.73331291858715E-18  -1.31078798698274E-01  -1.19357053277679E-01   0.00000000000000E+00   8.78099893820954E-11
     -7.64206858678505E-23  -3.72924951720513E-08  -3.72046851826692E-08  -2.13888922661299E-18
      2.98003986129836E-09
      0.00000000000000E+00  -4.73356754199128E-11   0.00000000000000E+00  -1.96331445566093E-11   1.37511438787827E-22
      4.73553196965406E-08   4.73356865519841E-08  -5.92540307304729E-19  -3.52334369487034E-01  -3.52334369475160E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18743149538832E-08   0.00000000000000E+00  -1.18743149538832E-08
      2.67921057107852E-18  -1.09434930424948E-01  -9.82623975091471E-02   0.00000000000000E+00   7.34774129959741E-11
     -7.30068695004858E-23  -3.55348490110967E-08  -3.54613715981008E-08  -2.08667026377379E-18
      2.98619079879836E-09
      0.00000000000000E+00  -4.51402188217041E-11   0.00000000000000E+00  -1.76953810977222E-11   1.26827000176328E-22
      4.51579347200849E-08   4.51402393389873E-08  -5.88378123911909E-19  -3.55064025455311E-01  -3.55064025443577E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17339497054546E-08   0.00000000000000E+00  -1.17339497054546E-08
      2.60703577981213E-18  -8.38791514365589E-02  -7.33540585187244E-02   0.00000000000000E+00   5.99739499434282E-11
     -6.28690045036042E-23  -3.34662635834763E-08  -3.34062896335330E-08  -2.01865765590022E-18
      2.99449456442336E-09
      0.00000000000000E+00  -4.18584226718047E-11   0.00000000000000E+00  -1.95456881277048E-11   1.18328697200052E-22
      4.18779345035010E-08   4.18583888153734E-08  -5.78010272106673E-19  -3.60365955761221E-01  -3.60365955749776E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14445963101720E-08   0.00000000000000E+00  -1.14445963101720E-08
      2.51200253437972E-18  -5.73056784580755E-02  -4.77233763132836E-02   0.00000000000000E+00   4.87278812866645E-11
     -3.07005331730040E-23  -3.04625203864879E-08  -3.04137925052013E-08  -1.93399226227305E-18
      3.00009960622023E-09
      0.00000000000000E+00  -3.90465960421963E-11   0.00000000000000E+00  -2.47596362696020E-11   1.16249965890315E-22
      3.90713921811160E-08   3.90466325448465E-08  -5.67639881019816E-19  -3.65045746802042E-01  -3.65045746790878E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11640924196350E-08   0.00000000000000E+00  -1.11640924196350E-08
      2.44942732974349E-18  -4.40571140927038E-02  -3.52723029756829E-02   0.00000000000000E+00   4.44610884529732E-11
      3.71807351373888E-24  -2.79270012136646E-08  -2.78825401252116E-08  -1.88178744872367E-18
      3.00388300943312E-09
      0.00000000000000E+00  -3.71555129030933E-11   0.00000000000000E+00  -2.46995344494147E-11   1.16827594867132E-22
      3.71802111188968E-08   3.71555115844475E-08  -5.58971412217742E-19  -3.68756505195380E-01  -3.68756505184431E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09494108232179E-08   0.00000000000000E+00  -1.09494108232179E-08
      2.40800129365567E-18  -3.72659260977416E-02  -2.90092929820759E-02   0.00000000000000E+00   3.94730068293651E-11
      2.90080331028760E-23  -2.62455737680588E-08  -2.62061007612294E-08  -1.84902988143793E-18
      3.00899060377053E-09
      0.00000000000000E+00  -3.52626847139834E-11   0.00000000000000E+00  -1.83473289227155E-11   1.20656704437003E-22
      3.52810467783208E-08   3.52626994493982E-08  -5.45143188878375E-19  -3.74496966244790E-01  -3.74496966234087E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07032123640856E-08   0.00000000000000E+00  -1.07032123640856E-08
      2.35333362679285E-18  -3.09554928592339E-02  -2.32176398937083E-02   0.00000000000000E+00   2.99219988193347E-11
      6.03804750379779E-23  -2.45894090841324E-08  -2.45594870853130E-08  -1.80819043791448E-18
      3.01588585612602E-09
      0.00000000000000E+00  -3.36241746022011E-11   0.00000000000000E+00  -1.17450491524938E-11   1.28400260391389E-22
      3.36358942678801E-08   3.36241492187277E-08  -5.24513931831137E-19  -3.82916093210336E-01  -3.82916093199854E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04819834852136E-08   0.00000000000000E+00  -1.04819834852136E-08
      2.28105770547619E-18  -2.55868651679002E-02  -1.82955511210379E-02   0.00000000000000E+00   2.11459077504834E-11
      9.68065712922516E-23  -2.31633116412647E-08  -2.31421657335141E-08  -1.75654377364505E-18
      3.02519444680594E-09
      0.00000000000000E+00  -3.23423894497329E-11   0.00000000000000E+00  -6.77824938786971E-12   1.38474310740120E-22
      3.23491296150619E-08   3.23423513656741E-08  -4.95662257927053E-19  -3.94611756740590E-01  -3.94611756730281E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03093959894392E-08   0.00000000000000E+00  -1.03093959894392E-08
      2.18509175805334E-18  -2.12648459329705E-02  -1.43229968084662E-02   0.00000000000000E+00   1.45592320839734E-11
      1.35404819076132E-22  -2.20475146083192E-08  -2.20329553762351E-08  -1.68942950012628E-18
      3.03776104422382E-09
      0.00000000000000E+00  -3.12952676008299E-11   0.00000000000000E+00  -4.07642858371877E-12   1.45465106871919E-22
      3.12993462854055E-08   3.12952698568219E-08  -4.57385568562916E-19  -4.10157025780646E-01  -4.10157025770476E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01705337876553E-08   0.00000000000000E+00  -1.01705337876553E-08
      2.05728275441886E-18  -1.78239953844966E-02  -1.11682869346941E-02   0.00000000000000E+00   1.04619139366409E-11
      1.68185905578567E-22  -2.11351979831033E-08  -2.11247360691665E-08  -1.59989718585594E-18
      3.05472595073797E-09
      0.00000000000000E+00  -3.01993761964697E-11   0.00000000000000E+00  -3.14908684331150E-12   1.39409159614066E-22
      3.02024883161340E-08   3.01993392292909E-08  -4.08592897053764E-19  -4.30170996718211E-01  -4.30170996708184E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00267658781739E-08   0.00000000000000E+00  -1.00267658781739E-08
      1.88717960865641E-18  -1.50144811125001E-02  -8.65875963229589E-03   0.00000000000000E+00   8.25275622955993E-12
      1.79030236904427E-22  -2.01808261073466E-08  -2.01725733511169E-08  -1.47858671160264E-18
      3.07472595073797E-09
      0.00000000000000E+00  -2.89556147652053E-11   0.00000000000000E+00  -3.03406502331967E-12   1.14770843442867E-22
      2.89586579854130E-08   2.89556239203898E-08  -3.55329399939867E-19  -4.52355669790112E-01  -4.52355669780242E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87038726398252E-09   0.00000000000000E+00  -9.87038726398252E-09
      1.68977186337675E-18  -1.28723312830043E-02  -6.85918747455390E-03   0.00000000000000E+00   7.09209744847215E-12
      1.55046884533015E-22  -1.90923287538559E-08  -1.90852366564073E-08  -1.33444246343689E-18
      3.09472595073797E-09
      0.00000000000000E+00  -2.78590804476847E-11   0.00000000000000E+00  -2.67614924588936E-12   8.21975577596829E-23
      2.78617724157049E-08   2.78590962664591E-08  -3.05826942852719E-19  -4.73327206277190E-01  -4.73327206267457E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73348979247670E-09   0.00000000000000E+00  -9.73348979247670E-09
      1.49510206752722E-18  -1.14248120114620E-02  -5.71401159417230E-03   0.00000000000000E+00   6.02783704651894E-12
      1.11565799004508E-22  -1.81316343110291E-08  -1.81256064739824E-08  -1.18927512467450E-18
      3.11472595073797E-09
      0.00000000000000E+00  -2.69737890257413E-11   0.00000000000000E+00  -2.15848121547702E-12   5.20438611505444E-23
      2.69759846721024E-08   2.69738261908870E-08  -2.59515970931725E-19  -4.93289171737656E-01  -4.93289171728056E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59983350314596E-09   0.00000000000000E+00  -9.59983350314596E-09
      1.30310539746430E-18  -1.04232407533045E-02  -4.94924565622676E-03   0.00000000000000E+00   4.98562865500503E-12
      6.79122413356890E-23  -1.73789783163961E-08  -1.73739926877410E-08  -1.04358942653258E-18
      3.13472595073797E-09
      0.00000000000000E+00  -2.63141601231169E-11   0.00000000000000E+00  -1.60432818104954E-12   2.99280837486502E-23
      2.63157129749240E-08   2.63141086467430E-08  -2.15809234490211E-19  -5.12485593696360E-01  -5.12485593686832E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52775345298347E-09   0.00000000000000E+00  -9.52775345298347E-09
      1.11255032840463E-18  -9.70563424335932E-03  -4.41678166918371E-03   0.00000000000000E+00   4.19479374409230E-12
      3.50640365626064E-23  -1.67905499875036E-08  -1.67863551937595E-08  -8.96741093914421E-19
      3.15472595073797E-09
      0.00000000000000E+00  -2.70254976127892E-11   0.00000000000000E+00   1.77656685766949E-12   1.67058654760937E-23
      2.70237581231735E-08   2.70255346900312E-08  -1.70299933140287E-19  -5.32978852024369E-01  -5.32978852013941E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04284126757012E-08   0.00000000000000E+00  -1.04284126757012E-08
      9.03982074890608E-19  -9.38421923345847E-03  -4.15498487317360E-03   0.00000000000000E+00   3.13558175341038E-12
      1.51463314755352E-23  -1.66002575960834E-08  -1.65971220143300E-08  -7.33682141750321E-19
      3.17472595073797E-09
      0.00000000000000E+00  -2.79311785663926E-11   0.00000000000000E+00   2.26304050691387E-12   9.79418603927954E-24
      2.79289116779320E-08   2.79311747184390E-08  -1.24111467652558E-19  -5.54324407977886E-01  -5.54324407966673E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12131456178562E-08   0.00000000000000E+00  -1.12131456178562E-08
      6.79719162533483E-19  -9.25952459024253E-03  -3.99219369719932E-03   0.00000000000000E+00   2.25996123921899E-12
      4.93652357576318E-24  -1.67202890618219E-08  -1.67180291005827E-08  -5.55607694880925E-19
      3.17722595073797E-09
      0.00000000000000E+00  -2.81674032304903E-11   0.00000000000000E+00   4.64923232018600E-12   8.98038502725211E-24
      2.81627824186445E-08   2.81674316509647E-08  -1.18396467071737E-19  -5.57013759455301E-01  -5.57013759443840E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14615058532213E-08   0.00000000000000E+00  -1.14615058532213E-08
      6.51065397900430E-19  -9.24876722680507E-03  -3.98524954582553E-03   0.00000000000000E+00   2.68864950347495E-12
      3.68094811828033E-24  -1.67086144472469E-08  -1.67059257977434E-08  -5.32668930828693E-19
      3.18060095073797E-09
      0.00000000000000E+00  -2.85272509108694E-11   0.00000000000000E+00   5.28559244701197E-12   8.09450661335991E-24
      2.85219225010517E-08   2.85272080934987E-08  -1.10585992231097E-19  -5.60705381873786E-01  -5.60705381862094E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16920521378013E-08   0.00000000000000E+00  -1.16920521378013E-08
      6.11604721935351E-19  -9.29489435882086E-03  -3.99065915026535E-03   0.00000000000000E+00   6.02843690701287E-13
      2.33508069755044E-24  -1.68357587993877E-08  -1.68351559556970E-08  -5.01018729704253E-19
      3.18515720073797E-09
      0.00000000000000E+00  -2.89828926521560E-11   0.00000000000000E+00   4.97347666459973E-12   7.22244992288088E-24
      2.89779651028396E-08   2.89829385795042E-08  -9.99691801868752E-20  -5.65748027178096E-01  -5.65748027166190E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19056550456606E-08   0.00000000000000E+00  -1.19056550456606E-08
      5.57359581133559E-19  -9.38109812056613E-03  -4.00057520716734E-03   0.00000000000000E+00  -1.58360615438980E-13
      1.02556858599938E-24  -1.70771251732286E-08  -1.70772835338440E-08  -4.57390400946684E-19
      3.18823266948797E-09
      0.00000000000000E+00  -2.92615495848436E-11   0.00000000000000E+00   4.51166626150369E-12   6.74348338103189E-24
      2.92570630721876E-08   2.92615747384491E-08  -9.28148699479576E-20  -5.69162311987639E-01  -5.69162311975620E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20191757869415E-08   0.00000000000000E+00  -1.20191757869415E-08
      5.20394981600064E-19  -9.43770925754117E-03  -4.00516319572311E-03   0.00000000000000E+00  -2.15396679575379E-13
      3.13887176829327E-25  -1.72421835548284E-08  -1.72423989515079E-08  -4.27580111652107E-19
      3.19238455230047E-09
      0.00000000000000E+00  -2.95053973621296E-11   0.00000000000000E+00   2.94703509553026E-12   6.24299858081530E-24
      2.95024638551135E-08   2.95054108902091E-08  -8.32179562803657E-20  -5.73757796725005E-01  -5.73757796712929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20767913824367E-08   0.00000000000000E+00  -1.20767913824367E-08
      4.70253559029177E-19  -9.48842653488400E-03  -3.99720779731666E-03   0.00000000000000E+00   1.84776288720594E-13
     -3.83916325970231E-25  -1.74288042840609E-08  -1.74286195077722E-08  -3.87035602748811E-19
      3.19798959409734E-09
      0.00000000000000E+00  -2.95762096545166E-11   0.00000000000000E+00   6.68479559663758E-13   5.73311100513553E-24
      2.95755239290149E-08   2.95761924085746E-08  -7.05450896972839E-20  -5.79852351272298E-01  -5.79852351260309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19889043052051E-08   0.00000000000000E+00  -1.19889043052051E-08
      4.03055249299768E-19  -9.49974170841885E-03  -3.95853101639741E-03   0.00000000000000E+00   9.29338498578751E-13
     -1.00453292810268E-24  -1.75882174418681E-08  -1.75872881033695E-08  -3.32510159602484E-19
      3.20555640052312E-09
      0.00000000000000E+00  -2.92480484084741E-11   0.00000000000000E+00  -2.10347817315235E-12   5.20729665515653E-24
      2.92501536498159E-08   2.92480501716427E-08  -5.43451541447563E-20  -5.87686332740813E-01  -5.87686332729247E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15663648429778E-08   0.00000000000000E+00  -1.15663648429778E-08
      3.15534805482993E-19  -9.43709433864691E-03  -3.86614136331088E-03   0.00000000000000E+00   1.56725531367617E-12
     -1.50322763488488E-24  -1.76832525839784E-08  -1.76816853286647E-08  -2.61189651338236E-19
      3.21577158919793E-09
      0.00000000000000E+00  -2.79402711953761E-11   0.00000000000000E+00  -6.28956650162586E-12   4.60238871071710E-24
      2.79465149659238E-08   2.79402253994222E-08  -3.54345531832861E-20  -5.96873228695940E-01  -5.96873228685708E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02324216250352E-08   0.00000000000000E+00  -1.02324216250352E-08
      2.11008687983107E-19  -9.25323072345205E-03  -3.67404765895275E-03   0.00000000000000E+00   1.74353529367442E-12
     -1.87299468039948E-24  -1.77095473096806E-08  -1.77078037743870E-08  -1.75574134799820E-19
      3.22956209390892E-09
      0.00000000000000E+00  -2.36189763097620E-11   0.00000000000000E+00  -1.54402980543013E-11   3.66461154849334E-24
      2.36344647575659E-08   2.36190244595116E-08  -2.11014367019838E-20  -6.03715073397347E-01  -6.03715073391424E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.92300269241995E-09   0.00000000000000E+00  -5.92300269241995E-09
      1.29327491450105E-19  -8.80674085741425E-03  -3.23126851702017E-03   0.00000000000000E+00   1.09948910410181E-12
     -2.16617031862074E-24  -1.76971212561959E-08  -1.76960217670918E-08  -1.08226054748121E-19
      3.24817927526875E-09
      0.00000000000000E+00  -1.09495458804069E-11   0.00000000000000E+00  -3.35510210321949E-11   1.65134701694519E-24
      1.09831476832789E-08   1.09495966622467E-08  -4.43029003870115E-20  -5.91562515001571E-01  -5.91562515008311E-01
      0.00000000000000E+00   0.00000000000000E+00   6.74009890307382E-09   0.00000000000000E+00   6.74009890307382E-09
      2.54809135111832E-19  -7.71404819568212E-03  -2.14056809650387E-03   0.00000000000000E+00  -1.15329452085144E-12
     -2.64188247014691E-24  -1.76885422707997E-08  -1.76896955653206E-08  -2.10506234724820E-19
      3.26817927526875E-09
      0.00000000000000E+00   8.05570190047217E-12   0.00000000000000E+00  -4.67282658990126E-11  -2.11797602323401E-24
     -8.00885480222527E-09  -8.05558306812428E-09  -1.45070415891929E-19  -5.42630365118752E-01  -5.42630365144488E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57359931109762E-08   0.00000000000000E+00   2.57359931109762E-08
      7.69528997331357E-19  -6.06372299645256E-03  -4.93207140758910E-04   0.00000000000000E+00  -5.22788639650055E-12
     -4.69199888123751E-24  -1.76751821564555E-08  -1.76804100428520E-08  -6.24458581439428E-19
      3.28817927526875E-09
      0.00000000000000E+00   2.24857959420955E-11   0.00000000000000E+00  -3.57512478512646E-11  -1.19355328887876E-23
     -2.24500334793670E-08  -2.24857847272183E-08  -3.37657037352864E-19  -4.58160409074146E-01  -4.58160409114258E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01123844364652E-08   0.00000000000000E+00   4.01123844364652E-08
      1.57177668606066E-18  -4.37168289828812E-03   1.18191366288794E-03   0.00000000000000E+00  -1.14384833806392E-11
     -1.83066559102830E-23  -1.76151612258663E-08  -1.76265997092470E-08  -1.23411964870780E-18
      3.30817927526875E-09
      0.00000000000000E+00   2.34849748381762E-11   0.00000000000000E+00  -2.83941399398378E-12  -3.57444512723431E-23
     -2.34821047538650E-08  -2.34849441678591E-08  -6.24715822085990E-19  -3.43445234978273E-01  -3.43445235019417E-01
      0.00000000000000E+00   0.00000000000000E+00   4.11445932024630E-08   0.00000000000000E+00   4.11445932024630E-08
      2.39466855010992E-18  -2.10262860345430E-03   3.46136970263924E-03   0.00000000000000E+00  -2.63541968851188E-11
     -6.37020819856388E-23  -1.76332948377188E-08  -1.76596490346039E-08  -1.76995272802393E-18
      3.32817927526875E-09
      0.00000000000000E+00   1.49260556225440E-11   0.00000000000000E+00   2.04803091137611E-11  -4.29366942433095E-23
     -1.49465013305717E-08  -1.49260210214580E-08  -9.06609482532204E-19  -2.19927226890766E-01  -2.19927226921954E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11879842705668E-08   0.00000000000000E+00   3.11879842705668E-08
      3.01842823552126E-18  -9.37956222870828E-03  -4.25594700312790E-03   0.00000000000000E+00  -5.65690912055789E-11
     -8.13460278011057E-23  -1.62053941579031E-08  -1.62619632491088E-08  -2.11181875298905E-18
      3.34817927526875E-09
      0.00000000000000E+00   9.96928700019099E-12   0.00000000000000E+00   1.14357447911910E-11  -4.58498171391248E-23
     -9.98071761259652E-09  -9.96928186780538E-09  -1.10463362048950E-18  -1.17634610745086E-01  -1.17634610767953E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28674701707364E-08   0.00000000000000E+00   2.28674701707364E-08
      3.47577763893598E-18  -3.88078383454625E-02  -3.47440437951815E-02   0.00000000000000E+00  -1.05746987450761E-10
     -9.44085332713928E-23  -1.27924413154802E-08  -1.28981883029310E-08  -2.37114401844649E-18
      3.35317927526875E-09
      0.00000000000000E+00   8.37431129384508E-12   0.00000000000000E+00   1.47381580502903E-11  -4.64535116605778E-23
     -8.38907005319908E-09  -8.37433189514884E-09  -1.14622699371809E-18  -9.43348416219999E-02  -9.43348416419497E-02
      0.00000000000000E+00   0.00000000000000E+00   1.99498164997284E-08   0.00000000000000E+00   1.99498164997284E-08
      3.57552672143463E-18  -4.82544843897400E-02  -4.46074026959092E-02   0.00000000000000E+00  -1.48353301748912E-10
     -9.78463677891140E-23  -1.14271313028305E-08  -1.15754846045795E-08  -2.42929972771654E-18
      3.35655427526875E-09
      0.00000000000000E+00   7.36631530299248E-12   0.00000000000000E+00   1.38025425425214E-11  -4.68156928004837E-23
     -7.38017243225200E-09  -7.36636988970952E-09  -1.17087782127949E-18  -8.01654188978925E-02  -8.01654189160702E-02
      0.00000000000000E+00   0.00000000000000E+00   1.81777752309562E-08   0.00000000000000E+00   1.81777752309562E-08
      3.63687671283911E-18  -5.54012368383652E-02  -5.19948857583074E-02   0.00000000000000E+00  -1.63629562126318E-10
     -1.00144470760032E-22  -1.06477757791206E-08  -1.08114053412471E-08  -2.46599889155961E-18
      3.36111052526875E-09
      0.00000000000000E+00   6.08921423212182E-12   0.00000000000000E+00   1.29931850089934E-11  -4.72122389532982E-23
     -6.10218777028694E-09  -6.08919458527799E-09  -1.19831048502139E-18  -6.40491824089466E-02  -6.40491824249328E-02
      0.00000000000000E+00   0.00000000000000E+00   1.59861899935710E-08   0.00000000000000E+00   1.59861899935710E-08
      3.70971379099731E-18  -6.62463837108414E-02  -6.31281342404699E-02   0.00000000000000E+00  -1.70997931839464E-10
     -1.03126242937146E-22  -9.72599747645345E-09  -9.89699540829302E-09  -2.51140330597592E-18
      3.36726146276875E-09
      0.00000000000000E+00   4.44317285188852E-12   0.00000000000000E+00   1.25409617745766E-11  -4.75774686143120E-23
     -4.45571470108606E-09  -4.44317373931153E-09  -1.22519854781952E-18  -4.78376192844307E-02  -4.78376192975935E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31627891581955E-08   0.00000000000000E+00   1.31627891581955E-08
      3.79067728443505E-18  -8.28340355901686E-02  -8.00867425629303E-02   0.00000000000000E+00  -1.74294008311808E-10
     -1.06892216717119E-22  -8.54532141057220E-09  -8.71961541888411E-09  -2.56547873661553E-18
      3.37141334558125E-09
      0.00000000000000E+00   3.30650238420817E-12   0.00000000000000E+00   1.29789933942947E-11  -4.77401775038734E-23
     -3.31951884094820E-09  -3.30653984755396E-09  -1.23862474759280E-18  -3.95621068045167E-02  -3.95621068157004E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11836850786786E-08   0.00000000000000E+00   1.11836850786786E-08
      3.83711063429363E-18  -9.48927829158619E-02  -9.24109226775608E-02   0.00000000000000E+00  -1.77272436452959E-10
     -1.09316491136266E-22  -7.69987279467169E-09  -7.87714523112476E-09  -2.59848588670083E-18
      3.37701838737812E-09
      0.00000000000000E+00   2.19260941135529E-12   0.00000000000000E+00   9.48408781343147E-12  -4.78753327737485E-23
     -2.20212789720638E-09  -2.19264380939300E-09  -1.25050478566413E-18  -3.20225490211606E-02  -3.20225490303695E-02
      0.00000000000000E+00   0.00000000000000E+00   9.20889197735516E-09   0.00000000000000E+00   9.20889197735516E-09
      3.88872685872961E-18  -1.12177247426756E-01  -1.09966629390084E-01   0.00000000000000E+00  -1.77105714306134E-10
     -1.12384697339538E-22  -6.83914245365575E-09  -7.01624816796200E-09  -2.63822207306548E-18
      3.38458519380390E-09
      0.00000000000000E+00   1.29886827358884E-12   0.00000000000000E+00   5.64914684949970E-12  -4.79739901473686E-23
     -1.30455357789379E-09  -1.29890443104433E-09  -1.25978372842828E-18  -2.58404426997218E-02  -2.58404427072421E-02
      0.00000000000000E+00   0.00000000000000E+00   7.52025154507298E-09   0.00000000000000E+00   7.52025154507298E-09
      3.94563114644436E-18  -1.36259261355738E-01  -1.34299091976877E-01   0.00000000000000E+00  -1.79738717644469E-10
     -1.16291957200581E-22  -6.04160839638401E-09  -6.22134711402859E-09  -2.68584741801608E-18
      3.39480038247871E-09
      0.00000000000000E+00   7.13449918628068E-13   0.00000000000000E+00   2.74063915521991E-12  -4.80391741000902E-23
     -7.16174708832609E-10  -7.13434069677437E-10  -1.26634350224648E-18  -2.10892017629749E-02  -2.10892017692112E-02
      0.00000000000000E+00   0.00000000000000E+00   6.23633397723900E-09   0.00000000000000E+00   6.23633397723900E-09
      4.00933647466095E-18  -1.68596383901199E-01  -1.66856272971211E-01   0.00000000000000E+00  -1.86883434313140E-10
     -1.21330682874373E-22  -5.33601647324827E-09  -5.52289990756153E-09  -2.74299297241447E-18
      3.40859088718969E-09
      0.00000000000000E+00   3.87584791015763E-13   0.00000000000000E+00   1.12845674031466E-12  -4.80780883133947E-23
     -3.88743654715994E-10  -3.87615197975727E-10  -1.27073480061913E-18  -1.74636256971453E-02  -1.74636257023603E-02
      0.00000000000000E+00   0.00000000000000E+00   5.21503702149795E-09   0.00000000000000E+00   5.21503702149795E-09
      4.08125446727389E-18  -2.09890619815889E-01  -2.08369631236717E-01   0.00000000000000E+00  -1.96029695546960E-10
     -1.27789098040653E-22  -4.63139212797510E-09  -4.82742182352219E-09  -2.81051966665475E-18
      3.42720806854953E-09
      0.00000000000000E+00   2.30346600916477E-13   0.00000000000000E+00   4.03576836736749E-13  -4.80993568840432E-23
     -2.30765061868192E-10  -2.30361485031503E-10  -1.27378045791422E-18  -1.45851570847201E-02  -1.45851570888667E-02
      0.00000000000000E+00   0.00000000000000E+00   4.14662581205283E-09   0.00000000000000E+00   4.14662581205283E-09
      4.15845295204823E-18  -2.57491528249885E-01  -2.56257616400889E-01   0.00000000000000E+00  -1.93494219336704E-10
     -1.35482165810596E-22  -3.72277010768450E-09  -3.91626432702134E-09  -2.88467249413402E-18
      3.44720806854953E-09
      0.00000000000000E+00   1.70831211206000E-13   0.00000000000000E+00   1.42622378769967E-13  -4.81099004113228E-23
     -1.70939249046259E-10  -1.70796626667537E-10  -1.27589884514402E-18  -1.25787874597483E-02  -1.25787874627815E-02
      0.00000000000000E+00   0.00000000000000E+00   3.03320180530933E-09   0.00000000000000E+00   3.03320180530933E-09
      4.21911698815442E-18  -2.95661359056599E-01  -2.94759486454958E-01   0.00000000000000E+00  -1.66093319820164E-10
     -1.41905157748412E-22  -2.69631185882153E-09  -2.86240517864184E-09  -2.94321814301040E-18
      3.46720806854953E-09
      0.00000000000000E+00   1.43920703204194E-13   0.00000000000000E+00   6.56097750239715E-14  -4.81140507854399E-23
     -1.44028275464337E-10  -1.43962665689361E-10  -1.27750665331429E-18  -1.12248174907453E-02  -1.12248174928417E-02
      0.00000000000000E+00   0.00000000000000E+00   2.09643939731896E-09   0.00000000000000E+00   2.09643939731896E-09
      4.26104577610080E-18  -3.21490681319970E-01  -3.20875504346123E-01   0.00000000000000E+00  -1.23469596883286E-10
     -1.46365426676691E-22  -1.82900713474620E-09  -1.95247673162963E-09  -2.98353912278651E-18
      3.48720806854953E-09
      0.00000000000000E+00   1.31980887367216E-13   0.00000000000000E+00   3.04159479208580E-14  -4.81155601691049E-23
     -1.32018642639191E-10  -1.31988226691319E-10  -1.27889220903486E-18  -1.02785163409649E-02  -1.02785163423275E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36259425983114E-09   0.00000000000000E+00   1.36259425983114E-09
      4.28829766129742E-18  -3.36951600064782E-01  -3.36563870227325E-01   0.00000000000000E+00  -7.71338174318853E-11
     -1.49044329378342E-22  -1.15347221570780E-09  -1.23060603313984E-09  -3.00940545226257E-18
      3.50720806854953E-09
      0.00000000000000E+00   1.24357774178991E-13   0.00000000000000E+00   2.05930726914741E-14  -4.81151134102838E-23
     -1.24332356673542E-10  -1.24311763600898E-10  -1.28013514085979E-18  -9.62048943030762E-03  -9.62048943112372E-03
      0.00000000000000E+00   0.00000000000000E+00   8.16098886011778E-10   0.00000000000000E+00   8.16098886011778E-10
      4.30461963901766E-18  -3.44467235100963E-01  -3.44249278317625E-01   0.00000000000000E+00  -3.64612018497261E-11
     -1.50292679128202E-22  -6.55325920560963E-10  -6.91787122410840E-10  -3.02448449815787E-18
      3.52720806854953E-09
      0.00000000000000E+00   9.29468740540171E-14   0.00000000000000E+00   8.37540896505669E-14  -4.81025151652310E-23
     -9.30651263179591E-11  -9.29813722283566E-11  -1.28076250499816E-18  -9.35215184609029E-03  -9.35215184678520E-03
      0.00000000000000E+00   0.00000000000000E+00   6.94911764431902E-10   0.00000000000000E+00   6.94911764431902E-10
      4.31851787430630E-18  -3.51141107012242E-01  -3.50951462275169E-01   0.00000000000000E+00  -3.10553074309462E-11
     -1.51329549948251E-22  -5.70875084772434E-10  -6.01930392203532E-10  -3.03775536930813E-18
      3.54720806854953E-09
      0.00000000000000E+00   6.96183108033053E-14   0.00000000000000E+00   6.78601489339625E-14  -4.80827460947652E-23
     -6.96847522114268E-11  -6.96168920625409E-11  -1.28093683852736E-18  -9.25897617167538E-03  -9.25897617254601E-03
      0.00000000000000E+00   0.00000000000000E+00   8.70631043411737E-10   0.00000000000000E+00   8.70631043411737E-10
      4.33593049517453E-18  -3.61238594460818E-01  -3.60986220789646E-01   0.00000000000000E+00  -5.01412131521421E-11
     -1.52956929602915E-22  -7.50872938196891E-10  -8.01014151349186E-10  -3.05499365664717E-18
      3.54970806854953E-09
      0.00000000000000E+00   5.79540291779494E-14   0.00000000000000E+00   2.39272843391715E-13  -4.80791743713799E-23
     -5.81663535313691E-11  -5.79270806880254E-11  -1.28092964289524E-18  -9.26321452680435E-03  -9.26321452769385E-03
      0.00000000000000E+00   0.00000000000000E+00   8.89505685359770E-10   0.00000000000000E+00   8.89505685359770E-10
      4.33815425938793E-18  -3.62581498970475E-01  -3.62319494315323E-01   0.00000000000000E+00  -5.38939969401264E-11
     -1.53172909694279E-22  -7.77684607731356E-10  -8.31578604671636E-10  -3.05722461649269E-18
      3.55308306854953E-09
      0.00000000000000E+00   2.30530290390892E-14   0.00000000000000E+00   5.23435112395194E-13  -4.80710870193350E-23
     -2.35728772232599E-11  -2.30494421109128E-11  -1.28080276010121E-18  -9.32555054558131E-03  -9.32555054663382E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05251085305573E-09   0.00000000000000E+00   1.05251085305573E-09
      4.34170648351699E-18  -3.65029937336214E-01  -3.64705581220597E-01   0.00000000000000E+00  -7.42711570384677E-11
     -1.53569294566225E-22  -9.55190253905546E-10  -1.02946141094417E-09  -3.06090372341578E-18
      3.55763931854953E-09
      0.00000000000000E+00   1.09295237276957E-14   0.00000000000000E+00   1.55555472360763E-13  -4.80615642231203E-23
     -1.10715492568063E-11  -1.09159937844936E-11  -1.28057736040966E-18  -9.41460903137623E-03  -9.41460903268250E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30626853726755E-09   0.00000000000000E+00   1.30626853726755E-09
      4.34765816953992E-18  -3.69301564360978E-01  -3.68893429012670E-01   0.00000000000000E+00  -9.91832412714326E-11
     -1.54282656448172E-22  -1.19616930221170E-09  -1.29535254348328E-09  -3.06708080913026E-18
      3.56379025604953E-09
      0.00000000000000E+00   1.77260342810527E-14   0.00000000000000E+00  -3.39123250744629E-14  -4.80508869055660E-23
     -1.76528975668777E-11  -1.76868098920002E-11  -1.28031709592355E-18  -9.47554845245402E-03  -9.47554845401316E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55914384577649E-09   0.00000000000000E+00   1.55914384577649E-09
      4.35724836588880E-18  -3.76186161098495E-01  -3.75700481329591E-01   0.00000000000000E+00  -1.22754818776954E-10
     -1.55468867303522E-22  -1.41870221710709E-09  -1.54145703588420E-09  -3.07693126996525E-18
      3.57209402167453E-09
      0.00000000000000E+00   3.30641053947096E-14   0.00000000000000E+00  -7.54387465749850E-14  -4.80392971823862E-23
     -3.30074892816449E-11  -3.30829280282679E-11  -1.28009809407215E-18  -9.45096449335718E-03  -9.45096449508635E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72917160573115E-09   0.00000000000000E+00   1.72917160573115E-09
      4.37160700162820E-18  -3.86373673059505E-01  -3.85839270774057E-01   0.00000000000000E+00  -1.39793023266000E-10
     -1.57272377730569E-22  -1.55629565443695E-09  -1.69608867770311E-09  -3.09150890755605E-18
      3.58330410526828E-09
      0.00000000000000E+00   5.06982949385548E-14   0.00000000000000E+00  -6.52109734732311E-14  -4.80272855475864E-23
     -5.05991794655643E-11  -5.06643904390856E-11  -1.28000760421054E-18  -9.28313941724141E-03  -9.28313941903170E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79028719069204E-09   0.00000000000000E+00   1.79028719069204E-09
      4.39167627069267E-18  -4.00404950419228E-01  -3.99856830801421E-01   0.00000000000000E+00  -1.49006218664029E-10
     -1.59822240373133E-22  -1.59061658158885E-09  -1.73962280025304E-09  -3.11166866648214E-18
      3.59843771811984E-09
      0.00000000000000E+00   7.67822003054924E-14   0.00000000000000E+00  -7.80336708278811E-14  -4.80187289830250E-23
     -7.67146543513238E-11  -7.67926880221997E-11  -1.28029444840601E-18  -8.81989167169701E-03  -8.81989167347845E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78144259904742E-09   0.00000000000000E+00   1.78144259904742E-09
      4.41863593330394E-18  -4.18794129186108E-01  -4.18257028518139E-01   0.00000000000000E+00  -1.53220296001494E-10
     -1.63279131679968E-22  -1.55142961502352E-09  -1.70464991102518E-09  -3.13834148489793E-18
      3.61843771811984E-09
      0.00000000000000E+00   1.24725153127821E-13   0.00000000000000E+00  -1.19764996548044E-13  -4.80257889319370E-23
     -1.24528446532900E-10  -1.24648211529496E-10  -1.28165064601802E-18  -7.64944499445989E-03  -7.64944499622319E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76329872809052E-09   0.00000000000000E+00   1.76329872809052E-09
      4.45390190786575E-18  -4.41695190488892E-01  -4.41178884488661E-01   0.00000000000000E+00  -1.56684997808081E-10
     -1.67815987912767E-22  -1.48196551875268E-09  -1.63865051656093E-09  -3.17225126184773E-18
      3.63843771811984E-09
      0.00000000000000E+00   1.67157421717699E-13   0.00000000000000E+00  -1.14588501115846E-13  -4.80479337599172E-23
     -1.67035027571293E-10  -1.67149616072457E-10  -1.28387325533776E-18  -5.99013400094335E-03  -5.99013400268084E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73749013030795E-09   0.00000000000000E+00   1.73749013030795E-09
      4.48865171047191E-18  -4.63227999716781E-01  -4.62733215548545E-01   0.00000000000000E+00  -1.60626541615439E-10
     -1.72326529855740E-22  -1.40971397261995E-09  -1.57034051423556E-09  -3.20477845513415E-18
      3.65843771811984E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.17461886500326E-14  -4.80695333908848E-23
     -1.71423559317048E-10  -1.71445305505746E-10  -1.28619664556667E-18  -4.29954459887171E-03  -4.29954460053794E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66622746052781E-09   0.00000000000000E+00   1.66622746052781E-09
      4.52197625968246E-18  -4.83677614754688E-01  -4.83206636452608E-01   0.00000000000000E+00  -1.62626316376378E-10
     -1.76764382730758E-22  -1.33215583864551E-09  -1.49478215502206E-09  -3.23577961411579E-18
      3.67843771811984E-09
      0.00000000000000E+00   2.22907177202667E-13   0.00000000000000E+00  -1.46921950802027E-13  -4.81125808550121E-23
     -2.22772558216041E-10  -2.22919480166891E-10  -1.28956071876927E-18  -2.00240478763287E-03  -2.00240478931374E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68087437885761E-09   0.00000000000000E+00   1.68087437885761E-09
      4.55559374725961E-18  -5.03126209376022E-01  -5.02666832841448E-01   0.00000000000000E+00  -1.69131896565530E-10
     -1.81255109698480E-22  -1.28882300212502E-09  -1.45795489869073E-09  -3.26603302849035E-18
      3.69843771811984E-09
      0.00000000000000E+00  -6.92968542230789E-13   0.00000000000000E+00   2.38997286111560E-12  -4.77733715141417E-23
      6.90619107014680E-10   6.93009079875747E-10  -1.27467091504758E-18  -1.07381847250872E-02  -1.07381847252455E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58302610160684E-10   0.00000000000000E+00   1.58302610160684E-10
      4.55875979946283E-18  -5.22859601272394E-01  -5.22591378954214E-01   0.00000000000000E+00  -8.64335587145816E-11
     -1.83501882922902E-22  -7.64878131321647E-10  -8.51311690036412E-10  -3.28408888441525E-18
      3.71843771811984E-09
      0.00000000000000E+00  -2.58607226555233E-12   0.00000000000000E+00   5.07664639601047E-12  -4.67223848288893E-23
      2.58099102895759E-09   2.58606767535355E-09  -1.22229051974037E-18  -4.12651070509301E-02  -4.12651070480561E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.87404122005943E-09   0.00000000000000E+00  -2.87404122005943E-09
      4.50127897506164E-18  -5.43844017181243E-01  -5.43934792763861E-01   0.00000000000000E+00   8.56710083917140E-11
     -1.81244001419837E-22   2.02302536314241E-10   2.87973544705774E-10  -3.27898845532128E-18
      3.72843771811984E-09
      0.00000000000000E+00  -3.78565637821984E-12   0.00000000000000E+00   6.45089230719198E-12  -4.59835635003652E-23
      3.77919667703026E-09   3.78564756933740E-09  -1.18439904892204E-18  -6.26865578394635E-02  -6.26865578347476E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.71590861613736E-09   0.00000000000000E+00  -4.71590861613736E-09
      4.45411988890027E-18  -5.54602705552822E-01  -5.54895879212668E-01   0.00000000000000E+00   1.78743019578558E-10
     -1.78859252415088E-22   7.51518027221728E-10   9.30261046800107E-10  -3.26972083997822E-18
      3.73518771811984E-09
      0.00000000000000E+00  -4.67590741597239E-12   0.00000000000000E+00   7.07147181687941E-12  -4.53866172925999E-23
      4.66883669893693E-09   4.67590817075376E-09  -1.15310124478882E-18  -7.99484697472519E-02  -7.99484697412292E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.02270985804639E-09   0.00000000000000E+00  -6.02270985804639E-09
      4.41346659735845E-18  -5.62000328437257E-01  -5.62424752610603E-01   0.00000000000000E+00   2.35561569595767E-10
     -1.76708242309124E-22   1.11124011769709E-09   1.34680168729268E-09  -3.26036535256963E-18
      3.73974396811984E-09
      0.00000000000000E+00  -5.30761551848576E-12   0.00000000000000E+00   7.41871138874265E-12  -4.49402967403519E-23
      5.30018893606030E-09   5.30760764744900E-09  -1.12932417098517E-18  -9.28038992378548E-02  -9.28038992309483E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.90647727713261E-09   0.00000000000000E+00  -6.90647727713261E-09
      4.38199896026452E-18  -5.67040000226902E-01  -5.67543853772963E-01   0.00000000000000E+00   2.68345647308513E-10
     -1.75034952477510E-22   1.33052398237475E-09   1.59886962968309E-09  -3.25267478927935E-18
      3.74281943686984E-09
      0.00000000000000E+00  -5.72091683591963E-12   0.00000000000000E+00   7.21723933285292E-12  -4.46223743050827E-23
      5.71367589930773E-09   5.72089313864054E-09  -1.11215461435470E-18  -1.01948883380019E-01  -1.01948883372564E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.45496798150069E-09   0.00000000000000E+00  -7.45496798150069E-09
      4.35907143920516E-18  -5.70449302601207E-01  -5.70995763018233E-01   0.00000000000000E+00   2.85389137164861E-10
     -1.73823045241616E-22   1.44868570569541E-09   1.73407484286010E-09  -3.24691682485046E-18
      3.74697131968234E-09
      0.00000000000000E+00  -6.15864885345071E-12   0.00000000000000E+00   5.79913769961159E-12  -4.41746400846673E-23
      6.15281746050886E-09   6.15861659820842E-09  -1.08755571850531E-18  -1.14844133931776E-01  -1.14844133923801E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97546805368123E-09   0.00000000000000E+00  -7.97546805368123E-09
      4.32595823047144E-18  -5.75030484973580E-01  -5.75603037786773E-01   0.00000000000000E+00   2.99438548011850E-10
     -1.72089520269178E-22   1.51741290746135E-09   1.81685145547303E-09  -3.23840251196614E-18
      3.75257636147921E-09
      0.00000000000000E+00  -6.65653917385271E-12   0.00000000000000E+00   4.94622186199210E-12  -4.35103328350853E-23
      6.65163371588296E-09   6.65657993774491E-09  -1.05272941820710E-18  -1.32707223436063E-01  -1.32707223427649E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.41438243116455E-09   0.00000000000000E+00  -8.41438243116455E-09
      4.27879526524988E-18  -5.81090298993475E-01  -5.81644267666241E-01   0.00000000000000E+00   3.04797437521049E-10
     -1.69675873719580E-22   1.45300505589845E-09   1.75780249341933E-09  -3.22606584704277E-18
      3.76014316790499E-09
      0.00000000000000E+00  -7.38073492673406E-12   0.00000000000000E+00   5.22383937848219E-12  -4.22710893703543E-23
      7.37547064863203E-09   7.38069448801047E-09  -1.00421799705843E-18  -1.56872067857490E-01  -1.56872067848752E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.73816496054133E-09   0.00000000000000E+00  -8.73816496054133E-09
      4.21267526247691E-18  -5.88841392031970E-01  -5.89269274313876E-01   0.00000000000000E+00   2.99744886004599E-10
     -1.66415859327877E-22   1.05772558652641E-09   1.35747047253084E-09  -3.20845726541848E-18
      3.77035835657980E-09
      0.00000000000000E+00  -8.98599724364721E-12   0.00000000000000E+00   8.16727509050755E-12  -3.83810863706839E-23
      8.97786224315792E-09   8.98602951824839E-09  -9.38124924273739E-19  -1.88574738730086E-01  -1.88574738721112E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.97337720469783E-09   0.00000000000000E+00  -8.97337720469783E-09
      4.12101052128073E-18  -5.97803989333535E-01  -5.97800316332624E-01   0.00000000000000E+00   2.87569350916870E-10
     -1.62092938978704E-22  -3.00221664467326E-10  -1.26523135506183E-11  -3.18288559700699E-18
      3.78414886129078E-09
      0.00000000000000E+00  -1.38090399286261E-11   0.00000000000000E+00   1.75535683593526E-11  -2.05760972568780E-23
      1.37915232592400E-08   1.38090768275993E-08  -8.52089015489170E-19  -2.28023223147879E-01  -2.28023223138645E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.23364161984128E-09   0.00000000000000E+00  -9.23364161984128E-09
      3.99367394302275E-18  -6.03961607623179E-01  -6.02520723003007E-01   0.00000000000000E+00   2.80788047332777E-10
     -1.56168570949869E-22  -4.85622325509063E-09  -4.57543520775801E-09  -3.14158492753358E-18
      3.80276604265062E-09
      0.00000000000000E+00  -2.76018233387664E-11   0.00000000000000E+00   3.67580448887544E-11   4.48417099334883E-23
      2.75650648966356E-08   2.76018229415244E-08  -7.52922899720507E-19  -2.71713823715779E-01  -2.71713823706048E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73064251254319E-09   0.00000000000000E+00  -9.73064251254319E-09
      3.81251680661905E-18  -5.90059791493469E-01  -5.84430680001260E-01   0.00000000000000E+00   3.02068968829966E-10
     -1.46815260521532E-22  -1.81732493978111E-08  -1.78711804289812E-08  -3.05959390689854E-18
      3.82276604265062E-09
      0.00000000000000E+00  -4.78325554482055E-11   0.00000000000000E+00   5.01720927019045E-11   1.41327689761507E-22
      4.77824348500752E-08   4.78326069427772E-08  -6.75877893268442E-19  -3.05527572094828E-01  -3.05527572084418E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04108641226634E-08   0.00000000000000E+00  -1.04108641226634E-08
      3.60429952416578E-18  -5.38961755482578E-01  -5.27173480891689E-01   0.00000000000000E+00   3.19263750947557E-10
     -1.33873752775622E-22  -3.77410065710612E-08  -3.74217428201138E-08  -2.92842163089734E-18
      3.84276604265062E-09
      0.00000000000000E+00  -6.31219488511425E-11   0.00000000000000E+00   3.80530534704883E-11   2.12902844205549E-22
      6.30838950331321E-08   6.31219480866028E-08  -6.27835217437768E-19  -3.27734720764127E-01  -3.27734720753100E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10266071195690E-08   0.00000000000000E+00  -1.10266071195690E-08
      3.38376738177440E-18  -4.52587416520154E-01  -4.36175702771566E-01   0.00000000000000E+00   2.92755761696688E-10
     -1.17914894713480E-22  -5.23880967287303E-08  -5.20953409670337E-08  -2.75593216433663E-18
      3.86276604265062E-09
      0.00000000000000E+00  -6.49878665322506E-11   0.00000000000000E+00   4.74939378523497E-12   2.22342048884250E-22
      6.49831147745593E-08   6.49878641683448E-08  -6.05254775430675E-19  -3.40067452394095E-01  -3.40067452382515E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15798166720243E-08   0.00000000000000E+00  -1.15798166720243E-08
      3.15217104833391E-18  -3.36437078460470E-01  -3.19611049001774E-01   0.00000000000000E+00   2.43496195873337E-10
     -1.01570081376933E-22  -5.36515436921937E-08  -5.34080474963204E-08  -2.54691627290324E-18
      3.88276604265062E-09
      0.00000000000000E+00  -5.64295902297789E-11   0.00000000000000E+00  -2.11250760077923E-11   1.83345421128928E-22
      5.64507947990870E-08   5.64296697230794E-08  -5.97995511380314E-19  -3.46538510668939E-01  -3.46538510657017E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19216347482183E-08   0.00000000000000E+00  -1.19216347482183E-08
      2.91373835336955E-18  -2.13585806430885E-01  -1.99563302862091E-01   0.00000000000000E+00   1.68296599768759E-10
     -8.48965504980767E-23  -4.46763315746299E-08  -4.45080349748613E-08  -2.31574284198924E-18
      3.90276604265062E-09
      0.00000000000000E+00  -4.91835915325282E-11   0.00000000000000E+00  -1.79789785148132E-11   1.43514195755538E-22
      4.92015646418103E-08   4.91835856632956E-08  -5.88926810966833E-19  -3.53773100199465E-01  -3.53773100187634E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18317227651154E-08   0.00000000000000E+00  -1.18317227651154E-08
      2.67710389806724E-18  -1.12745671977781E-01  -1.00977528358252E-01   0.00000000000000E+00   8.94954358563142E-11
     -7.30031749126846E-23  -3.74413583340364E-08  -3.73518628981801E-08  -2.08817708710041E-18
      3.90526604265062E-09
      0.00000000000000E+00  -4.75263450943556E-11   0.00000000000000E+00  -3.25795193105918E-11   1.37467434603654E-22
      4.75588947202875E-08   4.75263152009771E-08  -5.88295210004128E-19  -3.54466329366539E-01  -3.54466329354628E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19102836163664E-08   0.00000000000000E+00  -1.19102836163664E-08
      2.64732818902632E-18  -1.00583335219333E-01  -8.93620635243869E-02   0.00000000000000E+00   8.48973135323646E-11
     -7.01165255295765E-23  -3.57009288981437E-08  -3.56160315846114E-08  -2.05903297902220E-18
      3.90864104265062E-09
      0.00000000000000E+00  -4.58334628981465E-11   0.00000000000000E+00  -2.49527535414557E-11   1.29853472034255E-22
      4.58584600477740E-08   4.58335072942327E-08  -5.86764886617064E-19  -3.55676913643975E-01  -3.55676913632139E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18360252690495E-08   0.00000000000000E+00  -1.18360252690495E-08
      2.60738160374328E-18  -8.57608726421007E-02  -7.50495261054251E-02   0.00000000000000E+00   6.73933898296401E-11
     -6.35291356477348E-23  -3.40648754150127E-08  -3.39974820251832E-08  -2.02061671712622E-18
      3.91319729265062E-09
      0.00000000000000E+00  -4.36572018500141E-11   0.00000000000000E+00  -2.36702016974233E-11   1.22042375291817E-22
      4.36808392339959E-08   4.36571690322986E-08  -5.82932700385404E-19  -3.57931033408041E-01  -3.57931033396383E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16577056255055E-08   0.00000000000000E+00  -1.16577056255055E-08
      2.55426618248707E-18  -6.86694506453718E-02  -5.85875765071351E-02   0.00000000000000E+00   5.72606706818976E-11
     -5.03583540214713E-23  -3.20567240774749E-08  -3.19994634067931E-08  -1.97133348210167E-18
      3.91934823015062E-09
      0.00000000000000E+00  -4.06822589671251E-11   0.00000000000000E+00  -2.39267739943881E-11   1.16734716585206E-22
      4.07062194691099E-08   4.06822926951156E-08  -5.73854447411451E-19  -3.62300611207363E-01  -3.62300611196013E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13501990034391E-08   0.00000000000000E+00  -1.13501990034391E-08
      2.48445181780436E-18  -5.11051238809812E-02  -4.18636188472562E-02   0.00000000000000E+00   4.80069708961720E-11
     -1.71294585720320E-23  -2.93801006625730E-08  -2.93320936916768E-08  -1.91059737039291E-18
      3.92350011296312E-09
      0.00000000000000E+00  -3.84747707083422E-11   0.00000000000000E+00  -2.62599182581137E-11   1.15669853864491E-22
      3.85010247136556E-08   3.84747647953976E-08  -5.65616764936829E-19  -3.65943924327104E-01  -3.65943924315994E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11098429262984E-08   0.00000000000000E+00  -1.11098429262984E-08
      2.43832505190908E-18  -4.20075185637628E-02  -3.33857883095901E-02   0.00000000000000E+00   4.39290679116095E-11
      1.01804568244715E-23  -2.74088509370105E-08  -2.73649218690988E-08  -1.87270828697226E-18
      3.92630263386156E-09
      0.00000000000000E+00  -3.70391456210514E-11   0.00000000000000E+00  -2.53276143549433E-11   1.16150612550439E-22
      3.70644942629529E-08   3.70391666485980E-08  -5.59106022131684E-19  -3.68719546652133E-01  -3.68719546641192E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09416308782913E-08   0.00000000000000E+00  -1.09416308782913E-08
      2.40766090270968E-18  -3.70785132017824E-02  -2.88560850447787E-02   0.00000000000000E+00   3.95920902608549E-11
      2.90616526512283E-23  -2.61371278605675E-08  -2.60975357703067E-08  -1.84855488057800E-18
      3.93008603707445E-09
      0.00000000000000E+00  -3.55291262966224E-11   0.00000000000000E+00  -1.97715437819796E-11   1.18705380922561E-22
      3.55489207166010E-08   3.55291491728192E-08  -5.49036075248786E-19  -3.72909561028037E-01  -3.72909561017293E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07441632127300E-08   0.00000000000000E+00  -1.07441632127300E-08
      2.36701140109082E-18  -3.21224827062464E-02  -2.43135850173813E-02   0.00000000000000E+00   3.15964001314888E-11
      5.28197891005212E-23  -2.48165823602206E-08  -2.47849859600891E-08  -1.81797532584203E-18
      3.93519363141185E-09
      0.00000000000000E+00  -3.41113190883499E-11   0.00000000000000E+00  -1.37351307657622E-11   1.24170518885254E-22
      3.41250117465917E-08   3.41112766158260E-08  -5.34066419925551E-19  -3.79039948255149E-01  -3.79039948244597E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05519443824160E-08   0.00000000000000E+00  -1.05519443824160E-08
      2.31311634971461E-18  -2.74954601000130E-02  -2.00727149845747E-02   0.00000000000000E+00   2.37369279600629E-11
      8.14434245695273E-23  -2.35830691613703E-08  -2.35593322334101E-08  -1.77904992978906E-18
      3.94208888376734E-09
      0.00000000000000E+00  -3.29073264282964E-11   0.00000000000000E+00  -8.61386402222395E-12   1.32465802127399E-22
      3.29159277342225E-08   3.29073138702004E-08  -5.12804397892240E-19  -3.87671664563203E-01  -3.87671664552814E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03884274196061E-08   0.00000000000000E+00  -1.03884274196061E-08
      2.24148552107970E-18  -2.34270654656022E-02  -1.63321208072830E-02   0.00000000000000E+00   1.71586690398966E-11
      1.14167188014243E-22  -2.25360451196346E-08  -2.25188864505946E-08  -1.72868112318746E-18
      3.95139747444726E-09
      0.00000000000000E+00  -3.19167809375132E-11   0.00000000000000E+00  -5.22249505210964E-12   1.41498307134419E-22
      3.19220452522557E-08   3.19168227572038E-08  -4.83896151415962E-19  -3.99381446098977E-01  -3.99381446088721E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02560579301562E-08   0.00000000000000E+00  -1.02560579301562E-08
      2.14601607581837E-18  -1.99648569275204E-02  -1.31402692889328E-02   0.00000000000000E+00   1.24752779195896E-11
      1.47862221792391E-22  -2.16732401049674E-08  -2.16607648270477E-08  -1.66211992440241E-18
      3.96396407186514E-09
      0.00000000000000E+00  -3.10051300759913E-11   0.00000000000000E+00  -3.54104635250784E-12   1.45776241335194E-22
      3.10086990368229E-08   3.10051579904705E-08  -4.46050937885245E-19  -4.14778842991183E-01  -4.14778842981047E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01355692135522E-08   0.00000000000000E+00  -1.01355692135522E-08
      2.01864645791054E-18  -1.70365408575018E-02  -1.04612186568690E-02   0.00000000000000E+00   9.55721009289441E-12
      1.74084675214241E-22  -2.08791459870113E-08  -2.08695887769183E-08  -1.57259552002529E-18
      3.98092897837929E-09
      0.00000000000000E+00  -2.99400066585956E-11   0.00000000000000E+00  -3.05961747912299E-12   1.36080756698405E-22
      2.99430642161745E-08   2.99400045986955E-08  -3.98019952311408E-19  -4.34540099961798E-01  -4.34540099951802E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99601046847322E-09   0.00000000000000E+00  -9.99601046847322E-09
      1.84906507479846E-18  -1.45180962922862E-02  -8.23439114674243E-03   0.00000000000000E+00   7.90588442306136E-12
      1.77293697728936E-22  -1.99519000146456E-08  -1.99439941302224E-08  -1.45104512248705E-18
      4.00092897837929E-09
      0.00000000000000E+00  -2.87209514616401E-11   0.00000000000000E+00  -2.97413633793084E-12   1.08983133217296E-22
      2.87239442494944E-08   2.87209701131565E-08  -3.45549699985388E-19  -4.56467532158477E-01  -4.56467532148635E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84220132675501E-09   0.00000000000000E+00  -9.84220132675501E-09
      1.65222104826336E-18  -1.25449914719820E-02  -6.59689791747342E-03   0.00000000000000E+00   6.86833554004595E-12
      1.47856903255940E-22  -1.88856371219416E-08  -1.88787687864014E-08  -1.30667134827797E-18
      4.02092897837929E-09
      0.00000000000000E+00  -2.76736459232627E-11   0.00000000000000E+00  -2.55557909644264E-12   7.61416649485387E-23
      2.76761845832076E-08   2.76736290041112E-08  -2.96691883925242E-19  -4.77235643025093E-01  -4.77235643015384E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70929840325895E-09   0.00000000000000E+00  -9.70929840325895E-09
      1.45803508019818E-18  -1.12032856420374E-02  -5.54329721129238E-03   0.00000000000000E+00   5.80190278886129E-12
      1.02980627381168E-22  -1.79701325036414E-08  -1.79643306008524E-08  -1.16134319627294E-18
      4.04092897837929E-09
      0.00000000000000E+00  -2.68120504435189E-11   0.00000000000000E+00  -2.10037328587079E-12   4.71933778448245E-23
      2.68141916747271E-08   2.68120913014413E-08  -2.50992619585243E-19  -4.97001917299480E-01  -4.97001917289912E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56730043161673E-09   0.00000000000000E+00  -9.56730043161673E-09
      1.26668907156584E-18  -1.02633432925677E-02  -4.83005487938676E-03   0.00000000000000E+00   4.81895714470029E-12
      6.07550835715804E-23  -1.72496098269692E-08  -1.72447908698244E-08  -1.01569645198060E-18
      4.06092897837929E-09
      0.00000000000000E+00  -2.63422646127024E-11   0.00000000000000E+00  -1.13643377310076E-12   2.68060098963006E-23
      2.63433635365724E-08   2.63422271027993E-08  -2.07226835400697E-19  -5.16307767068461E-01  -5.16307767058830E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63097902172498E-09   0.00000000000000E+00  -9.63097902172498E-09
      1.07406949113135E-18  -9.61184981595721E-03  -4.34666048937339E-03   0.00000000000000E+00   4.02780763404526E-12
      3.03809570368119E-23  -1.67152758887084E-08  -1.67112480810744E-08  -8.66842655730649E-19
      4.08092897837929E-09
      0.00000000000000E+00  -2.71989923213742E-11   0.00000000000000E+00   2.13579155677910E-12   1.49967487391535E-23
      2.71968107634411E-08   2.71989465549979E-08  -1.61464226963527E-19  -5.37018288934357E-01  -5.37018288923758E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05984869921210E-08   0.00000000000000E+00  -1.05984869921210E-08
      8.62099751288925E-19  -9.34882341223845E-03  -4.11853697158457E-03   0.00000000000000E+00   2.92533047019009E-12
      1.25934498228027E-23  -1.66033848933470E-08  -1.66004595628768E-08  -7.00635524325397E-19
      4.10092897837929E-09
      0.00000000000000E+00  -2.81291958198120E-11   0.00000000000000E+00   2.32446650400481E-12   8.97475880802836E-24
      2.81268802786001E-08   2.81292047451041E-08  -1.15254707835959E-19  -5.58485152962759E-01  -5.58485152951414E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13447467888273E-08   0.00000000000000E+00  -1.13447467888273E-08
      6.35204815512379E-19  -9.25975097285250E-03  -3.97148990360072E-03   0.00000000000000E+00   2.07983529084077E-12
      3.75275094516985E-24  -1.67865377915677E-08  -1.67844579562769E-08  -5.19950107676420E-19
      4.10342897837929E-09
      0.00000000000000E+00  -2.83930657498092E-11   0.00000000000000E+00   5.18533094316567E-12   8.27451917678532E-24
      2.83878687275692E-08   2.83930540585123E-08  -1.09537926138945E-19  -5.61190704495354E-01  -5.61190704483768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15864277237198E-08   0.00000000000000E+00  -1.15864277237198E-08
      6.06238746203080E-19  -9.26558886715260E-03  -3.97034289152685E-03   0.00000000000000E+00   1.99888406972199E-12
      2.66561391135816E-24  -1.68086252188617E-08  -1.68066263347920E-08  -4.96700820064133E-19
      4.10680397837929E-09
      0.00000000000000E+00  -2.87822119013575E-11   0.00000000000000E+00   5.71706762235836E-12   7.52005552324233E-24
      2.87764680012159E-08   2.87821850688382E-08  -1.01732032989095E-19  -5.64900991844571E-01  -5.64900991832761E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18101519409006E-08   0.00000000000000E+00  -1.18101519409006E-08
      5.66379483402540E-19  -9.32934565048016E-03  -3.98198403740997E-03   0.00000000000000E+00   4.70984648533569E-14
      1.51061423717240E-24  -1.69720802264024E-08  -1.69720331279376E-08  -4.64647450413444E-19
      4.11136022837929E-09
      0.00000000000000E+00  -2.92088307056865E-11   0.00000000000000E+00   4.66616624553420E-12   6.77696114651359E-24
      2.92041980441992E-08   2.92088642104447E-08  -9.11631941843181E-20  -5.69945691356299E-01  -5.69945691344315E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19837670678300E-08   0.00000000000000E+00  -1.19837670678300E-08
      5.11778444699739E-19  -9.41818351477576E-03  -3.99108859998105E-03   0.00000000000000E+00  -3.11990202939877E-13
      4.04045455054475E-25  -1.72247851524120E-08  -1.72250971426149E-08  -4.20615250515421E-19
      4.11751116587929E-09
      0.00000000000000E+00  -2.94903348252276E-11   0.00000000000000E+00   2.30569051267428E-12   6.07408278519570E-24
      2.94880075430531E-08   2.94903132335658E-08  -7.70886461390378E-20  -5.76696734360750E-01  -5.76696734348733E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20165270820781E-08   0.00000000000000E+00  -1.20165270820781E-08
      4.37865537650819E-19  -9.47674718108395E-03  -3.97129758296823E-03   0.00000000000000E+00   3.71135114462802E-13
     -5.51072909156339E-25  -1.74741572866021E-08  -1.74737861514876E-08  -3.60776891511781E-19
      4.12581493150429E-09
      0.00000000000000E+00  -2.93445772272792E-11   0.00000000000000E+00  -8.25899969527405E-13   5.40822865554979E-24
      2.93454301362772E-08   2.93446042363077E-08  -5.89651825867724E-20  -5.85444583955736E-01  -5.85444583944030E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17056778286920E-08   0.00000000000000E+00  -1.17056778286920E-08
      3.40664332479602E-19  -9.44863994305621E-03  -3.89115911943510E-03   0.00000000000000E+00   1.25085417911370E-12
     -1.28262587148803E-24  -1.76401772617950E-08  -1.76389264076159E-08  -2.81699149892829E-19
      4.13702501509804E-09
      0.00000000000000E+00  -2.81468300093559E-11   0.00000000000000E+00  -5.24283993723861E-12   4.70912701220569E-24
      2.81520906759282E-08   2.81468478359910E-08  -3.76768003994512E-20  -5.95781495653796E-01  -5.95781495643347E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04487103677651E-08   0.00000000000000E+00  -1.04487103677651E-08
      2.23533415810072E-19  -9.27674994658923E-03  -3.70061252422403E-03   0.00000000000000E+00   1.65988905214215E-12
     -1.78664209158624E-24  -1.76997973572779E-08  -1.76981374682257E-08  -1.85856615410622E-19
      4.15215862794960E-09
      0.00000000000000E+00  -2.35996889149484E-11   0.00000000000000E+00  -1.48058569486023E-11   3.67949689855735E-24
      2.36144392493242E-08   2.35996333923756E-08  -2.19553435883215E-20  -6.03290204504423E-01  -6.03290204498517E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90669836930966E-09   0.00000000000000E+00  -5.90669836930966E-09
      1.34143729457984E-19  -8.80647733563588E-03  -3.23197755820356E-03   0.00000000000000E+00   1.07382345184765E-12
     -2.14905087410187E-24  -1.76940088465178E-08  -1.76929350230659E-08  -1.12188385869663E-19
      4.17215862794960E-09
      0.00000000000000E+00  -9.82757057067978E-12   0.00000000000000E+00  -3.39492418957986E-11   1.47617608594932E-24
      9.86149267491263E-09   9.82754343301684E-09  -5.10327915614471E-20  -5.88210500435688E-01  -5.88210500443547E-01
      0.00000000000000E+00   0.00000000000000E+00   7.85918706138751E-09   0.00000000000000E+00   7.85918706138751E-09
      2.91327470685735E-19  -7.62514184344879E-03  -2.05259636126461E-03   0.00000000000000E+00  -1.36422569867309E-12
     -2.71263679594655E-24  -1.76853662687057E-08  -1.76867304944043E-08  -2.40294679124287E-19
      4.19215862794960E-09
      0.00000000000000E+00   9.17235021544128E-12   0.00000000000000E+00  -4.66889409437051E-11  -2.49290559903625E-24
     -9.12556706913446E-09  -9.17225601007816E-09  -1.57415884747137E-19  -5.36906544545971E-01  -5.36906544572820E-01
      0.00000000000000E+00   0.00000000000000E+00   2.68492767744150E-08   0.00000000000000E+00   2.68492767744150E-08
      8.28313006174035E-19  -5.96215999926790E-03  -3.92721553778626E-04   0.00000000000000E+00  -5.59255930985428E-12
     -5.08006719578894E-24  -1.76714282050270E-08  -1.76770207643368E-08  -6.70897121426898E-19
      4.21215862794960E-09
      0.00000000000000E+00   2.29057100806083E-11   0.00000000000000E+00  -3.40467094303378E-11  -1.33228626331440E-23
     -2.28716558186940E-08  -2.29057025281243E-08  -3.56749905950526E-19  -4.50309578454309E-01  -4.50309578494836E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05279878927535E-08   0.00000000000000E+00   4.05279878927535E-08
      1.63887276402911E-18  -4.27129024804365E-03   1.28094616583724E-03   0.00000000000000E+00  -1.21010847768402E-11
     -2.07557437840313E-23  -1.76101842798525E-08  -1.76222853646293E-08  -1.28212285807858E-18
      4.23215862794961E-09
      0.00000000000000E+00   2.28350814776958E-11   0.00000000000000E+00  -2.18654933356613E-13  -3.69487922245297E-23
     -2.28348951445573E-08  -2.28351137994907E-08  -6.48056641742577E-19  -3.33997102727978E-01  -3.33997102768475E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04969081498699E-08   0.00000000000000E+00   4.04969081498699E-08
      2.44881092702650E-18  -1.96163025647461E-03   3.60304267100870E-03   0.00000000000000E+00  -2.80696011644496E-11
     -6.62776431133574E-23  -1.76337247492146E-08  -1.76617943503791E-08  -1.80075428528393E-18
      4.25215862794961E-09
      0.00000000000000E+00   1.44240322889677E-11   0.00000000000000E+00   2.01012825517093E-11  -4.31858286423644E-23
     -1.44441456081140E-08  -1.44240443255624E-08  -9.23809405934137E-19  -2.11587166501508E-01  -2.11587166531929E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04209541321950E-08   0.00000000000000E+00   3.04209541321950E-08
      3.05723000967040E-18  -1.10705784219695E-02  -6.03047373948503E-03   0.00000000000000E+00  -5.93219192702257E-11
     -8.22801383813028E-23  -1.59375878873622E-08  -1.59969098066325E-08  -2.13342060373627E-18
      4.27215862794961E-09
      0.00000000000000E+00   9.67786364903151E-12   0.00000000000000E+00   1.09064717803128E-11  -4.60228908280588E-23
     -9.68880653809530E-09  -9.67790006631503E-09  -1.11603239975359E-18  -1.11285464886729E-01  -1.11285464909072E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23430356542977E-08   0.00000000000000E+00   2.23430356542977E-08
      3.50409072275636E-18  -4.18844922005535E-02  -3.78941247527962E-02   0.00000000000000E+00  -1.10446787872841E-10
     -9.53920468190052E-23  -1.25546888001098E-08  -1.26651355879827E-08  -2.38805832300277E-18
      4.27465862794961E-09
      0.00000000000000E+00   8.69282884248079E-12   0.00000000000000E+00   1.82926430442846E-11  -4.63241401778653E-23
     -8.71109214798542E-09  -8.69279950494118E-09  -1.13763478504831E-18  -9.92027221773723E-02  -9.92027221978622E-02
      0.00000000000000E+00   0.00000000000000E+00   2.04898203444004E-08   0.00000000000000E+00   2.04898203444004E-08
      3.55531527361736E-18  -4.64370554717601E-02  -4.27201724666375E-02   0.00000000000000E+00  -1.47140586714299E-10
     -9.71319619478924E-23  -1.16498802527446E-08  -1.17970208394590E-08  -2.41768048856905E-18
      4.27803362794961E-09
      0.00000000000000E+00   7.68483285162818E-12   0.00000000000000E+00   1.38356536147379E-11  -4.67054364834258E-23
     -7.69866623247983E-09  -7.68483057886514E-09  -1.16336766423815E-18  -8.45021208281792E-02  -8.45021208468977E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87185197540220E-08   0.00000000000000E+00   1.87185197540220E-08
      3.61849027778718E-18  -5.33552461572914E-02  -4.98788607521256E-02   0.00000000000000E+00  -1.61526599860506E-10
     -9.94517014126435E-23  -1.08721625752965E-08  -1.10336891751571E-08  -2.45512261354903E-18
      4.28258987794961E-09
      0.00000000000000E+00   6.41443644657367E-12   0.00000000000000E+00   1.28934337610666E-11  -4.71277011259312E-23
     -6.42734368098785E-09  -6.41445024722683E-09  -1.19228719595144E-18  -6.76079772922668E-02  -6.76079773088047E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65378108141155E-08   0.00000000000000E+00   1.65378108141155E-08
      3.69384067830900E-18  -6.38977261046825E-02  -6.07081564061358E-02   0.00000000000000E+00  -1.69687758066825E-10
     -1.02465710658474E-22  -9.95367280882150E-09  -1.01233605668884E-08  -2.50155348235755E-18
      4.28874081544961E-09
      0.00000000000000E+00   4.75278146101509E-12   0.00000000000000E+00   1.26285498598404E-11  -4.75249142030345E-23
     -4.76538862137228E-09  -4.75276007151249E-09  -1.22108204134112E-18  -5.03376723514677E-02  -5.03376723651585E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36907944239240E-08   0.00000000000000E+00   1.36907944239240E-08
      3.77805189913590E-18  -8.01199434702607E-02  -7.73038337193617E-02   0.00000000000000E+00  -1.74010716238196E-10
     -1.06282415710734E-22  -8.76402363617317E-09  -8.93803435241147E-09  -2.55696985779479E-18
      4.29289269826211E-09
      0.00000000000000E+00   3.57358688000766E-12   0.00000000000000E+00   1.34424448950335E-11  -4.77045059827978E-23
     -3.58701703154442E-09  -3.57357458664943E-09  -1.23561772350276E-18  -4.14256453546674E-02  -4.14256453663132E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16458535123437E-08   0.00000000000000E+00   1.16458535123437E-08
      3.82640411817070E-18  -9.19806934966483E-02  -8.94373528782529E-02   0.00000000000000E+00  -1.77347473884837E-10
     -1.08740181544494E-22  -7.89493145180950E-09  -8.07227892569445E-09  -2.59078639466794E-18
      4.29849774005898E-09
      0.00000000000000E+00   2.38640180686317E-12   0.00000000000000E+00   1.00974494836573E-11  -4.78545344687784E-23
     -2.39648154658037E-09  -2.38638409709676E-09  -1.24858378966009E-18  -3.32508494838993E-02  -3.32508494934548E-02
      0.00000000000000E+00   0.00000000000000E+00   9.55547913961181E-09   0.00000000000000E+00   9.55547913961181E-09
      3.87996297813738E-18  -1.09097287857372E-01  -1.06838512766067E-01   0.00000000000000E+00  -1.76989751767032E-10
     -1.11843598769016E-22  -6.99210529074781E-09  -7.16909504251496E-09  -2.63137918847729E-18
      4.30606454648476E-09
      0.00000000000000E+00   1.41110254245644E-12   0.00000000000000E+00   6.16243065511517E-12  -4.79633863204078E-23
     -1.41726360683035E-09  -1.41110117617528E-09  -1.25871101327226E-18  -2.65644953436964E-02  -2.65644953514331E-02
      0.00000000000000E+00   0.00000000000000E+00   7.73670396387163E-09   0.00000000000000E+00   7.73670396387163E-09
      3.93850511940558E-18  -1.33098721632890E-01  -1.31105704840276E-01   0.00000000000000E+00  -1.79165374825255E-10
     -1.15780010897263E-22  -6.14643741287094E-09  -6.32560278769631E-09  -2.67979410613332E-18
      4.31627973515957E-09
      0.00000000000000E+00   7.65525884624735E-13   0.00000000000000E+00   3.02280968399661E-12  -4.80342925769408E-23
     -7.68545403242150E-10  -7.65522593558201E-10  -1.26580140825965E-18  -2.14914609551459E-02  -2.14914609615030E-02
      0.00000000000000E+00   0.00000000000000E+00   6.35702411162538E-09   0.00000000000000E+00   6.35702411162538E-09
      4.00344332011611E-18  -1.65482515545261E-01  -1.63720790723321E-01   0.00000000000000E+00  -1.85989521777914E-10
     -1.20841101333683E-22  -5.40551199628913E-09  -5.59150151806717E-09  -2.73764191185646E-18
      4.33007023987055E-09
      0.00000000000000E+00   4.07974322675834E-13   0.00000000000000E+00   1.23909819633480E-12  -4.80760363392668E-23
     -4.09163716783438E-10  -4.07924618587151E-10  -1.27047077592076E-18  -1.76890515545987E-02  -1.76890515598882E-02
      0.00000000000000E+00   0.00000000000000E+00   5.28954058692800E-09   0.00000000000000E+00   5.28954058692800E-09
      4.07638875449910E-18  -2.07010504551256E-01  -2.05472441410722E-01   0.00000000000000E+00  -1.95390437100904E-10
     -1.27330140229046E-22  -4.68622553123984E-09  -4.88161596834087E-09  -2.80591797857833E-18
      4.34868742123038E-09
      0.00000000000000E+00   2.37051266732627E-13   0.00000000000000E+00   4.38822169900815E-13  -4.80984660716959E-23
     -2.37440078052252E-10  -2.37001255882399E-10  -1.27363792820711E-18  -1.47192077698773E-02  -1.47192077740866E-02
      0.00000000000000E+00   0.00000000000000E+00   4.20925652095217E-09   0.00000000000000E+00   4.20925652095217E-09
      4.15475324653972E-18  -2.55174152387107E-01  -2.53922599697517E-01   0.00000000000000E+00  -1.94130647195451E-10
     -1.35097971034453E-22  -3.77812461787414E-09  -3.97225526506973E-09  -2.88111531833261E-18
      4.36868742123039E-09
      0.00000000000000E+00   1.73127329636188E-13   0.00000000000000E+00   1.53009066962534E-13  -4.81094494650147E-23
     -1.73248119189529E-10  -1.73095110122614E-10  -1.27580069662305E-18  -1.26664238158273E-02  -1.26664238189153E-02
      0.00000000000000E+00   0.00000000000000E+00   3.08801116600678E-09   0.00000000000000E+00   3.08801116600678E-09
      4.21651346985985E-18  -2.94024808333049E-01  -2.93106391028409E-01   0.00000000000000E+00  -1.68015886120753E-10
     -1.41624084304844E-22  -2.74690016976323E-09  -2.91491605588412E-09  -2.94071277323680E-18
      4.38868742123039E-09
      0.00000000000000E+00   1.45114684787892E-13   0.00000000000000E+00   6.83768739172772E-14  -4.81138677938869E-23
     -1.45146978627458E-10  -1.45078601753589E-10  -1.27742974541764E-18  -1.12840329298032E-02  -1.12840329319421E-02
      0.00000000000000E+00   0.00000000000000E+00   2.13888031530562E-09   0.00000000000000E+00   2.13888031530562E-09
      4.25929107616596E-18  -3.20430203512066E-01  -3.19802005960508E-01   0.00000000000000E+00  -1.25777613597104E-10
     -1.46180272456528E-22  -1.86802409995483E-09  -1.99380171355208E-09  -2.98186133074833E-18
      4.40868742123039E-09
      0.00000000000000E+00   1.32348266316046E-13   0.00000000000000E+00   3.23263122437410E-14  -4.81154117413624E-23
     -1.32350143633783E-10  -1.32317817321587E-10  -1.27882122554052E-18  -1.03213614441432E-02  -1.03213614455399E-02
      0.00000000000000E+00   0.00000000000000E+00   1.39668970145335E-09   0.00000000000000E+00   1.39668970145335E-09
      4.28722487019503E-18  -3.36387334326028E-01  -3.35988965464263E-01   0.00000000000000E+00  -7.95426229628953E-11
     -1.48946612996346E-22  -1.18482926116879E-09  -1.26437188413184E-09  -3.00840364465451E-18
      4.42868742123039E-09
      0.00000000000000E+00   1.25368066288274E-13   0.00000000000000E+00   1.86694498746681E-14  -4.81153594525980E-23
     -1.25379331252267E-10  -1.25360661802441E-10  -1.28008463927426E-18  -9.64474842983547E-03  -9.64474843067015E-03
      0.00000000000000E+00   0.00000000000000E+00   8.34684412850395E-10   0.00000000000000E+00   8.34684412850395E-10
      4.30391855845204E-18  -3.44150598558849E-01  -3.43927116259451E-01   0.00000000000000E+00  -3.78049776169341E-11
     -1.50241681404166E-22  -6.71518773430842E-10  -7.09323751047926E-10  -3.02383391917778E-18
      4.44868742123039E-09
      0.00000000000000E+00   9.44163898493375E-14   0.00000000000000E+00   8.26758716805287E-14  -4.81032524836279E-23
     -9.44603190343858E-11  -9.43776431627534E-11  -1.28073934692969E-18  -9.36194654820033E-03  -9.36194654889388E-03
      0.00000000000000E+00   0.00000000000000E+00   6.93546440555606E-10   0.00000000000000E+00   6.93546440555606E-10
      4.31778948726315E-18  -3.50759032376928E-01  -3.50570257803343E-01   0.00000000000000E+00  -3.07257929447927E-11
     -1.51269138260611E-22  -5.68443004447876E-10  -5.99168797392820E-10  -3.03705014033346E-18
      4.45868742123039E-09
      0.00000000000000E+00   8.18336608519063E-14   0.00000000000000E+00   7.04995366019408E-14  -4.80952730678572E-23
     -8.18678954457326E-11  -8.17973959091787E-11  -1.28094380178488E-18  -9.28694458909677E-03  -9.28694458979279E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96013415311084E-10   0.00000000000000E+00   6.96013415311084E-10
      4.32474962141626E-18  -3.54278530388299E-01  -3.54085014351251E-01   0.00000000000000E+00  -3.29699162005384E-11
     -1.51811137686642E-22  -5.81246103201209E-10  -6.14216019401899E-10  -3.04380581963138E-18
      4.46206242123039E-09
      0.00000000000000E+00   7.46697713497193E-14   0.00000000000000E+00   1.12722920438055E-13  -4.80919784628761E-23
     -7.48056004464472E-11  -7.46928775260572E-11  -1.28098917409625E-18  -9.27395454241301E-03  -9.27395454312338E-03
      0.00000000000000E+00   0.00000000000000E+00   7.10360012136285E-10   0.00000000000000E+00   7.10360012136285E-10
      4.32714708645722E-18  -3.55542031635775E-01  -3.55341756437547E-01   0.00000000000000E+00  -3.53510632726974E-11
     -1.52005627416775E-22  -6.00316071337606E-10  -6.35667134610455E-10  -3.04615791236097E-18
      4.46661867123039E-09
      0.00000000000000E+00   5.39128607408182E-14   0.00000000000000E+00   2.37067595253375E-13  -4.80851624369205E-23
     -5.41048127011177E-11  -5.38677451059124E-11  -1.28095630689390E-18  -9.29909029668114E-03  -9.29909029751261E-03
      0.00000000000000E+00   0.00000000000000E+00   8.31471309754904E-10   0.00000000000000E+00   8.31471309754904E-10
      4.33093547761229E-18  -3.57836683075203E-01  -3.57591684976384E-01   0.00000000000000E+00  -4.92307642744358E-11
     -1.52366613444727E-22  -7.28372800374359E-10  -7.77603564648947E-10  -3.04997917071839E-18
      4.47276960873039E-09
      0.00000000000000E+00   3.51765343504827E-14   0.00000000000000E+00   1.66331035100049E-13  -4.80746287775396E-23
     -3.53756408864846E-11  -3.52093098514326E-11  -1.28079892103904E-18  -9.36623320978107E-03  -9.36623321085115E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07007515969952E-09   0.00000000000000E+00   1.07007515969952E-09
      4.33751744303991E-18  -3.62238802354993E-01  -3.61912743862947E-01   0.00000000000000E+00  -7.30716488337120E-11
     -1.53085666162814E-22  -9.61794201014107E-10  -1.03486584984797E-09  -3.05671852200087E-18
      4.47692149154289E-09
      0.00000000000000E+00   2.23182711414290E-14   0.00000000000000E+00   1.71073573040124E-13  -4.80665745029975E-23
     -2.25111673976537E-11  -2.23400938246617E-11  -1.28064017823087E-18  -9.42520739191639E-03  -9.42520739317445E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25806702068504E-09   0.00000000000000E+00   1.25806702068504E-09
      4.34274078988006E-18  -3.65895557951061E-01  -3.65506210222712E-01   0.00000000000000E+00  -9.23403384240469E-11
     -1.53695002981525E-22  -1.14338658843632E-09  -1.23572692686052E-09  -3.06210061164919E-18
      4.47972401244132E-09
      0.00000000000000E+00   1.64402079601473E-14   0.00000000000000E+00   1.24543623428474E-13  -4.80610371738112E-23
     -1.65265711244446E-11  -1.64020275010642E-11  -1.28051684332736E-18  -9.46630177600330E-03  -9.46630177739421E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39090652756200E-09   0.00000000000000E+00   1.39090652756200E-09
      4.34663883449133E-18  -3.68676971543076E-01  -3.68243896378295E-01   0.00000000000000E+00  -1.05925878864137E-10
     -1.54164650878449E-22  -1.26857862119653E-09  -1.37450450006083E-09  -3.06612199116397E-18
      4.48350741565421E-09
      0.00000000000000E+00   1.81852579670903E-14   0.00000000000000E+00  -2.92848406501711E-15  -4.80543450382021E-23
     -1.81956549049134E-11  -1.81985833890264E-11  -1.28035803292550E-18  -9.50440120511619E-03  -9.50440120666294E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54675843350685E-09   0.00000000000000E+00   1.54675843350685E-09
      4.35249084531822E-18  -3.72870988625413E-01  -3.72389372465942E-01   0.00000000000000E+00  -1.20813504147387E-10
     -1.54885051075083E-22  -1.40774634597050E-09  -1.52855985011804E-09  -3.07213281239272E-18
      4.48861500999162E-09
      0.00000000000000E+00   2.75534211622580E-14   0.00000000000000E+00  -7.26679280525541E-14  -4.80466414412516E-23
     -2.74784812802356E-11  -2.75511492083362E-11  -1.28019310586092E-18  -9.51189111561091E-03  -9.51189111729686E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68594995435879E-09   0.00000000000000E+00   1.68594995435879E-09
      4.36110199375825E-18  -3.79003344448607E-01  -3.78480817643715E-01   0.00000000000000E+00  -1.34190845773785E-10
     -1.55958442098221E-22  -1.52420795937619E-09  -1.65839880515013E-09  -3.08090888789733E-18
      4.49551026234711E-09
      0.00000000000000E+00   3.96769264736516E-14   0.00000000000000E+00  -7.22202475162152E-14  -4.80378163714760E-23
     -3.96033767621192E-11  -3.96755970096835E-11  -1.28005718026503E-18  -9.45855489959232E-03  -9.45855490136703E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77471468082747E-09   0.00000000000000E+00   1.77471468082747E-09
      4.37333909934156E-18  -3.87635564951776E-01  -3.87088889643535E-01   0.00000000000000E+00  -1.44072645055397E-10
     -1.57498011977939E-22  -1.59096643876237E-09  -1.73503908381792E-09  -3.09328191907652E-18
      4.50481885302702E-09
      0.00000000000000E+00   5.29944133687429E-14   0.00000000000000E+00  -5.86180893719610E-14  -4.80281391241315E-23
     -5.28905544753463E-11  -5.29491725647663E-11  -1.28000280884199E-18  -9.30505968668149E-03  -9.30505968848456E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80306980569466E-09   0.00000000000000E+00   1.80306980569466E-09
      4.39012313813008E-18  -3.99345379110203E-01  -3.98793951506084E-01   0.00000000000000E+00  -1.49985789222213E-10
     -1.59629299440205E-22  -1.60013484390756E-09  -1.75012063312993E-09  -3.11012032928809E-18
      4.51738545044491E-09
      0.00000000000000E+00   7.32002555543988E-14   0.00000000000000E+00  -7.17571678989733E-14  -4.80200807284802E-23
     -7.31578870672525E-11  -7.32296442351995E-11  -1.28019378090246E-18  -8.94606733642899E-03  -8.94606733821881E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78981908270741E-09   0.00000000000000E+00   1.78981908270741E-09
      4.41261507399332E-18  -4.14743173425660E-01  -4.14202310593539E-01   0.00000000000000E+00  -1.53158903774413E-10
     -1.62509498934838E-22  -1.56343053469758E-09  -1.71658943847216E-09  -3.13242129309086E-18
      4.53435035695906E-09
      0.00000000000000E+00   1.12969026765258E-13   0.00000000000000E+00  -1.14938960240651E-13  -4.80223589044601E-23
     -1.12812539275938E-10  -1.12927478236227E-10  -1.28114016902102E-18  -8.06840451338273E-03  -8.06840451515418E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77144532967148E-09   0.00000000000000E+00   1.77144532967148E-09
      4.44266747840611E-18  -4.34505544447052E-01  -4.33982978526615E-01   0.00000000000000E+00  -1.55956757558127E-10
     -1.66370595428689E-22  -1.50256109387689E-09  -1.65851785143518E-09  -3.16152730938509E-18
      4.55435035695906E-09
      0.00000000000000E+00   1.58891395369021E-13   0.00000000000000E+00  -1.21555898571277E-13  -4.80416809993555E-23
     -1.58782383072956E-10  -1.58903938971575E-10  -1.28319265511020E-18  -6.50150856119434E-03  -6.50150856294637E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75202736515599E-09   0.00000000000000E+00   1.75202736515599E-09
      4.47770802570924E-18  -4.56434284525057E-01  -4.55932322304339E-01   0.00000000000000E+00  -1.59588250959984E-10
     -1.70895238539897E-22  -1.43353517522430E-09  -1.59312342618445E-09  -3.19451537059903E-18
      4.57435035695906E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -4.34157341046935E-14  -4.80639116712843E-23
     -1.71962392372781E-10  -1.72005808106933E-10  -1.28552240894894E-18  -4.79830560989324E-03  -4.79830561158369E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69044812962282E-09   0.00000000000000E+00   1.69044812962282E-09
      4.51151698830169E-18  -4.77203513611873E-01  -4.76725080797720E-01   0.00000000000000E+00  -1.62050585137279E-10
     -1.75357451272835E-22  -1.35639173637847E-09  -1.51844232151592E-09  -3.22599457935275E-18
      4.59435035695906E-09
      0.00000000000000E+00   1.96180358675277E-13   0.00000000000000E+00  -7.50541378834774E-14  -4.80957145108624E-23
     -1.96116115877292E-10  -1.96191170015223E-10  -1.28834872723157E-18  -2.81970897330486E-03  -2.81970897496362E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65875703735726E-09   0.00000000000000E+00   1.65875703735726E-09
      4.54469212904884E-18  -4.96971433259571E-01  -4.96510604625750E-01   0.00000000000000E+00  -1.66073634329532E-10
     -1.79805597646566E-22  -1.29649223301232E-09  -1.46256586734203E-09  -3.25634340181727E-18
      4.61435035695906E-09
      0.00000000000000E+00  -1.21326897851143E-13   0.00000000000000E+00   8.20538236576572E-13  -4.79947594360692E-23
      1.20472496514883E-10   1.21293034751411E-10  -1.28485395056631E-18  -4.68812849444250E-03  -4.68812849553119E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08869008756877E-09   0.00000000000000E+00   1.08869008756877E-09
      4.56646593080021E-18  -5.16270293971928E-01  -5.15889052726240E-01   0.00000000000000E+00  -1.38992109891119E-10
     -1.83437690368963E-22  -1.07099101242892E-09  -1.20998312232022E-09  -3.28161198023390E-18
      4.63435035695906E-09
      0.00000000000000E+00  -2.02894208965147E-12   0.00000000000000E+00   5.04030786659506E-12  -4.71298404673070E-23
      2.02392438564588E-09   2.02896469351243E-09  -1.24342313550002E-18  -2.90840684257054E-02  -2.90840684237124E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.99295842585801E-09   0.00000000000000E+00  -1.99295842585801E-09
      4.52660676228305E-18  -5.36973676777485E-01  -5.36962363279418E-01   0.00000000000000E+00   3.69425016172824E-11
     -1.82466349299371E-22  -7.29487692715627E-11  -3.60062676544627E-11  -3.28318362678304E-18
      4.64435035695906E-09
      0.00000000000000E+00  -3.19729899166842E-12   0.00000000000000E+00   6.23365703532907E-12  -4.64867932444831E-23
      3.19101789579149E-09   3.19725155282677E-09  -1.21118980162083E-18  -4.76227363873961E-02  -4.76227363835662E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.82992918089398E-09   0.00000000000000E+00  -3.82992918089398E-09
      4.48830747047411E-18  -5.47621916865714E-01  -5.47821311733239E-01   0.00000000000000E+00   1.36507182309591E-10
     -1.80664642795965E-22   4.96170445758037E-10   6.32677628067448E-10  -3.27711766885328E-18
      4.65110035695906E-09
      0.00000000000000E+00  -4.00029752907383E-12   0.00000000000000E+00   6.40412131097479E-12  -4.59637235917213E-23
      3.99387513737018E-09   4.00027925868111E-09  -1.18416688733097E-18  -6.28410047357641E-02  -6.28410047307141E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.05008306305940E-09   0.00000000000000E+00  -5.05008306305940E-09
      4.45421940979846E-18  -5.54940823811981E-01  -5.55271658245901E-01   0.00000000000000E+00   1.95043885063701E-10
     -1.78905954509687E-22   8.54759919314719E-10   1.04980380437824E-09  -3.27005252246749E-18
      4.66021285695906E-09
      0.00000000000000E+00  -4.98845505668961E-12   0.00000000000000E+00   5.93960213777544E-12  -4.51288502245465E-23
      4.98254644201873E-09   4.98848604415647E-09  -1.13930795370935E-18  -8.74375418242348E-02  -8.74375418177633E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.47151307960684E-09   0.00000000000000E+00  -6.47151307960684E-09
      4.39524774686054E-18  -5.64987478854273E-01  -5.65454829784450E-01   0.00000000000000E+00   2.55205324107867E-10
     -1.75746586132270E-22   1.22782171134258E-09   1.48302703545027E-09  -3.25593979315120E-18
      4.66328832570906E-09
      0.00000000000000E+00  -5.47183390861282E-12   0.00000000000000E+00   8.29588928972031E-12  -4.48162943834982E-23
      5.46354902412149E-09   5.47184491341116E-09  -1.12280650329494E-18  -9.62976216732434E-02  -9.62976216661186E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.12479020422105E-09   0.00000000000000E+00  -7.12479020422105E-09
      4.37333567723715E-18  -5.68390352386320E-01  -5.68911246153454E-01   0.00000000000000E+00   2.74685570640551E-10
     -1.74585513024169E-22   1.37825972016930E-09   1.65294529080968E-09  -3.25052917394221E-18
      4.66744020852156E-09
      0.00000000000000E+00  -5.95567198422207E-12   0.00000000000000E+00   6.35756116068099E-12  -4.43788279831686E-23
      5.94933554401824E-09   5.95569310517888E-09  -1.09884978851580E-18  -1.08958339271327E-01  -1.08958339263585E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.74138756808191E-09   0.00000000000000E+00  -7.74138756808191E-09
      4.34119434324833E-18  -5.72985371399047E-01  -5.73548102102018E-01   0.00000000000000E+00   2.93981201425349E-10
     -1.72891639870927E-22   1.49171326147839E-09   1.78569446290356E-09  -3.24234455473253E-18
      4.67304525031843E-09
      0.00000000000000E+00  -6.47817669419569E-12   0.00000000000000E+00   5.17555552971904E-12  -4.37431552391417E-23
      6.47293668179875E-09   6.47811223732843E-09  -1.06455826669917E-18  -1.26693463042171E-01  -1.26693463033901E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.26970569253951E-09   0.00000000000000E+00  -8.26970569253951E-09
      4.29484229719380E-18  -5.79096254719538E-01  -5.79660862374655E-01   0.00000000000000E+00   3.03997457984301E-10
     -1.70495629242300E-22   1.48759599722696E-09   1.79159345521109E-09  -3.23028403049463E-18
      4.68061205674421E-09
      0.00000000000000E+00  -7.16848173904746E-12   0.00000000000000E+00   5.02155248925495E-12  -4.26429108715912E-23
      7.16345132058392E-09   7.16847287307313E-09  -1.01639282627850E-18  -1.50883788208934E-01  -1.50883788200275E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.65940386841812E-09   0.00000000000000E+00  -8.65940386841812E-09
      4.22931826435882E-18  -5.86979597671897E-01  -5.87449515307772E-01   0.00000000000000E+00   3.01834940874939E-10
     -1.67228111324188E-22   1.18909605447005E-09   1.49093099534483E-09  -3.21292543808032E-18
      4.69082724541902E-09
      0.00000000000000E+00  -8.59253438945016E-12   0.00000000000000E+00   7.31046381201997E-12  -3.94440796879735E-23
      8.58519771641989E-09   8.59250818023187E-09  -9.50330567093269E-19  -1.82819060106006E-01  -1.82819060097078E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.92726652916093E-09   0.00000000000000E+00  -8.92726652916093E-09
      4.13812455241317E-18  -5.96307665532640E-01  -5.96413419651216E-01   0.00000000000000E+00   2.90165516445011E-10
     -1.62888077241729E-22   4.45928324841940E-11   3.34758348929042E-10  -3.18779398531990E-18
      4.70461775013001E-09
      0.00000000000000E+00  -1.28800304117719E-11   0.00000000000000E+00   1.56547783318976E-11  -2.44419975622017E-23
      1.28643250272813E-08   1.28799798056131E-08  -8.63575816841138E-19  -2.22860175519474E-01  -2.22860175510287E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.18707426894563E-09   0.00000000000000E+00  -9.18707426894563E-09
      4.01143016142709E-18  -6.03593053810620E-01  -6.02430157622870E-01   0.00000000000000E+00   2.81229317000593E-10
     -1.56995332933702E-22  -3.97413485366805E-09  -3.69290553666761E-09  -3.14785434458595E-18
      4.72323493148984E-09
      0.00000000000000E+00  -2.57868794868085E-11   0.00000000000000E+00   3.44129076759883E-11   3.61667420558105E-23
      2.57524359843390E-08   2.57868488920150E-08  -7.62076552445196E-19  -2.67726500809351E-01  -2.67726500799686E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66496435713025E-09   0.00000000000000E+00  -9.66496435713025E-09
      3.83149576715409E-18  -5.92614154050122E-01  -5.87536097237042E-01   0.00000000000000E+00   2.99448113435294E-10
     -1.47836175337200E-22  -1.64213326483198E-08  -1.61218845348847E-08  -3.06941921470889E-18
      4.74323493148984E-09
      0.00000000000000E+00  -4.58861817773036E-11   0.00000000000000E+00   4.98349873109734E-11   1.32036550226056E-22
      4.58363641699161E-08   4.58861991572272E-08  -6.82034361119192E-19  -3.02790264281329E-01  -3.02790264270984E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452635369360E-08   0.00000000000000E+00  -1.03452635369360E-08
      3.62459049641537E-18  -5.45170691185097E-01  -5.33974973827653E-01   0.00000000000000E+00   3.18965434293273E-10
     -1.35226924129033E-22  -3.58599010545844E-08  -3.55409356202913E-08  -2.94255613529618E-18
      4.76323493148984E-09
      0.00000000000000E+00  -6.20949409996879E-11   0.00000000000000E+00   4.03236671958120E-11   2.08118331739370E-22
      6.20546663785382E-08   6.20949900457343E-08  -6.31357126737947E-19  -3.26029363028552E-01  -3.26029363017581E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09712564343781E-08   0.00000000000000E+00  -1.09712564343781E-08
      3.40516536772781E-18  -4.62020626475585E-01  -4.45915086961523E-01   0.00000000000000E+00   2.96423033897943E-10
     -1.19477120133599E-22  -5.14201566452539E-08  -5.11237336113560E-08  -2.77380824098986E-18
      4.78323493148984E-09
      0.00000000000000E+00  -6.54321195261234E-11   0.00000000000000E+00   8.40655719935408E-12   2.24153527500425E-22
      6.54237427996346E-08   6.54321493568341E-08  -6.06479460123177E-19  -3.39249145691340E-01  -3.39249145679811E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15284373199313E-08   0.00000000000000E+00  -1.15284373199313E-08
      3.17459662132918E-18  -3.48328701499274E-01  -3.31346574700383E-01   0.00000000000000E+00   2.48488764645907E-10
     -1.03115650874336E-22  -5.41522008015487E-08  -5.39037120369029E-08  -2.56811716120600E-18
      4.80323493148984E-09
      0.00000000000000E+00  -5.72437938251236E-11   0.00000000000000E+00  -2.02695423342988E-11   1.87362372906725E-22
      5.72640408055107E-08   5.72437712631766E-08  -5.98668927436845E-19  -3.45925769362742E-01  -3.45925769350831E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19110116200953E-08   0.00000000000000E+00  -1.19110116200953E-08
      2.93637638892728E-18  -2.24401481134443E-01  -2.10119153365391E-01   0.00000000000000E+00   1.76923969244692E-10
     -8.64821529348073E-23  -4.55096836123259E-08  -4.53327596430813E-08  -2.33770746149043E-18
      4.82323493148984E-09
      0.00000000000000E+00  -4.97802149454283E-11   0.00000000000000E+00  -1.85181564483965E-11   1.46860845936429E-22
      4.97986700500069E-08   4.97801518935587E-08  -5.90094657811076E-19  -3.52970472898053E-01  -3.52970472886203E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18501162264993E-08   0.00000000000000E+00  -1.18501162264993E-08
      2.69937406439729E-18  -1.21109958213321E-01  -1.09159669904482E-01   0.00000000000000E+00   9.51702601865876E-11
     -7.46419771812531E-23  -3.80252059272458E-08  -3.79300356670593E-08  -2.10927940658621E-18
      4.84323493148984E-09
      0.00000000000000E+00  -4.26812596724470E-11   0.00000000000000E+00  -1.75736982641808E-11   1.22868568176242E-22
      4.26988382434650E-08   4.26812645452009E-08  -5.67406103161975E-19  -3.64948138229693E-01  -3.64948138218257E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14359068467736E-08   0.00000000000000E+00  -1.14359068467736E-08
      2.47065592746182E-18  -5.28280770951091E-02  -4.29837728190250E-02   0.00000000000000E+00   5.17002361760164E-11
     -1.57786943780246E-23  -3.12970579346033E-08  -3.12453576984273E-08  -1.90324982429984E-18
      4.84573493148984E-09
      0.00000000000000E+00  -4.05116114453936E-11   0.00000000000000E+00  -4.24681265387952E-11   1.19887732946940E-22
      4.05540047272452E-08   4.05115366007065E-08  -5.63764892063967E-19  -3.66645468459529E-01  -3.66645468448188E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13402824425939E-08   0.00000000000000E+00  -1.13402824425939E-08
      2.44230522135533E-18  -4.57386927077279E-02  -3.65478596243598E-02   0.00000000000000E+00   6.41649494915875E-11
      1.51442182142158E-24  -2.92354191076039E-08  -2.91712541581123E-08  -1.87854032929136E-18
      4.84910993148984E-09
      0.00000000000000E+00  -3.81866537677222E-11   0.00000000000000E+00  -3.41929113039625E-11   1.18179985228405E-22
      3.82208272046225E-08   3.81866342933186E-08  -5.56966296557237E-19  -3.69601143955974E-01  -3.69601143944882E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10924164143684E-08   0.00000000000000E+00  -1.10924164143684E-08
      2.40486831595684E-18  -3.85861313840197E-02  -3.00496872720215E-02   0.00000000000000E+00   4.93428123557605E-11
      2.55338009366053E-23  -2.71435606913060E-08  -2.70942178789502E-08  -1.84790201939961E-18
      4.85366618148984E-09
      0.00000000000000E+00  -3.59371924640355E-11   0.00000000000000E+00  -2.44922256679491E-11   1.19670134018906E-22
      3.59617254955342E-08   3.59372332698663E-08  -5.45391255350642E-19  -3.74433226460581E-01  -3.74433226449779E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08020957849816E-08   0.00000000000000E+00  -1.08020957849816E-08
      2.35565126703652E-18  -3.20130275769295E-02  -2.40938098821212E-02   0.00000000000000E+00   3.60918679123019E-11
      5.48414920653192E-23  -2.51712293527972E-08  -2.51351374848849E-08  -1.81026001168588E-18
      4.85981711898984E-09
      0.00000000000000E+00  -3.40413333985977E-11   0.00000000000000E+00  -1.52682389820761E-11   1.25332381479732E-22
      3.40565967378151E-08   3.40413284988331E-08  -5.27474035588710E-19  -3.81758345685596E-01  -3.81758345675053E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05431247478464E-08   0.00000000000000E+00  -1.05431247478464E-08
      2.29080116565781E-18  -2.64844784964114E-02  -1.90809913627895E-02   0.00000000000000E+00   2.47119227048902E-11
      8.85801394360344E-23  -2.35229156736919E-08  -2.34982037509869E-08  -1.76332713006910E-18
      4.86812088461484E-09
      0.00000000000000E+00  -3.26192094876764E-11   0.00000000000000E+00  -8.45318427402846E-12   1.34230493422995E-22
      3.26276566441392E-08   3.26192034598653E-08  -5.01872309762544E-19  -3.92135845726669E-01  -3.92135845716321E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03479450493218E-08   0.00000000000000E+00  -1.03479450493218E-08
      2.20487425526786E-18  -2.20786812182330E-02  -1.50617529705819E-02   0.00000000000000E+00   1.64125143425256E-11
      1.24922694363065E-22  -2.22876709248861E-08  -2.22712584105434E-08  -1.70300194550532E-18
      4.87933096820859E-09
      0.00000000000000E+00  -3.15421462544437E-11   0.00000000000000E+00  -4.71197039183059E-12   1.42273018927299E-22
      3.15468942175065E-08   3.15421822471148E-08  -4.67427261121953E-19  -4.06099881093594E-01  -4.06099881083391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02032153983058E-08   0.00000000000000E+00  -1.02032153983058E-08
      2.09049535772782E-18  -1.85855261289618E-02  -1.18623228157607E-02   0.00000000000000E+00   1.13884512212289E-11
      1.58474970406638E-22  -2.13503553000303E-08  -2.13389668488089E-08  -1.62306809660587E-18
      4.89446458106015E-09
      0.00000000000000E+00  -3.05206490872216E-11   0.00000000000000E+00  -3.29245046787008E-12   1.41153082552506E-22
      3.05239843586848E-08   3.05206919082171E-08  -4.23041952736955E-19  -4.24235950451273E-01  -4.24235950441204E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00683809697633E-08   0.00000000000000E+00  -1.00683809697633E-08
      1.93812437808938E-18  -1.57342250232166E-02  -9.29036957953267E-03   0.00000000000000E+00   8.72944638038509E-12
      1.76632615305726E-22  -2.04610403848343E-08  -2.04523109384538E-08  -1.51508242535243E-18
      4.91446458106015E-09
      0.00000000000000E+00  -2.92810206691316E-11   0.00000000000000E+00  -3.02270697108359E-12   1.21065742676475E-22
      2.92840515963180E-08   2.92810288893470E-08  -3.68621473421452E-19  -4.46797150064803E-01  -4.46797150054894E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90824197898560E-09   0.00000000000000E+00  -9.90824197898560E-09
      1.73995953850967E-18  -1.33520714705180E-02  -7.24833144520378E-03   0.00000000000000E+00   7.33378389354347E-12
      1.61954344828598E-22  -1.93801206942551E-08  -1.93727869103614E-08  -1.37133806508822E-18
      4.93446458106015E-09
      0.00000000000000E+00  -2.81242362040028E-11   0.00000000000000E+00  -2.82342966539654E-12   8.98891141350893E-23
      2.81270825838655E-08   2.81242591542002E-08  -3.18200693043556E-19  -4.68058311903264E-01  -4.68058311893498E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76614027683265E-09   0.00000000000000E+00  -9.76614027683265E-09
      1.54463673297302E-18  -1.17488805321830E-02  -5.96482415062778E-03   0.00000000000000E+00   6.33431498577614E-12
      1.22142428240730E-22  -1.83644531923535E-08  -1.83581188773676E-08  -1.22643603992946E-18
      4.95446458106015E-09
      0.00000000000000E+00  -2.71951348424115E-11   0.00000000000000E+00  -2.26600834149726E-12   5.87146412514433E-23
      2.71973908879435E-08   2.71951248796020E-08  -2.71072405912296E-19  -4.88278010224193E-01  -4.88278010214555E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63761056098692E-09   0.00000000000000E+00  -9.63761056098692E-09
      1.35188452175328E-18  -1.06529766076322E-02  -5.12116067685545E-03   0.00000000000000E+00   5.23109445024843E-12
      7.76529967986898E-23  -1.75627454130654E-08  -1.75575143186151E-08  -1.08081211584098E-18
      4.97446458106015E-09
      0.00000000000000E+00  -2.64006778655664E-11   0.00000000000000E+00  -1.93601640125779E-12   3.44985832820222E-23
      2.64026588884942E-08   2.64007228720930E-08  -2.27002228019712E-19  -5.07531260440591E-01  -5.07531260431107E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48434940965097E-09   0.00000000000000E+00  -9.48434940965097E-09
      1.16219753356026E-18  -9.86027268127552E-03  -4.53045629502973E-03   0.00000000000000E+00   4.40083770073516E-12
      4.18668348466367E-23  -1.69207743001427E-08  -1.69163734624420E-08  -9.35195305540547E-19
      4.99446458106015E-09
      0.00000000000000E+00  -2.67688834170313E-11   0.00000000000000E+00   9.29618347334655E-13   1.92837662713873E-23
      2.67679568197231E-08   2.67688864380705E-08  -1.82050079269000E-19  -5.27636725888360E-01  -5.27636725878196E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01630762819530E-08   0.00000000000000E+00  -1.01630762819530E-08
      9.58936007921199E-19  -9.43692454124902E-03  -4.20495363011181E-03   0.00000000000000E+00   3.44657003504233E-12
      1.90189445897969E-23  -1.66092567261525E-08  -1.66058101561174E-08  -7.76885928652198E-19
      5.01446458106015E-09
      0.00000000000000E+00  -2.76777789364370E-11   0.00000000000000E+00   2.26917877222417E-12   1.10776488652749E-23
      2.76755275215828E-08   2.76777967003550E-08  -1.35960003106402E-19  -5.48792882940803E-01  -5.48792882929782E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10217822549562E-08   0.00000000000000E+00  -1.10217822549562E-08
      7.38500362822073E-19  -9.27292653302933E-03  -4.02513516622752E-03   0.00000000000000E+00   2.46446496868465E-12
      6.80309840052228E-24  -1.66584789103676E-08  -1.66560144453989E-08  -6.02540359715673E-19
      5.02446458106015E-09
      0.00000000000000E+00  -2.83752478707910E-11   0.00000000000000E+00   3.46712232998798E-12   8.37046337478470E-24
      2.83717662349279E-08   2.83752333572579E-08  -1.12827814162651E-19  -5.59641291372126E-01  -5.59641291360571E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15543025416069E-08   0.00000000000000E+00  -1.15543025416069E-08
      6.22957337406005E-19  -9.28589404728962E-03  -3.98614124130638E-03   0.00000000000000E+00   1.68326224043620E-12
      2.77746081228918E-24  -1.68226140778913E-08  -1.68209308156509E-08  -5.10129523243355E-19
      5.02783958106015E-09
      0.00000000000000E+00  -2.87184716537355E-11   0.00000000000000E+00   5.03001362895646E-12   7.61550483120610E-24
      2.87134591777758E-08   2.87184891914048E-08  -1.05016948583340E-19  -5.63343909381169E-01  -5.63343909369395E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17734514808441E-08   0.00000000000000E+00  -1.17734514808441E-08
      5.83221938658156E-19  -9.32877279936909E-03  -3.98991699512063E-03   0.00000000000000E+00   6.51183852418766E-13
      1.62985673968349E-24  -1.69456888944127E-08  -1.69450377105602E-08  -4.78204990074815E-19
      5.03239583106015E-09
      0.00000000000000E+00  -2.91413248238390E-11   0.00000000000000E+00   4.61732443062647E-12   6.86334490946854E-24
      2.91366835281426E-08   2.91413008525732E-08  -9.44251399013667E-20  -5.68389372024730E-01  -5.68389372012768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19617158346823E-08   0.00000000000000E+00  -1.19617158346823E-08
      5.28721370886385E-19  -9.40949923910713E-03  -3.99674403115108E-03   0.00000000000000E+00  -9.39581179122485E-14
      5.11012671862929E-25  -1.71794910597731E-08  -1.71795850178910E-08  -4.34296230985017E-19
      5.03854676856015E-09
      0.00000000000000E+00  -2.94660878146048E-11   0.00000000000000E+00   2.65072156822141E-12   6.15274748653498E-24
      2.94633979935203E-08   2.94660487150885E-08  -8.02757811006351E-20  -5.75165481992367E-01  -5.75165481980336E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20304372334552E-08   0.00000000000000E+00  -1.20304372334552E-08
      4.54722903365729E-19  -9.47404805457842E-03  -3.98062626779634E-03   0.00000000000000E+00   3.33201861674156E-13
     -4.66276274260515E-25  -1.74359446834950E-08  -1.74356114816333E-08  -3.74447122265094E-19
      5.04685053418515E-09
      0.00000000000000E+00  -2.94072153380547E-11   0.00000000000000E+00  -3.09170702330619E-13   5.48249107270108E-24
      2.94075556332558E-08   2.94072464625535E-08  -6.19536628405209E-20  -5.83997924445790E-01  -5.83997924434003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17870875602246E-08   0.00000000000000E+00  -1.17870875602246E-08
      3.56845690864271E-19  -9.45976361690441E-03  -3.90819599582119E-03   0.00000000000000E+00   1.16542991684591E-12
     -1.22335219435998E-24  -1.76213243322458E-08  -1.76201589023289E-08  -2.94892028023751E-19
      5.05806061777890E-09
      0.00000000000000E+00  -2.83769929207979E-11   0.00000000000000E+00  -4.50484225859983E-12   4.78850316063714E-24
      2.83814625054781E-08   2.83769576632195E-08  -4.01107352704874E-20  -5.94598462054913E-01  -5.94598462044231E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06824125079181E-08   0.00000000000000E+00  -1.06824125079181E-08
      2.37094953667588E-19  -9.30563749557653E-03  -3.73063202582537E-03   0.00000000000000E+00   1.64594531696083E-12
     -1.74866438315867E-24  -1.76961911006182E-08  -1.76945451553013E-08  -1.96984218397101E-19
      5.07319423063047E-09
      0.00000000000000E+00  -2.42479290701591E-11   0.00000000000000E+00  -1.34418211226016E-11   3.79670661447328E-24
      2.42614411890513E-08   2.42479993679287E-08  -2.25874862522421E-20  -6.03013270180575E-01  -6.03013270174021E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55424563726356E-09   0.00000000000000E+00  -6.55424563726356E-09
      1.37905537659199E-19  -8.86743462343224E-03  -3.29267704624852E-03   0.00000000000000E+00   1.17632057627178E-12
     -2.12063223750324E-24  -1.76949300512414E-08  -1.76937537306651E-08  -1.15318051406957E-19
      5.09319423063047E-09
      0.00000000000000E+00  -1.11536248864820E-11   0.00000000000000E+00  -3.22779552060874E-11   1.68925595587806E-24
      1.11858666292460E-08   1.11535886740399E-08  -4.67957382191916E-20  -5.90354159241778E-01  -5.90354159248311E-01
      0.00000000000000E+00   0.00000000000000E+00   6.53286238041231E-09   0.00000000000000E+00   6.53286238041231E-09
      2.68562785267445E-19  -7.73745559470463E-03  -2.16499867516291E-03   0.00000000000000E+00  -1.12336490105213E-12
     -2.65076833562498E-24  -1.76853276895511E-08  -1.76864510544522E-08  -2.21767047048253E-19
      5.11319423063047E-09
      0.00000000000000E+00   7.78880109414710E-12   0.00000000000000E+00  -4.66951723937947E-11  -2.09084524363050E-24
     -7.74214664138870E-09  -7.78884181378250E-09  -1.46789703359016E-19  -5.41853961499415E-01  -5.41853961524884E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54684914755542E-08   0.00000000000000E+00   2.54684914755542E-08
      7.77932614778530E-19  -6.09287827404999E-03  -5.22562803823325E-04   0.00000000000000E+00  -5.07946914785611E-12
     -4.73019902749255E-24  -1.76745701926239E-08  -1.76796496617718E-08  -6.31142911419513E-19
      5.13319423063047E-09
      0.00000000000000E+00   2.22623376964696E-11   0.00000000000000E+00  -3.58562283297160E-11  -1.19517382739268E-23
     -2.22264282551462E-08  -2.22622844834759E-08  -3.38721885469632E-19  -4.57733819673384E-01  -4.57733819713273E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98888589419723E-08   0.00000000000000E+00   3.98888589419723E-08
      1.57570979361798E-18  -4.40203459827740E-03   1.15155389963133E-03   0.00000000000000E+00  -1.14222175626257E-11
     -1.84221564397744E-23  -1.76151522409337E-08  -1.76265744584963E-08  -1.23698790814834E-18
      5.15319423063047E-09
      0.00000000000000E+00   2.33514325902765E-11   0.00000000000000E+00  -3.06101905118407E-12  -3.57506348406566E-23
     -2.33483595228137E-08  -2.33514205418649E-08  -6.25140766678408E-19  -3.43278192609251E-01  -3.43278192650259E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10074561282008E-08   0.00000000000000E+00   4.10074561282008E-08
      2.39585891618199E-18  -2.15868982331663E-03   3.40416989799991E-03   0.00000000000000E+00  -2.63400221869924E-11
     -6.37632339394403E-23  -1.76296955641490E-08  -1.76560355863360E-08  -1.77071814950358E-18
      5.17319423063047E-09
      0.00000000000000E+00   1.48910627776679E-11   0.00000000000000E+00   2.02376489066810E-11  -4.29340741938387E-23
     -1.49112757180870E-08  -1.48910380691803E-08  -9.06550576859640E-19  -2.19950914462732E-01  -2.19950914493872E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11400661334432E-08   0.00000000000000E+00   3.11400661334432E-08
      3.01866023885086E-18  -9.52310715175309E-03  -4.40356740630907E-03   0.00000000000000E+00  -5.65535689753140E-11
     -8.13574540259873E-23  -1.61924744952876E-08  -1.62490280642630E-08  -2.11210966199122E-18
      5.18319423063047E-09
      0.00000000000000E+00   1.13825938163404E-11   0.00000000000000E+00   1.65149407656525E-11  -4.45560000808870E-23
     -1.13990572956495E-08  -1.13825423548839E-08  -1.02015384285246E-18  -1.63135985755098E-01  -1.63135985780508E-01
      0.00000000000000E+00   0.00000000000000E+00   2.54099562626180E-08   0.00000000000000E+00   2.54099562626180E-08
      3.27275980147704E-18  -2.09574766604531E-02  -1.65378850370179E-02   0.00000000000000E+00  -9.00026792722446E-11
     -8.79311180674291E-23  -1.39374112284616E-08  -1.40274139077339E-08  -2.25260595862458E-18
      5.18994423063047E-09
      0.00000000000000E+00   9.63901332519273E-12   0.00000000000000E+00   1.18787417656088E-11  -4.55069697218310E-23
     -9.65091076779025E-09  -9.63903202602469E-09  -1.08501932418800E-18  -1.28571476031105E-01  -1.28571476053423E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23181068740802E-08   0.00000000000000E+00   2.23181068740802E-08
      3.42340702287708E-18  -3.16156555722067E-02  -2.76208738636629E-02   0.00000000000000E+00  -1.18895928287219E-10
     -9.25150228472776E-23  -1.25601789197683E-08  -1.26790748480556E-08  -2.33838769868908E-18
      5.19450048063047E-09
      0.00000000000000E+00   8.55607202877878E-12   0.00000000000000E+00   1.08060063974946E-11  -4.60893468189596E-23
     -8.56690375144205E-09  -8.55609774504460E-09  -1.12379130260682E-18  -1.07123073057478E-01  -1.07123073077843E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03652599413647E-08   0.00000000000000E+00   2.03652599413647E-08
      3.51619623848492E-18  -4.00261007007667E-02  -3.63053937641379E-02   0.00000000000000E+00  -1.39357636932504E-10
     -9.56185801180737E-23  -1.16698045593875E-08  -1.18091621963201E-08  -2.39240493587810E-18
      5.20065141813047E-09
      0.00000000000000E+00   7.24333519987160E-12   0.00000000000000E+00   9.64477054098774E-12  -4.67605115542526E-23
     -7.25297632546458E-09  -7.24333155492364E-09  -1.16796251988397E-18  -8.18970997738484E-02  -8.18970997918886E-02
      0.00000000000000E+00   0.00000000000000E+00   1.80402563743778E-08   0.00000000000000E+00   1.80402563743778E-08
      3.62716072792770E-18  -5.31722812879448E-02  -4.97704973211643E-02   0.00000000000000E+00  -1.55870656426282E-10
     -9.97134869286766E-23  -1.06410541630275E-08  -1.07969248194539E-08  -2.45919820804372E-18
      5.20895518375547E-09
      0.00000000000000E+00   5.35638507394296E-12   0.00000000000000E+00   1.04543166215764E-11  -4.74008321194690E-23
     -5.36681803418944E-09  -5.35636371756791E-09  -1.21185571616149E-18  -5.59130098438619E-02  -5.59130098586152E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47533183014430E-08   0.00000000000000E+00   1.47533183014430E-08
      3.74966882529390E-18  -7.40763355196531E-02  -7.11156383732858E-02   0.00000000000000E+00  -1.68530260390877E-10
     -1.04941982985821E-22  -9.22842432348408E-09  -9.39695458387506E-09  -2.53781310913241E-18
      5.21456022555234E-09
      0.00000000000000E+00   3.83286457314451E-12   0.00000000000000E+00   1.27991901700127E-11  -4.76724321068926E-23
     -3.84566179761183E-09  -3.83286260744186E-09  -1.23293318728581E-18  -4.30638987967777E-02  -4.30638988088788E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21010751871637E-08   0.00000000000000E+00   1.21010751871637E-08
      3.81749585750508E-18  -8.98124714747600E-02  -8.72074004026895E-02   0.00000000000000E+00  -1.75594553525547E-10
     -1.08289607107825E-22  -8.09261802619614E-09  -8.26821257972180E-09  -2.58456267021927E-18
      5.21834362876523E-09
      0.00000000000000E+00   2.85582025873084E-12   0.00000000000000E+00   1.22897938863824E-11  -4.77947684750692E-23
     -2.86815462663304E-09  -2.85586483274670E-09  -1.24346192920767E-18  -3.65087296909361E-02  -3.65087297013214E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03852829153029E-08   0.00000000000000E+00   1.03852829153029E-08
      3.85678757025362E-18  -1.01085749751652E-01  -9.87134467029305E-02   0.00000000000000E+00  -1.78070369506942E-10
     -1.10451352751794E-22  -7.35134771304919E-09  -7.52941808255624E-09  -2.61332564104594E-18
      5.22345122310264E-09
      0.00000000000000E+00   1.92763734451157E-12   0.00000000000000E+00   8.69202438669627E-12  -4.78995035366756E-23
     -1.93629437863273E-09  -1.92760235424608E-09  -1.25293404170458E-18  -3.04338852885379E-02  -3.04338852972597E-02
      0.00000000000000E+00   0.00000000000000E+00   8.72183114020031E-09   0.00000000000000E+00   8.72183114020031E-09
      3.90133514559708E-18  -1.17027455387238E-01  -1.14886787806734E-01   0.00000000000000E+00  -1.78096948257723E-10
     -1.13207712401946E-22  -6.61613183769642E-09  -6.79422878595426E-09  -2.64840110389250E-18
      5.23034647545813E-09
      0.00000000000000E+00   1.18736876261891E-12   0.00000000000000E+00   5.13796477162561E-12  -4.79803780733362E-23
     -1.19248389239622E-09  -1.18734592762464E-09  -1.26062087247798E-18  -2.52585618066206E-02  -2.52585618139216E-02
      0.00000000000000E+00   0.00000000000000E+00   7.30103006388852E-09   0.00000000000000E+00   7.30103006388852E-09
      3.95167759034264E-18  -1.39043330241783E-01  -1.37117081132871E-01   0.00000000000000E+00  -1.80838675038851E-10
     -1.16745831732611E-22  -5.93284546122507E-09  -6.11368413626404E-09  -2.69105671786466E-18
      5.23965506613804E-09
      0.00000000000000E+00   6.88468150107621E-13   0.00000000000000E+00   2.56119238804895E-12  -4.80378069061129E-23
     -6.91036374874609E-10  -6.88475182486608E-10  -1.26636608041786E-18  -2.10684757755458E-02  -2.10684757817320E-02
      0.00000000000000E+00   0.00000000000000E+00   6.18615440438595E-09   0.00000000000000E+00   6.18615440438595E-09
      4.00926196957582E-18  -1.68537208013725E-01  -1.66805042426142E-01   0.00000000000000E+00  -1.87529008212146E-10
     -1.21333450802141E-22  -5.31015021368704E-09  -5.49767922189930E-09  -2.74289588915797E-18
      5.25222166355593E-09
      0.00000000000000E+00   3.94381301569120E-13   0.00000000000000E+00   1.11632502250288E-12  -4.80749174624835E-23
     -3.95477514087851E-10  -3.94361189065396E-10  -1.27045015326269E-18  -1.77065047758702E-02  -1.77065047811327E-02
      0.00000000000000E+00   0.00000000000000E+00   5.26247256095945E-09   0.00000000000000E+00   5.26247256095945E-09
      4.07539334367208E-18  -2.06413406506160E-01  -2.04879597175341E-01   0.00000000000000E+00  -1.96161697821325E-10
     -1.27247865262089E-22  -4.67194967407252E-09  -4.86811137189397E-09  -2.80494319040939E-18
      5.26918657007008E-09
      0.00000000000000E+00   2.40816900958135E-13   0.00000000000000E+00   4.31811108501812E-13  -4.80966549259968E-23
     -2.41213444869796E-10  -2.40781633761342E-10  -1.27339679519037E-18  -1.49408246934595E-02  -1.49408246977462E-02
      0.00000000000000E+00   0.00000000000000E+00   4.28671947183126E-09   0.00000000000000E+00   4.28671947183126E-09
      4.14811713876406E-18  -2.51067774320525E-01  -2.49793005647778E-01   0.00000000000000E+00  -1.95942826797359E-10
     -1.34431155656584E-22  -3.84999501127249E-09  -4.04593783806998E-09  -2.87472034357370E-18
      5.28918657007008E-09
      0.00000000000000E+00   1.75790827015206E-13   0.00000000000000E+00   1.55250884249280E-13  -4.81085844957726E-23
     -1.75952471901844E-10  -1.75797221017643E-10  -1.27561064770377E-18  -1.28234356308546E-02  -1.28234356340355E-02
      0.00000000000000E+00   0.00000000000000E+00   3.18093260197526E-09   0.00000000000000E+00   3.18093260197526E-09
      4.21173579080357E-18  -2.91102769604050E-01  -2.90155926740274E-01   0.00000000000000E+00  -1.71223965785917E-10
     -1.41132044893372E-22  -2.83391141517146E-09  -3.00513538095752E-09  -2.93612514309979E-18
      5.30918657007008E-09
      0.00000000000000E+00   1.47043424269250E-13   0.00000000000000E+00   6.99751358476729E-14  -4.81136572637622E-23
     -1.47093894822637E-10  -1.47023919686838E-10  -1.27727655489118E-18  -1.13916495623667E-02  -1.13916495645806E-02
      0.00000000000000E+00   0.00000000000000E+00   2.21386744539204E-09   0.00000000000000E+00   2.21386744539204E-09
      4.25601313971141E-18  -3.18524920959600E-01  -3.17873709592333E-01   0.00000000000000E+00  -1.29791939815313E-10
     -1.45856360511946E-22  -1.93705158588982E-09  -2.06684352570527E-09  -2.97873658482022E-18
      5.32918657007008E-09
      0.00000000000000E+00   1.32991179476499E-13   0.00000000000000E+00   3.54343649714530E-14  -4.81153391973553E-23
     -1.33016525727001E-10  -1.32981091362077E-10  -1.27867998633763E-18  -1.03994092832306E-02  -1.03994092846882E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45759148004301E-09   0.00000000000000E+00   1.45759148004301E-09
      4.28516496931227E-18  -3.35365737378412E-01  -3.34948388443286E-01   0.00000000000000E+00  -8.38064250623061E-11
     -1.48777973266934E-22  -1.24080396361851E-09  -1.32461038868097E-09  -3.00648498297464E-18
      5.34918657007008E-09
      0.00000000000000E+00   1.27113116295217E-13   0.00000000000000E+00   1.58585782487484E-14  -4.81159326246336E-23
     -1.27088642141828E-10  -1.27072783563627E-10  -1.27997667453933E-18  -9.69093720467545E-03  -9.69093720554580E-03
      0.00000000000000E+00   0.00000000000000E+00   8.70342898211923E-10   0.00000000000000E+00   8.70342898211923E-10
      4.30257182727651E-18  -3.43613829407351E-01  -3.43379651145221E-01   0.00000000000000E+00  -4.04198877552404E-11
     -1.50163623432725E-22  -7.02850226892903E-10  -7.43270114648294E-10  -3.02259515273718E-18
      5.36918657007008E-09
      0.00000000000000E+00   9.71717319655633E-14   0.00000000000000E+00   7.95552697968424E-14  -4.81048430263010E-23
     -9.72605148487831E-11  -9.71809595790344E-11  -1.28068630877830E-18  -9.37928678451741E-03  -9.37928678520825E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90847881684027E-10   0.00000000000000E+00   6.90847881684027E-10
      4.31638878491019E-18  -3.50092343296953E-01  -3.49905302337117E-01   0.00000000000000E+00  -3.00844934569445E-11
     -1.51172395723380E-22  -5.63582428647891E-10  -5.93666922104987E-10  -3.03570247613188E-18
      5.38918657007008E-09
      0.00000000000000E+00   7.40268581892666E-14   0.00000000000000E+00   6.65770657538446E-14  -4.80865622827406E-23
     -7.41262821685145E-11  -7.40597051028087E-11  -1.28094695273313E-18  -9.25951978751119E-03  -9.25951978833074E-03
      0.00000000000000E+00   0.00000000000000E+00   8.19554977108666E-10   0.00000000000000E+00   8.19554977108666E-10
      4.33277988445236E-18  -3.59269797471708E-01  -3.59034917108171E-01   0.00000000000000E+00  -4.49506788486202E-11
     -1.52637301467922E-22  -7.00544593157047E-10  -7.45495272005820E-10  -3.05183293171924E-18
      5.39168657007008E-09
      0.00000000000000E+00   6.94346213288902E-14   0.00000000000000E+00   1.01024820649906E-13  -4.80839590519787E-23
     -6.95241598323176E-11  -6.94231350117158E-11  -1.28096815470571E-18  -9.25128232969086E-03  -9.25128233050336E-03
      0.00000000000000E+00   0.00000000000000E+00   8.12501792961633E-10   0.00000000000000E+00   8.12501792961633E-10
      4.33481113893477E-18  -3.60414248222577E-01  -3.60180129108031E-01   0.00000000000000E+00  -4.50660726927122E-11
     -1.52819476110006E-22  -6.98012585256417E-10  -7.43078657949282E-10  -3.05384298422905E-18
      5.39506157007008E-09
      0.00000000000000E+00   3.38907080295774E-14   0.00000000000000E+00   5.29426415834470E-13  -4.80764159502151E-23
     -3.43959554103961E-11  -3.38665289946097E-11  -1.28087726542276E-18  -9.30053651433115E-03  -9.30053651527962E-03
      0.00000000000000E+00   0.00000000000000E+00   9.48472643226241E-10   0.00000000000000E+00   9.48472643226241E-10
      4.33801223410565E-18  -3.62533409368679E-01  -3.62245242994112E-01   0.00000000000000E+00  -6.31217074193454E-11
     -1.53157670772670E-22  -8.51484406811905E-10  -9.14606114231403E-10  -3.05713496868289E-18
      5.39961782007008E-09
      0.00000000000000E+00   1.59809842741097E-14   0.00000000000000E+00   2.16572633367456E-13  -4.80669097588058E-23
     -1.61826029922085E-11  -1.59660303588891E-11  -1.28067409914906E-18  -9.38800624783233E-03  -9.38800624902705E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19471971339812E-09   0.00000000000000E+00   1.19471971339812E-09
      4.34345567579983E-18  -3.66378761115302E-01  -3.66007364797299E-01   0.00000000000000E+00  -8.78434360928493E-11
     -1.53791587162491E-22  -1.09091024694636E-09  -1.17875368303936E-09  -3.06278157665076E-18
      5.40269328882008E-09
      0.00000000000000E+00   1.13887474137333E-14   0.00000000000000E+00   9.56107455307314E-14  -4.80606910351857E-23
     -1.14785220603565E-11  -1.13829113148738E-11  -1.28052341620966E-18  -9.44375623028163E-03  -9.44375623164124E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35960883583979E-09   0.00000000000000E+00   1.35960883583979E-09
      4.34763711028667E-18  -3.69384029777532E-01  -3.68959234567627E-01   0.00000000000000E+00  -1.04048156412088E-10
     -1.54296756023364E-22  -1.24417776811287E-09  -1.34822592452511E-09  -3.06711369407701E-18
      5.40684517163258E-09
      0.00000000000000E+00   1.57972947996946E-14   0.00000000000000E+00  -3.13440336092585E-14  -4.80533045909792E-23
     -1.57402302770268E-11  -1.57715743106841E-11  -1.28033929585138E-18  -9.49147386720804E-03  -9.49147386874980E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54175600975649E-09   0.00000000000000E+00   1.54175600975649E-09
      4.35403830056465E-18  -3.73988561806312E-01  -3.73507757068839E-01   0.00000000000000E+00  -1.21065049822507E-10
     -1.55087568580755E-22  -1.40491938562302E-09  -1.52598443544569E-09  -3.07369900471327E-18
      5.41245021342945E-09
      0.00000000000000E+00   2.76452658994656E-14   0.00000000000000E+00  -8.67791412405581E-14  -4.80449570095776E-23
     -2.75271373486408E-11  -2.76139164899294E-11  -1.28015916029835E-18  -9.49817842887406E-03  -9.49817843056740E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69334802110618E-09   0.00000000000000E+00   1.69334802110618E-09
      4.36352958699961E-18  -3.80752801032549E-01  -3.80227962925667E-01   0.00000000000000E+00  -1.35507687218781E-10
     -1.56274376752684E-22  -1.53022641739736E-09  -1.66573410461630E-09  -3.08337042670125E-18
      5.42001701985523E-09
      0.00000000000000E+00   4.14219764805946E-14   0.00000000000000E+00  -7.59641469074847E-14  -4.80355710089633E-23
     -4.13511504923994E-11  -4.14271146393550E-11  -1.28002425349090E-18  -9.43034096090244E-03  -9.43034096268275E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78030218486855E-09   0.00000000000000E+00   1.78030218486855E-09
      4.37700078901190E-18  -3.90245488052638E-01  -3.89697604018335E-01   0.00000000000000E+00  -1.45426416415014E-10
     -1.57974067695188E-22  -1.59344865381385E-09  -1.73887507022902E-09  -3.09697653552100E-18
      5.43023220853004E-09
      0.00000000000000E+00   5.64845133826290E-14   0.00000000000000E+00  -6.17281331472566E-14  -4.80256863209625E-23
     -5.64299127695589E-11  -5.64916409027542E-11  -1.28000264961739E-18  -9.24006689328554E-03  -9.24006689508612E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80057703537071E-09   0.00000000000000E+00   1.80057703537071E-09
      4.39539402315173E-18  -4.03039361255754E-01  -4.02489835185000E-01   0.00000000000000E+00  -1.50911179390216E-10
     -1.60316186794348E-22  -1.59317421507766E-09  -1.74408539446804E-09  -3.11539137353434E-18
      5.44402271324103E-09
      0.00000000000000E+00   8.12825924286612E-14   0.00000000000000E+00  -8.23340428259368E-14  -4.80190671851967E-23
     -8.12031211643526E-11  -8.12854552072266E-11  -1.28032655200878E-18  -8.78148561670991E-03  -8.78148561849344E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78352812468923E-09   0.00000000000000E+00   1.78352812468923E-09
      4.41998977615744E-18  -4.19745107332455E-01  -4.19208764835678E-01   0.00000000000000E+00  -1.53867877084919E-10
     -1.63471381005254E-22  -1.54837479239705E-09  -1.70224266948213E-09  -3.13966322414866E-18
      5.46263989460086E-09
      0.00000000000000E+00   1.26745737346387E-13   0.00000000000000E+00  -1.22420393624924E-13  -4.80263446670801E-23
     -1.26583182791617E-10  -1.26705603185290E-10  -1.28162666513026E-18  -7.66947358540881E-03  -7.66947358717548E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76667657981567E-09   0.00000000000000E+00   1.76667657981567E-09
      4.45288031444803E-18  -4.41063170627257E-01  -4.40546448361036E-01   0.00000000000000E+00  -1.56941281837232E-10
     -1.67700427822229E-22  -1.48302969479297E-09  -1.63997097663037E-09  -3.17125364931777E-18
      5.48263989460086E-09
      0.00000000000000E+00   1.67065576980491E-13   0.00000000000000E+00  -1.09187798513652E-13  -4.80482748243990E-23
     -1.66913866956221E-10  -1.67023054754782E-10  -1.28384612551431E-18  -6.01159654997479E-03  -6.01159655171426E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73947764226924E-09   0.00000000000000E+00   1.73947764226924E-09
      4.48766986729342E-18  -4.62626842157504E-01  -4.62131391916032E-01   0.00000000000000E+00  -1.60580012495683E-10
     -1.72213233231192E-22  -1.41187457501848E-09  -1.57245458751434E-09  -3.20382374177911E-18
      5.50263989460086E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.22576945332437E-14  -4.80698909442029E-23
     -1.71510055137339E-10  -1.71532312831920E-10  -1.28617066734686E-18  -4.31982522470737E-03  -4.31982522637558E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66820371900737E-09   0.00000000000000E+00   1.66820371900737E-09
      4.52103394167357E-18  -4.83101661421213E-01  -4.82630087883768E-01   0.00000000000000E+00  -1.62579800858298E-10
     -1.76653137622589E-22  -1.33409160531705E-09  -1.49667140617553E-09  -3.23486327432671E-18
      5.52263989460086E-09
      0.00000000000000E+00   2.23182711414290E-13   0.00000000000000E+00  -1.47297963885915E-13  -4.81130020434291E-23
     -2.23000616830450E-10  -2.23147914794384E-10  -1.28953874321368E-18  -2.01981092406193E-03  -2.01981092574487E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68293401824489E-09   0.00000000000000E+00   1.68293401824489E-09
      4.55469262203846E-18  -5.02573584189121E-01  -5.02113630707302E-01   0.00000000000000E+00  -1.69100821973801E-10
     -1.81146190987918E-22  -1.29068528147649E-09  -1.45978610345047E-09  -3.26515387882478E-18
      5.54263989460086E-09
      0.00000000000000E+00  -6.28218002499483E-13   0.00000000000000E+00   2.22035012388484E-12  -4.78005225105318E-23
      6.26013636618039E-10   6.28233986741876E-10  -1.27593922017462E-18  -9.98153375765048E-03  -9.98153375791350E-03
      0.00000000000000E+00   0.00000000000000E+00   2.63025277576596E-10   0.00000000000000E+00   2.63025277576596E-10
      4.55995312759000E-18  -5.22251876763352E-01  -5.21971066744668E-01   0.00000000000000E+00  -9.24170495191401E-11
     -1.83549369846375E-22  -7.98842214799152E-10  -8.91259264318476E-10  -3.28401390741538E-18
      5.56263989460086E-09
      0.00000000000000E+00  -2.53390445481846E-12   0.00000000000000E+00   5.10173233947216E-12  -4.67659700892263E-23
      2.52880227788607E-09   2.53390401022549E-09  -1.22457755037928E-18  -3.99522824455694E-02  -3.99522824427769E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.79252707930849E-09   0.00000000000000E+00  -2.79252707930849E-09
      4.50410258600383E-18  -5.43212092640977E-01  -5.43293619643367E-01   0.00000000000000E+00   8.13300665656654E-11
     -1.81407527105699E-22   1.77293002517450E-10   2.58623069082934E-10  -3.27952503562455E-18
      5.57263989460086E-09
      0.00000000000000E+00  -3.72889633062559E-12   0.00000000000000E+00   6.42624191246047E-12  -4.60362149561088E-23
      3.72250434417018E-09   3.72893058608260E-09  -1.18722438523732E-18  -6.11087110768304E-02  -6.11087110721980E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.63238165454977E-09   0.00000000000000E+00  -4.63238165454977E-09
      4.45777876945833E-18  -5.53960973370720E-01  -5.54245699084021E-01   0.00000000000000E+00   1.75049952211219E-10
     -1.79074958312508E-22   7.28401116256131E-10   9.03451068467170E-10  -3.27055438422100E-18
      5.57938989460086E-09
      0.00000000000000E+00  -4.61317746045965E-12   0.00000000000000E+00   7.03077519196513E-12  -4.54456047989291E-23
      4.60616642235172E-09   4.61319719754364E-09  -1.15631338468520E-18  -7.81949837622029E-02  -7.81949837562674E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.93549812981489E-09   0.00000000000000E+00  -5.93549812981489E-09
      4.41771415708208E-18  -5.61353310758756E-01  -5.61770015670165E-01   0.00000000000000E+00   2.32330076652821E-10
     -1.76956431254738E-22   1.08997085561881E-09   1.32230093227145E-09  -3.26140077239687E-18
      5.58394614460086E-09
      0.00000000000000E+00  -5.24598769981951E-12   0.00000000000000E+00   7.43010795066583E-12  -4.50027625022728E-23
      5.23855539023948E-09   5.24598549819011E-09  -1.13277881246340E-18  -9.09506660594031E-02  -9.09506660525767E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.82640124712421E-09   0.00000000000000E+00  -6.82640124712421E-09
      4.38661136639987E-18  -5.66392620925801E-01  -5.66890658926151E-01   0.00000000000000E+00   2.65964345016506E-10
     -1.75300571778669E-22   1.31445140391735E-09   1.58041574893368E-09  -3.25383255393646E-18
      5.58702161335086E-09
      0.00000000000000E+00  -5.66277911726727E-12   0.00000000000000E+00   7.27361912061647E-12  -4.46868350355456E-23
      5.65545920579567E-09   5.66273282491624E-09  -1.11575327701506E-18  -1.00042620254588E-01  -1.00042620247203E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.38503722421015E-09   0.00000000000000E+00  -7.38503722421015E-09
      4.36389891519922E-18  -5.69803990681861E-01  -5.70346741256343E-01   0.00000000000000E+00   2.83799176458948E-10
     -1.74097379542568E-22   1.43850522283501E-09   1.72230439929379E-09  -3.24814563818416E-18
      5.59117349616336E-09
      0.00000000000000E+00  -6.10510337165872E-12   0.00000000000000E+00   5.85827536358232E-12  -4.42422502326206E-23
      6.09931695730799E-09   6.10517523267153E-09  -1.09130591443464E-18  -1.12892976638119E-01  -1.12892976630198E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.92135851762663E-09   0.00000000000000E+00  -7.92135851762663E-09
      4.33101036291824E-18  -5.74392479514570E-01  -5.74964820194295E-01   0.00000000000000E+00   2.98816186376771E-10
     -1.72370291615594E-22   1.51736709857908E-09   1.81618328495568E-09  -3.23970444848360E-18
      5.59677853796023E-09
      0.00000000000000E+00  -6.60372844995838E-12   0.00000000000000E+00   4.95574991624531E-12  -4.35883460703562E-23
      6.59871162175717E-09   6.60366737167337E-09  -1.05661430163750E-18  -1.30735570393174E-01  -1.30735570384796E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37833878588793E-09   0.00000000000000E+00  -8.37833878588793E-09
      4.28404942383496E-18  -5.80470835749520E-01  -5.81030116852126E-01   0.00000000000000E+00   3.05127600357599E-10
     -1.69957929438491E-22   1.46954381385684E-09   1.77467141421427E-09  -3.22743512219746E-18
      5.60434534438601E-09
      0.00000000000000E+00  -7.31139215014237E-12   0.00000000000000E+00   5.12258789126253E-12  -4.23998858813299E-23
      7.30623116920507E-09   7.31135375709629E-09  -1.00819255753950E-18  -1.54920539686058E-01  -1.54920539677341E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71687386280616E-09   0.00000000000000E+00  -8.71687386280616E-09
      4.21809052667715E-18  -5.88267121811575E-01  -5.88710138327962E-01   0.00000000000000E+00   3.00676194960999E-10
     -1.66692972780721E-22   1.10484391074923E-09   1.40552010571006E-09  -3.20989796913765E-18
      5.61456053306082E-09
      0.00000000000000E+00  -8.85273052995909E-12   0.00000000000000E+00   7.86433767679852E-12  -3.87548348909003E-23
      8.84483286555911E-09   8.85269720323587E-09  -9.42095133527980E-19  -1.86705578204946E-01  -1.86705578195987E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.95955101955913E-09   0.00000000000000E+00  -8.95955101955913E-09
      4.12656702257081E-18  -5.97353658207934E-01  -5.97387627312558E-01   0.00000000000000E+00   2.88505426518262E-10
     -1.62363446009369E-22  -1.81651610194968E-10   1.06853816323131E-10  -3.18447188904284E-18
      5.62835103777181E-09
      0.00000000000000E+00  -1.34957575300112E-11   0.00000000000000E+00   1.69153600100288E-11  -2.19137313154646E-23
      1.34788808489500E-08   1.34957962089600E-08  -8.55809346418265E-19  -2.26352836106810E-01  -2.26352836097591E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.21846857713726E-09   0.00000000000000E+00  -9.21846857713726E-09
      3.99943968822972E-18  -6.03890705623222E-01  -6.02543722385816E-01   0.00000000000000E+00   2.80960226988775E-10
     -1.56449483782033E-22  -4.55828785881139E-09  -4.27732763182277E-09  -3.14363034181146E-18
      5.64696821913164E-09
      0.00000000000000E+00  -2.70027201179617E-11   0.00000000000000E+00   3.60016869174893E-11   4.19293542037684E-23
      2.69666854657799E-08   2.70026871526974E-08  -7.55868652602759E-19  -2.70430046199096E-01  -2.70430046189387E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70909889546504E-09   0.00000000000000E+00  -9.70909889546504E-09
      3.81868363325231E-18  -5.90954125390272E-01  -5.85506965289158E-01   0.00000000000000E+00   3.01274654970253E-10
     -1.47159927712737E-22  -1.75948629122024E-08  -1.72935882572323E-08  -3.06281498064955E-18
      5.66696821913164E-09
      0.00000000000000E+00  -4.72036945325456E-11   0.00000000000000E+00   5.00946138083475E-11   1.38230754360825E-22
      4.71536844897110E-08   4.72037791035195E-08  -6.77846792591495E-19  -3.04650006058649E-01  -3.04650006048259E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03895378049114E-08   0.00000000000000E+00  -1.03895378049114E-08
      3.61089287715409E-18  -5.41044910916219E-01  -5.29448033957885E-01   0.00000000000000E+00   3.19291201831845E-10
     -1.34326614491274E-22  -3.71335325004398E-08  -3.68142412986080E-08  -2.93304608456259E-18
      5.68696821913164E-09
      0.00000000000000E+00  -6.28035231472440E-11   0.00000000000000E+00   3.88198475744327E-11   2.11285408150769E-22
      6.27646710658393E-08   6.28034909134139E-08  -6.28948385016388E-19  -3.27192303197369E-01  -3.27192303186361E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10085756562953E-08   0.00000000000000E+00  -1.10085756562953E-08
      3.39072136402818E-18  -4.55714510322433E-01  -4.39397468998131E-01   0.00000000000000E+00   2.94044790504217E-10
     -1.18430341194679E-22  -5.20889600476228E-08  -5.17949152571187E-08  -2.76177297901179E-18
      5.70696821913164E-09
      0.00000000000000E+00  -6.51499724934219E-11   0.00000000000000E+00   5.94398689193952E-12   2.22874922915334E-22
      6.51439934933953E-08   6.51499374802875E-08  -6.05624766870162E-19  -3.39812098465969E-01  -3.39812098454406E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15631160477328E-08   0.00000000000000E+00  -1.15631160477328E-08
      3.15945904307352E-18  -3.40342664427151E-01  -3.23460332253779E-01   0.00000000000000E+00   2.45201386498376E-10
     -1.02080017484793E-22  -5.38320228190530E-08  -5.35868214325547E-08  -2.55383427620336E-18
      5.72696821913164E-09
      0.00000000000000E+00  -5.66954807439946E-11   0.00000000000000E+00  -2.09342831815264E-11   1.84582525742501E-22
      5.67163970660906E-08   5.66954627829093E-08  -5.98208615390139E-19  -3.46341435373994E-01  -3.46341435362076E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19186929852244E-08   0.00000000000000E+00  -1.19186929852244E-08
      2.92108518336904E-18  -2.17095175027421E-01  -2.02987992959052E-01   0.00000000000000E+00   1.71226290410900E-10
     -8.55441699592379E-23  -4.49479960880957E-08  -4.47767697976849E-08  -2.32287656797890E-18
      5.74696821913164E-09
      0.00000000000000E+00  -4.93791289780431E-11   0.00000000000000E+00  -1.81533578068219E-11   1.44548292898285E-22
      4.93972657182387E-08   4.93791123604320E-08  -5.89311968704451E-19  -3.53510422771127E-01  -3.53510422759289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18379883165733E-08   0.00000000000000E+00  -1.18379883165733E-08
      2.68432541703757E-18  -1.15438294759422E-01  -1.03610527093986E-01   0.00000000000000E+00   9.13229657308680E-11
     -7.36217077641435E-23  -3.76324470095894E-08  -3.75411240438586E-08  -2.09501344833312E-18
      5.76696821913164E-09
      0.00000000000000E+00  -4.21506726255991E-11   0.00000000000000E+00  -1.78899366377844E-11   1.22554766195280E-22
      4.21685438272516E-08   4.21506538906139E-08  -5.64844982295513E-19  -3.66085775686775E-01  -3.66085775675387E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13883566948661E-08   0.00000000000000E+00  -1.13883566948661E-08
      2.45655828314025E-18  -5.01255379688346E-02  -4.04334248751531E-02   0.00000000000000E+00   4.99756700567280E-11
     -8.48222802424812E-24  -3.08122728658046E-08  -3.07622971957478E-08  -1.89171330084473E-18
      5.78696821913164E-09
      0.00000000000000E+00  -3.49918345839584E-11   0.00000000000000E+00  -1.76702626038176E-11   1.31063658548235E-22
      3.50095201229721E-08   3.49918498603684E-08  -5.12572848273194E-19  -3.87874505214777E-01  -3.87874505204171E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06060747456299E-08   0.00000000000000E+00  -1.06060747456299E-08
      2.24443678822765E-18  -2.57789588245520E-02  -1.80958269387077E-02   0.00000000000000E+00   2.93001377971459E-11
      1.00822650365619E-22  -2.44150752525358E-08  -2.43857751147386E-08  -1.73186393995446E-18
      5.80696821913164E-09
      0.00000000000000E+00  -3.16825768576340E-11   0.00000000000000E+00  -8.15481637318204E-12   1.39515111417354E-22
      3.16907390560163E-08   3.16825842396433E-08  -4.52901408687299E-19  -4.12116119981440E-01  -4.12116119971246E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01938505358505E-08   0.00000000000000E+00  -1.01938505358505E-08
      2.04055977751064E-18  -1.79238902781990E-02  -1.11534993024601E-02   0.00000000000000E+00   1.46506675721403E-11
      1.60257966626825E-22  -2.15033843713652E-08  -2.14887337037929E-08  -1.58765836882334E-18
      5.82696821913164E-09
      0.00000000000000E+00  -3.00285449852637E-11   0.00000000000000E+00  -4.05311272523258E-12   1.29301175245303E-22
      3.00326543915877E-08   3.00286012788626E-08  -3.96157305023101E-19  -4.35406116032268E-01  -4.35406116022275E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99364464197351E-09   0.00000000000000E+00  -9.99364464197351E-09
      1.84068688467117E-18  -1.45310483687624E-02  -8.21868409595508E-03   0.00000000000000E+00   8.92722121392669E-12
      1.67654408199178E-22  -2.00438838581031E-08  -2.00349566368890E-08  -1.44452957964807E-18
      5.84696821913164E-09
      0.00000000000000E+00  -2.87227883563843E-11   0.00000000000000E+00  -3.19077075396648E-12   1.03256110220282E-22
      2.87259701530567E-08   2.87227793823028E-08  -3.43676404535308E-19  -4.57311690233144E-01  -4.57311690223308E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.83618037621227E-09   0.00000000000000E+00  -9.83618037621227E-09
      1.64396327714693E-18  -1.25148944591923E-02  -6.56433373723652E-03   0.00000000000000E+00   7.06659092535342E-12
      1.39411496326889E-22  -1.88936655970161E-08  -1.88865990060906E-08  -1.30028687261162E-18
      5.86696821913164E-09
      0.00000000000000E+00  -2.76651962074396E-11   0.00000000000000E+00  -2.58164158503909E-12   7.20028562531371E-23
      2.76677134840540E-08   2.76651318424691E-08  -2.94831569516724E-19  -4.78061919520388E-01  -4.78061919510685E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70272931092242E-09   0.00000000000000E+00  -9.70272931092242E-09
      1.44990869092848E-18  -1.11771663746770E-02  -5.51778526006041E-03   0.00000000000000E+00   5.81458235439433E-12
      9.67080953524240E-23  -1.79682171139013E-08  -1.79624025315468E-08  -1.15507712141175E-18
      5.88696821913164E-09
      0.00000000000000E+00  -2.68013046092656E-11   0.00000000000000E+00  -2.10622746175582E-12   4.46046033345369E-23
      2.68034016943448E-08   2.68012954668831E-08  -2.49184753029937E-19  -4.97804683643761E-01  -4.97804683634200E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56137815474111E-09   0.00000000000000E+00  -9.56137815474111E-09
      1.25868112783365E-18  -1.02425007587861E-02  -4.81074770569399E-03   0.00000000000000E+00   4.81425341750293E-12
      5.67804460763462E-23  -1.72447315655594E-08  -1.72399173121418E-08  -1.00949637480372E-18
      5.90696821913164E-09
      0.00000000000000E+00  -2.63677974496461E-11   0.00000000000000E+00  -1.04677109040776E-12   2.54100349120211E-23
      2.63688628448026E-08   2.63678160737122E-08  -2.05359230714384E-19  -5.17147588778479E-01  -5.17147588768823E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.65648583130098E-09   0.00000000000000E+00  -9.65648583130098E-09
      1.06555141120764E-18  -9.60071746947609E-03  -4.33550213418202E-03   0.00000000000000E+00   4.01183295844132E-12
      2.82275403844557E-23  -1.67153420753698E-08  -1.67113302424113E-08  -8.60192180493250E-19
      5.92696821913164E-09
      0.00000000000000E+00  -2.72269131214853E-11   0.00000000000000E+00   2.14176147543690E-12   1.43359493062453E-23
      2.72247445768030E-08   2.72268863382785E-08  -1.59593933378230E-19  -5.37877172259780E-01  -5.37877172249159E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06208411606917E-08   0.00000000000000E+00  -1.06208411606917E-08
      8.53134587993801E-19  -9.34261688234907E-03  -4.11057049071985E-03   0.00000000000000E+00   2.90569570522600E-12
      1.15897600476298E-23  -1.66089508732920E-08  -1.66060451775868E-08  -6.93540654615571E-19
      5.94696821913164E-09
      0.00000000000000E+00  -2.81513304014790E-11   0.00000000000000E+00   2.31006158707822E-12   8.69879581949932E-24
      2.81490139127332E-08   2.81513239743203E-08  -1.13440938230766E-19  -5.59339446414085E-01  -5.59339446402729E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13562605171397E-08   0.00000000000000E+00  -1.13562605171397E-08
      6.26009377651007E-19  -9.25698081002175E-03  -3.96537817931792E-03   0.00000000000000E+00   2.05928020564350E-12
      3.35041883637174E-24  -1.67971227373863E-08  -1.67950634571806E-08  -5.12568439420240E-19
      5.96696821913164E-09
      0.00000000000000E+00  -2.89763716758142E-11   0.00000000000000E+00   2.06375888359538E-12   6.11823618243641E-24
      2.89742635190085E-08   2.89763272778921E-08  -6.87561206666931E-20  -5.80681347125790E-01  -5.80681347114153E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16363345174241E-08   0.00000000000000E+00  -1.16363345174241E-08
      3.93282687302526E-19  -9.34069829810516E-03  -3.87740267489862E-03   0.00000000000000E+00   9.90342813557032E-13
     -2.17467238937323E-25  -1.73409831032817E-08  -1.73399927604681E-08  -3.24526566635833E-19
      5.96946821913164E-09
      0.00000000000000E+00  -2.90774008867425E-11   0.00000000000000E+00   2.02299402644654E-12   5.80918925440816E-24
      2.90754058084619E-08   2.90774288024883E-08  -6.33264236416757E-20  -5.83313337497333E-01  -5.83313337485678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16547472230215E-08   0.00000000000000E+00  -1.16547472230215E-08
      3.64145819244972E-19  -9.35887514498840E-03  -3.86952637849812E-03   0.00000000000000E+00   5.94626359710962E-13
     -6.61408558778875E-25  -1.74232762058261E-08  -1.74226815794664E-08  -3.00819395603296E-19
      5.97284321913164E-09
      0.00000000000000E+00  -2.90961372131329E-11   0.00000000000000E+00   3.21506613474535E-13   5.46342339911215E-24
      2.90958242257340E-08   2.90961457323475E-08  -5.61225148186699E-20  -5.86812085561620E-01  -5.86812085550068E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15519926685346E-08   0.00000000000000E+00  -1.15519926685346E-08
      3.25157843988668E-19  -9.37741529793595E-03  -3.84979415450130E-03   0.00000000000000E+00   3.95179372694913E-13
     -1.10354560271746E-24  -1.75445482431854E-08  -1.75441530638127E-08  -2.69035329169997E-19
      5.97739946913164E-09
      0.00000000000000E+00  -2.88350226252519E-11   0.00000000000000E+00  -2.76804380074682E-12   5.08726462267665E-24
      2.88377719760490E-08   2.88350039322483E-08  -4.68068627348746E-20  -5.91342169123669E-01  -5.91342169112477E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11910895504060E-08   0.00000000000000E+00  -1.11910895504060E-08
      2.74168442224631E-19  -9.35426033133850E-03  -3.79521010843529E-03   0.00000000000000E+00   9.72511545345972E-13
     -1.49279274104443E-24  -1.76448868933880E-08  -1.76439143818426E-08  -2.27361579489756E-19
      5.98355040663164E-09
      0.00000000000000E+00  -2.80047462008958E-11   0.00000000000000E+00  -6.58581424318004E-12   4.65842922277446E-24
      2.80114018398560E-08   2.80048160256129E-08  -3.53831514891337E-20  -5.96902042796307E-01  -5.96902042785995E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03110797029381E-08   0.00000000000000E+00  -1.03110797029381E-08
      2.10745635414340E-19  -9.25362363439127E-03  -3.67888381155056E-03   0.00000000000000E+00   1.43123684955840E-12
     -1.80607381033523E-24  -1.76951675595242E-08  -1.76937363226746E-08  -1.75362483925205E-19
      5.99185417225664E-09
      0.00000000000000E+00  -2.59085737636084E-11   0.00000000000000E+00  -1.24269818617661E-11   4.09322080636453E-24
      2.59209721671240E-08   2.59085451852623E-08  -2.33323210416635E-20  -6.02737783650214E-01  -6.02737783642008E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20551411438856E-09   0.00000000000000E+00  -8.20551411438856E-09
      1.42608969375827E-19  -9.02389653720715E-03  -3.44621628432262E-03   0.00000000000000E+00   1.40371624132939E-12
     -2.04773944051848E-24  -1.77044347871150E-08  -1.77030310708737E-08  -1.19276648334164E-19
      6.00306425585039E-09
      0.00000000000000E+00  -2.06686478164446E-11   0.00000000000000E+00  -2.30373897382477E-11   3.15108493116769E-24
      2.06916376911169E-08   2.06686003013786E-08  -1.77215198884158E-20  -6.05227558715587E-01  -6.05227558712618E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.96960383726438E-09   0.00000000000000E+00  -2.96960383726438E-09
      1.09319462119773E-19  -8.53171329931483E-03  -2.95530307319817E-03   0.00000000000000E+00   5.52093472768621E-13
     -2.26572110777819E-24  -1.76995485575871E-08  -1.76989964641144E-08  -9.15979422313584E-20
      6.01819786870196E-09
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00  -3.90430624321927E-11   1.28652732915488E-24
      8.70973424957309E-09   8.67069118714090E-09  -4.28280013414892E-20  -5.92156954493439E-01  -5.92156954502470E-01
      0.00000000000000E+00   0.00000000000000E+00   9.03078295809482E-09   0.00000000000000E+00   9.03078295809482E-09
      2.45987835154069E-19  -7.50600742795955E-03  -1.92882687335188E-03   0.00000000000000E+00  -1.60723113900461E-12
     -2.67801789352217E-24  -1.76998669140965E-08  -1.77014741452355E-08  -2.03159833812578E-19
      6.03819786870196E-09
      0.00000000000000E+00   1.05297235866313E-11   0.00000000000000E+00  -4.73510352836413E-11  -2.68690030316939E-24
     -1.04823672023745E-08  -1.05297182376582E-08  -1.53720180954068E-19  -5.38521890675082E-01  -5.38521890703292E-01
      0.00000000000000E+00   0.00000000000000E+00   2.82103506081614E-08   0.00000000000000E+00   2.82103506081614E-08
      8.10194847317297E-19  -5.81942302022648E-03  -2.48797562416627E-04   0.00000000000000E+00  -5.61404638918038E-12
     -5.00727003148266E-24  -1.76750183241141E-08  -1.76806323705033E-08  -6.56474666363228E-19
      6.05819786870196E-09
      0.00000000000000E+00   2.38822033265988E-11   0.00000000000000E+00  -3.31192990653277E-11  -1.35931111773416E-23
     -2.38490599658104E-08  -2.38821792648758E-08  -3.57322705907738E-19  -4.50024501782654E-01  -4.50024501824160E-01
      0.00000000000000E+00   0.00000000000000E+00   4.15055066141391E-08   0.00000000000000E+00   4.15055066141391E-08
      1.64030497960008E-18  -4.12288696569695E-03   1.42967829702869E-03   0.00000000000000E+00  -1.23275316667559E-11
     -2.08879790127031E-23  -1.76109998175967E-08  -1.76233273492635E-08  -1.28298227369234E-18
      6.07819786870196E-09
      0.00000000000000E+00   2.31727945764078E-11   0.00000000000000E+00   1.35162114640104E-12  -3.71985297859023E-23
     -2.31741711366940E-08  -2.31728195155476E-08  -6.52164880662491E-19  -3.32310692231655E-01  -3.32310692272509E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08540158421157E-08   0.00000000000000E+00   4.08540158421157E-08
      2.45738529644239E-18  -1.67905198110144E-03   3.89173396997914E-03   0.00000000000000E+00  -2.85575435901675E-11
     -6.66455962617916E-23  -1.76526387829779E-08  -1.76811963265681E-08  -1.80522041577990E-18
      6.09819786870196E-09
      0.00000000000000E+00   1.44299103521489E-11   0.00000000000000E+00   2.09149706761157E-11  -4.32806372797514E-23
     -1.44507564162751E-08  -1.44298414455990E-08  -9.28190627457973E-19  -2.09467418615358E-01  -2.09467418645771E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04129104979169E-08   0.00000000000000E+00   3.04129104979169E-08
      3.06564350640073E-18  -1.09003044401444E-02  -5.86456063441846E-03   0.00000000000000E+00  -6.00448048839615E-11
     -8.25282152576306E-23  -1.59230242474338E-08  -1.59830690523179E-08  -2.13745287894276E-18
      6.11819786870196E-09
      0.00000000000000E+00   9.62688981988133E-12   0.00000000000000E+00   1.10434347754904E-11  -4.60771319445519E-23
     -9.63794859136162E-09  -9.62690515658618E-09  -1.11937895801463E-18  -1.09440687912645E-01  -1.09440687934901E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22562269201069E-08   0.00000000000000E+00   2.22562269201069E-08
      3.51076804480287E-18  -4.19658860001124E-02  -3.79868023715958E-02   0.00000000000000E+00  -1.11416891751027E-10
     -9.55928026537346E-23  -1.25179048717696E-08  -1.26293217635207E-08  -2.39138908678824E-18
      6.12319786870196E-09
      0.00000000000000E+00   8.00307486605226E-12   0.00000000000000E+00   1.50194535025369E-11  -4.66504318899691E-23
     -8.01812588660836E-09  -8.00310643310587E-09  -1.15909539687093E-18  -8.69661659724023E-02  -8.69661659916955E-02
      0.00000000000000E+00   0.00000000000000E+00   1.92931622366270E-08   0.00000000000000E+00   1.92931622366270E-08
      3.60723385598600E-18  -5.18251869019042E-02  -4.82680338315303E-02   0.00000000000000E+00  -1.53878700892389E-10
     -9.90180989141987E-23  -1.11361771026285E-08  -1.12900558035210E-08  -2.44813845911508E-18
      6.12994786870196E-09
      0.00000000000000E+00   6.16516982979244E-12   0.00000000000000E+00   1.26085718945392E-11  -4.72489824636495E-23
     -6.17782089682582E-09  -6.16521232493133E-09  -1.20024635766154E-18  -6.28749236643563E-02  -6.28749236804712E-02
      0.00000000000000E+00   0.00000000000000E+00   1.61148808313593E-08   0.00000000000000E+00   1.61148808313593E-08
      3.71600930159768E-18  -6.77388805609826E-02  -6.46040393085054E-02   0.00000000000000E+00  -1.68601199058954E-10
     -1.03425363145899E-22  -9.78106730736867E-09  -9.94966850642773E-09  -2.51576294393614E-18
      6.13906036870196E-09
      0.00000000000000E+00   3.88044014701801E-12   0.00000000000000E+00   1.17858336502220E-11  -4.77101333962454E-23
     -3.89227071448264E-09  -3.88048488083246E-09  -1.23494603411543E-18  -4.17835178913098E-02  -4.17835179034834E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21736151595781E-08   0.00000000000000E+00   1.21736151595781E-08
      3.82694136973933E-18  -9.31499580454881E-02  -9.05370406233362E-02   0.00000000000000E+00  -1.73618633241659E-10
     -1.08839831069657E-22  -8.11951164550397E-09  -8.29313027874574E-09  -2.59199533562391E-18
      6.14213583745196E-09
      0.00000000000000E+00   2.96401335916130E-12   0.00000000000000E+00   1.41859706659914E-11  -4.78075591230884E-23
     -2.97817296257822E-09  -2.96398699191228E-09  -1.24383721640062E-18  -3.62620932657268E-02  -3.62620932762751E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05483138216970E-08   0.00000000000000E+00   1.05483138216970E-08
      3.85938237926316E-18  -1.02230248997227E-01  -9.98406455325240E-02   0.00000000000000E+00  -1.79928366030033E-10
     -1.10614930394930E-22  -7.40439846375485E-09  -7.58432682978499E-09  -2.61554516286254E-18
      6.14628772026446E-09
      0.00000000000000E+00   2.07100697929252E-12   0.00000000000000E+00   1.03221281610974E-11  -4.78954269911495E-23
     -2.08132407888570E-09  -2.07100195072465E-09  -1.25213220917279E-18  -3.09757031889344E-02  -3.09757031979023E-02
      0.00000000000000E+00   0.00000000000000E+00   8.96790291263122E-09   0.00000000000000E+00   8.96790291263122E-09
      3.89661606123028E-18  -1.15090544668941E-01  -1.12917527480494E-01   0.00000000000000E+00  -1.79371546233150E-10
     -1.12883655679926E-22  -6.71752941567325E-09  -6.89690096190651E-09  -2.64448385205749E-18
      6.15189276206133E-09
      0.00000000000000E+00   1.33459587636257E-12   0.00000000000000E+00   6.30712260698842E-12  -4.79678192516453E-23
     -1.34088920072756E-09  -1.33458207812062E-09  -1.25920475498479E-18  -2.62781187479213E-02  -2.62781187555154E-02
      0.00000000000000E+00   0.00000000000000E+00   7.59408883952988E-09   0.00000000000000E+00   7.59408883952988E-09
      3.93918124658503E-18  -1.32942329907473E-01  -1.30970135863633E-01   0.00000000000000E+00  -1.80542160518269E-10
     -1.15794996711641E-22  -6.07896460089056E-09  -6.25950676140894E-09  -2.67997649160024E-18
      6.15945956848711E-09
      0.00000000000000E+00   8.11631942702914E-13   0.00000000000000E+00   3.31070075055662E-12  -4.80233294717105E-23
     -8.14939385475939E-10  -8.11628684725430E-10  -1.26480268621946E-18  -2.23053335595035E-02  -2.23053335660021E-02
      0.00000000000000E+00   0.00000000000000E+00   6.49863465407372E-09   0.00000000000000E+00   6.49863465407372E-09
      3.98835515704428E-18  -1.57106759386703E-01  -1.55314942263930E-01   0.00000000000000E+00  -1.85253592930149E-10
     -1.19571508365550E-22  -5.50175237641826E-09  -5.68700596934853E-09  -2.72355247082482E-18
      6.16967475716192E-09
      0.00000000000000E+00   4.83011472974383E-13   0.00000000000000E+00   1.53592706356874E-12  -4.80629358033538E-23
     -4.84528356586271E-10  -4.82992429522750E-10  -1.26901861749553E-18  -1.89959457225546E-02  -1.89959457281717E-02
      0.00000000000000E+00   0.00000000000000E+00   5.61711709197931E-09   0.00000000000000E+00   5.61711709197931E-09
      4.04573506794732E-18  -1.88805532676599E-01  -1.87187910547671E-01   0.00000000000000E+00  -1.93060112843590E-10
     -1.24487527706148E-22  -4.94106454961284E-09  -5.13412466245656E-09  -2.77671645045179E-18
      6.18346526187290E-09
      0.00000000000000E+00   2.94178693275708E-13   0.00000000000000E+00   6.52614061149949E-13  -4.80884447505047E-23
     -2.94797662494147E-10  -2.94145048433045E-10  -1.27213377308066E-18  -1.62093078334086E-02  -1.62093078381828E-02
      0.00000000000000E+00   0.00000000000000E+00   4.77419975848809E-09   0.00000000000000E+00   4.77419975848809E-09
      4.11157369220793E-18  -2.28232511113894E-01  -2.26820965176986E-01   0.00000000000000E+00  -1.98892984354467E-10
     -1.30720984677346E-22  -4.28116172570036E-09  -4.48005471005496E-09  -2.83943991912727E-18
      6.20208244323274E-09
      0.00000000000000E+00   1.98843856054295E-13   0.00000000000000E+00   2.44056616860932E-13  -4.81040524440552E-23
     -1.99093917890681E-10  -1.98849861273868E-10  -1.27460594780625E-18  -1.38003547709340E-02  -1.38003547746794E-02
      0.00000000000000E+00   0.00000000000000E+00   3.74540215335415E-09   0.00000000000000E+00   3.74540215335415E-09
      4.18130252336243E-18  -2.71872514831390E-01  -2.70755087138680E-01   0.00000000000000E+00  -1.87179176924673E-10
     -1.37876910234550E-22  -3.35937311515537E-09  -3.54655229208019E-09  -2.90669657555618E-18
      6.22208244323274E-09
      0.00000000000000E+00   1.58799550631814E-13   0.00000000000000E+00   9.60684605607309E-14  -4.81120869133574E-23
     -1.58924869078432E-10  -1.58828800617919E-10  -1.27649478347362E-18  -1.20577665835621E-02  -1.20577665862502E-02
      0.00000000000000E+00   0.00000000000000E+00   2.68808847938868E-09   0.00000000000000E+00   2.68808847938868E-09
      4.23506429295020E-18  -3.05631433788951E-01  -3.04834526378237E-01   0.00000000000000E+00  -1.52490842838017E-10
     -1.43619266081446E-22  -2.37676883593261E-09  -2.52925967877077E-09  -2.95856950947659E-18
      6.24208244323274E-09
      0.00000000000000E+00   1.38042640022913E-13   0.00000000000000E+00   5.14234878860911E-14  -4.81148015987440E-23
     -1.38108242822530E-10  -1.38056819334692E-10  -1.27799108007032E-18  -1.08691619281932E-02  -1.08691619300239E-02
      0.00000000000000E+00   0.00000000000000E+00   1.83072600009612E-09   0.00000000000000E+00   1.83072600009612E-09
      4.27167881295213E-18  -3.27794363625582E-01  -3.27261046462311E-01   0.00000000000000E+00  -1.08093247999950E-10
     -1.47461427211635E-22  -1.58457593276139E-09  -1.69266918076149E-09  -2.99368773288180E-18
      6.26208244323274E-09
      0.00000000000000E+00   1.30603216309103E-13   0.00000000000000E+00   1.92876920983333E-14  -4.81162962123507E-23
     -1.30634829072276E-10  -1.30615541380226E-10  -1.27935318458092E-18  -1.00178977647517E-02  -1.00178977658992E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14752613628677E-09   0.00000000000000E+00   1.14752613628677E-09
      4.29462933567786E-18  -3.40090824552583E-01  -3.39770426527619E-01   0.00000000000000E+00  -6.14047545814910E-11
     -1.49579176722072E-22  -9.55505840324833E-10  -1.01691059490647E-09  -3.01527615109695E-18
      6.28208244323274E-09
      0.00000000000000E+00   1.15081455721031E-13   0.00000000000000E+00   4.12893485381627E-14  -4.81122320253085E-23
     -1.15144050128060E-10  -1.15102760779570E-10  -1.28041533707999E-18  -9.49512671787225E-03  -9.49512671859938E-03
      0.00000000000000E+00   0.00000000000000E+00   7.27136622926621E-10   0.00000000000000E+00   7.27136622926621E-10
      4.30917206813639E-18  -3.46550684462723E-01  -3.46357856630618E-01   0.00000000000000E+00  -3.05255539068596E-11
     -1.50618819567299E-22  -5.81508308240064E-10  -6.12033862147074E-10  -3.02875673105641E-18
      6.30208244323274E-09
      0.00000000000000E+00   8.54156056029999E-14   0.00000000000000E+00   8.08738065051179E-14  -4.80972441858442E-23
     -8.55105276456966E-11  -8.54296538392395E-11  -1.28089568830649E-18  -9.29784171838960E-03  -9.29784171910573E-03
      0.00000000000000E+00   0.00000000000000E+00   7.16128213763989E-10   0.00000000000000E+00   7.16128213763989E-10
      4.32349463241167E-18  -3.53789749223965E-01  -3.53591039904321E-01   0.00000000000000E+00  -3.40826365360162E-11
     -1.51746114060157E-22  -5.96615923388526E-10  -6.30698559924693E-10  -3.04259894410519E-18
      6.30458244323274E-09
      0.00000000000000E+00   9.84575582864687E-14   0.00000000000000E+00  -2.44076789313749E-13  -4.80970690170955E-23
     -9.81716393270133E-11  -9.84157161163751E-11  -1.28098835427424E-18  -9.25699701016305E-03  -9.25699701080699E-03
      0.00000000000000E+00   0.00000000000000E+00   6.43940333928297E-10   0.00000000000000E+00   6.43940333928297E-10
      4.32510448324650E-18  -3.54484256533699E-01  -3.54312384915242E-01   0.00000000000000E+00  -2.54316429209514E-11
     -1.51852951651744E-22  -5.20092974891389E-10  -5.45524617812492E-10  -3.04411612897226E-18
      6.30795744323274E-09
      0.00000000000000E+00   7.13633608102483E-14   0.00000000000000E+00   3.95805854127008E-13  -4.80921865503207E-23
     -7.17579123624222E-11  -7.13621065083433E-11  -1.28102249042154E-18  -9.25360376116348E-03  -9.25360376184297E-03
      0.00000000000000E+00   0.00000000000000E+00   6.79488070975745E-10   0.00000000000000E+00   6.79488070975745E-10
      4.32739775548604E-18  -3.55697786325982E-01  -3.55506188801963E-01   0.00000000000000E+00  -3.35346895877534E-11
     -1.52036040406352E-22  -5.74591274879673E-10  -6.08125964467578E-10  -3.04637526506450E-18
      6.31251369323274E-09
      0.00000000000000E+00   5.13412080990075E-14   0.00000000000000E+00   2.31887737207625E-13  -4.80852946311868E-23
     -5.15794105738979E-11  -5.13475228367383E-11  -1.28097814520970E-18  -9.28665807495140E-03  -9.28665807576741E-03
      0.00000000000000E+00   0.00000000000000E+00   8.16014314121662E-10   0.00000000000000E+00   8.16014314121662E-10
      4.33111572070476E-18  -3.57958732720457E-01  -3.57717810774840E-01   0.00000000000000E+00  -4.82831377309416E-11
     -1.52389426779093E-22  -7.16383653553668E-10  -7.64666791284762E-10  -3.05013757549506E-18
      6.31866463073274E-09
      0.00000000000000E+00   3.39825527667849E-14   0.00000000000000E+00   1.56050306330992E-13  -4.80747094123593E-23
     -3.41598802195960E-11  -3.40038299133131E-11  -1.28081334937045E-18  -9.35875143006595E-03  -9.35875143112919E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06324627755649E-09   0.00000000000000E+00   1.06324627755649E-09
      4.33765568210511E-18  -3.62341038678226E-01  -3.62016752024574E-01   0.00000000000000E+00  -7.26625340028368E-11
     -1.53104131740037E-22  -9.56579913640382E-10  -1.02924244764337E-09  -3.05684233273467E-18
      6.32281651354524E-09
      0.00000000000000E+00   2.15835132437688E-14   0.00000000000000E+00   1.66265121940555E-13  -4.80666173635794E-23
     -2.17119142582240E-11  -2.15456491363315E-11  -1.28065131156993E-18  -9.41981618271936E-03  -9.41981618397417E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25481005578974E-09   0.00000000000000E+00   1.25481005578974E-09
      4.34286550640870E-18  -3.65992955517210E-01  -3.65604383680372E-01   0.00000000000000E+00  -9.21897494297396E-11
     -1.53712330513698E-22  -1.14107465722343E-09  -1.23326440665332E-09  -3.06221419483877E-18
      6.32561903444368E-09
      0.00000000000000E+00   1.57972947996946E-14   0.00000000000000E+00   1.20820869051199E-13  -4.80610634202423E-23
     -1.59444814170408E-11  -1.58236605480377E-11  -1.28052635834622E-18  -9.46188368260133E-03  -9.46188368399065E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38932382741127E-09   0.00000000000000E+00   1.38932382741127E-09
      4.34675911546972E-18  -3.68773686853133E-01  -3.68340928126586E-01   0.00000000000000E+00  -1.05896422971659E-10
     -1.54181767762494E-22  -1.26760374389110E-09  -1.37350016686292E-09  -3.06623275712349E-18
      6.32940243765657E-09
      0.00000000000000E+00   1.79097237554677E-14   0.00000000000000E+00  -6.02346409778290E-15  -4.80543636691200E-23
     -1.78551891226185E-11  -1.78612125867643E-11  -1.28036627544917E-18  -9.50068588885035E-03  -9.50068589039673E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54638210163585E-09   0.00000000000000E+00   1.54638210163585E-09
      4.35260970248140E-18  -3.72968766883790E-01  -3.72487162988992E-01   0.00000000000000E+00  -1.20863176721537E-10
     -1.54902368813369E-22  -1.40765771232781E-09  -1.52852088904950E-09  -3.07224342703223E-18
      6.33451003199397E-09
      0.00000000000000E+00   2.74615764250505E-14   0.00000000000000E+00  -7.46536501277058E-14  -4.80466622484684E-23
     -2.73453902524778E-11  -2.74200439026535E-11  -1.28020068450651E-18  -9.50847396212048E-03  -9.50847396380659E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68611185150813E-09   0.00000000000000E+00   1.68611185150813E-09
      4.36122167782639E-18  -3.79102977674445E-01  -3.78580358539005E-01   0.00000000000000E+00  -1.34266754615706E-10
     -1.55976234229290E-22  -1.52442505298981E-09  -1.65869180760567E-09  -3.08102099331988E-18
      6.34140528434946E-09
      0.00000000000000E+00   3.96769264736516E-14   0.00000000000000E+00  -7.32264896629069E-14  -4.80378491325260E-23
     -3.96097584220763E-11  -3.96829849117872E-11  -1.28006481752861E-18  -9.45500413785021E-03  -9.45500413962509E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77488224241738E-09   0.00000000000000E+00   1.77488224241738E-09
      4.37345993878914E-18  -3.87736287469088E-01  -3.87189561684083E-01   0.00000000000000E+00  -1.44135974303714E-10
     -1.57516281090310E-22  -1.59106328320165E-09  -1.73519925750552E-09  -3.09339512126054E-18
      6.35071387502938E-09
      0.00000000000000E+00   5.30862581059505E-14   0.00000000000000E+00  -5.92069630753837E-14  -4.80282004808109E-23
     -5.30029383256309E-11  -5.30621452887543E-11  -1.28001150612810E-18  -9.30080593481862E-03  -9.30080593662171E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80309109149387E-09   0.00000000000000E+00   1.80309109149387E-09
      4.39024417571846E-18  -3.99445168921189E-01  -3.98893770198726E-01   0.00000000000000E+00  -1.50026025343317E-10
     -1.59647849927441E-22  -1.60000292086154E-09  -1.75002894620501E-09  -3.11023266959036E-18
      6.36328047244726E-09
      0.00000000000000E+00   7.34757897660214E-14   0.00000000000000E+00  -7.23916017878511E-14  -4.80202133139150E-23
     -7.34185054242075E-11  -7.34908970260434E-11  -1.28020576526995E-18  -8.93980844008301E-03  -8.93980844187289E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78987342800563E-09   0.00000000000000E+00   1.78987342800563E-09
      4.41273679451718E-18  -4.14839548981768E-01  -4.14298751335840E-01   0.00000000000000E+00  -1.53187657022697E-10
     -1.62528197117325E-22  -1.56319487395678E-09  -1.71638253097964E-09  -3.13253102924723E-18
      6.38024537896141E-09
      0.00000000000000E+00   1.13336405714088E-13   0.00000000000000E+00  -1.15430603822757E-13  -4.80226249013890E-23
     -1.13215831765624E-10  -1.13331262369495E-10  -1.28115898992097E-18  -8.05803537662955E-03  -8.05803537840122E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77167704984841E-09   0.00000000000000E+00   1.77167704984841E-09
      4.44279313004112E-18  -4.34596414419917E-01  -4.34073902706612E-01   0.00000000000000E+00  -1.55988136587109E-10
     -1.66389564179678E-22  -1.50235765089174E-09  -1.65834578747902E-09  -3.16163414012014E-18
      6.40024537896141E-09
      0.00000000000000E+00   1.59166929580644E-13   0.00000000000000E+00  -1.21203270582665E-13  -4.80420238692254E-23
     -1.59023312777429E-10  -1.59144516048060E-10  -1.28321625374516E-18  -6.48828998118545E-03  -6.48828998293750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75204748730259E-09   0.00000000000000E+00   1.75204748730259E-09
      4.47783407978717E-18  -4.56519660991816E-01  -4.56017768225903E-01   0.00000000000000E+00  -1.59611735044601E-10
     -1.70914312224329E-22  -1.43329123620980E-09  -1.59290297125457E-09  -3.19461782604201E-18
      6.42024537896141E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -4.27815152718319E-14  -4.80642340436854E-23
     -1.71945500260085E-10  -1.71988281775405E-10  -1.28554561944978E-18  -4.78534549631628E-03  -4.78534549800639E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69011346541723E-09   0.00000000000000E+00   1.69011346541723E-09
      4.51163634909552E-18  -4.77284644575594E-01  -4.76806311681017E-01   0.00000000000000E+00  -1.62057952294012E-10
     -1.75376203425379E-22  -1.35606723134763E-09  -1.51812518364182E-09  -3.22609072964573E-18
      6.44024537896141E-09
      0.00000000000000E+00   1.96731427098522E-13   0.00000000000000E+00  -7.66749321532342E-14  -4.80962878147467E-23
     -1.96712253324811E-10  -1.96788928257013E-10  -1.28838382232186E-18  -2.79955345054626E-03  -2.79955345220571E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65944589670333E-09   0.00000000000000E+00   1.65944589670333E-09
      4.54482526702958E-18  -4.97048060442385E-01  -4.96587203091840E-01   0.00000000000000E+00  -1.66135953575807E-10
     -1.79825503229598E-22  -1.29652101487041E-09  -1.46265696844639E-09  -3.25644144470772E-18
      6.46024537896141E-09
      0.00000000000000E+00  -1.28858166302160E-13   0.00000000000000E+00   8.42023183827452E-13  -4.79921471452553E-23
      1.28053752852650E-10   1.28895776036430E-10  -1.28473733859064E-18  -4.75966327572699E-03  -4.75966327680329E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07630674159224E-09   0.00000000000000E+00   1.07630674159224E-09
      4.56635140186143E-18  -5.16353001368694E-01  -5.15973266507212E-01   0.00000000000000E+00  -1.38300530746247E-10
     -1.83439273521349E-22  -1.06690198688219E-09  -1.20520251762862E-09  -3.28161406327079E-18
      6.48024537896141E-09
      0.00000000000000E+00  -2.03904501074430E-12   0.00000000000000E+00   5.04786550956386E-12  -4.71236407465555E-23
      2.03400550741837E-09   2.03905337292789E-09  -1.24310701611884E-18  -2.92698877257831E-02  -2.92698877237742E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.00898524435300E-09   0.00000000000000E+00  -2.00898524435300E-09
      4.52617169697437E-18  -5.37063657659199E-01  -5.37054215319750E-01   0.00000000000000E+00   3.78403110924712E-11
     -1.82444367300968E-22  -6.79084396671436E-11  -3.00681285748548E-11  -3.28306468085552E-18
      6.50024537896141E-09
      0.00000000000000E+00  -3.82505777048187E-12   0.00000000000000E+00   4.92848182501035E-12  -4.56818632333110E-23
      3.82014883604481E-09   3.82507731786978E-09  -1.16694960138571E-18  -7.23102974851622E-02  -7.23102974804062E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.75600995113720E-09   0.00000000000000E+00  -4.75600995113720E-09
      4.43105149795163E-18  -5.58530795419882E-01  -5.58824176507854E-01   0.00000000000000E+00   1.80611826708372E-10
     -1.77609685899105E-22   7.50320806559276E-10   9.30932633267470E-10  -3.26410189656591E-18
      6.50274537896141E-09
      0.00000000000000E+00  -4.44078488872113E-12   0.00000000000000E+00   1.25224269344854E-11  -4.54511984718418E-23
      4.42824873142229E-09   4.44077115835673E-09  -1.15593369175214E-18  -7.83730748227761E-02  -7.83730748171357E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.64041371051256E-09   0.00000000000000E+00  -5.64041371051256E-09
      4.41695046367534E-18  -5.61236398741611E-01  -5.61614450497887E-01   0.00000000000000E+00   2.15219243878663E-10
     -1.76882231893246E-22   9.84423308277103E-10   1.19964255215559E-09  -3.26101677192320E-18
      6.50612037896141E-09
      0.00000000000000E+00  -5.00278283569398E-12   0.00000000000000E+00   8.83078358955212E-12  -4.51322945740741E-23
      4.99396268428542E-09   5.00279346787493E-09  -1.13927178819112E-18  -8.74299793085781E-02  -8.74299793021149E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.46320077124804E-09   0.00000000000000E+00  -6.46320077124804E-09
      4.39513716107238E-18  -5.64946720560075E-01  -5.65406942178520E-01   0.00000000000000E+00   2.49708151149975E-10
     -1.75733815683559E-22   1.21069915222331E-09   1.46040730337310E-09  -3.25586537288126E-18
      6.51067662896141E-09
      0.00000000000000E+00  -5.60078391965219E-12   0.00000000000000E+00   7.07708226605844E-12  -4.46719459458562E-23
      5.59366842776823E-09   5.60074551003424E-09  -1.11434943082740E-18  -1.00762340282658E-01  -1.00762340275373E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28488604711883E-09   0.00000000000000E+00  -7.28488604711883E-09
      4.36194539902019E-18  -5.69991280556977E-01  -5.70522006829333E-01   0.00000000000000E+00   2.80153954180800E-10
     -1.73976368656878E-22   1.40398658290382E-09   1.68414053708445E-09  -3.24759596819279E-18
      6.51682756646141E-09
      0.00000000000000E+00  -6.22982852478654E-12   0.00000000000000E+00   5.63415334640022E-12  -4.40052411801366E-23
      6.22421118649749E-09   6.22984533984384E-09  -1.07776453041031E-18  -1.19888170335727E-01  -1.19888170327714E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.01356132271221E-09   0.00000000000000E+00  -8.01356132271221E-09
      4.31265448417177E-18  -5.76741717572320E-01  -5.77303835580161E-01   0.00000000000000E+00   2.99609266214836E-10
     -1.71402812904720E-22   1.48410671665397E-09   1.78371598286863E-09  -3.23488995376147E-18
      6.52513133208641E-09
      0.00000000000000E+00  -6.98616993569052E-12   0.00000000000000E+00   5.02932338469499E-12  -4.29038631287664E-23
      6.98118878848736E-09   6.98621811187201E-09  -1.02551700393167E-18  -1.46341241664405E-01  -1.46341241655860E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.54539240772782E-09   0.00000000000000E+00  -8.54539240772782E-09
      4.24169554844435E-18  -5.85487925363874E-01  -5.85979335388131E-01   0.00000000000000E+00   3.02414800790838E-10
     -1.67828826516871E-22   1.25675949506514E-09   1.55917429585581E-09  -3.21617854451268E-18
      6.53634141568016E-09
      0.00000000000000E+00  -8.48204517058951E-12   0.00000000000000E+00   7.02554595952194E-12  -3.96858000508422E-23
      8.47505667143739E-09   8.48208221739687E-09  -9.53274782419148E-19  -1.81410602385735E-01  -1.81410602376850E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.88518270034810E-09   0.00000000000000E+00  -8.88518270034810E-09
      4.14209190762771E-18  -5.95820313728119E-01  -5.95947594071021E-01   0.00000000000000E+00   2.91399037267187E-10
     -1.63060303281133E-22   1.11701445684314E-10   4.03100482951338E-10  -3.18881712520856E-18
      6.55147502853172E-09
      0.00000000000000E+00  -1.32553080080019E-11   0.00000000000000E+00   1.58760446661514E-11  -2.28397537711328E-23
      1.32394787753923E-08   1.32553548200584E-08  -8.58544903125953E-19  -2.25121269990352E-01  -2.25121269981167E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.18501949050341E-09   0.00000000000000E+00  -9.18501949050341E-09
      4.00308937862437E-18  -6.03314639168834E-01  -6.02032856397965E-01   0.00000000000000E+00   2.82665694050014E-10
     -1.56556647097183E-22  -4.35300102360494E-09  -4.07033532955508E-09  -3.14454447549842E-18
      6.57147502853172E-09
      0.00000000000000E+00  -2.77179150865967E-11   0.00000000000000E+00   3.58762076909066E-11   4.53797711247927E-23
      2.76819713190568E-08   2.77178475267477E-08  -7.52134237385526E-19  -2.72076584922517E-01  -2.72076584912796E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.72040093713354E-09   0.00000000000000E+00  -9.72040093713354E-09
      3.80868135988170E-18  -5.88198303855697E-01  -5.82529405951112E-01   0.00000000000000E+00   3.03810162904527E-10
     -1.46462009408422E-22  -1.83012567525184E-08  -1.79974465896141E-08  -3.05654712249617E-18
      6.59147502853173E-09
      0.00000000000000E+00  -4.79176955195969E-11   0.00000000000000E+00   5.00582402679017E-11   1.41562226313528E-22
      4.78675771963026E-08   4.79176354365706E-08  -6.75356731583059E-19  -3.05783770002736E-01  -3.05783769992320E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04158840611613E-08   0.00000000000000E+00  -1.04158840611613E-08
      3.60036367865847E-18  -5.36852899937226E-01  -5.25039391196185E-01   0.00000000000000E+00   3.17175481461526E-10
     -1.33514414537555E-22  -3.78189268568707E-08  -3.75017513754093E-08  -2.92500694707541E-18
      6.61147502853173E-09
      0.00000000000000E+00  -6.30690462825110E-11   0.00000000000000E+00   3.77110899419943E-11   2.12478980544486E-22
      6.30314188596812E-08   6.30691299496234E-08  -6.27591123778683E-19  -3.27886030097870E-01  -3.27886030086837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10326813197792E-08   0.00000000000000E+00  -1.10326813197792E-08
      3.37971005226289E-18  -4.50219890022948E-01  -4.33826711111381E-01   0.00000000000000E+00   2.90662246578182E-10
     -1.17576084395229E-22  -5.23271108764222E-08  -5.20364486298442E-08  -2.75211892848420E-18
      6.63147502853173E-09
      0.00000000000000E+00  -6.47395183628415E-11   0.00000000000000E+00   4.26324347080764E-12   2.21143938761348E-22
      6.47352869321307E-08   6.47395501756018E-08  -6.05289689650797E-19  -3.40113941573397E-01  -3.40113941561810E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15865511460950E-08   0.00000000000000E+00  -1.15865511460950E-08
      3.14797902934099E-18  -3.33880918320466E-01  -3.17135229590487E-01   0.00000000000000E+00   2.41758398500189E-10
     -1.01269029772820E-22  -5.33947574280068E-08  -5.31529990295068E-08  -2.54268933969019E-18
      6.65147502853173E-09
      0.00000000000000E+00  -5.62181636447271E-11   0.00000000000000E+00  -2.10491954433358E-11   1.82159208933932E-22
      5.62392176731760E-08   5.62181684777329E-08  -5.97984581558126E-19  -3.46605832008397E-01  -3.46605831996476E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19204004260576E-08   0.00000000000000E+00  -1.19204004260576E-08
      2.90957102081984E-18  -2.11481343198010E-01  -1.97525074529718E-01   0.00000000000000E+00   1.66244708169233E-10
     -8.32392910881684E-23  -4.44640127598444E-08  -4.42977680516753E-08  -2.31158643926171E-18
      6.67147502853173E-09
      0.00000000000000E+00  -4.90512432662122E-11   0.00000000000000E+00  -1.77821290705197E-11   1.42745017215680E-22
      4.90690188257972E-08   4.90512366967268E-08  -5.88748438211003E-19  -3.53904978842094E-01  -3.53904978830268E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18265687653179E-08   0.00000000000000E+00  -1.18265687653179E-08
      2.67303964551348E-18  -1.11203597484016E-01  -9.94755253825664E-02   0.00000000000000E+00   8.83324026499171E-11
     -7.26414508597243E-23  -3.73130003340588E-08  -3.72246679314090E-08  -2.08429120730248E-18
      6.67397502853173E-09
      0.00000000000000E+00  -4.73957418780465E-11   0.00000000000000E+00  -3.25407739983408E-11   1.36753520248083E-22
      4.74282504810373E-08   4.73957097070391E-08  -5.88085200339714E-19  -3.54609719651025E-01  -3.54609719639121E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19035830389172E-08   0.00000000000000E+00  -1.19035830389172E-08
      2.64328068791619E-18  -9.91247089261374E-02  -8.79424727120866E-02   0.00000000000000E+00   8.41404898702997E-11
     -6.96224982267005E-23  -3.55762671579917E-08  -3.54921266681214E-08  -2.05519548757647E-18
      6.67735002853173E-09
      0.00000000000000E+00  -4.56942262765399E-11   0.00000000000000E+00  -2.50946043866474E-11   1.29234773008718E-22
      4.57193166481480E-08   4.56942220437615E-08  -5.86493052238121E-19  -3.55841654651499E-01  -3.55841654639672E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18270337376450E-08   0.00000000000000E+00  -1.18270337376450E-08
      2.60336444905163E-18  -8.44304597188902E-02  -7.37601562275918E-02   0.00000000000000E+00   6.68689212007403E-11
     -6.31395374442966E-23  -3.39340572273168E-08  -3.38671883061161E-08  -2.01687139681351E-18
      6.68190627853173E-09
      0.00000000000000E+00  -4.34987696783312E-11   0.00000000000000E+00  -2.38766450569356E-11   1.21574178784261E-22
      4.35226071327494E-08   4.34987304876926E-08  -5.82531008391400E-19  -3.58139494191803E-01  -3.58139494180158E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16443840228333E-08   0.00000000000000E+00  -1.16443840228333E-08
      2.55030972434760E-18  -6.75471774248054E-02  -5.75110228905341E-02   0.00000000000000E+00   5.68444121965297E-11
     -4.78600183687454E-23  -3.19111908770559E-08  -3.18543464648594E-08  -1.96777871595620E-18
      6.68805721603173E-09
      0.00000000000000E+00  -4.05116114453936E-11   0.00000000000000E+00  -2.40246941823559E-11   1.16544770396906E-22
      4.05356524731536E-08   4.05116277789713E-08  -5.73222160960573E-19  -3.62586195467782E-01  -3.62586195456449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13322017475854E-08   0.00000000000000E+00  -1.13322017475854E-08
      2.48060605966081E-18  -5.02935170573997E-02  -4.11001111284574E-02   0.00000000000000E+00   4.75938796948602E-11
     -1.50584033756774E-23  -2.92270199110805E-08  -2.91794260313856E-08  -1.90738389870024E-18
      6.69220909884423E-09
      0.00000000000000E+00  -3.83152363998128E-11   0.00000000000000E+00  -2.61284857186522E-11   1.15676726322490E-22
      3.83413569626865E-08   3.83152284769679E-08  -5.64831837458245E-19  -3.66280804835311E-01  -3.66280804824220E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10910529640041E-08   0.00000000000000E+00  -1.10910529640041E-08
      2.43455730748704E-18  -4.13920789229915E-02  -3.28146920505424E-02   0.00000000000000E+00   4.34249896154291E-11
      1.23881449502252E-23  -2.72676005025794E-08  -2.72241755129640E-08  -1.86972547002879E-18
      6.69781414064110E-09
      0.00000000000000E+00  -3.60148931117130E-11   0.00000000000000E+00  -2.03136554862882E-11   1.18642851633373E-22
      3.60352248073429E-08   3.60149111518567E-08  -5.50557286736504E-19  -3.72276089382511E-01  -3.72276089371713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07977790221007E-08   0.00000000000000E+00  -1.07977790221007E-08
      2.37403530475474E-18  -3.32283394313257E-02  -2.52832891204896E-02   0.00000000000000E+00   3.31967572951176E-11
      4.79207220043601E-23  -2.52503288870517E-08  -2.52171321297565E-08  -1.82347801801824E-18
      6.70538094706688E-09
      0.00000000000000E+00  -3.39946762720963E-11   0.00000000000000E+00  -1.31984817201335E-11   1.26552571511346E-22
      3.40078825771178E-08   3.39946840953978E-08  -5.28390582133035E-19  -3.81355112439528E-01  -3.81355112429001E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05273921188186E-08   0.00000000000000E+00  -1.05273921188186E-08
      2.29437656642335E-18  -2.65510539486960E-02  -1.91573057477870E-02   0.00000000000000E+00   2.31160442634607E-11
      8.94122136301290E-23  -2.34904080208426E-08  -2.34672919765790E-08  -1.76598598429031E-18
      6.71559613574169E-09
      0.00000000000000E+00  -3.24611446949422E-11   0.00000000000000E+00  -7.39500455364045E-12   1.37543769529584E-22
      3.24684956488080E-08   3.24611006442545E-08  -4.96857281855250E-19  -3.94144666913585E-01  -3.94144666903264E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03211253089908E-08   0.00000000000000E+00  -1.03211253089908E-08
      2.18894432405570E-18  -2.14839237157042E-02  -1.45083568129666E-02   0.00000000000000E+00   1.53156614351836E-11
      1.32886323597048E-22  -2.21552909966990E-08  -2.21399753352637E-08  -1.69208704220045E-18
      6.72938664045267E-09
      0.00000000000000E+00  -3.12753372928558E-11   0.00000000000000E+00  -4.20930328969910E-12   1.44828446807972E-22
      3.12794892396654E-08   3.12752799363758E-08  -4.54946783460899E-19  -4.11168627050689E-01  -4.11168627040526E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01639521712268E-08   0.00000000000000E+00  -1.01639521712268E-08
      2.04877829375616E-18  -1.76847868846177E-02  -1.10333026080633E-02   0.00000000000000E+00   1.05678231162818E-11
      1.68374875430103E-22  -2.11218955882656E-08  -2.11113277651491E-08  -1.59383151029526E-18
      6.74800382181251E-09
      0.00000000000000E+00  -3.00671197748908E-11   0.00000000000000E+00  -3.16443123195039E-12   1.36481651431671E-22
      3.00702979402892E-08   3.00671335090574E-08  -4.01801315149997E-19  -4.32994041070639E-01  -4.32994041060633E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00061889292922E-08   0.00000000000000E+00  -1.00061889292922E-08
      1.86249125973879E-18  -1.47166399317623E-02  -8.39608811781846E-03   0.00000000000000E+00   8.15622726339871E-12
      1.76779661998948E-22  -2.00691008070287E-08  -2.00609445797651E-08  -1.46068994458879E-18
      6.76800382181251E-09
      0.00000000000000E+00  -2.88126125093732E-11   0.00000000000000E+00  -3.06153331208227E-12   1.10376636953649E-22
      2.88156601765811E-08   2.88125986432691E-08  -3.49028159707590E-19  -4.55013897768152E-01  -4.55013897758300E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85224209727138E-09   0.00000000000000E+00  -9.85224209727138E-09
      1.66544641779336E-18  -1.26647246267670E-02  -6.69092581494567E-03   0.00000000000000E+00   7.01807423395010E-12
      1.49445751265875E-22  -1.89673746202318E-08  -1.89603565459977E-08  -1.31641825808577E-18
      6.78800382181251E-09
      0.00000000000000E+00  -2.77428968551172E-11   0.00000000000000E+00  -2.61059993687899E-12   7.78043040997521E-23
      2.77455161770166E-08   2.77429055770798E-08  -2.99923622874589E-19  -4.75856917492061E-01  -4.75856917482344E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71763394938238E-09   0.00000000000000E+00  -9.71763394938238E-09
      1.47109373880571E-18  -1.12828751319873E-02  -5.60368644495155E-03   0.00000000000000E+00   5.89417233525988E-12
      1.05301216879183E-22  -1.80311658000329E-08  -1.80252716276975E-08  -1.17117011593112E-18
      6.80800382181251E-09
      0.00000000000000E+00  -2.68723005911270E-11   0.00000000000000E+00  -2.12271805232294E-12   4.86027338387183E-23
      2.68743832241711E-08   2.68722605061188E-08  -2.53993517001335E-19  -4.95695810914531E-01  -4.95695810904952E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.57939757677884E-09   0.00000000000000E+00  -9.57939757677884E-09
      1.27950578727013E-18  -1.03205236992029E-02  -4.87208955172228E-03   0.00000000000000E+00   4.88217522040372E-12
      6.28204393610937E-23  -1.72977451045604E-08  -1.72928629293399E-08  -1.02551227026880E-18
      6.82800382181251E-09
      0.00000000000000E+00  -2.63283960573840E-11   0.00000000000000E+00  -1.31868646864353E-12   2.77376179717469E-23
      2.63297700391743E-08   2.63284513527057E-08  -2.10260072044757E-19  -5.14955838020876E-01  -5.14955838011286E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59056088824201E-09   0.00000000000000E+00  -9.59056088824201E-09
      1.08769456950529E-18  -9.64425151198064E-03  -4.37066823549676E-03   0.00000000000000E+00   4.09167709521927E-12
      3.17733712711320E-23  -1.67419821415589E-08  -1.67378904644637E-08  -8.77434497460537E-19
      6.84800382181251E-09
      0.00000000000000E+00  -2.71423241185171E-11   0.00000000000000E+00   2.02986363608091E-12   1.55183511268452E-23
      2.71403349836606E-08   2.71423648472967E-08  -1.64564789009205E-19  -5.35599054151835E-01  -5.35599054141293E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05424225011012E-08   0.00000000000000E+00  -1.05424225011012E-08
      8.76846119483270E-19  -9.36172903210862E-03  -4.13160572592857E-03   0.00000000000000E+00   2.99932317465113E-12
      1.33676886327685E-23  -1.66029416693701E-08  -1.65999423461955E-08  -7.12281330474066E-19
      6.85800382181251E-09
      0.00000000000000E+00  -2.77150678997433E-11   0.00000000000000E+00   2.85287416589212E-12   1.12134465469371E-23
      2.77122282400785E-08   2.77150811142444E-08  -1.41509577004506E-19  -5.46226678244350E-01  -5.46226678233239E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11117807397446E-08   0.00000000000000E+00  -1.11117807397446E-08
      7.65728312085825E-19  -9.28681051070312E-03  -4.05562798349834E-03   0.00000000000000E+00   2.55326180265982E-12
      6.89687171669361E-24  -1.66058536363028E-08  -1.66033003745001E-08  -6.24218735081320E-19
      6.86137882181251E-09
      0.00000000000000E+00  -2.79544152849061E-11   0.00000000000000E+00   3.52200793126407E-12   9.96270675536074E-24
      2.79509456147374E-08   2.79544676226686E-08  -1.33722886756547E-19  -5.49851021150433E-01  -5.49851021139097E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13365882409888E-08   0.00000000000000E+00  -1.13365882409888E-08
      7.27467326772488E-19  -9.27387748139686E-03  -4.03810111662194E-03   0.00000000000000E+00   2.31439971869706E-12
      5.01657889461578E-24  -1.66201937813981E-08  -1.66178793816794E-08  -5.93744440015939E-19
      6.86593507181251E-09
      0.00000000000000E+00  -2.82995678073320E-11   0.00000000000000E+00   3.76681417913786E-12   8.67685327268929E-24
      2.82957645544798E-08   2.82995313686589E-08  -1.23119988799187E-19  -5.54812739935344E-01  -5.54812739923783E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15605968263234E-08   0.00000000000000E+00  -1.15605968263234E-08
      6.74794357482552E-19  -9.29912102848500E-03  -4.02520305237713E-03   0.00000000000000E+00   1.21699623763121E-12
      3.11109548536938E-24  -1.67401515385736E-08  -1.67389345423360E-08  -5.51674368683366E-19
      6.87208600931251E-09
      0.00000000000000E+00  -2.87881818092760E-11   0.00000000000000E+00   3.95173445136580E-12   7.47834457552984E-24
      2.87842681497292E-08   2.87882198841806E-08  -1.08717557580182E-19  -5.61602391347366E-01  -5.61602391335555E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18111318094815E-08   0.00000000000000E+00  -1.18111318094815E-08
      6.02144823918169E-19  -9.36637654442604E-03  -4.01742284115315E-03   0.00000000000000E+00   5.92148184558196E-13
      1.35276104122418E-24  -1.69776802228837E-08  -1.69770880746992E-08  -4.93427266337987E-19
      6.87623789212501E-09
      0.00000000000000E+00  -2.91382021027739E-11   0.00000000000000E+00   4.18949205431887E-12   6.84915312296380E-24
      2.91339814346184E-08   2.91381709266728E-08  -9.90073485518548E-20  -5.66213911152535E-01  -5.66213911140562E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19736279998514E-08   0.00000000000000E+00  -1.19736279998514E-08
      5.52431723622317E-19  -9.42536616430732E-03  -4.01735061393130E-03   0.00000000000000E+00   2.41253334858154E-13
      4.28645506710320E-25  -1.71647841801561E-08  -1.71645429268212E-08  -4.53424375070462E-19
      6.87904041302344E-09
      0.00000000000000E+00  -2.93571599562766E-11   0.00000000000000E+00   3.89324076005765E-12   6.49062773362790E-24
      2.93532475340368E-08   2.93571407747968E-08  -9.24725570138714E-20  -5.69331481591638E-01  -5.69331481579578E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20602057940231E-08   0.00000000000000E+00  -1.20602057940231E-08
      5.18632744845110E-19  -9.46643023060702E-03  -4.01670165794989E-03   0.00000000000000E+00   1.10848513580986E-13
     -9.03235269482930E-26  -1.72970458292873E-08  -1.72969349807738E-08  -4.26160187831239E-19
      6.88282381623633E-09
      0.00000000000000E+00  -2.95537076939008E-11   0.00000000000000E+00   2.61066993426438E-12   6.10076868035668E-24
      2.95511236514561E-08   2.95537343213904E-08  -8.37096563607991E-20  -5.73525695195548E-01  -5.73525695183446E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21014610390104E-08   0.00000000000000E+00  -1.21014610390104E-08
      4.72848038269448E-19  -9.50444541483550E-03  -4.00577420318731E-03   0.00000000000000E+00   3.79578711216111E-13
     -6.17042386573514E-25  -1.74526528610908E-08  -1.74522732823796E-08  -3.89138381908648E-19
      6.88793141057374E-09
      0.00000000000000E+00  -2.96153355125670E-11   0.00000000000000E+00   6.39701803746023E-13   5.68485133618770E-24
      2.96147144781070E-08   2.96153541799107E-08  -7.21127516802040E-20  -5.79098997308719E-01  -5.79098997296694E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20241680245035E-08   0.00000000000000E+00  -1.20241680245035E-08
      4.11433465755519E-19  -9.51180814140713E-03  -3.96936939973311E-03   0.00000000000000E+00   9.97054039214045E-13
     -1.10650306533495E-24  -1.75921832094465E-08  -1.75911861554073E-08  -3.39320714075315E-19
      6.89482666292923E-09
      0.00000000000000E+00  -2.93577110246999E-11   0.00000000000000E+00  -1.80695159464083E-12   5.23566495862142E-24
      2.93595348612709E-08   2.93577279096762E-08  -5.71673800563063E-20  -5.86319322106690E-01  -5.86319322095013E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16774457984190E-08   0.00000000000000E+00  -1.16774457984190E-08
      3.30914530107827E-19  -9.45832812715875E-03  -3.88781741778212E-03   0.00000000000000E+00   1.57613075767576E-12
     -1.52207751033398E-24  -1.76818582420149E-08  -1.76802821112572E-08  -2.73747150051521E-19
      6.90413525360914E-09
      0.00000000000000E+00  -2.83393365785428E-11   0.00000000000000E+00  -5.36939017228000E-12   4.70789742174607E-24
      2.83447385049463E-08   2.83393691147740E-08  -3.91876679410540E-20  -5.95049873735228E-01  -5.95049873724599E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06293275190370E-08   0.00000000000000E+00  -1.06293275190370E-08
      2.31970471030346E-19  -9.30466500654210E-03  -3.72477709065472E-03   0.00000000000000E+00   1.79634229779518E-12
     -1.84961319084372E-24  -1.77118379380347E-08  -1.77100415957369E-08  -1.92782803089292E-19
      6.91670185102703E-09
      0.00000000000000E+00  -2.50734295681804E-11   0.00000000000000E+00  -1.28013514742843E-11   3.92111637079626E-24
      2.50862396280896E-08   2.50734382766153E-08  -2.27934412139816E-20  -6.02957836449733E-01  -6.02957836442361E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.37309366892127E-09   0.00000000000000E+00  -7.37309366892127E-09
      1.39315771168646E-19  -8.94537398467787E-03  -3.36854000656953E-03   0.00000000000000E+00   1.35608816849714E-12
     -2.11518839428351E-24  -1.77017006958626E-08  -1.77003446076941E-08  -1.16522329954665E-19
      6.93366675754118E-09
      0.00000000000000E+00  -1.51676072813998E-11   0.00000000000000E+00  -2.87879933983765E-11   2.30603096568230E-24
      1.51964799757449E-08   1.51676919823465E-08  -3.09538424590862E-20  -5.98362107794430E-01  -5.98362107796953E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52307732993457E-09   0.00000000000000E+00   2.52307732993457E-09
      1.82119542198949E-19  -8.06715835703820E-03  -2.49333975134223E-03   0.00000000000000E+00  -3.91422330230424E-13
     -2.46704457328860E-24  -1.76903778899509E-08  -1.76907693122811E-08  -1.51165699739863E-19
      6.95366675754118E-09
      0.00000000000000E+00   3.23734329709090E-12   0.00000000000000E+00  -4.53634319955433E-11  -9.16862647708670E-25
     -3.19201463905218E-09  -3.23737807104772E-09  -1.10611635567540E-19  -5.58935510384775E-01  -5.58935510405700E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09243785423292E-08   0.00000000000000E+00   2.09243785423292E-08
      6.00607113045533E-19  -6.49988649431851E-03  -9.27254698140446E-04   0.00000000000000E+00  -3.94895445310684E-12
     -3.78231494131935E-24  -1.76830515168284E-08  -1.76870004712815E-08  -4.89995477477993E-19
      6.97366675754118E-09
      0.00000000000000E+00   1.98391979947234E-11   0.00000000000000E+00  -4.10504277502887E-11  -8.09761148703691E-24
     -1.97981642704148E-08  -1.98392146981651E-08  -2.78451839464233E-19  -4.83045455252022E-01  -4.83045455289503E-01
      0.00000000000000E+00   0.00000000000000E+00   3.74816255608841E-08   0.00000000000000E+00   3.74816255608841E-08
      1.35023962426322E-18  -4.79672365725134E-03   7.61856359146186E-04   0.00000000000000E+00  -9.39508505397494E-12
     -1.21033777427599E-23  -1.76330157776650E-08  -1.76424108627190E-08  -1.07178778479898E-18
      6.99366675754118E-09
      0.00000000000000E+00   2.48040489539507E-11   0.00000000000000E+00  -1.25619958754453E-11  -3.01414209848019E-23
     -2.47914768886834E-08  -2.48040388845589E-08  -5.44790305115795E-19  -3.75285370238002E-01  -3.75285370280437E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24346932978188E-08   0.00000000000000E+00   4.24346932978188E-08
      2.19893349021959E-18  -2.81718395282634E-03   2.73768256891557E-03   0.00000000000000E+00  -2.10842549638220E-11
     -5.22900110536017E-23  -1.76095701582962E-08  -1.76306544132600E-08  -1.65414318510380E-18
      7.01366675754118E-09
      0.00000000000000E+00   1.68334871248699E-11   0.00000000000000E+00   1.90903132400922E-11  -4.19927990630091E-23
     -1.68525268129600E-08  -1.68334364997200E-08  -8.42677482304835E-19  -2.50054925010967E-01  -2.50054925044840E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38731496771484E-08   0.00000000000000E+00   3.38731496771484E-08
      2.87639648376256E-18  -4.70014685108435E-03   6.68515070239570E-04   0.00000000000000E+00  -4.75269914043347E-11
     -7.84284470738120E-23  -1.69921861860240E-08  -1.70397131774284E-08  -2.03371900145772E-18
      7.03366675754118E-09
      0.00000000000000E+00   1.10122758359197E-11   0.00000000000000E+00   1.36059021661130E-11  -4.51941053278117E-23
     -1.10258493373560E-08  -1.10122434351899E-08  -1.06119157873012E-18  -1.41337733038804E-01  -1.41337733063530E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47256910714921E-08   0.00000000000000E+00   2.47256910714921E-08
      3.37091030519240E-18  -2.91135014672435E-02  -2.47928453149737E-02   0.00000000000000E+00  -9.01987719624689E-11
     -9.09744000350984E-23  -1.36232488643397E-08  -1.37134476363023E-08  -2.30971872646228E-18
      7.04366675754118E-09
      0.00000000000000E+00   8.46193117314106E-12   0.00000000000000E+00   1.16754045370102E-11  -4.64421752120640E-23
     -8.47362883818234E-09  -8.46195343364538E-09  -1.14523719426284E-18  -9.49025964974247E-02  -9.49025965175778E-02
      0.00000000000000E+00   0.00000000000000E+00   2.01530850040966E-08   0.00000000000000E+00   2.01530850040966E-08
      3.57244115523337E-18  -4.76599243702944E-02  -4.39764147933769E-02   0.00000000000000E+00  -1.39150908303622E-10
     -9.77242569558502E-23  -1.15519806621474E-08  -1.16911315704511E-08  -2.42720396097053E-18
      7.05041675754118E-09
      0.00000000000000E+00   6.66232539229678E-12   0.00000000000000E+00   1.22729098928890E-11  -4.70975052228786E-23
     -6.67455873025379E-09  -6.66228582036094E-09  -1.18975532185229E-18  -6.90948376896632E-02  -6.90948377066439E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69807650859449E-08   0.00000000000000E+00   1.69807650859449E-08
      3.68706131956350E-18  -6.28838023228846E-02  -5.96327615810244E-02   0.00000000000000E+00  -1.64343849006775E-10
     -1.02185409548472E-22  -1.01541354165771E-08  -1.03184792655839E-08  -2.49730599771121E-18
      7.05952925754118E-09
      0.00000000000000E+00   4.36583958315978E-12   0.00000000000000E+00   1.17885270370684E-11  -4.76344752391335E-23
     -4.37758337973365E-09  -4.36579485269663E-09  -1.22888129260937E-18  -4.55250828002166E-02  -4.55250828132334E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30168033069357E-08   0.00000000000000E+00   1.30168033069357E-08
      3.80567693969795E-18  -8.74873696199253E-02  -8.47616966362051E-02   0.00000000000000E+00  -1.72628806307626E-10
     -1.07716168450028E-22  -8.47837964793135E-09  -8.65100845423908E-09  -2.57679564708858E-18
      7.06260472629118E-09
      0.00000000000000E+00   3.38980556085540E-12   0.00000000000000E+00   1.50642311449019E-11  -4.77513210369363E-23
     -3.40484468350770E-09  -3.38978045236285E-09  -1.23908264757701E-18  -3.92456981926819E-02  -3.92456982039810E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12991444035308E-08   0.00000000000000E+00   1.12991444035308E-08
      3.84042710521274E-18  -9.63494052181635E-02  -9.38573929899203E-02   0.00000000000000E+00  -1.79573696962120E-10
     -1.09531198290044E-22  -7.72979025420549E-09  -7.90936395116772E-09  -2.60134445763573E-18
      7.06675660910368E-09
      0.00000000000000E+00   2.40118880955358E-12   0.00000000000000E+00   1.14030151122424E-11  -4.78579487373618E-23
     -2.41260567687121E-09  -2.40120266175901E-09  -1.24874861171879E-18  -3.31546128083916E-02  -3.31546128179594E-02
      0.00000000000000E+00   0.00000000000000E+00   9.56780832666836E-09   0.00000000000000E+00   9.56780832666836E-09
      3.88015152415753E-18  -1.09011961623065E-01  -1.06753969281277E-01   0.00000000000000E+00  -1.78795721592072E-10
     -1.11844495587482E-22  -6.98780994331720E-09  -7.16660566490939E-09  -2.63140291243875E-18
      7.07236165090055E-09
      0.00000000000000E+00   1.55116576669792E-12   0.00000000000000E+00   7.27160937277983E-12  -4.79452595103485E-23
     -1.55842967190018E-09  -1.55115806252745E-09  -1.25703419332785E-18  -2.77359502456267E-02  -2.77359502536394E-02
      0.00000000000000E+00   0.00000000000000E+00   8.01268393475183E-09   0.00000000000000E+00   8.01268393475183E-09
      3.92506295251697E-18  -1.26748235452107E-01  -1.24712391997123E-01   0.00000000000000E+00  -1.79348914788738E-10
     -1.14797068729175E-22  -6.28217695743545E-09  -6.46152587222430E-09  -2.66802875918912E-18
      7.07992845732633E-09
      0.00000000000000E+00   9.30662722123869E-13   0.00000000000000E+00   3.92791931139022E-12  -4.80108910128169E-23
     -9.34598054186330E-10  -9.30670134874988E-10  -1.26353092271552E-18  -2.32206829238814E-02  -2.32206829306426E-02
      0.00000000000000E+00   0.00000000000000E+00   6.76113005940065E-09   0.00000000000000E+00   6.76113005940065E-09
      3.97622311489598E-18  -1.50938462391487E-01  -1.49101447998283E-01   0.00000000000000E+00  -1.83494852582280E-10
     -1.18607543065735E-22  -5.64696507194317E-09  -5.83045992452557E-09  -2.71269219218046E-18
      7.09014364600114E-09
      0.00000000000000E+00   5.39220452145390E-13   0.00000000000000E+00   1.83074716317430E-12  -4.80566589120848E-23
     -5.41053455874939E-10  -5.39222708711813E-10  -1.26831825309095E-18  -1.95564925674203E-02  -1.95564925732031E-02
      0.00000000000000E+00   0.00000000000000E+00   5.78279118235359E-09   0.00000000000000E+00   5.78279118235359E-09
      4.03529541789072E-18  -1.82871800120871E-01  -1.81219696291527E-01   0.00000000000000E+00  -1.91282817006524E-10
     -1.23559424627684E-22  -5.05228565663528E-09  -5.24356847364192E-09  -2.76697716479977E-18
      7.10393415071213E-09
      0.00000000000000E+00   3.17323567052005E-13   0.00000000000000E+00   7.67313798598334E-13  -4.80855159850493E-23
     -3.18101353636434E-10  -3.17334039837884E-10  -1.27174952688089E-18  -1.65573231826569E-02  -1.65573231875577E-02
      0.00000000000000E+00   0.00000000000000E+00   4.90075319336786E-09   0.00000000000000E+00   4.90075319336786E-09
      4.10287927789124E-18  -2.22907735230763E-01  -2.21463622899898E-01   0.00000000000000E+00  -1.98350409077475E-10
     -1.29865976305562E-22  -4.38506874445237E-09  -4.58341915352998E-09  -2.83112975101035E-18
      7.12255133207196E-09
      0.00000000000000E+00   2.06926192928558E-13   0.00000000000000E+00   2.83080864032747E-13  -4.81025951152079E-23
     -2.07148407794535E-10  -2.06865326930551E-10  -1.27436724153607E-18  -1.40233083522444E-02  -1.40233083561081E-02
      0.00000000000000E+00   0.00000000000000E+00   3.86366675577899E-09   0.00000000000000E+00   3.86366675577899E-09
      4.17480986259753E-18  -2.67763466957741E-01  -2.66611303285005E-01   0.00000000000000E+00  -1.89446557370429E-10
     -1.37189668429249E-22  -3.46735487147780E-09  -3.65680142884837E-09  -2.90044262106146E-18
      7.14255133207196E-09
      0.00000000000000E+00   1.62105961171285E-13   0.00000000000000E+00   1.07300724736749E-13  -4.81113713079989E-23
     -1.62214497786014E-10  -1.62107197061325E-10  -1.27631893651472E-18  -1.22064324556319E-02  -1.22064324584200E-02
      0.00000000000000E+00   0.00000000000000E+00   2.78808024927035E-09   0.00000000000000E+00   2.78808024927035E-09
      4.23057146758294E-18  -3.02815751591694E-01  -3.01988372325650E-01   0.00000000000000E+00  -1.56688171798542E-10
     -1.43134179361869E-22  -2.46928488041031E-09  -2.62597305220900E-09  -2.95425253106822E-18
      7.16255133207196E-09
      0.00000000000000E+00   1.39695845292648E-13   0.00000000000000E+00   5.53263729845054E-14  -4.81144847696945E-23
     -1.39724470864185E-10  -1.39669144491248E-10  -1.27784569046238E-18  -1.09711698931512E-02  -1.09711698950586E-02
      0.00000000000000E+00   0.00000000000000E+00   1.90744916286737E-09   0.00000000000000E+00   1.90744916286737E-09
      4.26872045084029E-18  -3.26045354183467E-01  -3.25488371152959E-01   0.00000000000000E+00  -1.12692016817453E-10
     -1.47157665570534E-22  -1.65508800155854E-09  -1.76778001837614E-09  -2.99087476037791E-18
      7.18255133207196E-09
      0.00000000000000E+00   1.30970595257933E-13   0.00000000000000E+00   2.23536366367505E-14  -4.81159838812954E-23
     -1.31004164934691E-10  -1.30981811298102E-10  -1.27921407842388E-18  -1.00928783532070E-02  -1.00928783544165E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20950060135524E-09   0.00000000000000E+00   1.20950060135524E-09
      4.29291046286739E-18  -3.39256933836240E-01  -3.38917124088027E-01   0.00000000000000E+00  -6.60179480982358E-11
     -1.49438428124624E-22  -1.01250084195886E-09  -1.07851879005724E-09  -3.01369638444351E-18
      7.20255133207196E-09
      0.00000000000000E+00   1.18204176786087E-13   0.00000000000000E+00   3.40302167871840E-14  -4.81131611237721E-23
     -1.18254824851125E-10  -1.18220794634386E-10  -1.28033763802662E-18  -9.52787736503136E-03  -9.52787736577913E-03
      0.00000000000000E+00   0.00000000000000E+00   7.47775925620382E-10   0.00000000000000E+00   7.47775925620382E-10
      4.30786598137980E-18  -3.45931329422459E-01  -3.45732980937070E-01   0.00000000000000E+00  -3.17817467624238E-11
     -1.50522934996251E-22  -5.97773384223262E-10  -6.29555130985837E-10  -3.02752834335317E-18
      7.22255133207196E-09
      0.00000000000000E+00   8.74361898215655E-14   0.00000000000000E+00   8.32517471240257E-14  -4.80987672463036E-23
     -8.75350746996580E-11  -8.74518229525820E-11  -1.28085728171591E-18  -9.31292496299725E-03  -9.31292496370497E-03
      0.00000000000000E+00   0.00000000000000E+00   7.07716687812694E-10   0.00000000000000E+00   7.07716687812694E-10
      4.32202031513605E-18  -3.52977649290787E-01  -3.52782227519145E-01   0.00000000000000E+00  -3.30286732721093E-11
     -1.51618265768755E-22  -5.87236191587900E-10  -6.20264864860161E-10  -3.04116303342015E-18
      7.24255133207196E-09
      0.00000000000000E+00   6.09849055057978E-14   0.00000000000000E+00   7.69030771322003E-14  -4.80759015303198E-23
     -6.10424769528839E-11  -6.09655738757998E-11  -1.28086314273129E-18  -9.27066013215530E-03  -9.27066013313135E-03
      0.00000000000000E+00   0.00000000000000E+00   9.76054931821366E-10   0.00000000000000E+00   9.76054931821366E-10
      4.34154141377248E-18  -3.64963211387769E-01  -3.64674894040554E-01   0.00000000000000E+00  -6.08925631747116E-11
     -1.53580828838922E-22  -8.54196794770739E-10  -9.15089357945605E-10  -3.06067827104119E-18
      7.24505133207196E-09
      0.00000000000000E+00   4.03198396341042E-14   0.00000000000000E+00   4.16023758358711E-13  -4.80709696907153E-23
     -4.07064152505884E-11  -4.02903914922777E-11  -1.28081246680804E-18  -9.29256957770158E-03  -9.29256957873576E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03418237539335E-09   0.00000000000000E+00   1.03418237539335E-09
      4.34412686971096E-18  -3.66661897182202E-01  -3.66348749069417E-01   0.00000000000000E+00  -7.01572801254574E-11
     -1.53858843631222E-22  -9.23734703775343E-10  -9.93891983900954E-10  -3.06331440290292E-18
      7.24842633207196E-09
      0.00000000000000E+00   1.08376789904882E-14   0.00000000000000E+00   4.49413828449179E-13  -4.80625866662006E-23
     -1.13190236784704E-11  -1.08696098500693E-11  -1.28064537838023E-18  -9.36541939780859E-03  -9.36541939903168E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22309043354545E-09   0.00000000000000E+00   1.22309043354545E-09
      4.34825479992418E-18  -3.69619342214897E-01  -3.69237400490165E-01   0.00000000000000E+00  -9.22252887421997E-11
     -1.54348135157103E-22  -1.11999553495272E-09  -1.21222082369507E-09  -3.06760942154394E-18
      7.25298258207196E-09
      0.00000000000000E+00   9.09262898354515E-15   0.00000000000000E+00   4.37506696509603E-14  -4.80536193173626E-23
     -9.16462290772154E-12  -9.12087223811864E-12  -1.28041311530668E-18  -9.44260786527758E-03  -9.44260786674078E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46320480261998E-09   0.00000000000000E+00   1.46320480261998E-09
      4.35492152680612E-18  -3.74453197480450E-01  -3.73995047585961E-01   0.00000000000000E+00  -1.15101312348915E-10
     -1.55171041436013E-22  -1.33898261803289E-09  -1.45408393038196E-09  -3.07450841149943E-18
      7.25913351957196E-09
      0.00000000000000E+00   2.32367185135043E-14   0.00000000000000E+00  -9.45186826934343E-14  -4.80440704961315E-23
     -2.31598289483921E-11  -2.32543476311336E-11  -1.28018895269876E-18  -9.46861633733483E-03  -9.46861633899766E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66282963376415E-09   0.00000000000000E+00   1.66282963376415E-09
      4.36514948795655E-18  -3.81779559317024E-01  -3.81262963465642E-01   0.00000000000000E+00  -1.33647482605046E-10
     -1.56453251310185E-22  -1.50592780352789E-09  -1.63957528613309E-09  -3.08496053525778E-18
      7.26743728519696E-09
      0.00000000000000E+00   4.05953738457268E-14   0.00000000000000E+00  -8.90280245096252E-14  -4.80338107659061E-23
     -4.05451473144614E-11  -4.06341753390190E-11  -1.28003515936898E-18  -9.39834429457522E-03  -9.39834429634663E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77140989776658E-09   0.00000000000000E+00   1.77140989776658E-09
      4.37985886057340E-18  -3.92157456226308E-01  -3.91612124165877E-01   0.00000000000000E+00  -1.45409353756851E-10
     -1.58313971361638E-22  -1.58536636867073E-09  -1.73077572242774E-09  -3.09982370120442E-18
      7.27864736879071E-09
      0.00000000000000E+00   5.90561660244397E-14   0.00000000000000E+00  -7.04019471835198E-14  -4.80236393878221E-23
     -5.89430491282293E-11  -5.90134510754609E-11  -1.28004147822617E-18  -9.17272248519210E-03  -9.17272248698686E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79476708306641E-09   0.00000000000000E+00   1.79476708306641E-09
      4.39997834960589E-18  -4.06121082492471E-01  -4.05574181609857E-01   0.00000000000000E+00  -1.51304469232449E-10
     -1.60881529613685E-22  -1.58444916275824E-09  -1.73575363199085E-09  -3.11993687137972E-18
      7.29378098164227E-09
      0.00000000000000E+00   8.92730845657160E-14   0.00000000000000E+00  -9.36356125699323E-14  -4.80187987900988E-23
     -8.91330540403589E-11  -8.92266896529768E-11  -1.28052030271228E-18  -8.59907707612071E-03  -8.59907707789914E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77842705673076E-09   0.00000000000000E+00   1.77842705673076E-09
      4.42689237616720E-18  -4.24256162859801E-01  -4.23723929728200E-01   0.00000000000000E+00  -1.54412322684757E-10
     -1.64337552285905E-22  -1.53478804439290E-09  -1.68920036707782E-09  -3.14637207345492E-18
      7.31378098164227E-09
      0.00000000000000E+00   1.38226329497328E-13   0.00000000000000E+00  -1.25024893075174E-13  -4.80308197261100E-23
     -1.38069392857092E-10  -1.38194417750215E-10  -1.28215142716692E-18  -7.27091541439671E-03  -7.27091541615864E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76192522174560E-09   0.00000000000000E+00   1.76192522174560E-09
      4.46213088060211E-18  -4.46816113757394E-01  -4.46304508339474E-01   0.00000000000000E+00  -1.57805340049464E-10
     -1.68873266518210E-22  -1.46592546394566E-09  -1.62373080399529E-09  -3.17997945343519E-18
      7.33378098164227E-09
      0.00000000000000E+00   1.70923055943207E-13   0.00000000000000E+00  -9.12040786769526E-14  -4.80537365889124E-23
     -1.70785320759642E-10  -1.70876524838367E-10  -1.28445206913163E-18  -5.57189369237058E-03  -5.57189369409467E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72408795492240E-09   0.00000000000000E+00   1.72408795492240E-09
      4.49661263970056E-18  -4.68076288237080E-01  -4.67586900831966E-01   0.00000000000000E+00  -1.61260821022503E-10
     -1.73370776923829E-22  -1.39195060906152E-09  -1.55321143008420E-09  -3.21216057056892E-18
      7.35378098164227E-09
      0.00000000000000E+00   1.73678398059433E-13   0.00000000000000E+00  -1.84127925484419E-14  -4.80760981889097E-23
     -1.73633883760639E-10  -1.73652296553236E-10  -1.28682270754332E-18  -3.85866924344202E-03  -3.85866924509523E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65321078278452E-09   0.00000000000000E+00   1.65321078278452E-09
      4.52967685535625E-18  -4.88295128602968E-01  -4.87828946700745E-01   0.00000000000000E+00  -1.63261603061061E-10
     -1.77797328068088E-22  -1.31629688316997E-09  -1.47955848623121E-09  -3.24285414781292E-18
      7.37378098164227E-09
      0.00000000000000E+00   2.17763871919046E-13   0.00000000000000E+00  -1.28096286311049E-13  -4.81169710513430E-23
     -2.17683714318529E-10  -2.17811810604889E-10  -1.29008775098212E-18  -1.62665144265931E-03  -1.62665144431732E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65801067151711E-09   0.00000000000000E+00   1.65801067151711E-09
      4.56283706878659E-18  -5.07547813243914E-01  -5.07094031075839E-01   0.00000000000000E+00  -1.69208312822523E-10
     -1.82262509789208E-22  -1.27099054808957E-09  -1.44019886091228E-09  -3.27274931780447E-18
      7.39378098164227E-09
      0.00000000000000E+00  -1.16541787042631E-12   0.00000000000000E+00   3.61769086627822E-12  -4.75831071758164E-23
      1.16184143155419E-09   1.16545912242042E-09  -1.26578971764670E-18  -1.59913897003930E-02  -1.59913896997870E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.05976872738624E-10   0.00000000000000E+00  -6.05976872738624E-10
      4.55071753133182E-18  -5.27654622789245E-01  -5.27478357765423E-01   0.00000000000000E+00  -4.26264634956709E-11
     -1.83365309879595E-22  -5.16855786185838E-10  -5.59482249681692E-10  -3.28492781368512E-18
      7.41378098164227E-09
      0.00000000000000E+00  -2.98669900925156E-12   0.00000000000000E+00   4.96191515721096E-12  -4.64046186958455E-23
      2.98177193762402E-09   2.98673385278118E-09  -1.20560838564830E-18  -5.07528868057773E-02  -5.07528868022800E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.49727507980792E-09   0.00000000000000E+00  -3.49727507980792E-09
      4.48077202973566E-18  -5.48811457521615E-01  -5.48972371967925E-01   0.00000000000000E+00   1.18763910329192E-10
     -1.80222010613607E-22   3.91777316697621E-10   5.10541227026632E-10  -3.27516364408736E-18
      7.42378098164227E-09
      0.00000000000000E+00  -4.26315716696177E-12   0.00000000000000E+00   6.83122168698506E-12  -4.55876003488924E-23
      4.25631504131590E-09   4.26314626300284E-09  -1.16320581079936E-18  -7.44011965615620E-02  -7.44011965561473E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.41463169611376E-09   0.00000000000000E+00  -5.41463169611376E-09
      4.42662571277452E-18  -5.59660139624727E-01  -5.60023017052728E-01   0.00000000000000E+00   2.09867626106197E-10
     -1.77400173040594E-22   9.41617807004970E-10   1.15148543311099E-09  -3.26341990197516E-18
      7.42715598164227E-09
      0.00000000000000E+00  -4.84848367718534E-12   0.00000000000000E+00   9.08390215160690E-12  -4.52718507857388E-23
      4.83943511204813E-09   4.84851901419969E-09  -1.14701210760965E-18  -8.32545215799037E-02  -8.32545215736476E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.25611494335176E-09   0.00000000000000E+00  -6.25611494335176E-09
      4.40551132484071E-18  -5.63362832853980E-01  -5.63806412505383E-01   0.00000000000000E+00   2.42611163979963E-10
     -1.76287733716752E-22   1.16498476517249E-09   1.40759592915227E-09  -3.25849921723106E-18
      7.43171223164227E-09
      0.00000000000000E+00  -5.45171991116437E-12   0.00000000000000E+00   7.13687858552680E-12  -4.48194467257130E-23
      5.44455743451986E-09   5.45169431310534E-09  -1.12265821177505E-18  -9.63586057916770E-02  -9.63586057845792E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.09782123295163E-09   0.00000000000000E+00  -7.09782123295163E-09
      4.37317187684807E-18  -5.68408293633944E-01  -5.68927039563803E-01   0.00000000000000E+00   2.74776591769894E-10
     -1.74569793769905E-22   1.37135032807690E-09   1.64612691984662E-09  -3.25051366507302E-18
      7.43786316914227E-09
      0.00000000000000E+00  -6.09279617687291E-12   0.00000000000000E+00   5.73655686592666E-12  -4.41651921235158E-23
      6.08709372472082E-09   6.09283028158670E-09  -1.08664356593712E-18  -1.15302529501307E-01  -1.15302529493432E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87500948802622E-09   0.00000000000000E+00  -7.87500948802622E-09
      4.32473318567532E-18  -5.75184132764479E-01  -5.75745762091259E-01   0.00000000000000E+00   2.97325884983440E-10
     -1.72024735589483E-22   1.48485332145654E-09   1.78217920643981E-09  -3.23808961973820E-18
      7.44616693476727E-09
      0.00000000000000E+00  -6.83756515088874E-12   0.00000000000000E+00   4.97164525010528E-12  -4.31270918922785E-23
      6.83261818454934E-09   6.83758982979941E-09  -1.03482598198810E-18  -1.41703308506359E-01  -1.41703308497895E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46396572648611E-09   0.00000000000000E+00  -8.46396572648611E-09
      4.25445039802454E-18  -5.84015637887943E-01  -5.84528212682403E-01   0.00000000000000E+00   3.03065687530923E-10
     -1.68455605332315E-22   1.32331020915586E-09   1.62637589668662E-09  -3.21962441603644E-18
      7.45737701836102E-09
      0.00000000000000E+00  -8.21496067479002E-12   0.00000000000000E+00   6.51804888214434E-12  -4.03330395492157E-23
      8.20848360726925E-09   8.21500165615136E-09  -9.62728333891203E-19  -1.76915126784382E-01  -1.76915126775541E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.84099191122639E-09   0.00000000000000E+00  -8.84099191122639E-09
      4.15534213964803E-18  -5.94613261648490E-01  -5.94810746976957E-01   0.00000000000000E+00   2.93169305541609E-10
     -1.63676123605691E-22   3.32820949533574E-10   6.25990255075019E-10  -3.19261380575682E-18
      7.47251063121259E-09
      0.00000000000000E+00  -1.25695033552733E-11   0.00000000000000E+00   1.45242055472571E-11  -2.56113480556430E-23
      1.25549666745232E-08   1.25694908800704E-08  -8.67477268304737E-19  -2.21094883565197E-01  -2.21094883556050E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14673826284322E-09   0.00000000000000E+00  -9.14673826284322E-09
      4.01691894392359E-18  -6.03017998579252E-01  -6.01940197679833E-01   0.00000000000000E+00   2.82992263603226E-10
     -1.57198763601098E-22  -3.70574488083027E-09  -3.42275261722720E-09  -3.14944167561885E-18
      7.49251063121259E-09
      0.00000000000000E+00  -2.63130579862704E-11   0.00000000000000E+00   3.41085336979009E-11   3.87299236368097E-23
      2.62789218069174E-08   2.63130303406154E-08  -7.59149818748888E-19  -2.69017726024497E-01  -2.69017726014829E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66840827678291E-09   0.00000000000000E+00  -9.66840827678291E-09
      3.82355077838793E-18  -5.90331403109852E-01  -5.85088668340719E-01   0.00000000000000E+00   3.01784632672619E-10
     -1.47268114297304E-22  -1.69464066965050E-08  -1.66446220638325E-08  -3.06440095963904E-18
      7.51251063121259E-09
      0.00000000000000E+00  -4.64315558268419E-11   0.00000000000000E+00   4.98833318106738E-11   1.34574652406814E-22
      4.63817017141544E-08   4.64315850459652E-08  -6.80066652505769E-19  -3.03683962668635E-01  -3.03683962658270E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03650029413083E-08   0.00000000000000E+00  -1.03650029413083E-08
      3.61625071956176E-18  -5.41798876360905E-01  -5.30437538104305E-01   0.00000000000000E+00   3.17086043228165E-10
     -1.34577081973733E-22  -3.63836681478848E-08  -3.60665821046568E-08  -2.93618406705599E-18
      7.53251063121258E-09
      0.00000000000000E+00  -6.23099495294907E-11   0.00000000000000E+00   3.95067197965004E-11   2.09061070148657E-22
      6.22704340248488E-08   6.23099407446455E-08  -6.30269955975902E-19  -3.26580973750802E-01  -3.26580973739812E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09897332500489E-08   0.00000000000000E+00  -1.09897332500489E-08
      3.39645605456078E-18  -4.57650088973779E-01  -4.41482616270001E-01   0.00000000000000E+00   2.93584770650598E-10
     -1.18789323359895E-22  -5.16137922652472E-08  -5.13202074945967E-08  -2.76618609858488E-18
      7.55251063121258E-09
      0.00000000000000E+00  -6.51171839222388E-11   0.00000000000000E+00   7.08930411024794E-12   2.22807410166293E-22
      6.51101294985316E-08   6.51172188026421E-08  -6.06202232083909E-19  -3.39490494039602E-01  -3.39490494028055E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15468557084465E-08   0.00000000000000E+00  -1.15468557084465E-08
      3.16551894039185E-18  -3.43172513954006E-01  -3.26295381911545E-01   0.00000000000000E+00   2.45711809587906E-10
     -1.02471046624169E-22  -5.38160749037834E-08  -5.35703630941956E-08  -2.55931670830795E-18
      7.57251063121258E-09
      0.00000000000000E+00  -5.68465653367010E-11   0.00000000000000E+00  -2.04757179022543E-11   1.85469051599105E-22
      5.68670135742421E-08   5.68465378563400E-08  -5.98518462210133E-19  -3.46122772653250E-01  -3.46122772641337E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19133183735827E-08   0.00000000000000E+00  -1.19133183735827E-08
      2.92725257292020E-18  -2.19854579761473E-01  -2.05698115642277E-01   0.00000000000000E+00   1.72992017445452E-10
     -8.59060567512494E-23  -4.51062115002027E-08  -4.49332194827574E-08  -2.32873411071007E-18
      7.59251063121258E-09
      0.00000000000000E+00  -4.95150591891102E-11   0.00000000000000E+00  -1.81900887719528E-11   1.45425817084102E-22
      4.95332884451984E-08   4.95150983564266E-08  -5.89686420388576E-19  -3.53267585703969E-01  -3.53267585692128E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18414061728056E-08   0.00000000000000E+00  -1.18414061728056E-08
      2.69042444946409E-18  -1.17646749356246E-01  -1.05777218590247E-01   0.00000000000000E+00   9.26602358764074E-11
     -7.40313008780983E-23  -3.77663524194973E-08  -3.76736921836209E-08  -2.10073802907551E-18
      7.59751063121258E-09
      0.00000000000000E+00  -4.68584501653825E-11   0.00000000000000E+00  -2.62205818689375E-11   1.34072103025087E-22
      4.68846846977903E-08   4.68584641159215E-08  -5.87813341653235E-19  -3.54906529476971E-01  -3.54906529465109E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18622440195794E-08   0.00000000000000E+00  -1.18622440195794E-08
      2.63111322936619E-18  -9.43596404279889E-02  -8.33336501814295E-02   0.00000000000000E+00   7.55109984026847E-11
     -6.77470463204720E-23  -3.50717310947447E-08  -3.49962200963421E-08  -2.04329988771295E-18
      7.60426063121258E-09
      0.00000000000000E+00  -4.38573315323893E-11   0.00000000000000E+00  -2.20511441803611E-11   1.22741384534347E-22
      4.38794053940277E-08   4.38573542498475E-08  -5.82222509784282E-19  -3.58224600775138E-01  -3.58224600763487E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16507342965578E-08   0.00000000000000E+00  -1.16507342965578E-08
      2.55247077286442E-18  -6.87008831401826E-02  -5.85537415604181E-02   0.00000000000000E+00   5.73428358921635E-11
     -4.83671651384269E-23  -3.22639627891820E-08  -3.22066199532898E-08  -1.97024826308014E-18
      7.61337313121258E-09
      0.00000000000000E+00  -3.97239509791018E-11   0.00000000000000E+00  -2.24319576740554E-11   1.17557261322105E-22
      3.97464087504113E-08   3.97239767927373E-08  -5.66833572030630E-19  -3.65361116533278E-01  -3.65361116522055E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12235847710769E-08   0.00000000000000E+00  -1.12235847710769E-08
      2.45019585663799E-18  -4.52983563347521E-02  -3.63188829279253E-02   0.00000000000000E+00   4.44180930506479E-11
      1.08179846414694E-24  -2.85448101147111E-08  -2.85003920216605E-08  -1.88336228460736E-18
      7.61644859996258E-09
      0.00000000000000E+00  -3.78989042060510E-11   0.00000000000000E+00  -2.92291141220479E-11   1.17025782715599E-22
      3.79281759398351E-08   3.78989468257132E-08  -5.60366416272861E-19  -3.68166558088976E-01  -3.68166558077931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10447201051030E-08   0.00000000000000E+00  -1.10447201051030E-08
      2.41622816510225E-18  -3.90677085367864E-02  -3.06068770898332E-02   0.00000000000000E+00   4.51389927623898E-11
      2.22195289680733E-23  -2.68993657133726E-08  -2.68542267206102E-08  -1.85586174882938E-18
      7.62060048277508E-09
      0.00000000000000E+00  -3.60011164011319E-11   0.00000000000000E+00  -2.26533141059662E-11   1.18931143360003E-22
      3.60236965381203E-08   3.60010432240145E-08  -5.49804892307443E-19  -3.72588636617813E-01  -3.72588636607007E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08063834667269E-08   0.00000000000000E+00  -1.08063834667269E-08
      2.37136132732146E-18  -3.30264138454667E-02  -2.50884440146063E-02   0.00000000000000E+00   3.49639983623031E-11
      4.91439433504830E-23  -2.52296237556497E-08  -2.51946597572873E-08  -1.82155643501402E-18
      7.62620552457196E-09
      0.00000000000000E+00  -3.42800378706001E-11   0.00000000000000E+00  -1.52011878025494E-11   1.24465761950836E-22
      3.42952572443056E-08   3.42800560565032E-08  -5.33621379272111E-19  -3.79225782691226E-01  -3.79225782680651E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05746041882521E-08   0.00000000000000E+00  -1.05746041882521E-08
      2.31209022886090E-18  -2.76509489491474E-02  -2.01821670780038E-02   0.00000000000000E+00   2.52420102985732E-11
      8.11092905565906E-23  -2.37306938785496E-08  -2.37054518682509E-08  -1.77846884958878E-18
      7.63377233099774E-09
      0.00000000000000E+00  -3.28944681650873E-11   0.00000000000000E+00  -9.03908714809770E-12   1.33084866876074E-22
      3.29034690635512E-08   3.28944299764033E-08  -5.10372547669747E-19  -3.88664237675074E-01  -3.88664237664688E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03858549026483E-08   0.00000000000000E+00  -1.03858549026483E-08
      2.23350247524630E-18  -2.31671205711766E-02  -1.60754242352672E-02   0.00000000000000E+00   1.74632545467777E-11
      1.16508888530438E-22  -2.25260383283017E-08  -2.25085750737548E-08  -1.72312992757656E-18
      7.64398751967254E-09
      0.00000000000000E+00  -3.18130882292059E-11   0.00000000000000E+00  -5.19648570876845E-12   1.42179911038121E-22
      3.18182888785668E-08   3.18130923928582E-08  -4.78768101201739E-19  -4.01469755039882E-01  -4.01469755029641E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02408324497306E-08   0.00000000000000E+00  -1.02408324497306E-08
      2.12889043958525E-18  -1.95226446816620E-02  -1.27259409167610E-02   0.00000000000000E+00   1.22676354019212E-11
      1.51874737374626E-22  -2.15845275785296E-08  -2.15722599431276E-08  -1.65012233838351E-18
      7.65777802438353E-09
      0.00000000000000E+00  -3.08325538147784E-11   0.00000000000000E+00  -3.47044324180003E-12   1.45706138627925E-22
      3.08359819493165E-08   3.08325115060748E-08  -4.37623538334900E-19  -4.18234392558802E-01  -4.18234392548691E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01111709185848E-08   0.00000000000000E+00  -1.01111709185848E-08
      1.98945228939891E-18  -1.65344476399330E-02  -1.00058321378657E-02   0.00000000000000E+00   9.26984874189781E-12
      1.77134210043414E-22  -2.07306104362321E-08  -2.07213405874900E-08  -1.55182875106401E-18
      7.67639520574336E-09
      0.00000000000000E+00  -2.96678707022497E-11   0.00000000000000E+00  -3.04961079068843E-12   1.31665664180055E-22
      2.96708773211699E-08   2.96678277103793E-08  -3.85757778302709E-19  -4.39638418856322E-01  -4.39638418846363E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95929968060319E-09   0.00000000000000E+00  -9.95929968060319E-09
      1.80403820102821E-18  -1.40064547494322E-02  -7.79693570706302E-03   0.00000000000000E+00   7.66792988948439E-12
      1.73511842893949E-22  -1.97161959596659E-08  -1.97085280297762E-08  -1.41828042272550E-18
      7.69639520574336E-09
      0.00000000000000E+00  -2.84626840606125E-11   0.00000000000000E+00  -2.94105195395060E-12   1.01483075209052E-22
      2.84656563221607E-08   2.84627152702068E-08  -3.34166002588253E-19  -4.61278743869887E-01  -4.61278743860076E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81011161252037E-09   0.00000000000000E+00  -9.81011161252037E-09
      1.60783596877780E-18  -1.21941310153058E-02  -6.31729358497488E-03   0.00000000000000E+00   6.66494461077463E-12
      1.37988732832857E-22  -1.86592686022974E-08  -1.86526036576865E-08  -1.27366996618955E-18
      7.71639520574336E-09
      0.00000000000000E+00  -2.74677300224434E-11   0.00000000000000E+00  -2.42736096190660E-12   6.87911002312986E-23
      2.74701589252190E-08   2.74677315642571E-08  -2.86031537473017E-19  -4.81817408438619E-01  -4.81817408428939E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68054813364662E-09   0.00000000000000E+00  -9.68054813364662E-09
      1.41422500610487E-18  -1.09624215484092E-02  -5.35824553861719E-03   0.00000000000000E+00   5.55551357928628E-12
      9.23793581914279E-23  -1.77927389441899E-08  -1.77871834306105E-08  -1.12819346863185E-18
      7.73639520574336E-09
      0.00000000000000E+00  -2.66254219375132E-11   0.00000000000000E+00  -2.05339660618667E-12   4.16283917825795E-23
      2.66275058745746E-08   2.66254524779685E-08  -2.41048222019374E-19  -5.01352451385260E-01  -5.01352451375735E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52558626841896E-09   0.00000000000000E+00  -9.52558626841896E-09
      1.22371328073649E-18  -1.00861764895845E-02  -4.69854843511901E-03   0.00000000000000E+00   4.64094449515772E-12
      5.24965475220829E-23  -1.71045071540447E-08  -1.70998662095495E-08  -9.82665058717118E-19
      7.75639520574336E-09
      0.00000000000000E+00  -2.64844402658996E-11   0.00000000000000E+00  -3.25820425603097E-13   2.34102153289871E-23
      2.64847453261084E-08   2.64844195056829E-08  -1.96844900101104E-19  -5.20959548330337E-01  -5.20959548320502E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.83486129425617E-09   0.00000000000000E+00  -9.83486129425617E-09
      1.02701605485137E-18  -9.52617060762270E-03  -4.28041708638992E-03   0.00000000000000E+00   3.80561273188025E-12
      2.52561814320059E-23  -1.66533638241587E-08  -1.66495582114268E-08  -8.30171154750266E-19
      7.76639520574336E-09
      0.00000000000000E+00  -2.70591127866071E-11   0.00000000000000E+00   2.85130760084343E-12   1.66111841548018E-23
      2.70562705874689E-08   2.70591218950698E-08  -1.74076374049827E-19  -5.31269568564240E-01  -5.31269568553705E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05348106221081E-08   0.00000000000000E+00  -1.05348106221081E-08
      9.21667948630286E-19  -9.38317587245470E-03  -4.17688216670914E-03   0.00000000000000E+00   3.25927186106514E-12
      1.48965110008602E-23  -1.65275705448224E-08  -1.65243112729614E-08  -7.47591574580460E-19
      7.77314520574336E-09
      0.00000000000000E+00  -2.74806801303897E-11   0.00000000000000E+00   3.11168316888885E-12   1.31094702383782E-23
      2.74775991165274E-08   2.74807107996963E-08  -1.58499398516347E-19  -5.38397809364741E-01  -5.38397809353809E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09327975572144E-08   0.00000000000000E+00  -1.09327975572144E-08
      8.47871565119089E-19  -9.33966517136420E-03  -4.12593412509795E-03   0.00000000000000E+00   2.44159035490702E-12
      9.60424007833151E-24  -1.65503548328370E-08  -1.65479132424821E-08  -6.89372166602743E-19
      7.77770145574336E-09
      0.00000000000000E+00  -2.77580512367564E-11   0.00000000000000E+00   3.03592481522856E-12   1.11994387217921E-23
      2.77550173850892E-08   2.77580533099044E-08  -1.47931327248377E-19  -5.43268915797906E-01  -5.43268915786735E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11715757790710E-08   0.00000000000000E+00  -1.11715757790710E-08
      7.96971072975697E-19  -9.32118678994222E-03  -4.09530476398132E-03   0.00000000000000E+00   2.16679720746001E-12
      6.74710256103500E-24  -1.65886443280405E-08  -1.65864775308331E-08  -6.49039745727320E-19
      7.78385239324336E-09
      0.00000000000000E+00  -2.81043058960288E-11   0.00000000000000E+00   2.81067786666738E-12   9.32370890405283E-24
      2.81015091163895E-08   2.81043197942561E-08  -1.33580457878930E-19  -5.49928357591278E-01  -5.49928357579863E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14140003983025E-08   0.00000000000000E+00  -1.14140003983025E-08
      7.26764269900763E-19  -9.31657972535867E-03  -4.05797956174531E-03   0.00000000000000E+00   1.73099278555435E-12
      3.99805836881294E-24  -1.66920503887390E-08  -1.66903193959534E-08  -5.93183812021834E-19
      7.79215615886836E-09
      0.00000000000000E+00  -2.86168913743840E-11   0.00000000000000E+00   3.07570281856499E-12   7.67324545155204E-24
      2.86138181832140E-08   2.86168938860326E-08  -1.14124212365061E-19  -5.59048409667602E-01  -5.59048409655895E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17062386932246E-08   0.00000000000000E+00  -1.17062386932246E-08
      6.29558407441919E-19  -9.35110223482633E-03  -4.02307996837634E-03   0.00000000000000E+00   1.21722595960326E-12
      1.62431380012825E-24  -1.69118724187675E-08  -1.69106551928079E-08  -5.15434195076857E-19
      7.79776120066523E-09
      0.00000000000000E+00  -2.90498474655803E-11   0.00000000000000E+00   3.83753906535853E-12   6.85264690396011E-24
      2.90460280638915E-08   2.90498656029569E-08  -1.01010051755116E-19  -5.65260245116644E-01  -5.65260245104719E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19250756005150E-08   0.00000000000000E+00  -1.19250756005150E-08
      5.62717860270138E-19  -9.41120626898119E-03  -4.01571587119356E-03   0.00000000000000E+00   5.96854140751952E-13
      4.34831380925727E-25  -1.71253868565826E-08  -1.71247900024419E-08  -4.61707808515021E-19
      7.80154460387812E-09
      0.00000000000000E+00  -2.93318108088074E-11   0.00000000000000E+00   3.71161386620055E-12   6.40497992909259E-24
      2.93281417270001E-08   2.93318533408663E-08  -9.21933873508214E-20  -5.69463348041639E-01  -5.69463348029598E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20406897439479E-08   0.00000000000000E+00  -1.20406897439479E-08
      5.17163076007466E-19  -9.46049354997413E-03  -4.01258340890798E-03   0.00000000000000E+00   2.75047205409325E-13
     -2.05843622328507E-25  -1.72914386441240E-08  -1.72911635969186E-08  -4.24969688656645E-19
      7.80665219821553E-09
      0.00000000000000E+00  -2.95503094386241E-11   0.00000000000000E+00   2.15426445650608E-12   5.93998192137594E-24
      2.95481436904612E-08   2.95502979549177E-08  -8.04223977108409E-20  -5.75100617009643E-01  -5.75100616997573E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20700283208685E-08   0.00000000000000E+00  -1.20700283208685E-08
      4.55514267703513E-19  -9.49996142764154E-03  -3.99246932956836E-03   0.00000000000000E+00   5.64691713779809E-13
     -8.11321909101262E-25  -1.74808343257631E-08  -1.74802696340493E-08  -3.75091869992671E-19
      7.81354745057102E-09
      0.00000000000000E+00  -2.95063158095017E-11   0.00000000000000E+00  -2.74438974540951E-13   5.45555158574674E-24
      2.95065822604578E-08   2.95063078214833E-08  -6.50587097651967E-20  -5.82499748072648E-01  -5.82499748060769E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18789103243754E-08   0.00000000000000E+00  -1.18789103243754E-08
      3.73606183308671E-19  -9.48497290165244E-03  -3.93112480797443E-03   0.00000000000000E+00   1.23511490736608E-12
     -1.32801918089607E-24  -1.76286326120153E-08  -1.76273974971080E-08  -3.08547473543474E-19
      7.82285604125094E-09
      0.00000000000000E+00  -2.88265729094288E-11   0.00000000000000E+00  -3.57129544987537E-12   4.91761020532975E-24
      2.88301513951056E-08   2.88265800996557E-08  -4.60515349861838E-20  -5.91711698591125E-01  -5.91711698579995E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11292490661430E-08   0.00000000000000E+00  -1.11292490661430E-08
      2.70008559177111E-19  -9.37097641784194E-03  -3.79509354952036E-03   0.00000000000000E+00   1.70321308119729E-12
     -1.73066467729903E-24  -1.76990342465939E-08  -1.76973310335127E-08  -2.23957024190927E-19
      7.83542263866882E-09
      0.00000000000000E+00  -2.63195789626121E-11   0.00000000000000E+00  -9.82017777365241E-12   4.18307112950537E-24
      2.63293900269150E-08   2.63195698491414E-08  -2.67062706086165E-20  -6.01090001258413E-01  -6.01090001249796E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.61751732427952E-09   0.00000000000000E+00  -8.61751732427952E-09
      1.61715688221230E-19  -9.07216737415160E-03  -3.49479568264328E-03   0.00000000000000E+00   1.53375880709719E-12
     -2.03845489576436E-24  -1.77035862836690E-08  -1.77020525248619E-08  -1.35009417612614E-19
      7.85238754518297E-09
      0.00000000000000E+00  -1.79550032109110E-11   0.00000000000000E+00  -2.43086507268850E-11   2.74374461320747E-24
      1.79793106479013E-08   1.79550019971744E-08  -2.63555318950666E-20  -6.00791508740436E-01  -6.00791508740171E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65328504607497E-10   0.00000000000000E+00  -2.65328504607497E-10
      1.57214414945025E-19  -8.30742799108456E-03  -2.73395494346777E-03   0.00000000000000E+00   1.02872585718945E-13
     -2.37308289136033E-24  -1.76897763651526E-08  -1.76896734925669E-08  -1.30858883049959E-19
      7.87238754518297E-09
      0.00000000000000E+00  -4.72265638721103E-13   0.00000000000000E+00  -4.30900046037732E-11  -1.62180948923482E-25
      5.15320221528042E-10   4.72230216924268E-10  -9.10619892883709E-20  -5.68394721732666E-01  -5.68394721749882E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72165612263528E-08   0.00000000000000E+00   1.72165612263528E-08
      5.01545639472081E-19  -6.82760024566259E-03  -1.25440415419062E-03   0.00000000000000E+00  -3.17193958096326E-12
     -3.36981944553762E-24  -1.76856195036960E-08  -1.76887914432770E-08  -4.10483650183710E-19
      7.89238754518297E-09
      0.00000000000000E+00   1.72892207108937E-11   0.00000000000000E+00  -4.38679309929827E-11  -6.08495857532747E-24
     -1.72453376989740E-08  -1.72892056299670E-08  -2.41356502104320E-19  -4.99099597972250E-01  -4.99099598007193E-01
      0.00000000000000E+00   0.00000000000000E+00   3.49430872552805E-08   0.00000000000000E+00   3.49430872552805E-08
      1.20040738457769E-18  -5.11858118566385E-03   4.43613877657002E-04   0.00000000000000E+00  -8.15114770872485E-12
     -9.23860924295790E-24  -1.76457304776047E-08  -1.76538816253134E-08  -9.59050882473370E-19
      7.91238754518297E-09
      0.00000000000000E+00   2.49796560914915E-11   0.00000000000000E+00  -1.92466425571494E-11  -2.52634820359602E-23
     -2.49604328270238E-08  -2.49796794695810E-08  -4.90003700321882E-19  -3.96913890477719E-01  -3.96913890520315E-01
      0.00000000000000E+00   0.00000000000000E+00   4.25967950575255E-08   0.00000000000000E+00   4.25967950575255E-08
      2.05234328572820E-18  -3.29693341771306E-03   2.25366984482272E-03   0.00000000000000E+00  -1.80144327068345E-11
     -4.27554355297399E-23  -1.75991011552378E-08  -1.76171155879446E-08  -1.56233958540632E-18
      7.93238754518297E-09
      0.00000000000000E+00   1.84098183495627E-11   0.00000000000000E+00   1.56820985150211E-11  -4.12026509805108E-23
     -1.84254515276331E-08  -1.84097694291181E-08  -7.93340401197730E-19  -2.72381187103036E-01  -2.72381187138850E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58138424003626E-08   0.00000000000000E+00   3.58138424003626E-08
      2.76862013373545E-18  -2.66495168552876E-03   2.81851200160572E-03   0.00000000000000E+00  -4.16112674188509E-11
     -7.60017162149958E-23  -1.73624617038256E-08  -1.74040729712445E-08  -1.97527973253772E-18
      7.95238754518297E-09
      0.00000000000000E+00   1.18174786470181E-11   0.00000000000000E+00   1.55353415293709E-11  -4.46887711447296E-23
     -1.18329907565097E-08  -1.18174554149803E-08  -1.02711573553440E-18  -1.59405387825835E-01  -1.59405387851962E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61274562906104E-08   0.00000000000000E+00   2.61274562906104E-08
      3.29116925954766E-18  -2.32355120478939E-02  -1.87269008475511E-02   0.00000000000000E+00  -8.03979745747729E-11
     -8.85521266315770E-23  -1.42296029010552E-08  -1.43100008756301E-08  -2.26405352401326E-18
      7.97238754518297E-09
      0.00000000000000E+00   7.74526668871073E-12   0.00000000000000E+00   9.21665558648588E-12  -4.70026878738865E-23
     -7.75447436249309E-09  -7.74525770690665E-09  -1.18062875697072E-18  -7.43126840209195E-02  -7.43126840398087E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88891309889370E-08   0.00000000000000E+00   1.88891309889370E-08
      3.66895187932640E-18  -6.28511439130830E-02  -5.93400735486210E-02   0.00000000000000E+00  -1.39939742227644E-10
     -1.01607935999861E-22  -1.10039335398026E-08  -1.11438732820304E-08  -2.48832312235568E-18
      7.97488754518296E-09
      0.00000000000000E+00   6.62788361584396E-12   0.00000000000000E+00   2.08955337426098E-11  -4.72147091800604E-23
     -6.64876228117280E-09  -6.62786674743023E-09  -1.19702828555060E-18  -6.47107982786815E-02  -6.47107982955312E-02
      0.00000000000000E+00   0.00000000000000E+00   1.68496906318647E-08   0.00000000000000E+00   1.68496906318647E-08
      3.71107610590606E-18  -6.84938033702656E-02  -6.52732109713938E-02   0.00000000000000E+00  -1.72894666545156E-10
     -1.03296765970142E-22  -1.00489292178894E-08  -1.02218238844347E-08  -2.51404782035547E-18
      7.97826254518297E-09
      0.00000000000000E+00   5.37383557401239E-12   0.00000000000000E+00   1.75839455672581E-11  -4.74522085382757E-23
     -5.39137270512291E-09  -5.37378875955570E-09  -1.21492653367192E-18  -5.40390995172020E-02  -5.40390995319079E-02
      0.00000000000000E+00   0.00000000000000E+00   1.47058396043108E-08   0.00000000000000E+00   1.47058396043108E-08
      3.76070831457061E-18  -7.69822582054917E-02  -7.40420027345380E-02   0.00000000000000E+00  -1.78826900460936E-10
     -1.05483352208608E-22  -9.15322394429393E-09  -9.33205084475498E-09  -2.54578178089870E-18
      7.98281879518297E-09
      0.00000000000000E+00   3.95345671309799E-12   0.00000000000000E+00   1.47957922436965E-11  -4.76748197292564E-23
     -3.96827548784222E-09  -3.95347969559858E-09  -1.23260984132811E-18  -4.32724914464163E-02  -4.32724914587027E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22864375977134E-08   0.00000000000000E+00   1.22864375977134E-08
      3.81668839587519E-18  -8.96685123699525E-02  -8.70430404844277E-02   0.00000000000000E+00  -1.78289764277452E-10
     -1.08238825753858E-22  -8.15466813783726E-09  -8.33295790211482E-09  -2.58407855454709E-18
      7.98589426393297E-09
      0.00000000000000E+00   3.06329752008264E-12   0.00000000000000E+00   1.38041338472931E-11  -4.77802071716189E-23
     -3.07714158321973E-09  -3.06333744937248E-09  -1.24180676997395E-18  -3.75726193267335E-02  -3.75726193374745E-02
      0.00000000000000E+00   0.00000000000000E+00   1.07409810163244E-08   0.00000000000000E+00   1.07409810163244E-08
      3.84972194733524E-18  -9.87229948340522E-02  -9.63039898288509E-02   0.00000000000000E+00  -1.79280482184772E-10
     -1.10021021217728E-22  -7.49836308476697E-09  -7.67764356695185E-09  -2.60791517736129E-18
      7.99004614674547E-09
      0.00000000000000E+00   2.17864901129974E-12   0.00000000000000E+00   1.02037081119327E-11  -4.78760659000884E-23
     -2.18888218972226E-09  -2.17867848161038E-09  -1.25054873440272E-18  -3.20212457277187E-02  -3.20212457368983E-02
      0.00000000000000E+00   0.00000000000000E+00   9.17961853253213E-09   0.00000000000000E+00   9.17961853253213E-09
      3.88783464774577E-18  -1.11542813848943E-01  -1.09337017333888E-01   0.00000000000000E+00  -1.78388925838159E-10
     -1.12300271800632E-22  -6.82255112508361E-09  -7.00094005092188E-09  -2.63728591334305E-18
      7.99565118854234E-09
      0.00000000000000E+00   1.42166468723531E-12   0.00000000000000E+00   6.47186021292009E-12  -4.79554415466333E-23
     -1.42809209923836E-09  -1.42162023902549E-09  -1.25810859457603E-18  -2.70314623333838E-02  -2.70314623411577E-02
      0.00000000000000E+00   0.00000000000000E+00   7.77395859817635E-09   0.00000000000000E+00   7.77395859817635E-09
      3.93140801061572E-18  -1.29373131607804E-01  -1.27371689479733E-01   0.00000000000000E+00  -1.79517226786544E-10
     -1.15225741757172E-22  -6.17282113236396E-09  -6.35233835915062E-09  -2.67329941603970E-18
      8.00321799496812E-09
      0.00000000000000E+00   8.67014319239052E-13   0.00000000000000E+00   3.50746942344001E-12  -4.80162208609023E-23
     -8.70483259664380E-10  -8.66975790240988E-10  -1.26412421240168E-18  -2.28045733847693E-02  -2.28045733913976E-02
      0.00000000000000E+00   0.00000000000000E+00   6.62837104030489E-09   0.00000000000000E+00   6.62837104030489E-09
      3.98156361119597E-18  -1.53574400105408E-01  -1.51759145564879E-01   0.00000000000000E+00  -1.84123771748729E-10
     -1.19017403890194E-22  -5.57727147831509E-09  -5.76139525006394E-09  -2.71743939879429E-18
      8.01343318364293E-09
      0.00000000000000E+00   5.11942565194754E-13   0.00000000000000E+00   1.65854712493337E-12  -4.80592723628954E-23
     -5.13611380278940E-10  -5.11952833154055E-10  -1.26863430401813E-18  -1.93110651354423E-02  -1.93110651411495E-02
      0.00000000000000E+00   0.00000000000000E+00   5.70714927331778E-09   0.00000000000000E+00   5.70714927331778E-09
      4.03986321781818E-18  -1.85417812785730E-01  -1.83780949198390E-01   0.00000000000000E+00  -1.92025779416254E-10
     -1.23953137383776E-22  -5.00317066074743E-09  -5.19519644016381E-09  -2.77122891380005E-18
      8.02722368835391E-09
      0.00000000000000E+00   3.06853267010347E-13   0.00000000000000E+00   7.08860296742657E-13  -4.80866914028981E-23
     -3.07522814968214E-10  -3.06813954671519E-10  -1.27192214130569E-18  -1.64071981253639E-02  -1.64071981302101E-02
      0.00000000000000E+00   0.00000000000000E+00   4.84623794885713E-09   0.00000000000000E+00   4.84623794885713E-09
      4.10669528508246E-18  -2.25201323380242E-01  -2.23771072323771E-01   0.00000000000000E+00  -1.98614680490485E-10
     -1.30229566906385E-22  -4.34080931369505E-09  -4.53942399418567E-09  -2.83477314377677E-18
      8.04584086971374E-09
      0.00000000000000E+00   2.03344248177464E-13   0.00000000000000E+00   2.65046736174354E-13  -4.81031235312460E-23
     -2.03600674496591E-10  -2.03335627760465E-10  -1.27447581730403E-18  -1.39272960090998E-02  -1.39272960129130E-02
      0.00000000000000E+00   0.00000000000000E+00   3.81323173039522E-09   0.00000000000000E+00   3.81323173039522E-09
      4.17768691177429E-18  -2.69542639010253E-01  -2.68405253697498E-01   0.00000000000000E+00  -1.88518066764931E-10
     -1.37483083782499E-22  -3.42137803586966E-09  -3.60989610263472E-09  -2.90321109447026E-18
      8.06584086971374E-09
      0.00000000000000E+00   1.60636445375964E-13   0.00000000000000E+00   1.02310309202320E-13  -4.81115632781970E-23
     -1.60777069382577E-10  -1.60674759073423E-10  -1.27640012325873E-18  -1.21422284884685E-02  -1.21422284912136E-02
      0.00000000000000E+00   0.00000000000000E+00   2.74515970621055E-09   0.00000000000000E+00   2.74515970621055E-09
      4.23259010589850E-18  -3.04040946435697E-01  -3.03226638979774E-01   0.00000000000000E+00  -1.54907838667913E-10
     -1.43341621334344E-22  -2.42957710846912E-09  -2.58448494713717E-09  -2.95618998263977E-18
      8.08584086971374E-09
      0.00000000000000E+00   1.38961087394988E-13   0.00000000000000E+00   5.36560390153980E-14  -4.81144869043753E-23
     -1.39000585990323E-10  -1.38946929951356E-10  -1.27791329583409E-18  -1.09270502358034E-02  -1.09270502376778E-02
      0.00000000000000E+00   0.00000000000000E+00   1.87439843549697E-09   0.00000000000000E+00   1.87439843549697E-09
      4.27007807460844E-18  -3.26811893491072E-01  -3.26265096499918E-01   0.00000000000000E+00  -1.10723515356332E-10
     -1.47287478299495E-22  -1.62472799018915E-09  -1.73545150554563E-09  -2.99216477877435E-18
      8.10584086971374E-09
      0.00000000000000E+00   1.30786905783518E-13   0.00000000000000E+00   2.10022445892330E-14  -4.81159754887738E-23
     -1.30826724034595E-10  -1.30805721790054E-10  -1.27927870056849E-18  -1.00603673816141E-02  -1.00603673827968E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18264792263620E-09   0.00000000000000E+00   1.18264792263620E-09
      4.29373103306116E-18  -3.39627300109029E-01  -3.39295895710077E-01   0.00000000000000E+00  -6.40247654350479E-11
     -1.49497852729475E-22  -9.87817435410946E-10  -1.05184220084614E-09  -3.01445233249267E-18
      8.12584086971374E-09
      0.00000000000000E+00   1.16918350465182E-13   0.00000000000000E+00   3.71101379258138E-14  -4.81126187989129E-23
     -1.16911255345364E-10  -1.16874145207486E-10  -1.28037582162627E-18  -9.51349133205983E-03  -9.51349133279829E-03
      0.00000000000000E+00   0.00000000000000E+00   7.38451993662655E-10   0.00000000000000E+00   7.38451993662655E-10
      4.30850007293442E-18  -3.46202522085034E-01  -3.46006687105326E-01   0.00000000000000E+00  -3.12048627612822E-11
     -1.50561920033677E-22  -5.90372985693804E-10  -6.21577848455237E-10  -3.02812425130814E-18
      8.14584086971374E-09
      0.00000000000000E+00   8.65177424494902E-14   0.00000000000000E+00   8.23104823275184E-14  -4.80979574608982E-23
     -8.66246784476029E-11  -8.65423679653234E-11  -1.28087785568927E-18  -9.30637393532834E-03  -9.30637393603957E-03
      0.00000000000000E+00   0.00000000000000E+00   7.11226026177504E-10   0.00000000000000E+00   7.11226026177504E-10
      4.32272459345797E-18  -3.53331079236616E-01  -3.53134265147945E-01   0.00000000000000E+00  -3.34761892607616E-11
     -1.51670883252820E-22  -5.91207468951210E-10  -6.24683658212123E-10  -3.04184673776870E-18
      8.16584086971374E-09
      0.00000000000000E+00   5.92398554988548E-14   0.00000000000000E+00   7.92523825892127E-14  -4.80744525241748E-23
     -5.92887472447859E-11  -5.92094948622447E-11  -1.28084952359811E-18  -9.27404834051891E-03  -9.27404834151696E-03
      0.00000000000000E+00   0.00000000000000E+00   9.98044759767006E-10   0.00000000000000E+00   9.98044759767006E-10
      4.34268548865330E-18  -3.65709222777159E-01  -3.65413423388793E-01   0.00000000000000E+00  -6.31432553028308E-11
     -1.53703538233650E-22  -8.75692009601742E-10  -9.38835264904726E-10  -3.06183596505520E-18
      8.17584086971374E-09
      0.00000000000000E+00   2.37877869367494E-14   0.00000000000000E+00   1.91717919112363E-13  -4.80552246205089E-23
     -2.39937854487868E-11  -2.38020675297225E-11  -1.28048693879185E-18  -9.37974397852654E-03  -9.37974397989682E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37027428099732E-09   0.00000000000000E+00   1.37027428099732E-09
      4.35638823146328E-18  -3.75355812930253E-01  -3.74931571033604E-01   0.00000000000000E+00  -1.04035872306757E-10
     -1.55340993534984E-22  -1.24243634116081E-09  -1.34647221346773E-09  -3.07590129267143E-18
      8.18934086971374E-09
      0.00000000000000E+00   3.13190553877666E-14   0.00000000000000E+00  -1.07692134756194E-14  -4.80350377482159E-23
     -3.12923715807371E-11  -3.13031407942608E-11  -1.28011043533943E-18  -9.36284493517734E-03  -9.36284493686270E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68535222437239E-09   0.00000000000000E+00   1.68535222437239E-09
      4.37914048649231E-18  -3.91521352776240E-01  -3.91000197116121E-01   0.00000000000000E+00  -1.36964027243813E-10
     -1.58201346341687E-22  -1.51708505633413E-09  -1.65404908357810E-09  -3.09903005115288E-18
      8.20756586971374E-09
      0.00000000000000E+00   6.08012160313827E-14   0.00000000000000E+00  -6.95010704007712E-14  -4.80192547821844E-23
     -6.06891140702130E-11  -6.07586151406618E-11  -1.28015946198816E-18  -8.98147177869998E-03  -8.98147178046680E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76681486967311E-09   0.00000000000000E+00   1.76681486967311E-09
      4.41134068749210E-18  -4.13819897001656E-01  -4.13282354104131E-01   0.00000000000000E+00  -1.50132619843835E-10
     -1.62320301975506E-22  -1.55592363468847E-09  -1.70605625453246E-09  -3.13118122550394E-18
      8.22756586971374E-09
      0.00000000000000E+00   1.10856597809485E-13   0.00000000000000E+00  -1.22758060496912E-13  -4.80214885439835E-23
     -1.10743686254365E-10  -1.10866444314910E-10  -1.28123641406465E-18  -7.97211815003663E-03  -7.97211815179827E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76164294133954E-09   0.00000000000000E+00   1.76164294133954E-09
      4.44657354631889E-18  -4.37027482746079E-01  -4.36507356380811E-01   0.00000000000000E+00  -1.55519664401521E-10
     -1.66853919255902E-22  -1.49525683262299E-09  -1.65077649702468E-09  -3.16533713225425E-18
      8.24756586971374E-09
      0.00000000000000E+00   1.61187513799209E-13   0.00000000000000E+00  -1.32655726960381E-13  -4.80419604639539E-23
     -1.61043226070948E-10  -1.61175881797956E-10  -1.28333654250343E-18  -6.37946627435811E-03  -6.37946627610490E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74679243068618E-09   0.00000000000000E+00   1.74679243068618E-09
      4.48150939493261E-18  -4.58831952066501E-01  -4.58332354972009E-01   0.00000000000000E+00  -1.59981962868094E-10
     -1.71374291933056E-22  -1.42563458601993E-09  -1.58561654888819E-09  -3.19817285242918E-18
      8.26756586971374E-09
      0.00000000000000E+00   1.71565969103660E-13   0.00000000000000E+00  -3.67397421906470E-14  -4.80639321948525E-23
     -1.71536976624615E-10  -1.71573716366854E-10  -1.28565974812639E-18  -4.68303148495190E-03  -4.68303148663422E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68231493615802E-09   0.00000000000000E+00   1.68231493615802E-09
      4.51515569365577E-18  -4.79501127621361E-01  -4.79025121148583E-01   0.00000000000000E+00  -1.62302505818261E-10
     -1.75829167580626E-22  -1.34843871397269E-09  -1.51074121979113E-09  -3.22949594552938E-18
      8.28756586971374E-09
      0.00000000000000E+00   2.03252403440257E-13   0.00000000000000E+00  -9.47239092839691E-14  -4.80987473427639E-23
     -2.03151242307080E-10  -2.03245966216412E-10  -1.28862878417760E-18  -2.62044725691580E-03  -2.62044725857898E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66318209651515E-09   0.00000000000000E+00   1.66318209651515E-09
      4.54841933558608E-18  -4.99165704112152E-01  -4.98705703832036E-01   0.00000000000000E+00  -1.66955647676189E-10
     -1.80287359298297E-22  -1.29298048262237E-09  -1.45993613029874E-09  -3.25979055140847E-18
      8.30756586971374E-09
      0.00000000000000E+00  -3.00424135405820E-13   0.00000000000000E+00   1.30916437350166E-12  -4.79232252751781E-23
      2.99053014958342E-10   3.00362179331795E-10  -1.28156471507994E-18  -6.64441418385503E-03  -6.64441418465143E-03
      0.00000000000000E+00   0.00000000000000E+00   7.96399616804961E-10   0.00000000000000E+00   7.96399616804961E-10
      4.56434732792218E-18  -5.18594224072582E-01  -5.18248659260082E-01   0.00000000000000E+00  -1.22602241404787E-10
     -1.83485207827238E-22  -9.74159554731839E-10  -1.09676179613681E-09  -3.28278261284224E-18
      8.32756586971374E-09
      0.00000000000000E+00  -2.22172419305007E-12   0.00000000000000E+00   5.10580265461691E-12  -4.69923395099674E-23
      2.21662914917787E-09   2.22173495183244E-09  -1.23633536155614E-18  -3.31894138431112E-02  -3.31894138408118E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.29936155566984E-09   0.00000000000000E+00  -2.29936155566984E-09
      4.51836009680878E-18  -5.39398859920686E-01  -5.39423354962709E-01   0.00000000000000E+00   5.40949016812864E-11
     -1.82062877558291E-22   2.35317021563753E-11   7.76266038374796E-11  -3.28202473525264E-18
      8.34756586971374E-09
      0.00000000000000E+00  -4.02132997389435E-12   0.00000000000000E+00   4.97197758568245E-12  -4.54915127482783E-23
      4.01639534952500E-09   4.02136732711063E-09  -1.15656383881630E-18  -7.79949593904942E-02  -7.79949593854571E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.03711157858925E-09   0.00000000000000E+00  -5.03711157858925E-09
      4.41761786523699E-18  -5.60908877413729E-01  -5.61228984700488E-01   0.00000000000000E+00   1.93099959806084E-10
     -1.76876596448203E-22   8.22644291672719E-10   1.01574425147863E-09  -3.26105402642070E-18
      8.35006586971374E-09
      0.00000000000000E+00  -4.64513942900787E-12   0.00000000000000E+00   1.26836970907736E-11  -4.52533347695967E-23
      4.63247494488563E-09   4.64515864197636E-09  -1.14508583509268E-18  -8.42632209568042E-02  -8.42632209508826E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.92158675700233E-09   0.00000000000000E+00  -5.92158675700233E-09
      4.40281389834449E-18  -5.63618939415940E-01  -5.64021188022646E-01   0.00000000000000E+00   2.25459004009532E-10
     -1.76110955329250E-22   1.05096911101610E-09   1.27642811502546E-09  -3.25772806325181E-18
      8.35344086971374E-09
      0.00000000000000E+00  -5.21127038915507E-12   0.00000000000000E+00   8.89259525277788E-12  -4.49253510217033E-23
      5.20239276857786E-09   5.21128536383060E-09  -1.12781091567347E-18  -9.35769527977229E-02  -9.35769527909860E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.73696723603307E-09   0.00000000000000E+00  -6.73696723603307E-09
      4.38007663392288E-18  -5.67330572701734E-01  -5.67811364742103E-01   0.00000000000000E+00   2.58473112847964E-10
     -1.74916592218951E-22   1.26720875935419E-09   1.52568187220198E-09  -3.25226571824940E-18
      8.35799711971374E-09
      0.00000000000000E+00  -5.79723981253909E-12   0.00000000000000E+00   6.94365938257434E-12  -4.44548997338056E-23
      5.79026935206406E-09   5.79721301144659E-09  -1.10218329279169E-18  -1.07168326104221E-01  -1.07168326096705E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.51644259838711E-09   0.00000000000000E+00  -7.51644259838711E-09
      4.34582984233398E-18  -5.72361326372178E-01  -5.72903113111217E-01   0.00000000000000E+00   2.85716784778332E-10
     -1.73115335976228E-22   1.43351280216260E-09   1.71922958694076E-09  -3.24364654954228E-18
      8.36414805721374E-09
      0.00000000000000E+00  -6.41214032814348E-12   0.00000000000000E+00   5.50878243721801E-12  -4.37661774836357E-23
      6.40667246955968E-09   6.41218125199686E-09  -1.06493968860497E-18  -1.26463750356714E-01  -1.26463750348540E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.17340517863237E-09   0.00000000000000E+00  -8.17340517863237E-09
      4.29555573791803E-18  -5.79059410416985E-01  -5.79614448868070E-01   0.00000000000000E+00   3.00909548413811E-10
     -1.70517555632134E-22   1.46031437822137E-09   1.76122392663501E-09  -3.23061604931306E-18
      8.37245182283874E-09
      0.00000000000000E+00  -7.20347458392353E-12   0.00000000000000E+00   5.21872958029819E-12  -4.25385967127523E-23
      7.19827602409371E-09   7.20349475367396E-09  -1.01223377907579E-18  -1.52909176295743E-01  -1.52909176287107E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.63613604610886E-09   0.00000000000000E+00  -8.63613604610886E-09
      4.22384328828553E-18  -5.87660216897236E-01  -5.88111773995745E-01   0.00000000000000E+00   3.00428718034909E-10
     -1.66949351144386E-22   1.13221257440023E-09   1.43264129243497E-09  -3.21160950920973E-18
      8.38366190643249E-09
      0.00000000000000E+00  -8.90361251437206E-12   0.00000000000000E+00   7.90439392916131E-12  -3.85590723804522E-23
      8.89574792802648E-09   8.90365232195561E-09  -9.39923996587379E-19  -1.87712135641724E-01  -1.87712135632786E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93734000354927E-09   0.00000000000000E+00  -8.93734000354927E-09
      4.12365495973997E-18  -5.97562689850050E-01  -5.97573613089145E-01   0.00000000000000E+00   2.88700203735764E-10
     -1.62199725875473E-22  -2.55012522142076E-10   3.36876815935262E-11  -3.18373096315260E-18
      8.39879551928405E-09
      0.00000000000000E+00  -1.43222683201417E-11   0.00000000000000E+00   1.79611789334926E-11  -1.82755919565128E-23
      1.43042757238820E-08   1.43222369028155E-08  -8.46099016881277E-19  -2.30697268081450E-01  -2.30697268072212E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.23785731966532E-09   0.00000000000000E+00  -9.23785731966532E-09
      3.98385280348619E-18  -6.03639272775915E-01  -6.02038074775926E-01   0.00000000000000E+00   2.82537424090826E-10
     -1.55649773063268E-22  -5.36691700724077E-09  -5.08437958315010E-09  -3.13775378660491E-18
      8.41879551928405E-09
      0.00000000000000E+00  -2.97711041868710E-11   0.00000000000000E+00   3.83027500019634E-11   5.52981591934735E-23
      2.97327692118529E-08   2.97710719618549E-08  -7.42534115185992E-19  -2.76253589912992E-01  -2.76253589903198E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79397270725994E-09   0.00000000000000E+00  -9.79397270725994E-09
      3.78797334934099E-18  -5.84963221141378E-01  -5.78670692835591E-01   0.00000000000000E+00   3.06757139320613E-10
     -1.45310079783026E-22  -2.02838563939154E-08  -1.99770992545949E-08  -3.04543923415500E-18
      8.43879551928405E-09
      0.00000000000000E+00  -4.99734562725130E-11   0.00000000000000E+00   5.00833311831374E-11   1.51565298570002E-22
      4.99233601066868E-08   4.99734434378701E-08  -6.69003850069833E-19  -3.08621657205601E-01  -3.08621657195114E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04864142226542E-08   0.00000000000000E+00  -1.04864142226542E-08
      3.57824506488790E-18  -5.29659273286878E-01  -5.17220284032004E-01   0.00000000000000E+00   3.16875417087711E-10
     -1.31993770206522E-22  -3.98039046323035E-08  -3.94870292152159E-08  -2.90924121481807E-18
      8.45879551928405E-09
      0.00000000000000E+00  -6.40182616415507E-11   0.00000000000000E+00   3.49745912879649E-11   2.17183587761552E-22
      6.39832564729985E-08   6.40182310642867E-08  -6.24069486454578E-19  -3.29617857490249E-01  -3.29617857479156E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10925394220227E-08   0.00000000000000E+00  -1.10925394220227E-08
      3.35639427644745E-18  -4.39568724182055E-01  -4.22895311237400E-01   0.00000000000000E+00   2.86402931878251E-10
     -1.15871054063175E-22  -5.32120945741421E-08  -5.29256916422640E-08  -2.73232478999287E-18
      8.47879551928405E-09
      0.00000000000000E+00  -6.41077184155909E-11   0.00000000000000E+00   3.32515288397604E-13   2.18774364137301E-22
      6.41074090762193E-08   6.41077415915079E-08  -6.04176693147978E-19  -3.40916768174818E-01  -3.40916768163177E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16408690311293E-08   0.00000000000000E+00  -1.16408690311293E-08
      3.12357689582486E-18  -3.20814369071905E-01  -3.04284781742995E-01   0.00000000000000E+00   2.35977964816606E-10
     -9.95607943260347E-23  -5.27028505251951E-08  -5.24668725603786E-08  -2.51940020267689E-18
      8.49879551928405E-09
      0.00000000000000E+00  -5.53659363281785E-11   0.00000000000000E+00  -2.16566772207462E-11   1.78161937119359E-22
      5.53875476484714E-08   5.53658909712508E-08  -5.97228130427754E-19  -3.47279313934109E-01  -3.47279313922183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19259728158756E-08   0.00000000000000E+00  -1.19259728158756E-08
      2.88505743950735E-18  -1.99977902202112E-01  -1.86291854751046E-01   0.00000000000000E+00   1.56944006265970E-10
     -8.34220967481053E-23  -4.35968621616412E-08  -4.34399181553753E-08  -2.28782930907960E-18
      8.51879551928405E-09
      0.00000000000000E+00  -4.84007988373085E-11   0.00000000000000E+00  -1.72809873714729E-11   1.39461655494864E-22
      4.84181001525572E-08   4.84008191651858E-08  -5.87330996224460E-19  -3.54826368655723E-01  -3.54826368643919E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18032575053604E-08   0.00000000000000E+00  -1.18032575053604E-08
      2.64899228940014E-18  -1.02518965830560E-01  -9.09884558862450E-02   0.00000000000000E+00   8.26495720529896E-11
     -7.02037981282390E-23  -3.66802112318784E-08  -3.65975616598255E-08  -2.06166129317568E-18
      8.52004551928405E-09
      0.00000000000000E+00  -4.73809548753561E-11   0.00000000000000E+00  -3.95656594966026E-11   1.36543917477479E-22
      4.74205209487621E-08   4.73809552892656E-08  -5.87007669588497E-19  -3.55164448415775E-01  -3.55164448403887E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18878772737544E-08   0.00000000000000E+00  -1.18878772737544E-08
      2.63413244280795E-18  -9.64639577352255E-02  -8.52814197755408E-02   0.00000000000000E+00   9.16010402958164E-11
     -6.84588408534555E-23  -3.55846790558072E-08  -3.54930780155115E-08  -2.04712477321946E-18
      8.52173301928405E-09
      0.00000000000000E+00  -4.63559676081201E-11   0.00000000000000E+00  -3.03797875809664E-11   1.32409298170805E-22
      4.63863687184237E-08   4.63559889308428E-08  -5.86465227038525E-19  -3.55681651954796E-01  -3.55681651942912E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18837126323737E-08   0.00000000000000E+00  -1.18837126323737E-08
      2.61407867774082E-18  -8.87616876177406E-02  -7.79007507211489E-02   0.00000000000000E+00   7.44815106620350E-11
     -6.51666583190198E-23  -3.45467578091316E-08  -3.44722762984697E-08  -2.02761345070230E-18
      8.52401114428405E-09
      0.00000000000000E+00  -4.51238704584811E-11   0.00000000000000E+00  -2.68763318037730E-11   1.27291305466081E-22
      4.51507545082699E-08   4.51238781764663E-08  -5.85268843932073E-19  -3.56552823799275E-01  -3.56552823787468E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18074593583502E-08   0.00000000000000E+00  -1.18074593583502E-08
      2.58717980939008E-18  -7.91920701729818E-02  -6.86952862828831E-02   0.00000000000000E+00   6.49963308231228E-11
     -5.91297270726535E-23  -3.33814151489391E-08  -3.33164188181161E-08  -2.00191096545801E-18
      8.52708661303405E-09
      0.00000000000000E+00  -4.35059335678333E-11   0.00000000000000E+00  -2.60677279434667E-11   1.21772230858937E-22
      4.35319896362013E-08   4.35059219082579E-08  -5.82672201169890E-19  -3.58070644676382E-01  -3.58070644664717E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16652025437174E-08   0.00000000000000E+00  -1.16652025437174E-08
      2.55130384350446E-18  -6.77668304255932E-02  -5.77349697856080E-02   0.00000000000000E+00   5.81204608309669E-11
     -4.78020598402142E-23  -3.18988398253712E-08  -3.18407193645403E-08  -1.96863164233456E-18
      8.53123849584655E-09
      0.00000000000000E+00  -4.13380303907869E-11   0.00000000000000E+00  -2.58442491094191E-11   1.17100567471141E-22
      4.13638199936602E-08   4.13379757445509E-08  -5.77191051509423E-19  -3.60793539829379E-01  -3.60793539817939E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14397046539905E-08   0.00000000000000E+00  -1.14397046539905E-08
      2.50380753037148E-18  -5.50738367495815E-02  -4.56539549351480E-02   0.00000000000000E+00   5.11223079726032E-11
     -2.68510033381764E-23  -2.99493933985333E-08  -2.98982710905608E-08  -1.92661647886205E-18
      8.53684353764342E-09
      0.00000000000000E+00  -3.86182321878604E-11   0.00000000000000E+00  -2.40048877995012E-11   1.15647836042497E-22
      3.86422712205231E-08   3.86182663327237E-08  -5.66238137726164E-19  -3.65673256570498E-01  -3.65673256559378E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11201682345713E-08   0.00000000000000E+00  -1.11201682345713E-08
      2.44147852262842E-18  -4.25617045767107E-02  -3.38980153718743E-02   0.00000000000000E+00   4.23720332951214E-11
      8.32057592285238E-24  -2.75404701314469E-08  -2.74980980981517E-08  -1.87524038490226E-18
      8.54062694085631E-09
      0.00000000000000E+00  -3.68073295043396E-11   0.00000000000000E+00  -2.36508637243237E-11   1.16675776049282E-22
      3.68309833215586E-08   3.68073324578344E-08  -5.57253597110184E-19  -3.69492327997813E-01  -3.69492327986907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09062274654126E-08   0.00000000000000E+00  -1.09062274654126E-08
      2.40021586659526E-18  -3.61671062555803E-02  -2.80065649239379E-02   0.00000000000000E+00   3.77570392797089E-11
      3.33169350758209E-23  -2.59388620317018E-08  -2.59011049924221E-08  -1.84296226948508E-18
      8.54573453519372E-09
      0.00000000000000E+00  -3.50146120787859E-11   0.00000000000000E+00  -1.73747705587668E-11   1.20910738292474E-22
      3.50319978089964E-08   3.50146230384378E-08  -5.43156267612767E-19  -3.75324530890880E-01  -3.75324530880209E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06704530676796E-08   0.00000000000000E+00  -1.06704530676796E-08
      2.34571552092927E-18  -3.02239457893944E-02  -2.25539305025028E-02   0.00000000000000E+00   2.86074252317692E-11
      6.41381565078546E-23  -2.43727773959900E-08  -2.43441699707582E-08  -1.80255925331650E-18
      8.55262978754921E-09
      0.00000000000000E+00  -3.34709775805390E-11   0.00000000000000E+00  -1.10613319691994E-11   1.28856153666476E-22
      3.34820367147943E-08   3.34709753828252E-08  -5.22363641777734E-19  -3.83798284742151E-01  -3.83798284731689E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04615966017526E-08   0.00000000000000E+00  -1.04615966017526E-08
      2.27358017231881E-18  -2.51389780647888E-02  -1.78894997232308E-02   0.00000000000000E+00   2.02907102088312E-11
      9.98398756912087E-23  -2.30296694912815E-08  -2.30093787810726E-08  -1.75121653054108E-18
      8.56193837822912E-09
      0.00000000000000E+00  -3.22542185020137E-11   0.00000000000000E+00  -6.43072977000160E-12   1.38822444275147E-22
      3.22606730274877E-08   3.22542422977178E-08  -4.93471935714529E-19  -3.95505648737334E-01  -3.95505648727035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02980407757354E-08   0.00000000000000E+00  -1.02980407757354E-08
      2.17771992593241E-18  -2.10015996793533E-02  -1.40839324763158E-02   0.00000000000000E+00   1.41144093084089E-11
      1.37526735546145E-22  -2.19703159312911E-08  -2.19562015219826E-08  -1.68424799021788E-18
      8.57450497564701E-09
      0.00000000000000E+00  -3.12379564848124E-11   0.00000000000000E+00  -3.95448708904738E-12   1.45379877544120E-22
      3.12419434146460E-08   3.12379889275571E-08  -4.55259131938223E-19  -4.11027658964706E-01  -4.11027658954543E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01634817523005E-08   0.00000000000000E+00  -1.01634817523005E-08
      2.04999954238722E-18  -1.76678568332063E-02  -1.10279734173465E-02   0.00000000000000E+00   1.02736068397478E-11
      1.69126365092350E-22  -2.10847807820965E-08  -2.10745071752566E-08  -1.59474041044899E-18
      8.59146988216116E-09
      0.00000000000000E+00  -3.01494126594288E-11   0.00000000000000E+00  -3.12779391563443E-12   1.38698258556717E-22
      3.01524896048984E-08   3.01493618109829E-08  -4.06600973534963E-19  -4.30995738754956E-01  -4.30995738744935E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00208113572374E-08   0.00000000000000E+00  -1.00208113572374E-08
      1.87999741451579E-18  -1.49173230209485E-02  -8.57547142808863E-03   0.00000000000000E+00   8.18447283203032E-12
      1.78597627574611E-22  -2.01367349265777E-08  -2.01285504537455E-08  -1.47339644098082E-18
      8.61146988216116E-09
      0.00000000000000E+00  -2.89098760860760E-11   0.00000000000000E+00  -3.02383889067153E-12   1.13627128709695E-22
      2.89128851450543E-08   2.89098613061637E-08  -3.53483874889006E-19  -4.53131972098833E-01  -4.53131972088968E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86494453078053E-09   0.00000000000000E+00  -9.86494453078053E-09
      1.68269852390018E-18  -1.28083093484161E-02  -6.80786882181823E-03   0.00000000000000E+00   7.05127386127798E-12
      1.53624389709032E-22  -1.90519680492446E-08  -1.90449167753832E-08  -1.32921464901117E-18
      8.63146988216116E-09
      0.00000000000000E+00  -2.78228017764877E-11   0.00000000000000E+00  -2.65303903975480E-12   8.10139595669100E-23
      2.78254151235869E-08   2.78227620845472E-08  -3.04101598166017E-19  -4.74065056648085E-01  -4.74065056638356E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.72889124908084E-09   0.00000000000000E+00  -9.72889124908084E-09
      1.48812069891856E-18  -1.13815089139217E-02  -5.68070721232899E-03   0.00000000000000E+00   5.98504498897005E-12
      1.09891131211609E-22  -1.80998558804554E-08  -1.80938708354663E-08  -1.18401910075254E-18
      8.65146988216116E-09
      0.00000000000000E+00  -2.69427455045652E-11   0.00000000000000E+00  -2.14562837872721E-12   5.10930111801650E-23
      2.69448792216737E-08   2.69427335932950E-08  -2.57903941766755E-19  -4.93990644579483E-01  -4.93990644569889E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59397822170727E-09   0.00000000000000E+00  -9.59397822170727E-09
      1.29624113448441E-18  -1.03921786661233E-02  -4.92613491237707E-03   0.00000000000000E+00   4.95302918759937E-12
      6.65111815278717E-23  -1.73537084007755E-08  -1.73487553715878E-08  -1.03833719271766E-18
      8.67146988216115E-09
      0.00000000000000E+00  -2.63127824520588E-11   0.00000000000000E+00  -1.53099221124442E-12   2.93097766748668E-23
      2.63143087607978E-08   2.63127777685866E-08  -2.14207467725982E-19  -5.13197519483688E-01  -5.13197519474145E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54236100039835E-09   0.00000000000000E+00  -9.54236100039835E-09
      1.10539391447645E-18  -9.68636424577567E-03  -4.40253324899791E-03   0.00000000000000E+00   4.16419347781652E-12
      3.41390855734643E-23  -1.67745809616660E-08  -1.67704167681882E-08  -8.91186446750463E-19
      8.69146988216115E-09
      0.00000000000000E+00  -2.70592046313443E-11   0.00000000000000E+00   1.86299659376572E-12   1.63660372700092E-23
      2.70573343647590E-08   2.70591973613528E-08  -1.68640260234258E-19  -5.33736177308645E-01  -5.33736177298183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04621464247507E-08   0.00000000000000E+00  -1.04621464247507E-08
      8.96150985981433E-19  -9.37725581119399E-03  -4.14804374027297E-03   0.00000000000000E+00   3.09377746482451E-12
      1.46380629006622E-23  -1.66001447140670E-08  -1.65970509366022E-08  -7.27510725747175E-19
      8.71146988216115E-09
      0.00000000000000E+00  -2.79679164612756E-11   0.00000000000000E+00   2.27071305414296E-12   9.62987832894271E-24
      2.79656032544370E-08   2.79678739674911E-08  -1.22443919371267E-19  -5.55106105723934E-01  -5.55106105712695E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12387767749409E-08   0.00000000000000E+00  -1.12387767749409E-08
      6.71375450482614E-19  -9.25885222507214E-03  -3.98803403038747E-03   0.00000000000000E+00   2.22804599942318E-12
      4.69882358287017E-24  -1.67313252385495E-08  -1.67290971925501E-08  -5.48931531111346E-19
      8.71396988216115E-09
      0.00000000000000E+00  -2.82097436543430E-11   0.00000000000000E+00   4.75748323561166E-12   8.83860307606504E-24
      2.82049497008881E-08   2.82097071841237E-08  -1.16727861598880E-19  -5.57798852071372E-01  -5.57798852059885E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14863593842077E-08   0.00000000000000E+00  -1.14863593842077E-08
      6.42659552022095E-19  -9.25122784124839E-03  -3.98222090108676E-03   0.00000000000000E+00   2.56076735042597E-12
      3.47667018067992E-24  -1.67259085672673E-08  -1.67233477999169E-08  -5.25931690423215E-19
      8.71734488216115E-09
      0.00000000000000E+00  -2.85770307584359E-11   0.00000000000000E+00   5.39656230965222E-12   7.97915287739712E-24
      2.85716660812069E-08   2.85770626435165E-08  -1.08916402266124E-19  -5.61494957671110E-01  -5.61494957659393E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17168049638051E-08   0.00000000000000E+00  -1.17168049638051E-08
      6.03115335269252E-19  -9.30121336248406E-03  -3.98906925528076E-03   0.00000000000000E+00   4.86171251813937E-13
      2.16868614345898E-24  -1.68607438509630E-08  -1.68602576797111E-08  -4.94198933003128E-19
      8.72190113216115E-09
      0.00000000000000E+00  -2.90308356049783E-11   0.00000000000000E+00   4.95385505681731E-12   7.13349028160649E-24
      2.90259010622681E-08   2.90308549173250E-08  -9.83047436591665E-20  -5.66540033461228E-01  -5.66540033449304E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19245579243051E-08   0.00000000000000E+00  -1.19245579243051E-08
      5.48784068226637E-19  -9.38895255721591E-03  -3.99928829550866E-03   0.00000000000000E+00  -2.06626266276025E-13
      8.99519938805010E-25  -1.71060903667538E-08  -1.71062969930201E-08  -4.50479324567471E-19
      8.72497660091115E-09
      0.00000000000000E+00  -2.93006754428940E-11   0.00000000000000E+00   4.37127913082260E-12   6.66832319176384E-24
      2.92962678177776E-08   2.93006390969084E-08  -9.11590304762978E-20  -5.69953109435480E-01  -5.69953109423450E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20302554658888E-08   0.00000000000000E+00  -1.20302554658888E-08
      5.11785393486780E-19  -9.44448392570447E-03  -4.00312067673470E-03   0.00000000000000E+00  -2.06117363374615E-13
      2.11190717061586E-25  -1.72701775136560E-08  -1.72703836310194E-08  -4.20626363010482E-19
      8.72912848372365E-09
      0.00000000000000E+00  -2.95254195148408E-11   0.00000000000000E+00   2.72112153539324E-12   6.18086183977716E-24
      2.95227035752714E-08   2.95254246968068E-08  -8.15844522451638E-20  -5.74541368018226E-01  -5.74541368006151E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20744757179289E-08   0.00000000000000E+00  -1.20744757179289E-08
      4.61653585283562E-19  -9.49150051584203E-03  -3.99324638932850E-03   0.00000000000000E+00   2.42800174809412E-13
     -4.61708183760671E-25  -1.74511917790526E-08  -1.74509489788778E-08  -3.80069133038398E-19
      8.73473352552053E-09
      0.00000000000000E+00  -2.95665659571098E-11   0.00000000000000E+00   4.06822935548798E-13   5.68198705531969E-24
      2.95661150338940E-08   2.95665218568296E-08  -6.89623668946144E-20  -5.80615667085718E-01  -5.80615667073753E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19657110947329E-08   0.00000000000000E+00  -1.19657110947329E-08
      3.94585274468253E-19  -9.49715716511373E-03  -3.95168584234960E-03   0.00000000000000E+00   9.94734225320532E-13
     -1.05848739655604E-24  -1.76018054963219E-08  -1.76008107620966E-08  -3.25622907573638E-19
      8.74230033194631E-09
      0.00000000000000E+00  -2.91943192372077E-11   0.00000000000000E+00  -2.39149551625109E-12   5.16363133884326E-24
      2.91966907886599E-08   2.91942992931436E-08  -5.28764218643048E-20  -5.88398918577980E-01  -5.88398918566473E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15073934121603E-08   0.00000000000000E+00  -1.15073934121603E-08
      3.07511056053126E-19  -9.42815000172712E-03  -3.85555212380241E-03   0.00000000000000E+00   1.60390259994615E-12
     -1.53734198824689E-24  -1.76885097835835E-08  -1.76869058809836E-08  -2.54634634188821E-19
      8.75251552062111E-09
      0.00000000000000E+00  -2.78016774869300E-11   0.00000000000000E+00  -6.69955671666223E-12   4.55865606319117E-24
      2.78083756247091E-08   2.78016760679924E-08  -3.42560237505618E-20  -5.97445882618840E-01  -5.97445882608747E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00934640295238E-08   0.00000000000000E+00  -1.00934640295238E-08
      2.04404416609186E-19  -9.23639266218683E-03  -3.65708089617643E-03   0.00000000000000E+00   1.73702125168969E-12
     -1.89337810261582E-24  -1.77099490597202E-08  -1.77082120384685E-08  -1.70148392858624E-19
      8.76630602533210E-09
      0.00000000000000E+00  -2.32796100057802E-11   0.00000000000000E+00  -1.61589510461939E-11   3.60370649623918E-24
      2.32957865617399E-08   2.32796276106937E-08  -2.07780230537171E-20  -6.03856440386005E-01  -6.03856440380421E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58399965593570E-09   0.00000000000000E+00  -5.58399965593570E-09
      1.27398243047858E-19  -8.77492385082400E-03  -3.19957550916868E-03   0.00000000000000E+00   1.04172476822141E-12
     -2.18057489097479E-24  -1.76966696795261E-08  -1.76956279547579E-08  -1.06620219994140E-19
      8.78492320669193E-09
      0.00000000000000E+00  -1.02939581462196E-11   0.00000000000000E+00  -3.43880328696777E-11   1.54669130468502E-24
      1.03283529475023E-08   1.02939649146326E-08  -4.62118699492601E-20  -5.90591425491192E-01  -5.90591425498588E-01
      0.00000000000000E+00   0.00000000000000E+00   7.39608519880170E-09   0.00000000000000E+00   7.39608519880170E-09
      2.65092502546715E-19  -7.65832133364050E-03  -2.08472949945459E-03   0.00000000000000E+00  -1.27296114813035E-12
     -2.67031415234299E-24  -1.76887771522862E-08  -1.76900501134344E-08  -2.18880632597455E-19
      8.80492320669193E-09
      0.00000000000000E+00   8.74499665321466E-12   0.00000000000000E+00  -4.68036774128557E-11  -2.31063057569371E-24
     -8.69810403758937E-09  -8.74490771500223E-09  -1.50112609195964E-19  -5.40274399240874E-01  -5.40274399267298E-01
      0.00000000000000E+00   0.00000000000000E+00   2.64241801185850E-08   0.00000000000000E+00   2.64241801185850E-08
      7.93576104918414E-19  -5.99871240211548E-03  -4.28558397139576E-04   0.00000000000000E+00  -5.41274600456849E-12
     -4.85243760631314E-24  -1.76738596575782E-08  -1.76792724035828E-08  -6.43463495722450E-19
      8.82492320669193E-09
      0.00000000000000E+00   2.28159777723566E-11   0.00000000000000E+00  -3.48734375788054E-11  -1.25829208195924E-23
     -2.27811291467833E-08  -2.28160025843621E-08  -3.46314086736208E-19  -4.54585093578431E-01  -4.54585093618872E-01
      0.00000000000000E+00   0.00000000000000E+00   4.04406438180516E-08   0.00000000000000E+00   4.04406438180516E-08
      1.60238898127945E-18  -4.30695193183001E-03   1.24602725713976E-03   0.00000000000000E+00  -1.17629083948282E-11
     -1.93970673682473E-23  -1.76128783252946E-08  -1.76246412336894E-08  -1.25607489454324E-18
      8.84492320669193E-09
      0.00000000000000E+00   2.32441579372181E-11   0.00000000000000E+00  -1.43971107705187E-12  -3.63508620199290E-23
     -2.32427190520819E-08  -2.32441587631590E-08  -6.35852039825058E-19  -3.38946889343725E-01  -3.38946889384633E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09076476300141E-08   0.00000000000000E+00   4.09076476300141E-08
      2.42054193387973E-18  -1.99951922985415E-03   3.56568831557325E-03   0.00000000000000E+00  -2.71829716630061E-11
     -6.49693203600851E-23  -1.76363058951920E-08  -1.76634888668551E-08  -1.78468989405467E-18
      8.86492320669193E-09
      0.00000000000000E+00   1.46951579532043E-11   0.00000000000000E+00   2.04485322741146E-11  -4.30598491674869E-23
     -1.47156175653635E-08  -1.46951690330894E-08  -9.15045983798430E-19  -2.15851220914978E-01  -2.15851220945814E-01
      0.00000000000000E+00   0.00000000000000E+00   3.08359342735228E-08   0.00000000000000E+00   3.08359342735228E-08
      3.03726061935018E-18  -1.01167964830685E-02  -5.03136720810920E-03   0.00000000000000E+00  -5.79006599045891E-11
     -8.17921506325667E-23  -1.60828645805286E-08  -1.61407652404333E-08  -2.12221463555175E-18
      8.88492320669193E-09
      0.00000000000000E+00   9.82995853384717E-12   0.00000000000000E+00   1.12050559475692E-11  -4.59360710997065E-23
     -9.84115026419549E-09  -9.82994520824797E-09  -1.11029639145627E-18  -1.14490590864865E-01  -1.14490590887482E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26174052205320E-08   0.00000000000000E+00   2.26174052205320E-08
      3.48960872376082E-18  -4.02103730124397E-02  -3.61814652518671E-02   0.00000000000000E+00  -1.08000012191181E-10
     -9.48819621184139E-23  -1.26794600000929E-08  -1.27874600122841E-08  -2.37931233230455E-18
      8.90492320669193E-09
      0.00000000000000E+00   5.64303249876765E-12   0.00000000000000E+00   9.59570942496560E-12  -4.75830414818992E-23
     -5.65260014182837E-09  -5.64300443240346E-09  -1.22171237789319E-18  -4.96887085988534E-02  -4.96887086140298E-02
      0.00000000000000E+00   0.00000000000000E+00   1.51764199041577E-08   0.00000000000000E+00   1.51764199041577E-08
      3.79313712184398E-18  -8.84243923711403E-02  -8.54207200540199E-02   0.00000000000000E+00  -1.60887676602756E-10
     -1.07340137707346E-22  -9.37252779515134E-09  -9.53341547175421E-09  -2.57142474395079E-18
      8.92492320669193E-09
      0.00000000000000E+00   1.96391601570854E-12   0.00000000000000E+00   8.77033408892562E-12  -4.80048501330004E-23
     -1.97268796366938E-09  -1.96391762958050E-09  -1.25955002362007E-18  -2.56427360687345E-02  -2.56427360773289E-02
      0.00000000000000E+00   0.00000000000000E+00   8.59439040660417E-09   0.00000000000000E+00   8.59439040660417E-09
      3.96502492997606E-18  -1.48728558724082E-01  -1.46639500705950E-01   0.00000000000000E+00  -1.77996217280510E-10
     -1.17986820381985E-22  -6.45247655974307E-09  -6.63047277702370E-09  -2.70547490635600E-18
      8.94492320669193E-09
      0.00000000000000E+00   5.97541860272169E-13   0.00000000000000E+00   3.30203078442432E-12  -4.80824532889674E-23
     -6.00810644565504E-10  -5.97508613781128E-10  -1.27011562017262E-18  -1.78738433479943E-02  -1.78738433536418E-02
      0.00000000000000E+00   0.00000000000000E+00   5.64754494381386E-09   0.00000000000000E+00   5.64754494381386E-09
      4.07797582885234E-18  -2.08412830283769E-01  -2.06821709293059E-01   0.00000000000000E+00  -1.92337126137077E-10
     -1.27506854214531E-22  -4.85769920389553E-09  -5.05003633003273E-09  -2.80786020867972E-18
      8.96492320669193E-09
      0.00000000000000E+00   2.54593611539264E-13   0.00000000000000E+00   8.32049769451538E-13  -4.81020944929135E-23
     -2.55436005295838E-10  -2.54603955526435E-10  -1.27387429556944E-18  -1.45043315273312E-02  -1.45043315314974E-02
      0.00000000000000E+00   0.00000000000000E+00   4.16627636679815E-09   0.00000000000000E+00   4.16627636679815E-09
      4.16130135618830E-18  -2.59151167059373E-01  -2.57918702957315E-01   0.00000000000000E+00  -1.92665597885911E-10
     -1.35747000076709E-22  -3.71900681338567E-09  -3.91167241127172E-09  -2.88742706061886E-18
      8.98492320669193E-09
      0.00000000000000E+00   1.71933348052490E-13   0.00000000000000E+00   2.00152435912581E-13  -4.81108492172564E-23
     -1.72168564383402E-10  -1.71968411947538E-10  -1.27601752565893E-18  -1.24975797076221E-02  -1.24975797106222E-02
      0.00000000000000E+00   0.00000000000000E+00   3.00005089973547E-09   0.00000000000000E+00   3.00005089973547E-09
      4.22130237418301E-18  -2.96836511006377E-01  -2.95945452547815E-01   0.00000000000000E+00  -1.64765307100292E-10
     -1.42098919391720E-22  -2.66331718068746E-09  -2.82808248778790E-09  -2.94528484852408E-18
      9.00492320669193E-09
      0.00000000000000E+00   1.43002255832119E-13   0.00000000000000E+00   7.10372265707092E-14  -4.81142333235099E-23
     -1.43110382837248E-10  -1.43039345610726E-10  -1.27760790277440E-18  -1.11654539856450E-02  -1.11654539877102E-02
      0.00000000000000E+00   0.00000000000000E+00   2.06519404823264E-09   0.00000000000000E+00   2.06519404823264E-09
      4.26260625514766E-18  -3.22241679253901E-01  -3.21636056077932E-01   0.00000000000000E+00  -1.21717599723353E-10
     -1.46486463703181E-22  -1.80043710289845E-09  -1.92215470262195E-09  -2.98499835237326E-18
      9.02492320669193E-09
      0.00000000000000E+00   1.31521663681178E-13   0.00000000000000E+00   2.92876606463328E-14  -4.81155256445899E-23
     -1.31577934841873E-10  -1.31548647181274E-10  -1.27898537996439E-18  -1.02339914516997E-02  -1.02339914530348E-02
      0.00000000000000E+00   0.00000000000000E+00   1.33514274748600E-09   0.00000000000000E+00   1.33514274748600E-09
      4.28930911009739E-18  -3.37305756137783E-01  -3.36926537284312E-01   0.00000000000000E+00  -7.51568659421056E-11
     -1.49094034174531E-22  -1.12843723436242E-09  -1.20359410030467E-09  -3.01032373013299E-18
      9.04492320669193E-09
      0.00000000000000E+00   1.22888258383671E-13   0.00000000000000E+00   2.32424773480178E-14  -4.81144971940485E-23
     -1.22907094262854E-10  -1.22883851785554E-10  -1.28020038883902E-18  -9.59620421736659E-03  -9.59620421817030E-03
      0.00000000000000E+00   0.00000000000000E+00   8.03717211137053E-10   0.00000000000000E+00   8.03717211137053E-10
      4.30538345432012E-18  -3.44677921187066E-01  -3.44463415744377E-01   0.00000000000000E+00  -3.56427099499005E-11
     -1.50313515118182E-22  -6.45190649401553E-10  -6.80833359351604E-10  -3.02518306548110E-18
      9.06492320669193E-09
      0.00000000000000E+00   9.15692029959042E-14   0.00000000000000E+00   8.39234235980337E-14  -4.81014239878365E-23
     -9.16585971285908E-11  -9.15746737050409E-11  -1.28080038124934E-18  -9.34078018742813E-03  -9.34078018812792E-03
      0.00000000000000E+00   0.00000000000000E+00   6.99792485374104E-10   0.00000000000000E+00   6.99792485374104E-10
      4.31937930402761E-18  -3.51470293558843E-01  -3.51278667712457E-01   0.00000000000000E+00  -3.16725807424360E-11
     -1.51369435608628E-22  -5.76545230926460E-10  -6.08217811669048E-10  -3.03857892277827E-18
      9.07492320669192E-09
      0.00000000000000E+00   7.92620082100956E-14   0.00000000000000E+00   6.94738857995556E-14  -4.80930494006903E-23
     -7.93511137529615E-11  -7.92816398672100E-11  -1.28098044595442E-18  -9.27460998732408E-03  -9.27460998804186E-03
      0.00000000000000E+00   0.00000000000000E+00   7.17779329347742E-10   0.00000000000000E+00   7.17779329347742E-10
      4.32655709732109E-18  -3.55195718487708E-01  -3.54994551567948E-01   0.00000000000000E+00  -3.52485880951067E-11
     -1.51947113482986E-22  -6.03249101385114E-10  -6.38497689480372E-10  -3.04557665136667E-18
      9.08842320669193E-09
      0.00000000000000E+00   4.97798475664795E-14   0.00000000000000E+00   1.21176740642611E-13  -4.80741663123188E-23
     -4.98850909348637E-11  -4.97639141942692E-11  -1.28083292861951E-18  -9.31624038364261E-03  -9.31624038468086E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03825463694070E-09   0.00000000000000E+00   1.03825463694070E-09
      4.34057353491978E-18  -3.64188095978549E-01  -3.63876650342873E-01   0.00000000000000E+00  -6.80844403178576E-11
     -1.53422724733081E-22  -9.20406282428412E-10  -9.88490722746423E-10  -3.05974060630027E-18
      9.10664820669192E-09
      0.00000000000000E+00   2.95740053808236E-14   0.00000000000000E+00   7.12900894526977E-14  -4.80441368269572E-23
     -2.96095628463964E-11  -2.95382727569917E-11  -1.28028527058236E-18  -9.37440981353759E-03  -9.37440981507942E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54183574702576E-09   0.00000000000000E+00   1.54183574702576E-09
      4.36867349140933E-18  -3.83984897372711E-01  -3.83508406861754E-01   0.00000000000000E+00  -1.19959015820384E-10
     -1.56851161310420E-22  -1.39233845844818E-09  -1.51229747426872E-09  -3.08838822082697E-18
      9.12664820669192E-09
      0.00000000000000E+00   4.89532449316118E-14   0.00000000000000E+00  -3.53744399599932E-14  -4.80216354171436E-23
     -4.89339764134270E-11  -4.89693508534350E-11  -1.28009806620054E-18  -9.10713817649105E-03  -9.10713817823216E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74110144593302E-09   0.00000000000000E+00   1.74110144593302E-09
      4.40349552032799E-18  -4.08347609244568E-01  -4.07814454314534E-01   0.00000000000000E+00  -1.45843456195672E-10
     -1.61281916823980E-22  -1.54628863888375E-09  -1.69213209507958E-09  -3.12339745412745E-18
      9.14664820669192E-09
      0.00000000000000E+00   9.65288188051106E-14   0.00000000000000E+00  -1.13857443008781E-13  -4.80185206040140E-23
     -9.64497460299555E-11  -9.65636034730123E-11  -1.28088474552445E-18  -8.26641701828948E-03  -8.26641702004816E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75867291016108E-09   0.00000000000000E+00   1.75867291016108E-09
      4.43866897853121E-18  -4.31855125301865E-01  -4.31331428514441E-01   0.00000000000000E+00  -1.54056124563854E-10
     -1.65806401537358E-22  -1.50805318212396E-09  -1.66210930668798E-09  -3.15778423300676E-18
      9.16664820669192E-09
      0.00000000000000E+00   1.52462263764494E-13   0.00000000000000E+00  -1.44791210246942E-13  -4.80361907048397E-23
     -1.52331570051910E-10  -1.52476361262205E-10  -1.28280743609097E-18  -6.77325601795470E-03  -6.77325601970813E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75342431251155E-09   0.00000000000000E+00   1.75342431251155E-09
      4.47373746478144E-18  -4.53958403699594E-01  -4.53453976273568E-01   0.00000000000000E+00  -1.59072198717822E-10
     -1.70332244728627E-22  -1.44187575253148E-09  -1.60094795124947E-09  -3.19093002869048E-18
      9.18664820669192E-09
      0.00000000000000E+00   1.71933348052490E-13   0.00000000000000E+00  -5.90867991761428E-14  -4.80587930670830E-23
     -1.71891991302391E-10  -1.71951078101616E-10  -1.28513501209340E-18  -5.06763579536555E-03  -5.06763579706600E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70045730155511E-09   0.00000000000000E+00   1.70045730155511E-09
      4.50774661081254E-18  -4.74869256030041E-01  -4.74387652382452E-01   0.00000000000000E+00  -1.61936964900436E-10
     -1.74805942398320E-22  -1.36656925855282E-09  -1.52850622345343E-09  -3.22261159871915E-18
      9.20664820669192E-09
      0.00000000000000E+00   1.85342679684789E-13   0.00000000000000E+00  -4.66889000726563E-14  -4.80860944384477E-23
     -1.85331057948377E-10  -1.85377746848498E-10  -1.28774464330085E-18  -3.21750443146087E-03  -3.21750443311076E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64989151908992E-09   0.00000000000000E+00   1.64989151908992E-09
      4.54074444119434E-18  -4.94768643253904E-01  -4.94307201133044E-01   0.00000000000000E+00  -1.64929772859183E-10
     -1.79237666083319E-22  -1.29958399938211E-09  -1.46451377224147E-09  -3.25299979789349E-18
      9.22664820669192E-09
      0.00000000000000E+00   1.53380711136570E-14   0.00000000000000E+00   4.34078537669526E-13  -4.80424461282417E-23
     -1.58017877886473E-11  -1.53677092510258E-11  -1.28697533270053E-18  -3.43540643456267E-03  -3.43540643587695E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31427909101275E-09   0.00000000000000E+00   1.31427909101275E-09
      4.56703002301460E-18  -5.13998561625029E-01  -5.13589298909466E-01   0.00000000000000E+00  -1.51370775976380E-10
     -1.83202578276712E-22  -1.14754060578521E-09  -1.29891138176177E-09  -3.28005469031407E-18
      9.24664820669192E-09
      0.00000000000000E+00  -1.81613783354163E-12   0.00000000000000E+00   4.82169561425962E-12  -4.72551312763775E-23
      1.81127327172231E-09   1.81609496733652E-09  -1.24975748965617E-18  -2.53999017802232E-02  -2.53999017785707E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65244336970459E-09   0.00000000000000E+00  -1.65244336970459E-09
      4.53398115562050E-18  -5.34570889899420E-01  -5.34519354215203E-01   0.00000000000000E+00   1.75196759944849E-11
     -1.82738882012396E-22  -1.81171273626152E-10  -1.63651597631850E-10  -3.28422366596433E-18
      9.26664820669192E-09
      0.00000000000000E+00  -3.58176106161913E-12   0.00000000000000E+00   4.86089337473824E-12  -4.58902315017984E-23
      3.57693939526589E-09   3.58180028864058E-09  -1.17818367169112E-18  -6.61075924216520E-02  -6.61075924172547E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.39732428264490E-09   0.00000000000000E+00  -4.39732428264490E-09
      4.44603466996761E-18  -5.55947480245240E-01  -5.56204493914087E-01   0.00000000000000E+00   1.63610338108064E-10
     -1.78374502732860E-22   6.51913655896518E-10   8.15523994004403E-10  -3.26785099827649E-18
      9.27664820669192E-09
      0.00000000000000E+00  -4.96393251185520E-12   0.00000000000000E+00   7.37310899586018E-12  -4.49676926100578E-23
      4.95659714949472E-09   4.96397025849053E-09  -1.12942674436918E-18  -9.27041147721043E-02  -9.27041147657171E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.38728405379791E-09   0.00000000000000E+00  -6.38728405379791E-09
      4.38216182942963E-18  -5.66882330895356E-01  -5.67330868644087E-01   0.00000000000000E+00   2.48122863188188E-10
     -1.74994823434290E-22   1.17519093211924E-09   1.42331379530725E-09  -3.25273508506045E-18
      9.28002320669192E-09
      0.00000000000000E+00  -5.54521785364164E-12   0.00000000000000E+00   9.03620167373609E-12  -4.46214684959012E-23
      5.53616352953799E-09   5.54519973121168E-09  -1.11118790574681E-18  -1.02424315613294E-01  -1.02424315606121E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17271016258323E-09   0.00000000000000E+00  -7.17271016258323E-09
      4.35795393263091E-18  -5.70593934416144E-01  -5.71106817052970E-01   0.00000000000000E+00   2.72414417907399E-10
     -1.73726556289176E-22   1.35509601346407E-09   1.62751043137129E-09  -3.24676602688409E-18
      9.28457945669192E-09
      0.00000000000000E+00  -6.09986822163789E-12   0.00000000000000E+00   6.60212374166347E-12  -4.41324613042763E-23
      6.09324913412921E-09   6.09985125787083E-09  -1.08452563550916E-18  -1.16386640283583E-01  -1.16386640275724E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.85829668341137E-09   0.00000000000000E+00  -7.85829668341137E-09
      4.32214956836712E-18  -5.75597959692081E-01  -5.76152110597442E-01   0.00000000000000E+00   2.93400449353977E-10
     -1.71862684157535E-22   1.46504497618717E-09   1.75844542554097E-09  -3.23762393285796E-18
      9.29073039419192E-09
      0.00000000000000E+00  -6.69483842926825E-12   0.00000000000000E+00   5.32907326072917E-12  -4.33900823860936E-23
      6.68949227343162E-09   6.69482134669230E-09  -1.04638263243530E-18  -1.35891577020766E-01  -1.35891577012371E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.39482987558693E-09   0.00000000000000E+00  -8.39482987558693E-09
      4.27051349447925E-18  -5.82205252403553E-01  -5.82741016072312E-01   0.00000000000000E+00   3.01981089250358E-10
     -1.69235441436897E-22   1.39802743964439E-09   1.70000852889457E-09  -3.22413086204394E-18
      9.29903415981692E-09
      0.00000000000000E+00  -7.56313857482821E-12   0.00000000000000E+00   5.64896141208397E-12  -4.18794150536601E-23
      7.55748437535300E-09   7.56313333676504E-09  -9.93104367662163E-19  -1.62280502745229E-01  -1.62280502736470E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.75899973917375E-09   0.00000000000000E+00  -8.75899973917375E-09
      4.19778081353571E-18  -5.90559309103703E-01  -5.90936290063261E-01   0.00000000000000E+00   2.97200262221865E-10
     -1.65678369306136E-22   8.98666140186898E-10   1.19586640240860E-09  -3.20467644587355E-18
      9.31024424341067E-09
      0.00000000000000E+00  -9.62441001197673E-12   0.00000000000000E+00   9.46422949841670E-12  -3.64326316221305E-23
      9.61491361871475E-09   9.62437784821313E-09  -9.20836199466374E-19  -1.96644196702077E-01  -1.96644196693065E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.01233882802817E-09   0.00000000000000E+00  -9.01233882802817E-09
      4.09675174189832E-18  -5.99734951683320E-01  -5.99542483625061E-01   0.00000000000000E+00   2.85117723409922E-10
     -1.60947698244972E-22  -8.97156743594587E-10  -6.12039020184826E-10  -3.17591554243195E-18
      9.32537785626223E-09
      0.00000000000000E+00  -1.60648385191801E-11   0.00000000000000E+00   2.12529017884527E-11  -1.04206112315739E-23
      1.60435728167818E-08   1.60648257185702E-08  -8.28575026419189E-19  -2.38503195128313E-01  -2.38503195118993E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.31965278001543E-09   0.00000000000000E+00  -9.31965278001543E-09
      3.95571172481458E-18  -6.03511393721998E-01  -6.01387050864444E-01   0.00000000000000E+00   2.83115721652899E-10
     -1.54304408150542E-22  -7.02828866020747E-09  -6.74517293855473E-09  -3.12713669839539E-18
      9.34537785626223E-09
      0.00000000000000E+00  -3.28381673411791E-11   0.00000000000000E+00   3.65906382290980E-11   7.00664473285423E-23
      3.27965901119803E-08   3.28331807502095E-08  -7.29307173542013E-19  -2.82016396408181E-01  -2.82016396398279E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90233052164377E-09   0.00000000000000E+00  -9.90233052164377E-09
      3.75766511438170E-18  -5.79498372963734E-01  -5.72273788082860E-01   0.00000000000000E+00   3.15697905720764E-10
     -1.43583688901489E-22  -2.32465481342863E-08  -2.29308502285657E-08  -3.02835794083969E-18
      9.36537785626223E-09
      0.00000000000000E+00  -5.28090706890581E-11   0.00000000000000E+00   4.95393006219517E-11   1.65233537486201E-22
      5.27595144331745E-08   5.28090537337966E-08  -6.60396888983075E-19  -3.12500632042169E-01  -3.12500632031583E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05861248193029E-08   0.00000000000000E+00  -1.05861248193029E-08
      3.54594261799564E-18  -5.18550802286062E-01  -5.05249824584539E-01   0.00000000000000E+00   3.15464051091011E-10
     -1.29729992207592E-22  -4.25383929655844E-08  -4.22229289144936E-08  -2.88554572901257E-18
      9.38537785626223E-09
      0.00000000000000E+00  -6.50971617695276E-11   0.00000000000000E+00   3.06254624631826E-11   2.22475910165563E-22
      6.50665039281161E-08   6.50971293905795E-08  -6.19475793247169E-19  -3.31932870392364E-01  -3.31932870381186E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11780465529928E-08   0.00000000000000E+00  -1.11780465529928E-08
      3.32238168693579E-18  -4.23571599116459E-01  -4.06585102855985E-01   0.00000000000000E+00   2.79897515906330E-10
     -1.13414773984853E-22  -5.41989803534931E-08  -5.39190828375869E-08  -2.70290589368862E-18
      9.40537785626223E-09
      0.00000000000000E+00  -6.29972236980147E-11   0.00000000000000E+00  -5.11250399585844E-12   2.14243200720054E-22
      6.30023404500001E-08   6.29972279460044E-08  -6.02842970785680E-19  -3.41976235602552E-01  -3.41976235590837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17147849088576E-08   0.00000000000000E+00  -1.17147849088576E-08
      3.08808598875863E-18  -3.01865622370351E-01  -2.85709106291670E-01   0.00000000000000E+00   2.26934682519400E-10
     -9.70513379457677E-23  -5.15093777196660E-08  -5.12824430371467E-08  -2.48524301797296E-18
      9.42537785626223E-09
      0.00000000000000E+00  -5.41845374734781E-11   0.00000000000000E+00  -2.18416244946486E-11   1.72122064741633E-22
      5.42063954587994E-08   5.41845538343050E-08  -5.96081093702822E-19  -3.48279047059828E-01  -3.48279047047902E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19256563161272E-08   0.00000000000000E+00  -1.19256563161272E-08
      2.84957286243609E-18  -1.83771100379109E-01  -1.70457099246279E-01   0.00000000000000E+00   1.43563324446529E-10
     -8.15819718796000E-23  -4.24024608426242E-08  -4.22588975181778E-08  -2.25349176873327E-18
      9.44537785626223E-09
      0.00000000000000E+00  -4.74384496808480E-11   0.00000000000000E+00  -1.66646641716707E-11   1.34855632484307E-22
      4.74552226389711E-08   4.74385579747996E-08  -5.84945649951147E-19  -3.56278591109220E-01  -3.56278591097458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17622944304397E-08   0.00000000000000E+00  -1.17622944304397E-08
      2.61432697382730E-18  -9.07169796896304E-02  -7.94767387270530E-02   0.00000000000000E+00   7.50856390603115E-11
     -6.45464348913208E-23  -3.57513491834200E-08  -3.56762635443598E-08  -2.02938132387615E-18
      9.45537785626223E-09
      0.00000000000000E+00  -4.25325630429080E-11   0.00000000000000E+00  -2.42552701092182E-11   1.21196465420837E-22
      4.25568001692887E-08   4.25325448991796E-08  -5.74065215754136E-19  -3.62046682239885E-01  -3.62046682228384E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15006830623745E-08   0.00000000000000E+00  -1.15006830623745E-08
      2.49932014320355E-18  -5.66535757014173E-02  -4.68765422949904E-02   0.00000000000000E+00   5.52222882804407E-11
     -2.71726501056050E-23  -3.10870841250857E-08  -3.10318618368053E-08  -1.92525492744942E-18
      9.46887785626223E-09
      0.00000000000000E+00  -3.69180024126747E-11   0.00000000000000E+00  -2.05614122427649E-11   1.23069480707678E-22
      3.69385664078484E-08   3.69180049956057E-08  -5.43200184660667E-19  -3.75305736761708E-01  -3.75305736750836E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08722654391913E-08   0.00000000000000E+00  -1.08722654391913E-08
      2.35254455977447E-18  -3.31092828926183E-02  -2.49031665265081E-02   0.00000000000000E+00   3.58417259164149E-11
      5.38988889007637E-23  -2.60815812823310E-08  -2.60457395564146E-08  -1.80934437511380E-18
      9.47343410626223E-09
      0.00000000000000E+00  -3.48297286227871E-11   0.00000000000000E+00  -2.26063060206465E-11   1.25592390461981E-22
      3.48523686535247E-08   3.48297623475042E-08  -5.30765153776262E-19  -3.80414944957066E-01  -3.80414944946415E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06511423841964E-08   0.00000000000000E+00  -1.06511423841964E-08
      2.30401529228648E-18  -2.79270694863650E-02  -2.03092106389234E-02   0.00000000000000E+00   3.27097460980920E-11
      8.13307557614989E-23  -2.42113297094060E-08  -2.41786199633078E-08  -1.77325013851021E-18
      9.47958504376223E-09
      0.00000000000000E+00  -3.32168431926857E-11   0.00000000000000E+00  -1.29928347180212E-11   1.31421146800279E-22
      3.32298056506003E-08   3.32168128158824E-08  -5.12264825397296E-19  -3.87925166064561E-01  -3.87925166054123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04376396895535E-08   0.00000000000000E+00  -1.04376396895535E-08
      2.23981402290851E-18  -2.37055985965941E-02  -1.65286478918235E-02   0.00000000000000E+00   2.12154792493454E-11
      1.11536107599740E-22  -2.28003886055780E-08  -2.27791731263285E-08  -1.72754919751121E-18
      9.48788880938723E-09
      0.00000000000000E+00  -3.20691513565405E-11   0.00000000000000E+00  -6.81464878115869E-12   1.39077254725281E-22
      3.20759655417048E-08   3.20691508929237E-08  -4.86590711516464E-19  -3.98317848005405E-01  -3.98317847995124E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02803710115610E-08   0.00000000000000E+00  -1.02803710115610E-08
      2.15444823149047E-18  -2.03003287330513E-02  -1.34354091001175E-02   0.00000000000000E+00   1.39894019335985E-11
      1.42290513086652E-22  -2.18027692832965E-08  -2.17887798813628E-08  -1.66785751997400E-18
      9.49909889298098E-09
      0.00000000000000E+00  -3.11553880660628E-11   0.00000000000000E+00  -3.98911039977922E-12   1.44041570397597E-22
      3.11594180352794E-08   3.11554289248798E-08  -4.52611302775060E-19  -4.12121032001415E-01  -4.12121031991258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01572566248836E-08   0.00000000000000E+00  -1.01572566248836E-08
      2.04058453564235E-18  -1.74692785891850E-02  -1.08534453733166E-02   0.00000000000000E+00   1.01298128366273E-11
      1.68273925398184E-22  -2.10083021128330E-08  -2.09981722999962E-08  -1.58797323286729E-18
      9.51423250583254E-09
      0.00000000000000E+00  -3.01823849200863E-11   0.00000000000000E+00  -3.13427042271266E-12   1.38510433142363E-22
      3.01855562786281E-08   3.01824220082055E-08  -4.09117247878809E-19  -4.29961427042009E-01  -4.29961427031981E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00286194724028E-08   0.00000000000000E+00  -1.00286194724028E-08
      1.88881529111136E-18  -1.50192954842198E-02  -8.66948811820798E-03   0.00000000000000E+00   8.19551088907955E-12
      1.77315159336349E-22  -2.01619980466918E-08  -2.01538025358026E-08  -1.47969804323256E-18
      9.53423250583254E-09
      0.00000000000000E+00  -2.89635134126052E-11   0.00000000000000E+00  -2.97283254312796E-12   1.14863561191787E-22
      2.89664578236842E-08   2.89634849911412E-08  -3.55782623982317E-19  -4.52169585450445E-01  -4.52169585440574E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87086418897110E-09   0.00000000000000E+00  -9.87086418897110E-09
      1.69139800733194E-18  -1.28865976155204E-02  -6.87112734099246E-03   0.00000000000000E+00   7.04199250431441E-12
      1.55799954220807E-22  -1.90996627946746E-08  -1.90926208021702E-08  -1.33561538334963E-18
      9.55423250583254E-09
      0.00000000000000E+00  -2.78681730766682E-11   0.00000000000000E+00  -2.67293443334758E-12   8.22170930079092E-23
      2.78708521679371E-08   2.78681792335039E-08  -3.06237263433882E-19  -4.73154113191556E-01  -4.73154113181822E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73425470919181E-09   0.00000000000000E+00  -9.73425470919181E-09
      1.49671291314811E-18  -1.14355976255800E-02  -5.72217649917328E-03   0.00000000000000E+00   6.03423943735182E-12
      1.11534598978898E-22  -1.81399587637495E-08  -1.81339245243120E-08  -1.19047564971422E-18
      9.57423250583254E-09
      0.00000000000000E+00  -2.69826979652505E-11   0.00000000000000E+00  -2.15890286942889E-12   5.21137758004435E-23
      2.69848797177591E-08   2.69827208148897E-08  -2.59893186669877E-19  -4.93126192196363E-01  -4.93126192186761E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.60109158588670E-09   0.00000000000000E+00  -9.60109158588670E-09
      1.30469108143037E-18  -1.04314642556601E-02  -4.95506315926854E-03   0.00000000000000E+00   4.99269475196223E-12
      6.79908719674163E-23  -1.73866219237551E-08  -1.73816292290031E-08  -1.04479789476050E-18
      9.59423250583254E-09
      0.00000000000000E+00  -2.63083739046728E-11   0.00000000000000E+00  -1.64050722110832E-12   3.00046691021231E-23
      2.63099692653518E-08   2.63083287581307E-08  -2.16213530243372E-19  -5.12306138920095E-01  -5.12306138910578E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51741328209382E-09   0.00000000000000E+00  -9.51741328209382E-09
      1.11434281578850E-18  -9.71004110541382E-03  -4.41975175830197E-03   0.00000000000000E+00   4.20285973324813E-12
      3.51664954771192E-23  -1.67951183357702E-08  -1.67909154760369E-08  -8.98129285545126E-19
      9.61423250583254E-09
      0.00000000000000E+00  -2.70039140995454E-11   0.00000000000000E+00   1.73742504554250E-12   1.67594721021797E-23
      2.70021826250786E-08   2.70039200501241E-08  -1.70765664694466E-19  -5.32766024898997E-01  -5.32766024888588E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04087759734778E-08   0.00000000000000E+00  -1.04087759734778E-08
      9.06167296318941E-19  -9.38410574063285E-03  -4.15549459602933E-03   0.00000000000000E+00   3.14988597300004E-12
      1.52253169301007E-23  -1.65982939626193E-08  -1.65951440766463E-08  -7.35401631624476E-19
      9.63423250583254E-09
      0.00000000000000E+00  -2.79119830163162E-11   0.00000000000000E+00   2.26891907181879E-12   9.82544704039380E-24
      2.79097185670108E-08   2.79119874860826E-08  -1.24603224512872E-19  -5.54093658535147E-01  -5.54093658523948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11997934200472E-08   0.00000000000000E+00  -1.11997934200472E-08
      6.82171427917996E-19  -9.25789432134040E-03  -3.99240189238948E-03   0.00000000000000E+00   2.26943597281920E-12
      4.98221584800158E-24  -1.67144635020083E-08  -1.67121940660355E-08  -5.57568203405124E-19
      9.64423250583254E-09
      0.00000000000000E+00  -2.86932143510034E-11   0.00000000000000E+00   3.87919238211390E-12   7.60341494168191E-24
      2.86893454349221E-08   2.86932246273042E-08  -1.01469980591575E-19  -5.65019880960655E-01  -5.65019880948938E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17164407871146E-08   0.00000000000000E+00  -1.17164407871146E-08
      5.65007020046850E-19  -9.32157231899521E-03  -3.97271429873179E-03   0.00000000000000E+00   1.16237588494045E-12
      1.67558671294249E-24  -1.69779462160744E-08  -1.69767838401894E-08  -4.63537039455275E-19
      9.65098250583254E-09
      0.00000000000000E+00  -2.92170048872980E-11   0.00000000000000E+00   3.86132042795086E-12   6.58048233155228E-24
      2.92131747657533E-08   2.92170360861812E-08  -8.59236946386039E-20  -5.72446706545802E-01  -5.72446706533857E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19450089776245E-08   0.00000000000000E+00  -1.19450089776245E-08
      4.84378209447885E-19  -9.41293813396950E-03  -3.97105697839908E-03   0.00000000000000E+00   2.53156148265384E-13
      1.77868468743990E-25  -1.72722802647052E-08  -1.72720271085570E-08  -3.98454514809282E-19
      9.66009500583254E-09
      0.00000000000000E+00  -2.93803048300529E-11   0.00000000000000E+00   9.25414281691586E-13   5.69992405014876E-24
      2.93793820971665E-08   2.93803075114482E-08  -6.56151034183093E-20  -5.82222802050259E-01  -5.82222802038427E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18314901434792E-08   0.00000000000000E+00  -1.18314901434792E-08
      3.76563755515430E-19  -9.44530351271267E-03  -3.91621346566417E-03   0.00000000000000E+00   7.94268027827375E-13
     -9.33793296163991E-25  -1.75496116359968E-08  -1.75488173679690E-08  -3.10948652097122E-19
      9.67239688083254E-09
      0.00000000000000E+00  -2.84482644368710E-11   0.00000000000000E+00  -3.70640463680861E-12   4.87491495411515E-24
      2.84519700670882E-08   2.84482636624514E-08  -4.13633612740269E-20  -5.93987485072479E-01  -5.93987485061706E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07721310430761E-08   0.00000000000000E+00  -1.07721310430761E-08
      2.44046345939889E-19  -9.30988599808504E-03  -3.74068176067426E-03   0.00000000000000E+00   1.48768457499389E-12
     -1.65012826087210E-24  -1.76776203039502E-08  -1.76761326193752E-08  -2.02682984665862E-19
      9.68900441208254E-09
      0.00000000000000E+00  -2.39372183241861E-11   0.00000000000000E+00  -1.33828172788892E-11   3.76158434454942E-24
      2.39506155774319E-08   2.39372327601530E-08  -2.30227498491201E-20  -6.02779832564331E-01  -6.02779832558082E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.24895464560959E-09   0.00000000000000E+00  -6.24895464560959E-09
      1.40266636383095E-19  -8.83859342074054E-03  -3.26556098942897E-03   0.00000000000000E+00   1.08488164574755E-12
     -2.11074429664796E-24  -1.76893629961892E-08  -1.76882781145434E-08  -1.17243886533975E-19
      9.70900441208254E-09
      0.00000000000000E+00  -1.05417552472055E-11   0.00000000000000E+00  -3.30226030860639E-11   1.59604145023833E-24
      1.05748454464752E-08   1.05418228433891E-08  -4.94914668856705E-20  -5.89002716456574E-01  -5.89002716463717E-01
      0.00000000000000E+00   0.00000000000000E+00   7.14330704596823E-09   0.00000000000000E+00   7.14330704596823E-09
      2.83132777302460E-19  -7.68694685265044E-03  -2.11490473980196E-03   0.00000000000000E+00  -1.24096833918304E-12
     -2.67831370946547E-24  -1.76838889210182E-08  -1.76851298893574E-08  -2.33641310416790E-19
      9.72900441208254E-09
      0.00000000000000E+00   8.42629541510454E-12   0.00000000000000E+00  -4.67614020789828E-11  -2.28337460504308E-24
     -8.37953773275937E-09  -8.42629913483835E-09  -1.52515038388940E-19  -5.39190222419522E-01  -5.39190222445626E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61040150516008E-08   0.00000000000000E+00   2.61040150516008E-08
      8.05213078334475E-19  -6.03380076844810E-03  -4.64094603078022E-04   0.00000000000000E+00  -5.25416973510046E-12
     -4.90909478388095E-24  -1.76724617470274E-08  -1.76777159167625E-08  -6.52698039945535E-19
      9.74900441208254E-09
      0.00000000000000E+00   2.25431989028502E-11   0.00000000000000E+00  -3.49851061976298E-11  -1.26330727543769E-23
     -2.25082270694089E-08  -2.25432121756066E-08  -3.48019885323875E-19  -4.53900027740975E-01  -4.53900027781142E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01671310485257E-08   0.00000000000000E+00   4.01671310485257E-08
      1.60855569930499E-18  -4.34354472705796E-03   1.20920686992409E-03   0.00000000000000E+00  -1.17552599885085E-11
     -1.95960842268941E-23  -1.76121636129306E-08  -1.76239188729191E-08  -1.26053581398112E-18
      9.76900441208254E-09
      0.00000000000000E+00   2.30670812838820E-11   0.00000000000000E+00  -1.62448699464189E-12  -3.63807866276382E-23
     -2.30653432312361E-08  -2.30669677182308E-08  -6.36826553279520E-19  -3.38557295032214E-01  -3.38557295072939E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07249482827614E-08   0.00000000000000E+00   4.07249482827614E-08
      2.42305466496022E-18  -2.07084275579493E-03   3.49261309339931E-03   0.00000000000000E+00  -2.72493603137116E-11
     -6.50895360433502E-23  -1.76307312042167E-08  -1.76579805645305E-08  -1.78622811168070E-18
      9.78900441208254E-09
      0.00000000000000E+00   1.46434493661564E-11   0.00000000000000E+00   2.01395821011206E-11  -4.30648160285192E-23
     -1.46635583383639E-08  -1.46434187562628E-08  -9.15303636168524E-19  -2.15720199875601E-01  -2.15720199906363E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07624147229691E-08   0.00000000000000E+00   3.07624147229691E-08
      3.03830295941960E-18  -1.03319448520237E-02  -5.25337444197703E-03   0.00000000000000E+00  -5.79368814874214E-11
     -8.18293624953621E-23  -1.60610590852188E-08  -1.61189959667063E-08  -2.12299932325108E-18
      9.80900441208254E-09
      0.00000000000000E+00   9.81737580484974E-12   0.00000000000000E+00   1.11086699668222E-11  -4.59355058215174E-23
     -9.82844866439662E-09  -9.81733999442984E-09  -1.11030935068116E-18  -1.14474217842961E-01  -1.14474217865554E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25932756678492E-08   0.00000000000000E+00   2.25932756678492E-08
      3.49016847277658E-18  -4.04800250244127E-02  -3.64547481845901E-02   0.00000000000000E+00  -1.08140119459378E-10
     -9.49122982247998E-23  -1.26677955539599E-08  -1.27759356734194E-08  -2.37985912209543E-18
      9.81400441208254E-09
      0.00000000000000E+00   8.22396145903636E-12   0.00000000000000E+00   1.47215776532463E-11  -4.65278030214627E-23
     -8.23868171844745E-09  -8.22396014079425E-09  -1.15114314937639E-18  -9.15106918705651E-02  -9.15106918902427E-02
      0.00000000000000E+00   0.00000000000000E+00   1.96776475680277E-08   0.00000000000000E+00   1.96776475680277E-08
      3.58855671061672E-18  -5.00935788714943E-02  -4.64848711761442E-02   0.00000000000000E+00  -1.50798711952530E-10
     -9.83454562696879E-23  -1.13028887152806E-08  -1.14536874272333E-08  -2.43741356124033E-18
      9.82075441208254E-09
      0.00000000000000E+00   6.44547996774981E-12   0.00000000000000E+00   1.21557032991300E-11  -4.71611536875368E-23
     -6.45759094666080E-09  -6.44543524336172E-09  -1.19419274484129E-18  -6.64468281215157E-02  -6.64468281381069E-02
      0.00000000000000E+00   0.00000000000000E+00   1.65911912120565E-08   0.00000000000000E+00   1.65911912120565E-08
      3.70054725129810E-18  -6.56194883929562E-02  -6.24228664945863E-02   0.00000000000000E+00  -1.67062995978840E-10
     -1.02788039274266E-22  -9.97869297271593E-09  -1.01457559686949E-08  -2.50635450645681E-18
      9.82986691208254E-09
      0.00000000000000E+00   4.15946445865447E-12   0.00000000000000E+00   1.17560770604604E-11  -4.76661149447910E-23
     -4.17118645460880E-09  -4.15943037754839E-09  -1.23143672926283E-18  -4.39289295094736E-02  -4.39289295221235E-02
      0.00000000000000E+00   0.00000000000000E+00   1.26499391073726E-08   0.00000000000000E+00   1.26499391073726E-08
      3.81581982141403E-18  -9.05546302599542E-02  -8.78795253542149E-02   0.00000000000000E+00  -1.73546338965917E-10
     -1.08272534912619E-22  -8.31696239085814E-09  -8.49050872982416E-09  -2.58438309215120E-18
      9.83294238083254E-09
      0.00000000000000E+00   3.20841220487053E-12   0.00000000000000E+00   1.46943381771698E-11  -4.77746408522983E-23
     -3.22314955103055E-09  -3.20845521285343E-09  -1.24108020788471E-18  -3.79722234700614E-02  -3.79722234810333E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09719277297402E-08   0.00000000000000E+00   1.09719277297402E-08
      3.84956364227411E-18  -9.95044826086349E-02  -9.70584360316303E-02   0.00000000000000E+00  -1.80174747761232E-10
     -1.10071636777765E-22  -7.58329776912533E-09  -7.76347251688667E-09  -2.60848343438941E-18
      9.83709426364504E-09
      0.00000000000000E+00   2.26011529320282E-12   0.00000000000000E+00   1.09483189206942E-11  -4.78731981589280E-23
     -2.27105668137701E-09  -2.26010836245636E-09  -1.25016046145989E-18  -3.22251675566755E-02  -3.22251675659799E-02
      0.00000000000000E+00   0.00000000000000E+00   9.30448357254350E-09   0.00000000000000E+00   9.30448357254350E-09
      3.88819476769814E-18  -1.12243593351033E-01  -1.10024111794333E-01   0.00000000000000E+00  -1.79433861039410E-10
     -1.12367060027831E-22  -6.86494134904777E-09  -7.04437521008729E-09  -2.63803430623825E-18
      9.84269930544191E-09
      0.00000000000000E+00   1.45840258211832E-12   0.00000000000000E+00   6.86099479320990E-12  -4.79540968467739E-23
     -1.46530785820508E-09  -1.45844686341192E-09  -1.25792693772200E-18  -2.71156678610212E-02  -2.71156678688481E-02
      0.00000000000000E+00   0.00000000000000E+00   7.82682521288579E-09   0.00000000000000E+00   7.82682521288579E-09
      3.93206445015320E-18  -1.30017270085208E-01  -1.28010774239512E-01   0.00000000000000E+00  -1.80206002427945E-10
     -1.15303118040092E-22  -6.18817234704592E-09  -6.36837834947398E-09  -2.67413751243120E-18
      9.85026611186769E-09
      0.00000000000000E+00   8.79872582448106E-13   0.00000000000000E+00   3.66252267039743E-12  -4.80154243283776E-23
     -8.83551206925190E-10  -8.79888684254841E-10  -1.26404051395346E-18  -2.28325947188891E-02  -2.28325947255316E-02
      0.00000000000000E+00   0.00000000000000E+00   6.64252192600748E-09   0.00000000000000E+00   6.64252192600748E-09
      3.98232712774631E-18  -1.54177779752203E-01  -1.52362135122172E-01   0.00000000000000E+00  -1.84557529056548E-10
     -1.19099945338228E-22  -5.57807571269588E-09  -5.76263324175255E-09  -2.71828661379285E-18
      9.86048130054250E-09
      0.00000000000000E+00   5.15524509945848E-13   0.00000000000000E+00   1.70339030571211E-12  -4.80586401042884E-23
     -5.17255221086663E-10  -5.15551830780999E-10  -1.26858768572151E-18  -1.93189755528485E-02  -1.93189755585542E-02
      0.00000000000000E+00   0.00000000000000E+00   5.70577048522177E-09   0.00000000000000E+00   5.70577048522177E-09
      4.04061264978798E-18  -1.85979897331206E-01  -1.84344602038344E-01   0.00000000000000E+00  -1.92303098640899E-10
     -1.24036368637451E-22  -4.99791555579980E-09  -5.19021865444083E-09  -2.77202496406647E-18
      9.87427180525348E-09
      0.00000000000000E+00   3.07955403856837E-13   0.00000000000000E+00   7.17721210303999E-13  -4.80862031520098E-23
     -3.08635070442309E-10  -3.07917349232053E-10  -1.27189109712690E-18  -1.64084523747963E-02  -1.64084523796358E-02
      0.00000000000000E+00   0.00000000000000E+00   4.83950999565023E-09   0.00000000000000E+00   4.83950999565023E-09
      4.10735193518186E-18  -2.25696574505866E-01  -2.24268790817424E-01   0.00000000000000E+00  -1.98712936805715E-10
     -1.30307754965396E-22  -4.33287970961240E-09  -4.53159264641825E-09  -2.83546083805496E-18
      9.89288898661331E-09
      0.00000000000000E+00   2.03987161337917E-13   0.00000000000000E+00   2.66298165778132E-13  -4.81028308667101E-23
     -2.04203148369732E-10  -2.03936850204002E-10  -1.27445630556391E-18  -1.39256184128709E-02  -1.39256184166752E-02
      0.00000000000000E+00   0.00000000000000E+00   3.80425782678615E-09   0.00000000000000E+00   3.80425782678615E-09
      4.17817649308270E-18  -2.69919108913033E-01  -2.68784740416112E-01   0.00000000000000E+00  -1.88332198264682E-10
     -1.37546469226277E-22  -3.41198877831723E-09  -3.60032097658205E-09  -2.90372018751879E-18
      9.91288898661331E-09
      0.00000000000000E+00   1.61003824324794E-13   0.00000000000000E+00   1.02894390824662E-13  -4.81114008310049E-23
     -1.61121308688686E-10  -1.61018414297909E-10  -1.27638771758215E-18  -1.21401046309757E-02  -1.21401046337125E-02
      0.00000000000000E+00   0.00000000000000E+00   2.73686578518130E-09   0.00000000000000E+00   2.73686578518130E-09
      4.23291380878632E-18  -3.04295068098962E-01  -3.03483482117793E-01   0.00000000000000E+00  -1.54536602996274E-10
     -1.43386701881356E-22  -2.42131076788709E-09  -2.57584737088351E-09  -2.95652609120418E-18
      9.93288898661331E-09
      0.00000000000000E+00   1.39144776869403E-13   0.00000000000000E+00   5.39724291061181E-14  -4.81144047981363E-23
     -1.39205269337922E-10  -1.39151296908864E-10  -1.27790511701189E-18  -1.09253749342131E-02  -1.09253749360810E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86790220443127E-09   0.00000000000000E+00   1.86790220443127E-09
      4.27027185287495E-18  -3.26967295988926E-01  -3.26422610217585E-01   0.00000000000000E+00  -1.10315966423962E-10
     -1.47316240325370E-22  -1.61843494109827E-09  -1.72875090752238E-09  -2.99236673586306E-18
      9.95288898661331E-09
      0.00000000000000E+00   1.30970595257933E-13   0.00000000000000E+00   2.10351189487914E-14  -4.81159662519721E-23
     -1.31008448535378E-10  -1.30987413416478E-10  -1.27927422182576E-18  -1.00589200932799E-02  -1.00589200944573E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17738274467755E-09   0.00000000000000E+00   1.17738274467755E-09
      4.29381950776850E-18  -3.39699702436169E-01  -3.39370014256341E-01   0.00000000000000E+00  -6.36183822048097E-11
     -1.49512117635796E-22  -9.82776949056090E-10  -1.04639533126105E-09  -3.01454528594274E-18
      9.97288898661331E-09
      0.00000000000000E+00   1.16734660990767E-13   0.00000000000000E+00   3.78873175709451E-14  -4.81125512316181E-23
     -1.16789712673188E-10  -1.16751825355665E-10  -1.28036894891053E-18  -9.51433623666717E-03  -9.51433623740388E-03
      0.00000000000000E+00   0.00000000000000E+00   7.36708079408643E-10   0.00000000000000E+00   7.36708079408643E-10
      4.30855366935667E-18  -3.46253343435821E-01  -3.46058019394036E-01   0.00000000000000E+00  -3.10875107069479E-11
     -1.50571944220185E-22  -5.88868743345944E-10  -6.19956254053043E-10  -3.02818472044614E-18
      9.99288898661331E-09
      0.00000000000000E+00   8.64258977122827E-14   0.00000000000000E+00   8.22163218845740E-14  -4.80978676054830E-23
     -8.65494852881115E-11  -8.64672689662751E-11  -1.28086954685437E-18  -9.30790152052467E-03  -9.30790152123668E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12010517152463E-10   0.00000000000000E+00   7.12010517152463E-10
      4.32279387969972E-18  -3.53397045182726E-01  -3.53199960246959E-01   0.00000000000000E+00  -3.35638752086261E-11
     -1.51683494579006E-22  -5.91979372977398E-10  -6.25543248186175E-10  -3.04192433284535E-18
      9.99466673995998E-09
      0.00000000000000E+00   1.07642032007221E-13   0.00000000000000E+00  -5.66211256651633E-13  -4.80988808013303E-23
     -1.07118705274596E-10  -1.07684916531296E-10  -1.28095183773502E-18  -9.26922243238815E-03  -9.26922243302373E-03
      0.00000000000000E+00   0.00000000000000E+00   6.35583998508631E-10   0.00000000000000E+00   6.35583998508631E-10
      4.32392379128016E-18  -3.53844460542447E-01  -3.53678142890103E-01   0.00000000000000E+00  -2.28559807585383E-11
     -1.51753202420779E-22  -5.05043101217769E-10  -5.27899081976459E-10  -3.04297195354514E-18
      9.99706670697799E-09
      0.00000000000000E+00   8.31194871728117E-14   0.00000000000000E+00   4.91060509457593E-13  -4.80954154561159E-23
     -8.35946793391852E-11  -8.31036188297757E-11  -1.28100409233084E-18  -9.25370367732799E-03  -9.25370367795743E-03
      0.00000000000000E+00   0.00000000000000E+00   6.29438746852620E-10   0.00000000000000E+00   6.29438746852620E-10
      4.32543442351246E-18  -3.54569138316300E-01  -3.54397010553216E-01   0.00000000000000E+00  -2.74844605244553E-11
     -1.51860755516254E-22  -5.18850667498856E-10  -5.46335128023463E-10  -3.04443033118162E-18
      1.00000000000000E-08
      0.00000000000000E+00   6.37402476220236E-14   0.00000000000000E+00   3.38881966237911E-13  -4.80912148706057E-23
     -6.41118023876582E-11  -6.37729204214684E-11  -1.28101152685334E-18  -9.26268399542201E-03  -9.26268399611155E-03
      0.00000000000000E+00   0.00000000000000E+00   6.89534698608488E-10   0.00000000000000E+00   6.89534698608488E-10
      4.32745703083233E-18  -3.55684462838704E-01  -3.55487308292208E-01   0.00000000000000E+00  -3.55268792554172E-11
     -1.52028591342870E-22  -5.90234898931471E-10  -6.25761778187040E-10  -3.04644550397898E-18
}
